/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.util.Service;

public class Arbori
extends CommandListener
implements IHelp {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    public String getCommand() {
        return "ARBORI";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String sql = cmd.getSql();
        if (cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("arbori")) {
            List src = Lexer.parse((String)sql);
            if (src.size() < 2) {
                this.log_info(ctx, "Syntax: arbori \"arbori script filename\" (\"sql script filename\")? \n");
                return true;
            }
            String arboriPath = ((LexerToken)src.get((int)1)).content;
            try {
                String arboriPrg = Service.readFile((String)arboriPath);
                String sqlPrg = "select 1 from dual";
                if (2 < src.size()) {
                    String sqlPath = null;
                    sqlPath = ((LexerToken)src.get((int)2)).content;
                    sqlPrg = Service.readFile((String)sqlPath);
                } else {
                    ArrayList<ISQLCommand> cmds = ctx.getExecutedCommandList();
                    if (1 < cmds.size()) {
                        sqlPrg = cmds.get(cmds.size() - 2).getSql();
                    }
                }
                SqlProgram r = new SqlProgram(arboriPrg){

                    public Boolean getBoolBindVar(String name) {
                        try {
                            Boolean tmp = super.getBoolBindVar(name);
                            if (tmp != null) {
                                return tmp;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        return true;
                    }
                };
                Map map = r.run(sqlPrg, (Object)"JS");
            }
            catch (AssertionError e) {
                this.log_error(ctx, ((Throwable)((Object)e)).getMessage() + "\n");
            }
            catch (IOException e) {
                this.log_error(ctx, "File " + arboriPath + " not found \n");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private void log_error(ScriptRunnerContext ctx, String msg) {
        try {
            ctx.write(msg);
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, msg);
        }
    }

    private void log_info(ScriptRunnerContext ctx, String msg) {
        try {
            ctx.write(msg);
        }
        catch (Throwable t) {
            this.logger.log(Level.INFO, msg);
        }
    }
}

