/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IShowMode;

public abstract class AForAllStmtsCommand
extends CommandListener
implements IShowMode {
    private SQLCommand.StmtSubType m_cmdStmtSubType;
    protected boolean m_isCmdOn = false;

    public AForAllStmtsCommand(SQLCommand.StmtSubType cmd) {
        this.m_cmdStmtSubType = cmd;
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getStmtSubType() == this.getStmtSubType()) {
            boolean isHandled = this.doHandleCmd(conn, ctx, cmd);
            if (isHandled && cmd.getProperty("prop_status_boolean") != null) {
                this.m_isCmdOn = (Boolean)cmd.getProperty("prop_status_boolean");
            }
            return isHandled;
        }
        if (this.isListenerOn(conn, ctx, cmd)) {
            return this.doHandleWatcher(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getStmtSubType() == this.getStmtSubType()) {
            this.doBeginCmd(conn, ctx, cmd);
        } else if (this.isListenerOn(conn, ctx, cmd)) {
            this.doBeginWatcher(conn, ctx, cmd);
        }
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getStmtSubType() == this.getStmtSubType()) {
            this.doEndCmd(conn, ctx, cmd);
        } else if (this.isListenerOn(conn, ctx, cmd)) {
            this.doEndWatcher(conn, ctx, cmd);
        }
    }

    protected boolean isListenerOn(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return this.m_isCmdOn;
    }

    protected boolean doHandleCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return true;
    }

    protected boolean doHandleWatcher(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return false;
    }

    protected void doBeginCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    protected void doBeginWatcher(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    protected void doEndCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    protected void doEndWatcher(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    private SQLCommand.StmtSubType getStmtSubType() {
        return this.m_cmdStmtSubType;
    }

    public boolean isCmdOn() {
        return this.m_isCmdOn;
    }

    public void setCmdOn(boolean cmdOn) {
        this.m_isCmdOn = cmdOn;
    }

    @Override
    public void setProperties(ISQLCommand cmd, ScriptRunnerContext ctx, String oldvalue, String printableString, String contextProperty) {
        cmd.setProperty("ishowmode.oldvalue", oldvalue);
        cmd.setProperty("ishowmode.printvalue", printableString);
        cmd.setProperty("ishowmode.ctx_set_string", contextProperty);
    }

    @Override
    public void writeShowMode(ISQLCommand cmd, ScriptRunnerContext ctx, String newVal) {
        String showmode = (String)ctx.getProperty("script.runner.setshowmode");
        if (showmode.matches("(?i:on|both)") && cmd.isSqlPlusSetCmd()) {
            ctx.write("old: " + String.valueOf(cmd.getProperty("ishowmode.printvalue")) + " " + String.valueOf(cmd.getProperty("ishowmode.oldvalue")) + "\n");
            ctx.write("new: " + String.valueOf(cmd.getProperty("ishowmode.printvalue")) + " " + newVal + "\n");
        }
    }
}

