/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.ServiceLoader;
import oracle.dbtools.raptor.format.FormatRegistry;
import oracle.dbtools.raptor.format.FormatterService;
import oracle.dbtools.raptor.format.Messages;
import oracle.dbtools.util.Logger;

public class FormatterServices {
    private static FormatterServices instance;
    private static ServiceLoader<FormatterService> loader;

    public FormatterServices() {
        loader = ServiceLoader.load(FormatterService.class);
    }

    public static synchronized FormatterServices getInstance() {
        if (instance == null) {
            instance = new FormatterServices();
        }
        return instance;
    }

    public void registerFormatterServices() {
        FormatRegistry.registerBasics();
        for (FormatterService resultFormatter : loader) {
            try {
                FormatRegistry.registerFormater(resultFormatter.getFormatterClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                Logger.warn(this.getClass(), Messages.getString("UNABLE_TO_REGISTER_FORMATTER"), e);
            }
        }
    }

    public Iterator<FormatterService> getFormatterServices() {
        return loader.iterator();
    }
}

