/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.impl;

import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeException;
import oracle.dbtools.raptor.datatypes.DataTypeExtensionObject;
import oracle.dbtools.raptor.datatypes.DataTypeFactoryExtension;
import oracle.dbtools.raptor.datatypes.TypeMetadata;

public abstract class AbstractDataTypeContextImpl
extends DataTypeExtensionObject
implements DataTypeContext {
    private volatile DataTypeConnectionProvider.ConnectionProviderAccess connectionProviderAccess;
    private final Map<TypeMetadata, SoftReference<DataType>> datatypeCache;
    private transient int creates = 0;
    private transient int frees = 0;
    private transient int reuses = 0;

    protected AbstractDataTypeContextImpl(DataTypeFactoryExtension.ExtensionAccess extensionAccess, DataTypeConnectionProvider.ConnectionProviderAccess connectionProviderAccess) {
        super(extensionAccess);
        this.connectionProviderAccess = connectionProviderAccess;
        this.datatypeCache = new ConcurrentHashMap<TypeMetadata, SoftReference<DataType>>();
    }

    protected abstract DataTypeContext.ContextAccess getContextAccess();

    @Override
    public DataTypeConnectionProvider getDataTypeConnectionProvider() {
        return this.connectionProviderAccess != null ? this.connectionProviderAccess.getDataTypeConnectionProvider() : null;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    protected DataType cacheDataType(TypeMetadata typeMetadata, DataType datatype) {
        if (datatype != null) {
            this.datatypeCache.put(typeMetadata, new SoftReference<DataType>(datatype));
            ++this.creates;
        }
        return datatype;
    }

    @Override
    public DataType getDataType(TypeMetadata typeMetadata) {
        DataType datatype = this.lookupDataTypeCache(typeMetadata);
        if (datatype == null) {
            datatype = this.cacheDataType(typeMetadata, this.resolveDataType(typeMetadata));
        } else {
            ++this.reuses;
        }
        return datatype;
    }

    @Override
    public DataType lookupDataType(TypeMetadata typeMetadata) {
        DataType datatype = this.lookupDataTypeCache(typeMetadata);
        if (datatype != null) {
            ++this.reuses;
        }
        return datatype;
    }

    @Override
    public void mapDataType(TypeMetadata typeMetadata, DataType datatype) {
        DataType mappedDatatype = this.lookupDataTypeCache(typeMetadata);
        if (datatype != null && mappedDatatype == null) {
            this.cacheDataType(typeMetadata, datatype);
        }
    }

    protected DataType resolveDataType(TypeMetadata typeMetadata) {
        return this.getExtensionAccess().resolveDataType(this, typeMetadata);
    }

    protected DataType lookupDataTypeCache(TypeMetadata typeMetadata) {
        SoftReference<DataType> ref = this.datatypeCache.get(typeMetadata);
        if (ref != null) {
            DataType dt = ref.get();
            if (dt == null) {
                this.datatypeCache.remove(typeMetadata);
                ++this.frees;
            } else {
                return dt;
            }
        }
        return null;
    }

    protected synchronized void releaseResources() throws DataTypeException {
        this.setDataTypeConnectionProvider(null);
        for (Map.Entry<TypeMetadata, SoftReference<DataType>> dataTypeMapEntry : this.datatypeCache.entrySet()) {
            SoftReference<DataType> value = dataTypeMapEntry.getValue();
            if (value == null) continue;
            value.clear();
        }
        this.datatypeCache.clear();
        this.creates = 0;
        this.frees = 0;
        this.reuses = 0;
    }

    private void setDataTypeConnectionProvider(DataTypeConnectionProvider.ConnectionProviderAccess connectionProviderAccess) {
        if (this.connectionProviderAccess != connectionProviderAccess) {
            DataTypeConnectionProvider.ConnectionProviderAccess oldConnectionProviderAccess = this.connectionProviderAccess;
            this.connectionProviderAccess = connectionProviderAccess;
            this.firePropertyChange("connection_provider", oldConnectionProviderAccess, connectionProviderAccess);
        }
    }

    protected synchronized void cleanupDataTypeCache() {
        Iterator<Map.Entry<TypeMetadata, SoftReference<DataType>>> dataTypeMapIter = this.datatypeCache.entrySet().iterator();
        while (dataTypeMapIter.hasNext()) {
            Map.Entry<TypeMetadata, SoftReference<DataType>> dataTypeMapEntry = dataTypeMapIter.next();
            if (dataTypeMapEntry.getValue() != null && dataTypeMapEntry.getValue().get() != null) continue;
            dataTypeMapIter.remove();
            ++this.frees;
        }
    }

    protected abstract void firePropertyChange(String var1, Object var2, Object var3);

    protected static abstract class Builder
    extends DataTypeExtensionObject.Builder
    implements DataTypeContext.Builder {
        private DataTypeConnectionProvider.ConnectionProviderAccess connectionProviderAccess;

        protected Builder(DataTypeConnectionProvider.ConnectionProviderAccess connectionProviderAccess) {
            this.connectionProviderAccess = connectionProviderAccess;
        }

        protected Builder() {
            this(null);
        }

        @Override
        public Builder setExtensionAccess(DataTypeFactoryExtension.ExtensionAccess extensionAccess) {
            super.setExtensionAccess(extensionAccess);
            return this;
        }

        @Override
        public Builder setConnectionProviderAccess(DataTypeConnectionProvider.ConnectionProviderAccess connectionProviderAccess) {
            this.connectionProviderAccess = connectionProviderAccess;
            return this;
        }

        @Override
        public DataTypeConnectionProvider.ConnectionProviderAccess getConnectionProviderAccess() {
            return this.connectionProviderAccess;
        }
    }
}

