/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.backgroundTask.utils;

import java.util.Collections;
import java.util.List;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.internal.IRaptorTaskUIListener;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskViewer;

public class RaptorTaskWrapper<V> {
    private RaptorTask<V> m_task;
    private List<IRaptorTaskListener> m_taskListeners;
    private List<IRaptorTaskUIListener> m_uiListeners;
    private List<ITaskViewer> m_viewers;

    public RaptorTaskWrapper(RaptorTask<V> task, List<IRaptorTaskListener> taskListeners, List<IRaptorTaskUIListener> uiListeners, List<ITaskViewer> viewers) {
        this.m_task = task;
        this.m_taskListeners = taskListeners != null ? taskListeners : Collections.EMPTY_LIST;
        for (IRaptorTaskListener listener : this.m_taskListeners) {
            this.m_task.getDescriptor().addListener(listener);
        }
        this.m_uiListeners = uiListeners != null ? uiListeners : Collections.EMPTY_LIST;
        this.m_viewers = viewers != null ? viewers : Collections.EMPTY_LIST;
    }

    public RaptorTask<V> getTask() {
        return this.m_task;
    }

    public List<IRaptorTaskListener> getRaptorTaskListeners() {
        return this.m_taskListeners;
    }

    public List<IRaptorTaskUIListener> getRaptorTaskUIListeners() {
        return this.m_uiListeners;
    }

    public List<ITaskViewer> getTaskViewers() {
        return this.m_viewers;
    }
}

