/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.util;

import oracle.dbtools.core.util.MessageLogger;
import oracle.dbtools.plusplus.util.DefaultLoggerWrapper;
import oracle.dbtools.plusplus.util.LoggerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public final class CommandContext
implements LoggerContext {
    private final ScriptRunnerContext ctx;
    private final MessageLogger logger;

    public static CommandContext of(ScriptRunnerContext ctx, MessageLogger logger) {
        return new CommandContext(ctx, logger);
    }

    public static CommandContext of(ScriptRunnerContext ctx, Class<?> cls) {
        DefaultLoggerWrapper wrapper = DefaultLoggerWrapper.logger(cls);
        MessageLogger logger = MessageLogger.builder().interactiveLogger(ctx::writeln).errorLogger((MessageLogger.ErrorLogger)wrapper).traceLogger((MessageLogger.TraceLogger)wrapper).build();
        return CommandContext.of(ctx, logger);
    }

    private CommandContext(ScriptRunnerContext ctx, MessageLogger logger) {
        this.ctx = ctx;
        this.logger = logger;
    }

    public ScriptRunnerContext getScriptRunnerContext() {
        return this.ctx;
    }

    @Override
    public MessageLogger getMessageLogger() {
        return this.logger;
    }
}

