/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.data.model.Column;

public class Table {
    private List<Column> columns = new ArrayList<Column>();
    private String tablename;

    public void addColumn(Column column) {
        if (column != null) {
            this.columns.add(column);
        }
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<Column> getEditableColumns() {
        ArrayList<Column> list = new ArrayList<Column>();
        for (Column col : this.columns) {
            if (col == null || !col.isEditable()) continue;
            list.add(col);
        }
        return list;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public void setColumns(Column[] columns) {
        ArrayList<Column> list = new ArrayList<Column>();
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] == null) continue;
            list.add(columns[i]);
        }
        this.setColumns(list);
    }

    public String getTablename() {
        return this.tablename;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public Column getColumnByIndex(int index) {
        if (this.columns.size() > index) {
            return this.columns.get(index);
        }
        return null;
    }

    public Column getColumnByName(String name) {
        for (Column col : this.columns) {
            if (!name.trim().equals(col.getName().trim())) continue;
            return col;
        }
        return null;
    }

    public int getColumnIndexByName(String name) {
        Iterator<Column> it = this.columns.iterator();
        int i = 0;
        while (it.hasNext()) {
            Column col = it.next();
            if (name.trim().equals(col.getName().trim())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Column getFirstColumn() {
        Iterator<Column> it = this.columns.iterator();
        if (it.hasNext()) {
            Column col = it.next();
            return col;
        }
        return null;
    }

    public Column getFirstEditableColumn() {
        for (Column col : this.columns) {
            if (!col.isEditable()) continue;
            return col;
        }
        return null;
    }

    public Column getSrcColName(String name) {
        for (Column col : this.columns) {
            if (!name.equals(col.getSourceColumnName())) continue;
            return col;
        }
        return null;
    }

    public void updateColumn(Column col) {
        for (Column c : this.columns) {
            if (!col.getName().equals(c.getName())) continue;
            c.setType(col.getType());
            c.setNullable(col.isNullable());
            c.setComment(col.getComment());
            c.setScale(col.getScale());
            c.setPrecision(col.getPrecision());
            c.setDefault(col.getDefault());
            c.setEditable(col.isEditable());
        }
    }
}

