/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;

public final class Iterators {
    private static final Iterator EMPTY = Iterators.iterator(new Object[0]);

    private Iterators() {
    }

    public static <T> void add(Collection<T> c, Iterator<? extends T> items) {
        Iterators.add(c, items, false);
    }

    public static <T> void add(Collection<T> c, Iterator<? extends T> items, boolean ignoreNulls) {
        if (c != null && items != null) {
            while (items.hasNext()) {
                T item = items.next();
                if (Iterators.ignore(item, ignoreNulls)) continue;
                c.add(item);
            }
        }
    }

    public static <T> int compare(Iterator<? extends T> i1, Iterator<? extends T> i2) {
        int c = 0;
        while (i1.hasNext()) {
            T v1 = i1.next();
            if (!i2.hasNext()) {
                c = 1;
                break;
            }
            T v2 = i2.next();
            c = ((Comparable)v1).compareTo(v2);
            if (c == 0) continue;
            break;
        }
        if (i2.hasNext()) {
            c = -1;
        }
        return c;
    }

    public static <T> int compare(Iterator<T> i1, Iterator<T> i2, Comparator<T> comparator) {
        int c = 0;
        while (i1.hasNext()) {
            T v1 = i1.next();
            if (!i2.hasNext()) {
                c = 1;
                break;
            }
            T v2 = i2.next();
            c = comparator.compare(v1, v2);
            if (c == 0) continue;
            break;
        }
        if (i2.hasNext()) {
            c = -1;
        }
        return c;
    }

    public static final <T> Iterator<T> empty() {
        return EMPTY;
    }

    public static final <T> Enumeration<T> enumeration(final Iterator<T> items) {
        return new Enumeration<T>(){

            @Override
            public boolean hasMoreElements() {
                return items.hasNext();
            }

            @Override
            public T nextElement() {
                return items.next();
            }

            public String toString() {
                return items.toString();
            }
        };
    }

    public static <T> boolean equals(Iterator<? extends T> i1, Iterator<? extends T> i2) {
        while (i1.hasNext()) {
            T v1 = i1.next();
            if (!i2.hasNext()) {
                return false;
            }
            T v2 = i2.next();
            boolean equal = v1 == v2 || v1.equals(v2);
            if (equal) continue;
            return false;
        }
        return !i2.hasNext();
    }

    public static final <T> Iterator<T> iterator(final Enumeration<T> items) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return items.hasMoreElements();
            }

            @Override
            public T next() {
                return items.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return items.toString();
            }
        };
    }

    public static <T> Iterator<T> iterator(final Iterable<? extends T> src) {
        if (src == null) {
            return null;
        }
        final Iterator<? extends T> iter = src.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public T next() {
                return iter.next();
            }

            @Override
            public void remove() {
                iter.remove();
            }

            public String toString() {
                return src.toString();
            }
        };
    }

    public static final <T> Iterator<T> iterator(T ... items) {
        if (items == null) {
            return null;
        }
        return new ArrayIterator<T>(items);
    }

    public static String join(Iterator<?> iter, String separator) {
        StringBuilder b = new StringBuilder();
        while (iter.hasNext()) {
            Object i = iter.next();
            b.append(i);
            if (!iter.hasNext()) continue;
            b.append(separator);
        }
        return b.toString();
    }

    public static <T> T max(Iterator<? extends T> i) {
        T candidate = i.next();
        while (i.hasNext()) {
            T next = i.next();
            if (((Comparable)next).compareTo(candidate) <= 0) continue;
            candidate = next;
        }
        return candidate;
    }

    public static final <T> T next(Iterator<? extends T> items) {
        T next = Iterators.nextOrNull(items);
        if (next == null) {
            throw new IllegalStateException("no more items");
        }
        return next;
    }

    public static final <T> T nextOrNull(Iterator<? extends T> items) {
        if (items.hasNext()) {
            return items.next();
        }
        return null;
    }

    private static <T> boolean ignore(T item, boolean ignoreNulls) {
        return ignoreNulls && item == null;
    }

    private static final class ArrayIterator<T>
    implements Iterator<T> {
        private final T[] items;
        private int pos = 0;

        private ArrayIterator(T ... items) {
            this.items = items;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.items.length;
        }

        @Override
        public T next() {
            T item = this.items[this.pos];
            ++this.pos;
            return item;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return Arrays.toString(this.items);
        }
    }
}

