/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.connections.db;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import oracle.dbtools.connections.db.AbstractConnectionCreator;

public class CustomConnectionCreator
extends AbstractConnectionCreator {
    public static final String SUBTYPE_THIRD_PARTY = "thirdParty";

    @Override
    public String getConnectionURL(Properties props) throws SQLException {
        String url = super.getConnectionURL(props);
        if (!this.hasLength(url)) {
            throw new SQLException("No URL specified for third-party JDBC driver");
        }
        return url;
    }

    @Override
    public String getDriverClassName(Properties props) throws SQLException {
        String driverClassName = super.getDriverClassName(props);
        if (!this.hasLength(driverClassName)) {
            throw new SQLException("No driver class specified for third-party JDBC driver");
        }
        return driverClassName;
    }

    @Override
    protected boolean allowNullPassword() {
        return true;
    }

    @Override
    public Collection<String> listRequiredProperties() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("driver");
        retval.add("customUrl");
        return retval;
    }
}

