/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.connections;

import oracle.dbtools.connections.Location;
import oracle.dbtools.connections.Storage;
import oracle.dbtools.connections.StorageException;
import oracle.dbtools.connections.StorageManager;
import oracle.dbtools.connections.security.ReferenceWorker;
import oracle.dbtools.core.secrets.TextSecret;

public abstract class StorageWrapper {
    private final StorageManager mgr;
    private final ReferenceWorker worker;

    protected final ReferenceWorker createReferenceWorker(TextSecret key) {
        ReferenceWorker<char[]> worker = key.isPresent() ? ReferenceWorker.createDefaultWorker(key) : ReferenceWorker.createNullWorker();
        return worker;
    }

    protected StorageWrapper(Location loc, TextSecret key) throws StorageException {
        this.worker = this.createReferenceWorker(key);
        this.mgr = StorageManager.builder().location(loc).autosave(true).addEnvValue(ReferenceWorker.KEY, this.worker).build();
    }

    public final ReferenceWorker getWorker() {
        return this.worker;
    }

    protected abstract String getType();

    public final <T> Storage<T> getStorage() {
        return this.mgr.getStorage(this.getType());
    }
}

