/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection0;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import oracle.dbtools.app.injection0.DependencyLink;
import oracle.dbtools.app.injection0.SqlInjection;
import oracle.dbtools.app.injection0.SqlInjectionGraph;
import oracle.dbtools.util.Service;

public class SqlInjectionTest {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_FAILURES_LETHAL = false;
    private static final boolean DEBUG_PRINT_TEST_METADATA = false;
    private static final boolean GRAPH_BASED_INJECTION = true;

    public static void main(String[] args) throws Exception {
        try {
            SqlInjectionTest.test();
        }
        catch (Throwable t) {
            System.out.flush();
            throw t;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void test() throws Exception {
        System.out.println("Graph-based injection: true");
        String input = Service.readFile(SqlInjection.class, (String)"test.sql");
        String[] tests = input.split("\\+\\+\\+\\+\\++[ \t]*");
        input = null;
        int testNum = 0;
        int testPassed = 0;
        int testWarned = 0;
        int testPassedDespiteKnownBad = 0;
        int inexactMatches = 0;
        int testFailed = 0;
        int testSkipped = 0;
        int knownBadFailures = 0;
        int unexpectedFailures = 0;
        boolean skipAhead = false;
        for (String test : tests) {
            int endPos;
            boolean parsed;
            if (test.matches("^[ \t]*$")) continue;
            ++testNum;
            String description = null;
            boolean injection = false;
            boolean knownBad = false;
            boolean skipOne = false;
            ArrayList expectedInjections = new ArrayList();
            int pos = 0;
            do {
                parsed = false;
                int cutPos = endPos = test.indexOf("\n", pos);
                if (test.indexOf("\r", pos) + 1 == endPos) {
                    --cutPos;
                }
                if (endPos <= pos) break;
                String line = test.substring(pos, cutPos);
                if (description == null) {
                    description = line;
                    parsed = true;
                } else if (line.length() > 1) {
                    String[] words = line.split("[ \t]+");
                    switch (words[0].toLowerCase()) {
                        case "description": {
                            System.out.println(line);
                            parsed = true;
                            break;
                        }
                        case "injection": {
                            injection = Boolean.valueOf((String)words[1]);
                            parsed = true;
                            break;
                        }
                        case "dataflow": {
                            ArrayList<DependencyLink> arrayList = new ArrayList<DependencyLink>();
                            for (int i = 1; i < words.length; ++i) {
                                String[] dep = ((String)words[i]).split(":");
                                arrayList.add(new DependencyLink(dep[0], Integer.parseInt(dep[1]), -1, -1));
                            }
                            expectedInjections.add(arrayList);
                            parsed = true;
                            break;
                        }
                        case "knownbad": {
                            knownBad = true;
                            parsed = true;
                            break;
                        }
                        case "start": {
                            skipAhead = false;
                            parsed = true;
                            break;
                        }
                        case "stop": {
                            skipAhead = true;
                            parsed = true;
                            break;
                        }
                        case "skip": {
                            skipOne = true;
                            parsed = true;
                            break;
                        }
                        default: {
                            parsed = false;
                        }
                    }
                }
                pos = endPos + 1;
            } while (parsed);
            if (skipAhead || skipOne) {
                System.out.println("Skipping test " + testNum + " " + description);
                ++testSkipped;
                continue;
            }
            System.out.println("Test " + testNum + " " + description);
            test = test.substring(pos);
            SqlInjectionGraph sig = new SqlInjectionGraph(test);
            List<List<DependencyLink>> injections = sig.getInjections(test);
            for (List list : injections) {
                System.out.println("Editor warning: " + SqlInjectionGraph.getEditorWarningText(list));
                System.out.println("   " + String.valueOf(list));
            }
            ArrayList<CallSite> failures = new ArrayList<CallSite>();
            ArrayList<CallSite> warnings = new ArrayList<CallSite>();
            HashSet<List<DependencyLink>> hashSet = new HashSet<List<DependencyLink>>(injections);
            for (List list : expectedInjections) {
                List matchedInjection = null;
                boolean exactMatch = false;
                for (List list2 : hashSet) {
                    if (((DependencyLink)list2.get(0)).equals(list.get(0)) && ((DependencyLink)list2.get(list2.size() - 1)).equals(list.get(list.size() - 1))) {
                        matchedInjection = list2;
                        hashSet.remove(list2);
                        exactMatch = true;
                        if (list.size() != list2.size()) {
                            exactMatch = false;
                        } else {
                            for (int j = 0; j < list2.size(); ++j) {
                                if (((DependencyLink)list2.get(j)).equals(list.get(j))) continue;
                                exactMatch = false;
                                break;
                            }
                        }
                    }
                    if (matchedInjection == null) continue;
                    break;
                }
                if (matchedInjection == null) {
                    failures.add((CallSite)((Object)("Did not find expected injection: " + SqlInjectionTest.toString(list))));
                    continue;
                }
                if (exactMatch) continue;
                warnings.add((CallSite)((Object)("Expected " + SqlInjectionTest.toString(list) + " got " + SqlInjectionTest.toString(matchedInjection))));
                ++inexactMatches;
            }
            for (List list : hashSet) {
                failures.add((CallSite)((Object)("Unexpected injection found: " + SqlInjectionTest.toString(list))));
            }
            if (knownBad && failures.isEmpty()) {
                ++testPassedDespiteKnownBad;
                warnings.add((CallSite)((Object)("**** " + description + ": Passed even though flagged 'knownbad' ****")));
            }
            for (String string : failures) {
                System.out.println("FAIL: " + string);
            }
            for (String string : warnings) {
                System.out.println("WARN: " + string);
            }
            if (failures.isEmpty()) {
                ++testPassed;
                System.out.println("Test " + testNum + " " + description + ": passed");
            } else {
                ++testFailed;
                System.out.println("Test " + testNum + " " + description + ": FAILED");
                if (knownBad) {
                    System.out.println("...as expected; this test is known bad");
                    ++knownBadFailures;
                } else {
                    System.out.println();
                    int linenum = 0;
                    pos = 0;
                    while (true) {
                        void var29_46;
                        int n = endPos = test.indexOf("\n", pos);
                        if (test.indexOf("\r", pos) + 1 == endPos) {
                            --var29_46;
                        }
                        if (endPos <= pos) break;
                        String line = test.substring(pos, (int)var29_46);
                        System.out.println(++linenum + ": " + line);
                        pos = endPos + 1;
                    }
                    System.out.flush();
                    ++unexpectedFailures;
                }
            }
            if (!warnings.isEmpty()) {
                ++testWarned;
            }
            System.out.println();
        }
        System.out.println("====================");
        System.out.println(testNum + " tests");
        System.out.println(testPassed + " passed");
        System.out.println("   Total injections with unexpected dataflows: " + inexactMatches);
        if (testPassedDespiteKnownBad > 0) {
            System.out.println("   " + testPassedDespiteKnownBad + " of those passed tests were marked 'knownbad'. Progress!");
        }
        System.out.println(testFailed + " failed");
        System.out.println("   " + knownBadFailures + " of those were tests that we know we fail");
        System.out.println("   " + unexpectedFailures + " were unexpected, oops");
        System.out.println(testWarned + " tests with warnings: (includes both passed and failed tests)");
        System.out.println(testSkipped + " skipped");
        if (testPassed + testFailed + testSkipped != testNum) {
            System.out.println("Warning: Test numbers don't add up!");
        }
    }

    private static String toString(List<DependencyLink> injection) {
        StringBuffer sb = new StringBuffer();
        String separator = "";
        for (DependencyLink dl : injection) {
            sb.append(separator + String.valueOf(dl));
            separator = " ";
        }
        return sb.toString();
    }
}

