/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.arbori.util.Pair;
import oracle.arbori.util.Service;
import oracle.dbtools.app.Obfuscator;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.plsql.ParsedSql;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;

public class SqlRecognizer {
    static final String path = "/oracle/dbtools/app/";
    static String[] builtInTypePrefixes = new String[]{"CHAR", "VARCHAR", "NCHAR", "NVARCHAR", "DATE", "TIMESTAMP", "INTERVAL", "BLOB", "CLOB", "NCLOB", "BFILE", "LONG", "RAW", "NUMBER", "FLOAT", "BINARY", "ROWID", "UROWID", "VARCHAR2", "MLSLABEL", "UROWID", "DBMS_ID", "DBMS_QUOTED_ID", "DBMS_ID_30", "DBMS_QUOTED_ID_30", "DBMS_ID_128", "VARCHAR", "STRING", "LONG", "RAW", "\"LONG RAW\"", "ROWID", "CHAR", "CHARACTER", "\"CHARACTER VARYING\"", "\"CHAR VARYING\"", "\"NATIONAL CHARACTER\"", "\"NATIONAL CHAR\"", "\"NCHAR\"", "\"NVARCHAR2\""};
    static String[] standard = new String[]{"COALESCE", "COMMIT", "COMMIT_CM", "COMPOSE", "CONCAT", "CONTINUE", "CONVERT", "COS", "COSH", "CUBE", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "DBTIMEZONE", "DECODE", "DECOMPOSE", "DEREF", "DUMP", "EMPTY_BLOB", "EMPTY_CLOB", "EXISTS", "EXP", "FLOOR", "FROM_TZ", "GLB", "GREATEST", "GREATEST_LB", "GROUPING", "HEXTORAW", "INITCAP", "INSTR", "INSTR2", "INSTR4", "INSTRB", "INSTRC", "ISNCHAR", "IS_JSON", "IS_NOT_JSON", "JSON_ARRAY", "JSON_EQUAL", "JSON_EXISTS", "JSON_OBJECT", "JSON_QUERY", "JSON_SCALAR", "JSON_SERIALIZE", "JSON_VALUE", "LAST_DAY", "LEAST", "LEAST_UB", "LENGTH", "LENGTH2", "LENGTH4", "LENGTHB", "LENGTHC", "LEVEL", "LN", "LOCALTIME", "LOCALTIMESTAMP", "LOG", "LOWER", "LPAD", "LTRIM", "LUB", "MONTHS_BETWEEN", "NANVL", "NCHARTOROWID", "NCHR", "NEW_TIME", "NEXT_DAY", "NHEXTORAW", "NLSSORT", "NLS_CHARSET_DECL_LEN", "NLS_CHARSET_ID", "NLS_CHARSET_NAME", "NLS_INITCAP", "NLS_LOWER", "NLS_UPPER", "NULLFN", "NULLIF", "NUMTODSINTERVAL", "NUMTOYMINTERVAL", "NVL", "NVL2", "POWER", "RAWTOHEX", "RAWTONHEX", "REF", "REGEXP_COUNT", "REGEXP_INSTR", "REGEXP_LIKE", "REGEXP_REPLACE", "REGEXP_SUBSTR", "REMAINDER", "REPLACE", "ROLLBACK_NR", "ROLLBACK_SV", "ROLLUP", "ROUND", "ROUND_TIES_TO_EVEN", "ROWID ", "ROWIDTOCHAR", "ROWIDTONCHAR", "ROWLABEL", "ROWNUM", "RPAD", "RTRIM", "SAVEPOINT", "SESSIONTIMEZONE", "SET", "SET_TRANSACTION_USE", "SIGN", "SIN", "SINH", "SOUNDEX", "SQLCODE", "SQLERRM", "SQRT", "SUBSTR", "SUBSTR2", "SUBSTR4", "SUBSTRB", "SUBSTRC", "SYS$LOB_REPLICATION", "SYSDATE", "SYSTIMESTAMP", "SYS_AT_TIME_ZONE", "SYS_CONTEXT", "SYS_EXTRACT_UTC", "SYS_GUID", "SYS_LITERALTODATE", "SYS_LITERALTODSINTERVAL", "SYS_LITERALTOTIME", "SYS_LITERALTOTIMESTAMP", "SYS_LITERALTOTZTIME", "SYS_LITERALTOTZTIMESTAMP", "SYS_LITERALTOYMINTERVAL", "TAN", "TANH", "TO_ANYLOB", "TO_BINARY_DOUBLE", "TO_BINARY_FLOAT", "TO_BLOB", "TO_BOOLEAN", "TO_CHAR", "TO_CLOB", "TO_DATE", "TO_DSINTERVAL", "TO_LABEL", "TO_MULTI_BYTE", "TO_NCHAR", "TO_NCLOB", "TO_NUMBER", "TO_RAW", "TO_SINGLE_BYTE", "TO_TIME", "TO_TIMESTAMP", "TO_TIMESTAMP_TZ", "TO_TIME_TZ", "TO_YMINTERVAL", "TRANSLATE", "TRIM", "TRUNC", "TZ_OFFSET", "UID", "UNISTR", "UPPER", "UROWID ", "USER", "USERENV", "VALUE", "VSIZE", "XOR"};
    static String[] dbms_standard = new String[]{"APPLYING_CROSSEDITION_TRIGGER", "INSTANCE_NUM", "ROLLBACK_SV", "CLIENT_IP_ADDRESS", "IS_ALTER_COLUMN", "SAVEPOINT", "COMMIT", "IS_CREATING_NESTED_TABLE", "SERVER_ERROR", "COMMIT_CM", "IS_DROP_COLUMN", "SERVER_ERROR_DEPTH", "DATABASE_NAME", "IS_SERVERERROR", "SERVER_ERROR_MSG", "DELETING", "LOGIN_USER", "SERVER_ERROR_NUM_PARAMS", "DES_ENCRYPTED_PASSWORD", "ORA_MAX_NAME_LEN_SUPPORTED", "SERVER_ERROR_PARAM", "DICTIONARY_OBJ_NAME", "ORIGINAL_SQL_TXT", "SET_TRANSACTION_USE", "DICTIONARY_OBJ_NAME_LIST", "PARTITION_POS", "SQL_TXT", "DICTIONARY_OBJ_OWNER", "PRIVILEGE_LIST", "SYSEVENT", "DICTIONARY_OBJ_OWNER_LIST", "RAISE_APPLICATION_ERROR", "SYS_GETTRIGGERSTATE", "DICTIONARY_OBJ_TYPE", "REVOKEE", "UPDATING", "GRANTEE", "ROLLBACK_NR", "WITH_GRANT_OPTION", "INSERTING"};
    private List<String> tables = new LinkedList<String>();
    private List<String> databases = new LinkedList<String>();
    private Map<String, String> objects = new HashMap<String, String>();
    private LinkedList<String> names = new LinkedList();
    private List<String> dependentObjects = new LinkedList<String>();
    private Map<Integer, String> referencedObjects = new TreeMap<Integer, String>();
    private Set<String> localNames = new TreeSet<String>();

    public static void main(String[] args) throws Exception {
        String input = Service.readFile((String)"/Users/VTROPASH/eclipse-workspace/sandbox/src/example.sql");
        SqlRecognizer.test(input);
    }

    private static void test(String input) {
        System.out.println(SqlRecognizer.getStatements(input));
    }

    public SqlRecognizer() {
    }

    public SqlRecognizer(String input) {
        input = SqlRecognizer.massage(input);
        List src = Lexer.parse((String)input);
        this.recognize(input, src, null);
    }

    public Map<String, Set<Long>> recognize(String input, List<LexerToken> src) {
        return this.recognize(input, src, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Set<Long>> recognize(String input, List<LexerToken> src, String extraSymbol) {
        try {
            Object recognitionPrg = Service.readFile(Obfuscator.class, (String)"/oracle/dbtools/app/recognize.prg");
            if (extraSymbol != null) {
                List tmp = Lexer.parse((String)recognitionPrg);
                boolean found = false;
                LexerToken prior = null;
                for (LexerToken t : tmp) {
                    if (":".equals(t.content) && prior != null && prior.content.equals("\"" + extraSymbol + "\"")) {
                        found = true;
                        break;
                    }
                    prior = t;
                }
                if (!found) {
                    recognitionPrg = (String)recognitionPrg + "\n\"" + extraSymbol + "\": [" + extraSymbol + ") " + extraSymbol + ";";
                }
            }
            SqlProgram program = new SqlProgram((String)recognitionPrg, (Object)this, null, null, false);
            Map predicateVectors = program.run(input, (Object)this);
            TreeMap<String, Set<Long>> ret = new TreeMap<String, Set<Long>>();
            Iterator iterator = predicateVectors.keySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return ret;
                }
                String key = (String)iterator.next();
                if (!key.startsWith("\"")) continue;
                String unquotedPredicateName = key.substring(1, key.length() - 1);
                this.fetch(unquotedPredicateName, src, predicateVectors, ret);
            }
        }
        catch (SyntaxError e) {
            throw e;
        }
        catch (AssertionError e) {
            System.err.println(((Throwable)((Object)e)).getMessage());
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void fetch(String predicate, List<LexerToken> src, Map<String, MaterializedPredicate> predicateVectors, Map<String, Set<Long>> ret) {
        MaterializedPredicate symbols = predicateVectors.get("\"" + predicate + "\"");
        HashSet<Long> intervals = new HashSet<Long>();
        if (null == symbols.getAttribute(predicate)) {
            return;
        }
        ret.put(predicate, intervals);
        for (Tuple t : symbols.getTuples()) {
            ParseNode pc = symbols.getAttribute(t, predicate);
            LexerToken f = src.get(pc.from);
            LexerToken t_1 = src.get(pc.to - 1);
            intervals.add(Service.lPair((int)f.begin, (int)t_1.end));
        }
    }

    public static Map<Integer, String> fragmentAtLocation(String input, String targetSymbol) {
        List src = Lexer.parse((String)input);
        return SqlRecognizer.fragmentAtLocation(input, src, targetSymbol);
    }

    public static Map<Integer, String> fragmentAtLocation(String input, List<LexerToken> src, String targetSymbol) {
        TreeMap<Integer, String> ret = new TreeMap<Integer, String>();
        if (input == null || src.size() == 0) {
            return ret;
        }
        SqlRecognizer o = new SqlRecognizer();
        Map<String, Set<Long>> output = o.recognize(input, src, targetSymbol);
        for (String symbol : output.keySet()) {
            if (!targetSymbol.equals(symbol)) continue;
            for (Long interval : output.get(symbol)) {
                int from = Service.lX((long)interval);
                int to = Service.lY((long)interval);
                ret.put(from, input.substring(from, to));
            }
        }
        return ret;
    }

    public static List<String> getList(String input, String targetSymbol) {
        Map<Integer, String> tmp = SqlRecognizer.fragmentAtLocation(input, targetSymbol);
        LinkedList<String> ret = new LinkedList<String>();
        int lastPos = -1;
        for (int pos : tmp.keySet()) {
            if (pos <= lastPos) {
                throw new AssertionError((Object)"pos <= lastPos");
            }
            ret.add(tmp.get(pos));
            lastPos = pos;
        }
        return ret;
    }

    public static List<String> getColumns(String input) {
        return SqlRecognizer.getList(input, "columnSelect");
    }

    public static List<String> getColumnNames(String input) {
        List<String> columns = SqlRecognizer.getColumns(input);
        LinkedList<String> ret = new LinkedList<String>();
        for (String string : columns) {
            String string2 = "select " + string;
            List src = Lexer.parse((String)string2);
            ParseNode root = SqlEarley.getInstance().parse(src);
            for (ParseNode child : root.children()) {
                if (!child.contains("select_term")) continue;
                root = child;
                break;
            }
            String alias = string2.substring(((LexerToken)src.get((int)root.from)).begin, ((LexerToken)src.get((int)(root.to - 1))).end);
            for (ParseNode child : root.children()) {
                if (!child.contains("c_alias") && !child.contains("as_alias")) continue;
                alias = string2.substring(((LexerToken)src.get((int)(child.to - 1))).begin, ((LexerToken)src.get((int)(root.to - 1))).end);
                break;
            }
            ret.add(alias);
        }
        return ret;
    }

    public static Map<String, String> getColumnMap(String input) {
        List<String> columns = SqlRecognizer.getColumns(input);
        HashMap<String, String> ret = new HashMap<String, String>();
        SqlEarley earley = SqlEarley.newPartialRecognizer((String[])new String[]{"select_term"});
        for (String column : columns) {
            List src = Lexer.parse((String)column);
            ParseNode root = earley.parse(src);
            if (root.contains("column")) {
                ret.put(column, column);
                continue;
            }
            String colexpr = null;
            String alias = null;
            for (ParseNode child : root.children()) {
                if (child.contains("column")) {
                    colexpr = column.substring(((LexerToken)src.get((int)child.from)).begin, ((LexerToken)src.get((int)(child.to - 1))).end);
                }
                if (!child.contains("as_alias")) continue;
                alias = column.substring(((LexerToken)src.get((int)(child.to - 1))).begin, ((LexerToken)src.get((int)(child.to - 1))).end);
            }
            if (colexpr == null || alias == null) continue;
            ret.put(alias, colexpr);
        }
        return ret;
    }

    public static List<String> getTables(String input) {
        return SqlRecognizer.getList(input, "tableFrom");
    }

    public static List<String> getAllTables(String input) {
        SqlRecognizer o = new SqlRecognizer();
        o.tables = new LinkedList<String>();
        List src = Lexer.parse((String)input);
        o.recognize(input, src);
        return o.tables;
    }

    public static List<String> getDatabaseNames(String input) {
        SqlRecognizer o = new SqlRecognizer();
        o.databases = new LinkedList<String>();
        List src = Lexer.parse((String)input);
        o.recognize(input, src);
        return o.databases;
    }

    public static List<String> getPredicates(String input) {
        return SqlRecognizer.getList(input, "predicateWhere");
    }

    public static List<String> getOrderBy(String input) {
        return SqlRecognizer.getList(input, "orderBy");
    }

    public static List<String> getGroupBy(String input) {
        return SqlRecognizer.getList(input, "groupBy");
    }

    public static List<String> getStatements(String input) {
        LinkedList<String> ret = new LinkedList<String>();
        ret.add(input.trim());
        int cut = 200;
        cut = Integer.min(cut, input.length());
        String prefix = input.toLowerCase().substring(0, cut);
        if (0 < prefix.indexOf("wrapped")) {
            return ret;
        }
        input = SqlRecognizer.massage(input);
        ret.clear();
        ParsedSql parsed = new ParsedSql(input);
        List<ParseNode> statements = SqlRecognizer.statements(parsed.getRoot());
        for (ParseNode node : statements) {
            ret.add(input.substring(((LexerToken)parsed.getSrc().get((int)node.from)).begin, ((LexerToken)parsed.getSrc().get((int)(node.to - 1))).end));
        }
        if (ret.size() == 0) {
            ScriptParser scriptParser = new ScriptParser(input);
            ISQLCommand command = null;
            try {
                while ((command = scriptParser.next()) != null) {
                    String sql = command.getSqlWithTerminator();
                    ret.add(sql);
                }
            }
            catch (IOException e) {
                System.err.println("SqlRecognizer,IOException: " + e.getMessage());
            }
        }
        return ret;
    }

    public static List<String> getAssignedBinds(String input) {
        input = SqlRecognizer.massage(input);
        return SqlRecognizer.getList(input, "assignedBind");
    }

    public static int[] getMatchRecognizeProblematicSymbols(String input) {
        Map<Integer, String> map = SqlRecognizer.fragmentAtLocation(input, "matchRecognizeProblematicSymbols");
        int[] ret = new int[map.size()];
        int pos = 0;
        for (int i : map.keySet()) {
            ret[pos++] = i;
        }
        return ret;
    }

    public static Pair<Integer, Integer> getWithClauseSpan(String input) {
        SqlRecognizer o = new SqlRecognizer();
        TreeMap ret = new TreeMap();
        List src = Lexer.parse((String)input);
        Map<String, Set<Long>> output = o.recognize(input, src, "withClause");
        for (String symbol : output.keySet()) {
            Iterator<Long> iterator;
            if (!"withClause".equals(symbol) || !(iterator = output.get(symbol).iterator()).hasNext()) continue;
            Long interval = iterator.next();
            int from = Service.lX((long)interval);
            int to = Service.lY((long)interval);
            return new Pair((Object)from, (Object)to);
        }
        return null;
    }

    private static String massage(String input) {
        if (2 < (input = input.trim()).length() && input.startsWith("{") && input.endsWith("}")) {
            input = input.substring(1, input.length() - 1);
        }
        return input;
    }

    public static LinkedList<String> getConstraintClausePrimitives(String input) {
        List src = Lexer.parse((String)input);
        ParseNode root = SqlEarley.getInstance().parse(src);
        LinkedList<String> ret = new LinkedList<String>();
        for (ParseNode child : root.descendants()) {
            if (!child.contains("constraint_clauses")) continue;
            for (ParseNode column : child.descendants()) {
                String col;
                if (!column.contains("column") || ret.contains(col = column.content(src))) continue;
                ret.add(col);
            }
        }
        return ret;
    }

    public static Map<Integer, String> getUserOrRole(String input) {
        Map<Integer, String> ret = SqlRecognizer.fragmentAtLocation(input, "role");
        if (0 < ret.size()) {
            return ret;
        }
        return SqlRecognizer.fragmentAtLocation(input, "user");
    }

    public List<String> getObjectNames() {
        return this.names;
    }

    public String getObjectType(String name) {
        String ret = this.objects.get(name);
        if (ret != null) {
            return ret;
        }
        return this.objects.get(Service.handleMixedCase((String)name));
    }

    public List<String> getReferencedTypes() {
        LinkedList<String> ret = new LinkedList<String>();
        block2: for (String t : this.dependentObjects) {
            for (String b : builtInTypePrefixes) {
                if (t.toUpperCase().equals(b) || t.toUpperCase().startsWith(b + "(")) continue block2;
            }
            for (String b : standard) {
                if (t.toUpperCase().equals(b)) continue block2;
            }
            for (String b : dbms_standard) {
                if (t.toUpperCase().equals(b)) continue block2;
            }
            if (t.toUpperCase().equals("DUAL")) continue;
            int dot = t.indexOf(46);
            String prefix = null;
            try {
                prefix = t.substring(0, dot);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String postfix = t.substring(dot + 1);
            if ("SYS".equalsIgnoreCase(prefix) || "DBMS_SQL".equalsIgnoreCase(postfix)) continue;
            if (0 < dot) {
                // empty if block
            }
            if (ret.contains(t)) continue;
            ret.add(t);
        }
        return ret;
    }

    public static int[] getReturns(String input) {
        Map<Integer, String> map = SqlRecognizer.fragmentAtLocation(input, "return");
        int[] ret = new int[map.size()];
        int pos = 0;
        for (int i : map.keySet()) {
            ret[pos++] = i;
        }
        return ret;
    }

    public static String reductPwd(String stmt) {
        Object ret = stmt;
        try {
            List src = Lexer.parse((String)ret);
            ParseNode root = null;
            TreeMap map = new TreeMap(Collections.reverseOrder());
            boolean sawDP = false;
            boolean sawMinus = false;
            boolean sawPwd = false;
            boolean sawIdentified = false;
            boolean sawBy = false;
            boolean sawSlash = false;
            int pos = -1;
            for (LexerToken t : src) {
                ++pos;
                if (sawBy | sawSlash) {
                    ParseNode leafAtPos;
                    sawBy = false;
                    sawSlash = false;
                    if (root == null) {
                        root = SqlEarley.getInstance().parse(src);
                    }
                    if ((leafAtPos = root.leafAtPos(pos)) == null || !leafAtPos.contains("password_value")) continue;
                    map.put(t.begin, t.content);
                    continue;
                }
                if (sawPwd) {
                    sawMinus = false;
                    sawPwd = false;
                    map.put(t.begin, t.content);
                    continue;
                }
                if (sawMinus) {
                    if ("enp".equalsIgnoreCase(t.content) || "encryptionpassword".equalsIgnoreCase(t.content)) {
                        sawPwd = true;
                        continue;
                    }
                    sawMinus = false;
                    continue;
                }
                if (sawDP && "-".equalsIgnoreCase(t.content)) {
                    sawMinus = true;
                    continue;
                }
                if ("dp".equalsIgnoreCase(t.content) || "dpu".equalsIgnoreCase(t.content) || "dpum".equalsIgnoreCase(t.content) || "dpump".equalsIgnoreCase(t.content) || "datapump".equalsIgnoreCase(t.content)) {
                    sawDP = true;
                    continue;
                }
                if ("identified".equalsIgnoreCase(t.content)) {
                    sawIdentified = true;
                    sawBy = false;
                    continue;
                }
                if ("by".equalsIgnoreCase(t.content)) {
                    if (sawIdentified) {
                        sawBy = true;
                        sawIdentified = false;
                        continue;
                    }
                    sawIdentified = false;
                    sawBy = false;
                }
                if (!"/".equalsIgnoreCase(t.content)) continue;
                sawSlash = true;
            }
            Iterator<Object> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                int key = (Integer)iterator.next();
                String pwd = (String)map.get(key);
                if (pwd.startsWith("&")) continue;
                ret = ((String)ret).substring(0, key) + Service.identln((int)6, (String)"", (String)"*") + ((String)ret).substring(key + pwd.length());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static String reductBTPwd(String stmt) {
        Object ret = stmt;
        try {
            List src = Lexer.parse((String)ret);
            Object root = null;
            TreeMap map = new TreeMap(Collections.reverseOrder());
            boolean sawWalletPassword = false;
            boolean sawPrivateKeyPassword = false;
            boolean sawOrapki = false;
            boolean sawOrapkiPwd = false;
            boolean sawOrapkiPvtKeyPwd = false;
            int pos = -1;
            for (LexerToken t : src) {
                ++pos;
                if (sawWalletPassword || sawPrivateKeyPassword || sawOrapkiPwd || sawOrapkiPvtKeyPwd) {
                    sawWalletPassword = false;
                    sawPrivateKeyPassword = false;
                    sawOrapkiPvtKeyPwd = false;
                    sawOrapkiPwd = false;
                    map.put(t.begin, t.content);
                    continue;
                }
                if ("walletPw".equalsIgnoreCase(t.content) || "wallet_password".equalsIgnoreCase(t.content)) {
                    sawWalletPassword = true;
                    continue;
                }
                if ("walletPvtKeyPw".equalsIgnoreCase(t.content) || "wallet_private_key_password".equalsIgnoreCase(t.content)) {
                    sawPrivateKeyPassword = true;
                    continue;
                }
                if ("orapki".equalsIgnoreCase(t.content)) {
                    sawOrapki = true;
                    continue;
                }
                if ("pwd".equalsIgnoreCase(t.content)) {
                    if (!sawOrapki) continue;
                    sawOrapkiPwd = true;
                    continue;
                }
                if (!"pvtkeypwd".equalsIgnoreCase(t.content) || !sawOrapki) continue;
                sawOrapkiPvtKeyPwd = true;
            }
            Iterator<Object> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                int key = (Integer)iterator.next();
                String pwd = (String)map.get(key);
                if (pwd.startsWith("&")) continue;
                ret = ((String)ret).substring(0, key) + Service.identln((int)6, (String)"", (String)"*") + ((String)ret).substring(key + pwd.length());
                sawOrapki = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public Map<Integer, String> getObjectReferences() {
        return this.referencedObjects;
    }

    public static List<ParseNode> statements(ParseNode root) {
        ArrayList<ParseNode> ret = new ArrayList<ParseNode>();
        if (root.contains(SqlEarley.getInstance().sql_statement)) {
            ret.add(root);
        }
        for (ParseNode child : root.children()) {
            ret.addAll(SqlRecognizer.statements(child));
        }
        return ret;
    }

    public void allTables(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("tableFrom");
        String name = ((LexerToken)target.getSrc().get((int)node.from)).content;
        if (!this.tables.contains(name)) {
            this.tables.add(name);
        }
        this.add(name);
    }

    public void objects(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("object_name");
        String name = ((LexerToken)target.getSrc().get((int)node.from)).content;
        if (name.charAt(0) == '\'') {
            name = name.substring(1, name.length() - 1);
        }
        ParseNode t = tuple.get("object_type");
        String type = ((LexerToken)target.getSrc().get((int)t.from)).content;
        if (type.charAt(0) == '\'') {
            type = type.substring(1, type.length() - 1);
        }
        if (!this.objects.containsKey(name)) {
            this.objects.put(name, type);
            this.names.add(name);
        }
    }

    public void references(Parsed target, Map<String, ParseNode> tuple) {
        LexerToken dot;
        ParseNode node = tuple.get("type");
        Object name = node.content(target.getSrc());
        if (node.from + 1 == node.to && node.to < target.getSrc().size() - 1 && (dot = (LexerToken)target.getSrc().get(node.to)) != null && ".".equals(dot.content)) {
            name = (String)name + "." + ((LexerToken)target.getSrc().get((int)(node.to + 1))).content;
        }
        this.add((String)name);
    }

    private void add(String name) {
        int iName = name.indexOf(46);
        String delete = null;
        String add = name;
        for (String cmp : this.dependentObjects) {
            String name2;
            int iCmp = cmp.indexOf(46);
            if ((iName < 0 && iCmp < 0 || 0 < iName && 0 < iCmp) && Service.handleMixedCase((String)name).equals(Service.handleMixedCase((String)cmp))) {
                add = null;
                break;
            }
            if (iName < 0 && 0 < iCmp) {
                String cmp2 = cmp.substring(iCmp + 1);
                if (Service.handleMixedCase((String)name).equals(Service.handleMixedCase((String)cmp2))) {
                    add = null;
                    break;
                }
            }
            if (iCmp >= 0 || 0 >= iName || !Service.handleMixedCase((String)(name2 = name.substring(iName + 1))).equals(Service.handleMixedCase((String)cmp))) continue;
            add = name;
            delete = cmp;
            break;
        }
        if (add != null) {
            this.dependentObjects.add(add);
        }
        if (delete != null) {
            this.dependentObjects.remove(delete);
        }
    }

    public void local_names(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("object");
        String name = node.content(target.getSrc());
        this.localNames.add(name);
    }

    public void global_names(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("object");
        String name = node.content(target.getSrc());
        for (String cmp : this.localNames) {
            if (!name.equals(cmp) && !name.startsWith(cmp + ".")) continue;
            return;
        }
        this.referencedObjects.put(((LexerToken)target.getSrc().get((int)node.from)).begin, name);
    }

    public void execute_immediate(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        String code = ((LexerToken)target.getSrc().get((int)node.from)).content;
        code = code.substring(1, code.length() - 1);
        int offset = ((LexerToken)target.getSrc().get((int)node.from)).begin;
        SqlRecognizer r = new SqlRecognizer(code);
        Map<Integer, String> objects = r.getObjectReferences();
        for (int pos : objects.keySet()) {
            this.referencedObjects.put(pos + offset, objects.get(pos));
        }
    }

    public void database_names(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("name");
        String name = node.content(target.getSrc());
        if (!this.databases.contains(name)) {
            this.databases.add(name);
        }
    }
}

