/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.util.Set;
import java.util.TreeSet;

public class Issue
implements Comparable {
    public int line;
    public int col;
    public String ruleNo;
    public String msg;

    public Issue(int line, int col, String ruleNo, String msg) {
        this(line, col, ruleNo);
        this.msg = msg;
    }

    public Issue(int line, int col, String ruleNo) {
        this.line = line;
        this.col = col;
        this.ruleNo = ruleNo;
    }

    public int compareTo(Object o) {
        Issue cmp = (Issue)o;
        int ret = this.line - cmp.line;
        if (ret != 0) {
            return ret;
        }
        ret = this.col - cmp.col;
        if (ret != 0) {
            return ret;
        }
        return this.ruleNo.compareTo(cmp.ruleNo);
    }

    public String toString() {
        Object ret = "";
        ret = (String)ret + "Warning (" + (this.line + 1) + "," + (this.col + 1) + "): " + this.ruleNo;
        if (this.msg != null) {
            ret = (String)ret + ": " + this.msg;
        }
        return ret;
    }

    public String toJson() {
        return "{ \"line\": " + this.line + ", \"col\": " + this.col + ", \"ruleNo\": \"" + this.ruleNo + "\", \"msg\": \"" + this.msg + "\"}";
    }

    public static Set<Issue> filterUnique(Set<Issue> input) {
        TreeSet<String> ruleNumbers = new TreeSet<String>();
        TreeSet<Issue> ret = new TreeSet<Issue>();
        for (Issue candidate : input) {
            if (ruleNumbers.contains(candidate.ruleNo)) continue;
            ret.add(candidate);
            ruleNumbers.add(candidate.ruleNo);
        }
        return ret;
    }
}

