/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage;

import com.oracle.bmc.objectstorage.ObjectStorage;
import com.oracle.bmc.objectstorage.model.PrivateEndpoint;
import com.oracle.bmc.objectstorage.requests.GetPrivateEndpointRequest;
import com.oracle.bmc.objectstorage.requests.GetWorkRequestRequest;
import com.oracle.bmc.objectstorage.responses.GetPrivateEndpointResponse;
import com.oracle.bmc.objectstorage.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class ObjectStorageWaiters {
    private final ExecutorService executorService;
    private final ObjectStorage client;

    public ObjectStorageWaiters(ExecutorService executorService, ObjectStorage client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetPrivateEndpointRequest, GetPrivateEndpointResponse> forPrivateEndpoint(GetPrivateEndpointRequest request, PrivateEndpoint.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forPrivateEndpoint(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetPrivateEndpointRequest, GetPrivateEndpointResponse> forPrivateEndpoint(GetPrivateEndpointRequest request, PrivateEndpoint.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forPrivateEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetPrivateEndpointRequest, GetPrivateEndpointResponse> forPrivateEndpoint(GetPrivateEndpointRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, PrivateEndpoint.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forPrivateEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetPrivateEndpointRequest, GetPrivateEndpointResponse> forPrivateEndpoint(BmcGenericWaiter waiter, GetPrivateEndpointRequest request, PrivateEndpoint.LifecycleState ... targetStates) {
        final HashSet<PrivateEndpoint.LifecycleState> targetStatesSet = new HashSet<PrivateEndpoint.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetPrivateEndpointRequest, GetPrivateEndpointResponse>(){

            @Override
            public GetPrivateEndpointResponse apply(GetPrivateEndpointRequest request) {
                return ObjectStorageWaiters.this.client.getPrivateEndpoint(request);
            }
        }, (Predicate)new Predicate<GetPrivateEndpointResponse>(){

            @Override
            public boolean test(GetPrivateEndpointResponse response) {
                return targetStatesSet.contains((Object)response.getPrivateEndpoint().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)PrivateEndpoint.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return ObjectStorageWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

