/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.diff;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.extension.project.diff.ObjectDiff;
import oracle.dbtools.extension.project.diff.ParseDiff;
import oracle.dbtools.extension.project.diff.TableInfo;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.plsql.ParsedSql;

public class TableDiff
extends ObjectDiff {
    TableInfo ta1 = null;
    TableInfo ta2 = null;
    static final String separator = ",\n";

    public TableDiff(ParsedSql parsed1, ParsedSql parsed2) throws Exception {
        super(parsed1, parsed2);
        this.ta1 = new TableInfo((Parsed)parsed1);
        this.ta2 = new TableInfo((Parsed)parsed2);
    }

    @Override
    public String alters() {
        Object ret = "";
        String alter = "alter table " + this.ta1.tableName + "\n";
        ParseDiff inlineConstraintDiffs = new ParseDiff(this.ta1.inlineNamedConstraints, (Parsed)this.parsed1, this.ta2.inlineNamedConstraints, (Parsed)this.parsed2){

            @Override
            public int nameIndex() {
                return 1;
            }
        };
        ParseDiff colDiffs = new ParseDiff(this.ta1.columnDefinitions, (Parsed)this.parsed1, this.ta2.columnDefinitions, (Parsed)this.parsed2){

            @Override
            public int nameIndex() {
                return 0;
            }
        };
        LinkedList<String> included = new LinkedList<String>();
        for (String constr : inlineConstraintDiffs.rename.keySet()) {
            String conDef = inlineConstraintDiffs.rename.get(constr);
            for (String col : colDiffs.modify.keySet()) {
                String colDef = colDiffs.modify.get(col);
                if (!colDef.contains(conDef)) continue;
                included.add(col);
            }
        }
        for (String col : included) {
            colDiffs.modify.remove(col);
        }
        ret = (String)ret + this.newAlters();
        if (colDiffs.delete.size() > 0) {
            ret = (String)ret + alter + " drop " + TableDiff.parenList(colDiffs.delete) + ";\n";
        }
        if (colDiffs.add.size() > 0) {
            ret = (String)ret + alter + " add " + TableDiff.parenList(colDiffs.add) + ";\n";
        }
        if (colDiffs.modify.size() > 0) {
            ret = (String)ret + alter + " modify " + TableDiff.parenList(colDiffs.modify) + ";\n";
        }
        for (String name : colDiffs.rename.keySet()) {
            ret = (String)ret + alter + " rename column " + name + " to " + colDiffs.rename.get(name) + ";\n";
        }
        if (!this.ta2.pkColumns.equals(this.ta1.pkColumns) || !this.ta2.pkState.equals(this.ta1.pkState)) {
            if (this.ta1.pkColumns.size() > 0) {
                ret = (String)ret + alter + " drop primary key cascade;\n";
            }
            if (this.ta2.pkColumns.size() > 0) {
                ret = (String)ret + alter + " add primary key " + TableDiff.parenList(this.ta2.pkColumns) + this.ta2.pkState + ";\n";
            }
        }
        ParseDiff outOfLineConstraintDiffs = new ParseDiff(this.ta1.outOfLineNamedConstraints, (Parsed)this.parsed1, this.ta2.outOfLineNamedConstraints, (Parsed)this.parsed2){

            @Override
            public int nameIndex() {
                return 1;
            }
        };
        for (String name : outOfLineConstraintDiffs.rename.keySet()) {
            ret = (String)ret + alter + " rename constraint " + name + " to " + outOfLineConstraintDiffs.rename.get(name) + ";\n";
        }
        for (String name : outOfLineConstraintDiffs.delete) {
            ret = (String)ret + alter + " drop constraint " + name + ";\n";
        }
        for (String name : outOfLineConstraintDiffs.modify.keySet()) {
            ret = (String)ret + alter + " drop constraint " + name + ";\n";
        }
        for (String name : outOfLineConstraintDiffs.add.keySet()) {
            ret = (String)ret + alter + " add " + outOfLineConstraintDiffs.add.get(name) + ";\n";
        }
        for (String name : outOfLineConstraintDiffs.modify.keySet()) {
            ret = (String)ret + alter + " add " + outOfLineConstraintDiffs.modify.get(name) + ";\n";
        }
        for (String name : inlineConstraintDiffs.rename.keySet()) {
            ret = (String)ret + alter + " rename constraint " + name + " to " + inlineConstraintDiffs.rename.get(name) + ";\n";
        }
        return ret;
    }

    String newAlters() {
        Object ret = "\n";
        List<String> tmp = this.newClauses(this.ta1.extraAlters, this.ta2.extraAlters);
        for (String c : tmp) {
            ret = (String)ret + c + ";\n";
        }
        return (String)ret + "\n";
    }

    private static String parenList(Collection<String> list) {
        Object ret = "(";
        for (String col : list) {
            ret = (String)ret + col + separator;
        }
        return ((String)ret).substring(0, ((String)ret).length() - separator.length()) + ")";
    }

    private static String parenList(Map<String, String> definitions) {
        Object ret = "(";
        for (String col : definitions.keySet()) {
            ret = (String)ret + definitions.get(col) + separator;
        }
        return ((String)ret).substring(0, ((String)ret).length() - separator.length()) + ")";
    }
}

