/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.diff;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.ScriptException;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.Substitutions;
import oracle.dbtools.parser.plsql.SqlEarley;

public class ColProperties {
    Parsed target;
    ParseNode definition;
    String name;
    ParseNode type;
    ParseNode constraint;
    private static SqlEarley earley = null;
    private static Program program = new Program((Earley)ColProperties.getEarley());

    String getType() {
        return this.type.content(this.target.getSrc()).toUpperCase();
    }

    public ColProperties(Parsed target, ParseNode def) {
        this.target = target;
        this.definition = def;
        for (ParseNode candidate : def.children()) {
            if (!candidate.contains("datatype")) continue;
            this.type = candidate;
            break;
        }
        if (this.type == null) {
            this.name = ((LexerToken)target.getSrc().get((int)(def.from + 1))).content;
            Iterator iterator = def.children().iterator();
            while (iterator.hasNext()) {
                ParseNode tmp;
                this.constraint = tmp = (ParseNode)iterator.next();
            }
        } else {
            this.name = ((LexerToken)target.getSrc().get((int)def.from)).content;
            for (ParseNode candidate : def.children()) {
                if (!candidate.contains("inline_constraint")) continue;
                this.constraint = candidate;
                break;
            }
        }
    }

    public static boolean sameName(ColProperties c1, ColProperties c2) {
        return c1.name.equalsIgnoreCase(c2.name);
    }

    public static boolean sameType(ColProperties c1, ColProperties c2) {
        if (c1.type == null) {
            return c2.type == null;
        }
        if (c2.type == null) {
            return false;
        }
        return c1.getType().equalsIgnoreCase(c2.getType());
    }

    public static boolean sameConstraint(ColProperties c1, ColProperties c2) {
        if (c1.constraint == null) {
            return c2.constraint == null;
        }
        if (c2.constraint == null) {
            return false;
        }
        return c1.constraint.content(c1.target.getSrc()).equalsIgnoreCase(c2.constraint.content(c2.target.getSrc()));
    }

    public String reduce(ColProperties cmp) {
        Parsed t1 = new Parsed(this.target.content(this.definition), (Earley)ColProperties.getEarley(), "col_properties");
        final Substitutions replace = new Substitutions(t1);
        try {
            program.eval(t1, new Object(){

                public void delete(Parsed target, Map<String, ParseNode> tuple) {
                    ParseNode node = tuple.get("node");
                    replace.replace(node, "");
                }
            });
        }
        catch (ScriptException scriptException) {
            // empty catch block
        }
        Substitutions ret = replace;
        if (cmp != null && this.constraint != null && ColProperties.sameConstraint(this, cmp)) {
            ret = new Substitutions(t1);
            int offset = ((LexerToken)this.target.getSrc().get((int)this.definition.from)).begin;
            int begin = ((LexerToken)this.target.getSrc().get((int)this.constraint.from)).begin - offset;
            int end = ((LexerToken)this.target.getSrc().get((int)(this.constraint.to - 1))).end - offset;
            ret.replace(begin, end, "");
        }
        return ret.transformInput();
    }

    private static SqlEarley getEarley() {
        if (earley != null) {
            return earley;
        }
        earley = new SqlEarley(){};
        TreeSet additionalRules = new TreeSet();
        earley.nullifySymbol2Recognize();
        earley.addSymbol2Recognize("col_properties");
        return earley;
    }

    static {
        String prg = "delete: [node) precheck_state \n->";
        try {
            program.compile(prg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

