/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.verify;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import lombok.NonNull;
import oracle.dbtools.extension.project.commands.verify.VerifyMessages;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.exceptions.GeneralVerifyException;
import oracle.dbtools.extension.project.core.messages.GeneralMessages;
import oracle.dbtools.extension.project.core.utils.ConsoleColors;
import oracle.dbtools.extension.project.core.utils.ProjectUtils;
import oracle.dbtools.extension.project.core.verify.interfaces.VerifyServiceInterface;
import oracle.dbtools.extension.project.core.verify.services.example.VerifyServiceExample;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class VerifyEngine {
    static VerifyEngine instance;
    Map<String, VerifyServiceInterface> services = new HashMap<String, VerifyServiceInterface>();
    Map<String, HashMap<String, VerifyServiceInterface>> groups = new HashMap<String, HashMap<String, VerifyServiceInterface>>();
    HashMap<String, HashMap<String, List<VerifyServiceInterface.ServiceMessage>>> groupMessages = new HashMap();

    private VerifyEngine() {
        ServiceLoader<VerifyServiceInterface> serviceLoader = ServiceLoader.load(VerifyServiceInterface.class, VerifyServiceExample.class.getClassLoader());
        for (VerifyServiceInterface service : serviceLoader) {
            this.services.put(service.getName().toLowerCase(), service);
            GeneralMessages.debugMessage("Verification Service '" + service.getName().toLowerCase() + "' loaded");
            String serviceName = service.getName().toLowerCase();
            String groupName = service.getGroup().toLowerCase();
            ArrayList<String> registeredGroups = new ArrayList<String>(this.groups.keySet());
            if (ProjectUtils.ignoreCaseContains(registeredGroups, service.getGroup().toLowerCase())) {
                HashMap<String, VerifyServiceInterface> groupServices = this.groups.get(service.getGroup().toLowerCase());
                if (ProjectUtils.ignoreCaseContains(new ArrayList<String>(groupServices.keySet()), serviceName)) {
                    ProjectConfig.getCurrentContext().writeln(VerifyMessages.format("SERVICE_EXISTS", service.getName()));
                    continue;
                }
                this.groups.get(service.getGroup().toLowerCase()).put(service.getName().toLowerCase(), service);
                continue;
            }
            this.groups.put(service.getGroup().toLowerCase(), new HashMap());
            this.groups.get(service.getGroup().toLowerCase()).put(service.getName().toLowerCase(), service);
        }
        GeneralMessages.debugMessage("Found " + this.services.size() + " services!");
    }

    public static void close() {
        instance = null;
    }

    public static VerifyEngine getInstance() {
        if (instance == null) {
            instance = new VerifyEngine();
        }
        ServiceLoader<VerifyServiceInterface> serviceLoader = ServiceLoader.load(VerifyServiceInterface.class);
        serviceLoader.reload();
        return instance;
    }

    public static String pad(int howMany) {
        return " ".repeat(Math.max(0, howMany));
    }

    public boolean serviceExists(String serviceName) {
        ArrayList<String> serviceNames = new ArrayList<String>(this.services.keySet());
        return ProjectUtils.ignoreCaseContains(serviceNames, serviceName.toLowerCase());
    }

    public boolean groupExists(String groupName) {
        ArrayList<String> groupNames = new ArrayList<String>(this.groups.keySet());
        return ProjectUtils.ignoreCaseContains(groupNames, groupName.toLowerCase());
    }

    public void reportServiceMessages(String service, Path root) {
        this.writeMessageRowHeader();
        ScriptRunnerContext ctx = ProjectConfig.getCurrentContext();
        String group = this.getService(service.toLowerCase()).getGroup();
        if (this.groupMessages.get(group.toLowerCase()) == null) {
            return;
        }
        List<VerifyServiceInterface.ServiceMessage> messages = this.groupMessages.get(group.toLowerCase()).get(service.toLowerCase());
        for (VerifyServiceInterface.ServiceMessage message : messages) {
            this.writeMessageRow(group, service, message, root);
        }
    }

    public void reportGroupMessages(String group, Path root) {
        this.writeMessageRowHeader();
        ScriptRunnerContext ctx = ProjectConfig.getCurrentContext();
        if (this.groupMessages.get(group.toLowerCase()) != null) {
            for (String service : this.groupMessages.get(group.toLowerCase()).keySet()) {
                List<VerifyServiceInterface.ServiceMessage> messages = this.groupMessages.get(group.toLowerCase()).get(service.toLowerCase());
                for (VerifyServiceInterface.ServiceMessage message : messages) {
                    this.writeMessageRow(group, service, message, root);
                }
            }
        }
    }

    public void reportAllMessages(Path root) {
        ScriptRunnerContext ctx = ProjectConfig.getCurrentContext();
        this.writeMessageRowHeader();
        for (String group : this.groupMessages.keySet()) {
            for (String service : this.groupMessages.get(group.toLowerCase()).keySet()) {
                for (VerifyServiceInterface.ServiceMessage message : this.groupMessages.get(group.toLowerCase()).get(service.toLowerCase())) {
                    this.writeMessageRow(group, service, message, root);
                }
            }
        }
    }

    private void writeMessageRowHeader() {
        ScriptRunnerContext ctx = ProjectConfig.getCurrentContext();
        ctx.writeln("Level" + VerifyEngine.pad(10 - "Level".length()) + "Group Name" + VerifyEngine.pad(15 - "Group Name".length()) + "Test Name" + VerifyEngine.pad(30 - "Test Name".length()) + "Message");
        ctx.writeln("-----" + VerifyEngine.pad(10 - "-----".length()) + "----------" + VerifyEngine.pad(15 - "----------".length()) + "-----------" + VerifyEngine.pad(30 - "-----------".length()) + "-------------------------");
    }

    private void writeMessageRow(String group, String service, VerifyServiceInterface.ServiceMessage message, Path root) {
        ScriptRunnerContext ctx = ProjectConfig.getCurrentContext();
        if (message.getLevel() == VerifyServiceInterface.MessageLevel.HIDDEN) {
            return;
        }
        String color = message.getLevel().equals((Object)VerifyServiceInterface.MessageLevel.ERROR) ? ConsoleColors.RED.code : (message.getLevel().equals((Object)VerifyServiceInterface.MessageLevel.WARN) ? ConsoleColors.YELLOW.code : ConsoleColors.GREEN.code);
        ctx.write(color + String.valueOf((Object)message.getLevel()) + VerifyEngine.pad(10 - message.getLevel().toString().length()) + ConsoleColors.RESET.code + group + VerifyEngine.pad(15 - group.length()) + service + VerifyEngine.pad(30 - service.length()) + message.getMessage());
        if (message.getType() != null && message.getType().equalsIgnoreCase("file")) {
            File file = (File)message.getDetail();
            ctx.writeln("\n  FILE: path=" + String.valueOf(root.relativize(Paths.get(file.toString(), new String[0]))));
        } else if (message.getType() != null && message.getType().equalsIgnoreCase("exception")) {
            Exception exception = (Exception)message.getDetail();
            ctx.writeln("\n  EXCEPTION: Cause=" + String.valueOf(exception.getCause()) + "\tMessage=" + exception.getMessage());
        } else {
            ctx.writeln("");
        }
    }

    public List<String> getAllServiceNames() {
        return List.copyOf(this.services.keySet());
    }

    public List<String> getAllGroupNames() {
        return List.copyOf(this.groups.keySet());
    }

    public List<String> getGroupServiceNames(@NonNull String group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        return List.copyOf(this.groups.get(group.toLowerCase()).keySet());
    }

    private VerifyServiceInterface getService(@NonNull String serviceName) {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is marked non-null but is null");
        }
        return this.services.get(serviceName.toLowerCase());
    }

    private List<VerifyServiceInterface> getGroupServices(@NonNull String group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        return List.copyOf(this.groups.get(group.toLowerCase()).values());
    }

    private boolean runService(String serviceName, HashMap<String, Object> params, boolean summary, boolean resetErrs) {
        @NonNull VerifyServiceInterface service = this.getService(serviceName.toLowerCase());
        return this.runService(service, params, summary, resetErrs);
    }

    public boolean runService(@NonNull VerifyServiceInterface service) {
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        return this.runService(service, null, false, true);
    }

    public boolean runService(@NonNull String serviceName) {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is marked non-null but is null");
        }
        return this.runService(serviceName.toLowerCase(), null);
    }

    public boolean runService(@NonNull String serviceName, HashMap<String, Object> params) {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is marked non-null but is null");
        }
        @NonNull VerifyServiceInterface service = this.getService(serviceName.toLowerCase());
        return this.runService(service, params, false, true);
    }

    private boolean runService(@NonNull VerifyServiceInterface service, HashMap<String, Object> params) {
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        return this.runService(service, params, false, true);
    }

    private boolean runService(@NonNull VerifyServiceInterface service, HashMap<String, Object> params, boolean summary, boolean resetErrs) {
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        boolean result = false;
        if (resetErrs) {
            this.groupMessages.clear();
        }
        try {
            result = service.executeTest(params);
        }
        catch (GeneralVerifyException generalVerifyException) {
            // empty catch block
        }
        if (service.getMessages() != null) {
            for (VerifyServiceInterface.ServiceMessage message : service.getMessages()) {
                this.addMessage(service.getGroup().toLowerCase(), service.getName().toLowerCase(), message);
            }
        }
        if (summary) {
            this.printMessageSummary(null, service.getName().toLowerCase());
        }
        return result;
    }

    public void printMessageSummary(String groupName, String serviceName) {
        ScriptRunnerContext ctx = ProjectConfig.getCurrentContext();
        HashMap<VerifyServiceInterface.MessageLevel, Integer> levels = new HashMap<VerifyServiceInterface.MessageLevel, Integer>();
        levels.put(VerifyServiceInterface.MessageLevel.HIDDEN, 0);
        levels.put(VerifyServiceInterface.MessageLevel.ERROR, 0);
        levels.put(VerifyServiceInterface.MessageLevel.WARN, 0);
        levels.put(VerifyServiceInterface.MessageLevel.INFO, 0);
        for (String group : this.groupMessages.keySet()) {
            for (String service : this.groupMessages.get(group.toLowerCase()).keySet()) {
                for (VerifyServiceInterface.ServiceMessage message : this.groupMessages.get(group.toLowerCase()).get(service.toLowerCase())) {
                    levels.put(message.getLevel(), (Integer)levels.get((Object)message.getLevel()) + 1);
                }
            }
        }
        ctx.writeln("-------- Results Summary ----------");
        if (groupName != null) {
            ctx.writeln(VerifyMessages.format("VERIFY_MESSAGE_GROUP", groupName, ConsoleColors.RED.code, levels.getOrDefault((Object)VerifyServiceInterface.MessageLevel.ERROR, 0), ConsoleColors.RESET.code, ConsoleColors.YELLOW.code, levels.getOrDefault((Object)VerifyServiceInterface.MessageLevel.WARN, 0), ConsoleColors.RESET.code, ConsoleColors.GREEN.code, levels.getOrDefault((Object)VerifyServiceInterface.MessageLevel.INFO, 0), ConsoleColors.RESET.code));
        } else if (serviceName != null) {
            ctx.writeln(VerifyMessages.format("VERIFY_MESSAGE_SERVICE", serviceName, ConsoleColors.RED.code, levels.getOrDefault((Object)VerifyServiceInterface.MessageLevel.ERROR, 0), ConsoleColors.RESET.code, ConsoleColors.YELLOW.code, levels.getOrDefault((Object)VerifyServiceInterface.MessageLevel.WARN, 0), ConsoleColors.RESET.code, ConsoleColors.GREEN.code, levels.getOrDefault((Object)VerifyServiceInterface.MessageLevel.INFO, 0), ConsoleColors.RESET.code));
        } else {
            ctx.writeln(VerifyMessages.format("VERIFY_MESSAGE_SUMMARY", ConsoleColors.RED.code, levels.getOrDefault((Object)VerifyServiceInterface.MessageLevel.ERROR, 0), ConsoleColors.RESET.code, ConsoleColors.YELLOW.code, levels.getOrDefault((Object)VerifyServiceInterface.MessageLevel.WARN, 0), ConsoleColors.RESET.code, ConsoleColors.GREEN.code, levels.getOrDefault((Object)VerifyServiceInterface.MessageLevel.INFO, 0), ConsoleColors.RESET.code));
        }
        if (!((Boolean)ProjectConfig.getCurrentContext().getProperty("project.debug")).booleanValue()) {
            ctx.writeln("---------------------------------\n");
        }
    }

    public boolean runGroup(@NonNull String group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        return this.runGroup(group.toLowerCase(), null);
    }

    public boolean runGroup(@NonNull String group, HashMap<String, HashMap<String, Object>> parmsSet) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        return this.runGroup(group.toLowerCase(), parmsSet, true, true);
    }

    private boolean runGroup(@NonNull String group, HashMap<String, HashMap<String, Object>> parmsSet, boolean summary, boolean clearLog) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (clearLog) {
            this.groupMessages.clear();
        }
        boolean retResult = true;
        List<String> serviceNames = this.getGroupServiceNames(group.toLowerCase());
        for (String serviceName : serviceNames) {
            VerifyServiceInterface service = this.getService(serviceName.toLowerCase());
            HashMap parms = parmsSet != null ? (HashMap)parmsSet.getOrDefault(serviceName.toLowerCase(), null) : null;
            boolean bl = this.runService(service, (HashMap<String, Object>)parms, false, false);
        }
        if (summary) {
            this.printMessageSummary(group.toLowerCase(), null);
        }
        return retResult;
    }

    public boolean runAllGroups(HashMap<String, HashMap<String, HashMap<String, Object>>> parmsSet) {
        boolean masterResult = true;
        this.groupMessages.clear();
        boolean retResult = true;
        List<String> groups = this.getAllGroupNames();
        for (String group : groups) {
            HashMap parms = parmsSet != null ? (HashMap)parmsSet.getOrDefault(group.toLowerCase(), null) : null;
            boolean result = this.runGroup(group.toLowerCase(), parms, false, false);
            if (result) continue;
            masterResult = false;
        }
        this.printMessageSummary(null, null);
        return masterResult;
    }

    public List<VerifyServiceInterface.ServiceMessage> getServiceMessages(String service) {
        return Collections.unmodifiableList(this.groupMessages.get(this.getService(service.toLowerCase()).getGroup().toLowerCase()).get(service.toLowerCase()));
    }

    public Map<String, List<VerifyServiceInterface.ServiceMessage>> getGroupMessages(String group) {
        return Collections.unmodifiableMap((Map)this.groupMessages.get(group.toLowerCase()));
    }

    public HashMap<String, HashMap<String, List<VerifyServiceInterface.ServiceMessage>>> getAllMessages() {
        return this.groupMessages;
    }

    private void addMessage(String group, String service, VerifyServiceInterface.ServiceMessage message) {
        this.groupMessages.computeIfAbsent(group.toLowerCase(), k -> new HashMap());
        this.groupMessages.get(group.toLowerCase()).computeIfAbsent(service.toLowerCase(), k -> new ArrayList());
        this.groupMessages.get(group.toLowerCase()).get(service.toLowerCase()).add(message);
    }
}

