/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.extension.project.commands.ProjectMessages;
import oracle.dbtools.extension.project.core.exceptions.FileUtilsException;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class ProjectFileUtils {
    static final int[] illegalChars = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 34, 42, 47, 58, 60, 62, 63, 92, 124};

    public static Path getCurrentWorkingProjectRoot(String directoryPath) {
        String path = ProjectFileUtils.findProjectRoot(directoryPath);
        if (path != null) {
            return Path.of(path, new String[0]);
        }
        return null;
    }

    public static String findProjectRoot(String cwd) {
        while (true) {
            String path;
            File f;
            if ((f = new File(path = cwd + File.separator + ".dbtools" + File.separator + "project.config.json")).exists()) {
                return cwd;
            }
            int pos = cwd.lastIndexOf(File.separator);
            if (pos < 0) break;
            cwd = cwd.substring(0, pos);
        }
        return null;
    }

    public static void createDir(Path dirPath, Boolean replace, boolean ignore) throws FileUtilsException {
        File file = new File(dirPath.toString());
        try {
            if (file.exists() && ignore) {
                return;
            }
            if (file.exists() && !replace.booleanValue()) {
                throw new FileAlreadyExistsException(ProjectMessages.format("FILE_ALREADY_EXISTS_EXCEPTION", dirPath));
            }
            if (file.exists() && replace.booleanValue()) {
                ProjectFileUtils.deleteDir(dirPath);
            }
            if (!file.mkdir()) {
                throw new FileUtilsException(ProjectMessages.format("FILE_NOT_CREATED_EXCEPTION", dirPath));
            }
        }
        catch (FileAlreadyExistsException | FileUtilsException e) {
            throw new FileUtilsException(e);
        }
    }

    public static boolean deleteDir(Path path) {
        boolean deleted;
        File file = new File(path.toString());
        if (!file.isDirectory()) {
            return false;
        }
        for (File f : Objects.requireNonNull(file.listFiles())) {
            if (f.isDirectory()) {
                ProjectFileUtils.deleteDir(Path.of(f.getPath(), new String[0]));
            }
            deleted = f.delete();
        }
        deleted = file.delete();
        return deleted;
    }

    public static void createFile(Path filePath, boolean replace) throws FileUtilsException {
        File file = new File(filePath.toString());
        try {
            if (file.exists() && !replace) {
                throw new FileAlreadyExistsException(ProjectMessages.format("FILE_ALREADY_EXISTS_EXCEPTION", filePath));
            }
            if (file.exists() && replace) {
                ProjectFileUtils.deleteDir(filePath);
            }
            if (!file.createNewFile()) {
                throw new FileUtilsException(ProjectMessages.format("FILE_NOT_CREATED_EXCEPTION", filePath));
            }
        }
        catch (Exception e) {
            throw new FileUtilsException(e);
        }
    }

    public static File findGitDirectory(String directoryPath) throws FileUtilsException {
        try {
            File directory = new File(directoryPath);
            if (!directory.isDirectory()) {
                throw new NotDirectoryException("NOT_DIRECTORY_EXCEPTION");
            }
            File[] files = directory.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.isDirectory() || !file.getName().equals(".git")) continue;
                    return file;
                }
            }
            if (directory.getParent() != null) {
                return ProjectFileUtils.findGitDirectory(directory.getParent());
            }
            return null;
        }
        catch (NotDirectoryException e) {
            throw new FileUtilsException(e);
        }
    }

    public static void createFileWithContent(Path file, String content) throws IOException {
        ProjectFileUtils.createFileWithContent(file, content, null);
    }

    public static void createFileWithContent(Path file, String content, Map<String, String> replaceStrings) throws IOException {
        ProjectFileUtils.createFileWithContent(file, content, replaceStrings, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
    }

    public static void createFileWithContent(Path file, String content, Map<String, String> replaceStrings, OpenOption ... options) throws IOException {
        if (replaceStrings != null) {
            for (String search : replaceStrings.keySet()) {
                content = content.replace(search, replaceStrings.get(search));
            }
        }
        Files.write(file, content.getBytes(), options);
    }

    private static File findFileInDirectory(String directoryPath, String targetFileName) throws FileUtilsException {
        try {
            File directory = new File(directoryPath);
            if (!directory.isDirectory()) {
                throw new NotDirectoryException(ProjectMessages.format("NOT_DIRECTORY_EXCEPTION", new Object[0]));
            }
            File[] files = directory.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isFile() && file.getName().equals(targetFileName)) {
                        return file;
                    }
                    if (!file.isDirectory()) continue;
                    return ProjectFileUtils.findFileInDirectory(file.getAbsolutePath(), targetFileName);
                }
            }
            return null;
        }
        catch (NotDirectoryException e) {
            throw new FileUtilsException(e);
        }
    }

    public static boolean setCurrentDirectory(String directory_name, ScriptRunnerContext ctx) {
        boolean result = false;
        File directory = new File(directory_name).getAbsoluteFile();
        if (directory.exists() || directory.mkdirs()) {
            boolean bl = result = System.setProperty("user.dir", directory.getAbsolutePath()) != null;
            if (result && ctx != null) {
                ctx.putProperty("script.runner.cd_command", (Object)directory);
                ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._PWD.toString(), directory.toString());
            }
        }
        return result;
    }

    public static String getResourcesFileContent(Path filePath) throws IOException {
        String resourcePath = String.valueOf(filePath);
        if (System.getProperty("os.name").startsWith("Windows")) {
            resourcePath = resourcePath.replace("\\", "/");
        }
        try (InputStream installReleasesStream = ProjectFileUtils.class.getClassLoader().getResourceAsStream(resourcePath);){
            assert (installReleasesStream != null);
            String string = new String(installReleasesStream.readAllBytes());
            return string;
        }
    }

    public static String findProjectRoot(ScriptRunnerContext ctx) {
        String cwd = FileUtils.getCWD((ScriptRunnerContext)ctx);
        return ProjectFileUtils.findProjectRoot(cwd);
    }

    public static String sanitizeFileName(String badFileName) {
        StringBuilder cleanName = new StringBuilder();
        int len = badFileName.codePointCount(0, badFileName.length());
        for (int i = 0; i < len; ++i) {
            int c = badFileName.codePointAt(i);
            if (Arrays.binarySearch(illegalChars, c) >= 0) continue;
            cleanName.appendCodePoint(c);
        }
        return cleanName.toString();
    }

    public static String[] getResourceListing(Class clazz, String path) throws URISyntaxException, IOException {
        URL dirURL = clazz.getClassLoader().getResource(path);
        if (dirURL != null && dirURL.getProtocol().equals("file")) {
            return new File(dirURL.toURI()).list();
        }
        if (dirURL == null) {
            String me = clazz.getName().replace(".", "/") + ".class";
            dirURL = clazz.getClassLoader().getResource(me);
        }
        if (dirURL != null && dirURL.getProtocol().equals("jar")) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            try (JarFile jar = new JarFile(URLDecoder.decode(jarPath, StandardCharsets.UTF_8));){
                Enumeration<JarEntry> entries = jar.entries();
                HashSet<String> result = new HashSet<String>();
                while (entries.hasMoreElements()) {
                    String name = entries.nextElement().getName();
                    if (!name.startsWith(path)) continue;
                    String entry = name.substring(path.length());
                    int checkSubdir = entry.indexOf("/");
                    if (checkSubdir >= 0) {
                        entry = entry.substring(0, checkSubdir);
                    }
                    result.add(entry);
                }
                String[] stringArray = result.toArray(new String[0]);
                return stringArray;
            }
        }
        throw new UnsupportedOperationException(ProjectMessages.format("CANNOT_LIST_FILES_EXCEPTION", dirURL));
    }

    public static String addExtensionIfDoesNotExist(String fileName, String extension) {
        if (fileName.contains(".")) {
            return fileName;
        }
        return fileName.endsWith(extension) ? fileName : fileName + extension;
    }

    public static String expandTilde(String path) {
        if (path.startsWith("~/")) {
            return path.replaceFirst("~/", System.getProperty("user.home") + "/");
        }
        return path;
    }

    private List<String> getDirectoryFileList(Path dir) {
        String[] dirFiles = dir.toFile().list();
        if (dirFiles != null) {
            return Arrays.asList(dirFiles);
        }
        return null;
    }
}

