/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.stage.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.extension.project.commands.export.DbObj;
import oracle.dbtools.extension.project.commands.stage.transforms.ObjectTypes;
import oracle.dbtools.extension.project.commands.stage.utils.interfaces.AbstractChangeLogSorter;
import oracle.dbtools.extension.project.core.exceptions.StageProcessException;

public class XmlChangeLogSorter
extends AbstractChangeLogSorter {
    private static final String INCLUDE_TAG = "<include";
    String regex = "file=\"([^\"]+)\"";

    @Override
    protected void buildLists(String logContents) throws IOException {
        boolean beforeIncludeTag = true;
        try (BufferedReader reader = new BufferedReader(new StringReader(logContents));){
            String currentLine;
            while ((currentLine = reader.readLine()) != null) {
                if (currentLine.startsWith(INCLUDE_TAG)) {
                    if (currentLine.contains("_custom") && beforeIncludeTag) {
                        this.getStartLines().add(currentLine);
                        continue;
                    }
                    beforeIncludeTag = false;
                    try {
                        this.getIncludedLines().add(this.processLine(currentLine));
                    }
                    catch (Exception e) {
                        this.getEndLines().add(currentLine);
                    }
                    continue;
                }
                if (beforeIncludeTag) {
                    this.getStartLines().add(currentLine);
                    continue;
                }
                this.getEndLines().add(currentLine);
            }
        }
    }

    private DbObj processLine(String line) throws Exception {
        Pattern pattern = Pattern.compile(this.regex);
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            String filePath = matcher.group(1);
            String[] vals = filePath.split("/");
            return new DbObj(vals[vals.length - 3].toUpperCase(), vals[vals.length - 1].substring(0, vals[vals.length - 1].indexOf(".")), ObjectTypes.singular(vals[vals.length - 2]), line);
        }
        throw new StageProcessException("Unable to parse " + line + " for sorting");
    }
}

