/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.stage.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import oracle.dbtools.extension.project.commands.export.DbObj;
import oracle.dbtools.extension.project.commands.stage.transforms.ObjectTypes;
import oracle.dbtools.extension.project.commands.stage.utils.interfaces.AbstractChangeLogSorter;

public class SqlChangeLogSorter
extends AbstractChangeLogSorter {
    private static final String AT_SYMBOL = "@";

    @Override
    protected void buildLists(String logContents) throws IOException {
        boolean beforeIncludeTag = true;
        try (BufferedReader reader = new BufferedReader(new StringReader(logContents));){
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith(AT_SYMBOL)) {
                    if (line.contains("_custom") && beforeIncludeTag) {
                        this.getStartLines().add(line);
                    } else {
                        try {
                            beforeIncludeTag = false;
                            this.getIncludedLines().add(this.processLine(line));
                        }
                        catch (Exception e) {
                            this.getEndLines().add(line);
                        }
                    }
                } else if (beforeIncludeTag) {
                    this.getStartLines().add(line);
                } else {
                    this.getEndLines().add(line);
                }
                line = reader.readLine();
            }
        }
    }

    private DbObj processLine(String line) {
        String cleanedLine = line.replace(AT_SYMBOL, "");
        String[] vals = cleanedLine.split("/");
        return new DbObj(vals[0].toUpperCase(), vals[2].substring(0, vals[2].indexOf(".")), ObjectTypes.singular(vals[1]), line);
    }
}

