/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.export;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.script.ScriptException;
import oracle.arbori.util.Pair;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.extension.project.commands.export.ExportMessages;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.plsql.ParsedSql;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;

public class Filters {
    private static SqlEarley earley = null;

    private static SqlEarley getEarley() {
        if (earley != null) {
            return earley;
        }
        earley = new SqlEarley(){};
        TreeSet<RuleTuple> additionalRules = new TreeSet<RuleTuple>();
        additionalRules.add(new RuleTuple("comma_separated_conditions", new String[]{"condition"}));
        additionalRules.add(new RuleTuple("comma_separated_conditions", new String[]{"identifier"}));
        additionalRules.add(new RuleTuple("comma_separated_conditions", new String[]{"comma_separated_conditions", "','", "condition"}));
        additionalRules.add(new RuleTuple("comma_separated_conditions", new String[]{"comma_separated_conditions", "','", "identifier"}));
        earley = earley.grammarExtension(additionalRules);
        earley.nullifySymbol2Recognize();
        earley.addSymbol2Recognize("comma_separated_conditions");
        return earley;
    }

    static List<String> parse(String filterStr, String fileName) throws Exception {
        final LinkedList<String> ret = new LinkedList<String>();
        if (filterStr == null) {
            return ret;
        }
        String dummy = "1=1";
        Parsed target = new Parsed((String)(filterStr = "1=1," + (String)filterStr), (Earley)Filters.getEarley(), "comma_separated_conditions");
        if (target.getSrc().size() < 5) {
            return ret;
        }
        SyntaxError error = target.getSyntaxError();
        if (error != null) {
            throw new Exception("Parsing " + fileName + ":" + error.getDetailedMessage() + "\n");
        }
        String prg = "conditions: ([node) condition |  [node) identifier) \n       &  ![node^) condition \n       &  [node-1) ',' \n->";
        Program program = new Program((Earley)Filters.getEarley());
        try {
            program.compile("conditions: ([node) condition |  [node) identifier) \n       &  ![node^) condition \n       &  [node-1) ',' \n->");
        }
        catch (ScriptException e) {
            throw new Exception(e.getMessage());
        }
        program.eval(target, new Object(){

            public void conditions(Parsed target, Map<String, ParseNode> tuple) {
                ParseNode node = tuple.get("node");
                String condition = target.getInput().substring(((LexerToken)target.getSrc().get((int)node.from)).begin, ((LexerToken)target.getSrc().get((int)(node.to - 1))).end);
                if (node.contains("identifier")) {
                    if (!condition.startsWith("\"")) {
                        return;
                    }
                    condition = condition.substring(1, condition.length() - 1);
                }
                if (!"1=1".equals(condition)) {
                    ret.add(condition);
                }
            }
        });
        return ret;
    }

    static void verify(Map<String, String> filters) throws Exception {
        for (String filter : filters.keySet()) {
            if (filter.length() == 0) continue;
            Parsed parsedF = new Parsed(filter, (Earley)SqlEarley.getInstance(), "condition");
            SyntaxError error = parsedF.getSyntaxError();
            if (error != null) {
                throw new Exception(MessageFormat.format(ExportMessages.getString("FILTER_SYNTAX_ERROR"), filter, filters.get(filter) + "\n" + error.getDetailedMessage()));
            }
            for (ParseNode node : Filters.descendants(parsedF.getRoot(), "subquery")) {
                String prefix;
                if (!node.contains("column") || node.from + 3 != node.to || Filters.isReferenced(prefix = ((LexerToken)parsedF.getSrc().get((int)node.from)).content)) continue;
                throw new Exception(MessageFormat.format(ExportMessages.getString("FILTER_DOESNT_MATCH_ANY_VIEW"), filter, filters.get(filter)));
            }
        }
    }

    static String apply(String query, Map<String, String> filters) throws Exception {
        ParsedSql parsedQ = new ParsedSql((String)query);
        HashSet columns = new HashSet();
        String prg = "whereOrFromClauses: [node) where_clause \n        | [node) from_clause \n; \ninnerClauses: [*[))node(whereOrFromClauses) \n; \nlastClause: [)[*)node(innerClauses) \n-> \ncolumns: [node) select_term \n-> \ntables: [node) query_table_expression \n     &  node) < [node + 4 --not (subquery) \n-> \n";
        final ParseNode[] lastClause = new ParseNode[1];
        final boolean[] isFrom = new boolean[]{false};
        String[] table = new String[1];
        Program program = new Program((Earley)Filters.getEarley());
        try {
            program.compile("whereOrFromClauses: [node) where_clause \n        | [node) from_clause \n; \ninnerClauses: [*[))node(whereOrFromClauses) \n; \nlastClause: [)[*)node(innerClauses) \n-> \ncolumns: [node) select_term \n-> \ntables: [node) query_table_expression \n     &  node) < [node + 4 --not (subquery) \n-> \n");
        }
        catch (ScriptException e) {
            throw new Exception(e.getMessage() + "\n");
        }
        program.eval((Parsed)parsedQ, new Object((Parsed)parsedQ, columns, table){
            final /* synthetic */ Parsed val$parsedQ;
            final /* synthetic */ Set val$columns;
            final /* synthetic */ String[] val$table;
            {
                this.val$parsedQ = parsed;
                this.val$columns = set;
                this.val$table = stringArray;
            }

            public void lastClause(Parsed target, Map<String, ParseNode> tuple) {
                ParseNode node = tuple.get("node");
                if (node.contains("from_clause")) {
                    isFrom[0] = true;
                }
                lastClause[0] = node;
            }

            public void columns(Parsed target, Map<String, ParseNode> tuple) {
                ParseNode node = tuple.get("node");
                String content = ((LexerToken)this.val$parsedQ.getSrc().get((int)(node.to - 1))).content.toUpperCase();
                this.val$columns.add(content);
            }

            public void tables(Parsed target, Map<String, ParseNode> tuple) {
                ParseNode node = tuple.get("node");
                this.val$table[0] = Filters.normalizeViewName(((LexerToken)this.val$parsedQ.getSrc().get((int)(node.to - 1))).content);
            }
        });
        StringBuilder condition = new StringBuilder();
        if (isFrom[0]) {
            condition.append("    where 1=1\n");
        }
        condition.append("--- filters ---\n");
        block2: for (String filter : filters.keySet()) {
            if (filter.length() == 0) continue;
            Parsed parsedF = new Parsed(filter, (Earley)SqlEarley.getInstance(), "condition");
            for (ParseNode node : Filters.descendants(parsedF.getRoot(), "subquery")) {
                if (!node.contains("column")) continue;
                if (node.contains("identifier") && !node.contains("table")) {
                    if (columns.contains(node.content(parsedF.getSrc()).toUpperCase())) continue;
                    continue block2;
                }
                if (node.from + 3 != node.to) continue;
                String prefix = Filters.normalizeViewName(((LexerToken)parsedF.getSrc().get((int)node.from)).content);
                if (!prefix.equals(table[0])) continue block2;
                String suffix = ((LexerToken)parsedF.getSrc().get((int)(node.to - 1))).content.toUpperCase();
                if (columns.contains(suffix)) continue;
                throw new Exception(MessageFormat.format(ExportMessages.getString("FILTER_DOESNT_MATCH_ANY_COLUMN"), filter, filters.get(filter)) + "\n" + (String)query);
            }
            condition.append("    and (" + filter + ") --<-- " + filters.get(filter) + "\n");
        }
        int pos = lastClause[0].to - 1;
        int offset = ((LexerToken)parsedQ.getSrc().get((int)pos)).end;
        ParsedSql target = new ParsedSql((String)(query = ((String)query).substring(0, offset) + " " + String.valueOf(condition) + ((String)query).substring(offset)));
        SyntaxError error = target.getSyntaxError();
        if (error != null) {
            throw error;
        }
        return query;
    }

    private static List<ParseNode> descendants(ParseNode root, String excludeBranchWPayload) {
        ArrayList<ParseNode> ret = new ArrayList<ParseNode>();
        if (root.contains(excludeBranchWPayload)) {
            return ret;
        }
        ret.add(root);
        for (ParseNode n : root.children()) {
            ret.addAll(Filters.descendants(n, excludeBranchWPayload));
        }
        return ret;
    }

    private static String normalizeViewName(String view) {
        String ret = view.toUpperCase();
        String prefix = "All_";
        if (ret.length() < prefix.length()) {
            return ret;
        }
        return prefix + ret.substring(prefix.length());
    }

    static boolean isReferenced(String view) {
        if ("APEX_APPLICATIONS".equalsIgnoreCase(view)) {
            return true;
        }
        if ("All_OBJECTS".equals(view = Filters.normalizeViewName(view))) {
            return true;
        }
        if ("All_INDEXES".equals(view)) {
            return true;
        }
        if ("All_TRIGGERS".equals(view)) {
            return true;
        }
        if ("All_SYNONYMS".equals(view)) {
            return true;
        }
        if ("All_TAB_COMMENTS".equals(view)) {
            return true;
        }
        if ("All_COL_COMMENTS".equals(view)) {
            return true;
        }
        if ("All_TAB_PRIVS".equals(view)) {
            return true;
        }
        if ("All_MVIEW_LOGS".equals(view)) {
            return true;
        }
        if ("All_DEPENDENCIES".equals(view)) {
            return true;
        }
        if ("All_QUEUE_TABLES".equals(view)) {
            return true;
        }
        if ("All_QUEUES".equals(view)) {
            return true;
        }
        return "All_CONSTRAINTS".equals(view);
    }

    static List<String> addSchemas(Collection<String> sChemas) {
        int i;
        LinkedList<String> schemas = new LinkedList<String>();
        for (String sChema : sChemas) {
            schemas.add(sChema.toUpperCase());
        }
        LinkedList<String> ret = new LinkedList<String>();
        if (schemas.size() == 0) {
            return ret;
        }
        Object ownerIn = "owner in (";
        for (int i2 = 0; i2 < schemas.size(); ++i2) {
            if (0 < i2) {
                ownerIn = (String)ownerIn + ",";
            }
            ownerIn = (String)ownerIn + "'" + (String)schemas.get(i2) + "'";
        }
        ret.add("all_objects." + (String)ownerIn + ")");
        ret.add("all_indexes." + (String)ownerIn + ")");
        ret.add("all_triggers." + (String)ownerIn + ")");
        ret.add("all_synonyms." + (String)ownerIn + ",'PUBLIC')");
        ret.add("all_tab_comments." + (String)ownerIn + ")");
        ret.add("all_col_comments." + (String)ownerIn + ")");
        ret.add("all_constraints." + (String)ownerIn + ")");
        ret.add("apex_applications." + (String)ownerIn + ")");
        ret.add("all_queue_tables." + (String)ownerIn + ")");
        ret.add("all_queues." + (String)ownerIn + ")");
        StringBuilder sb = new StringBuilder("(all_tab_privs.grantee in (");
        for (i = 0; i < schemas.size(); ++i) {
            if (0 < i) {
                sb.append(",");
            }
            sb.append("'" + (String)schemas.get(i) + "'");
        }
        sb.append(") or all_tab_privs.grantor in (");
        for (i = 0; i < schemas.size(); ++i) {
            if (0 < i) {
                sb.append(",");
            }
            sb.append("'" + (String)schemas.get(i) + "'");
        }
        sb.append("))");
        ret.add(sb.toString());
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    static List<String> addObjects(List<String> objects) {
        void var5_13;
        String objectPredicate;
        Object obj;
        int pos;
        String owner;
        Object object;
        int i;
        LinkedList<String> ret = new LinkedList<String>();
        if (objects.size() == 0) {
            return ret;
        }
        LinkedList<String> apexIds = new LinkedList<String>();
        HashSet<String> schemas = new HashSet<String>();
        for (String string : objects) {
            if (string.startsWith("APEX.")) {
                apexIds.add(string);
                continue;
            }
            int dot = string.indexOf(46);
            if (0 >= dot) continue;
            schemas.add(string.substring(0, dot).toUpperCase());
        }
        objects.removeAll(apexIds);
        String ords = null;
        for (String o : objects) {
            String obj2 = o.toLowerCase();
            if (!obj2.startsWith("ords.")) continue;
            ords = o;
            break;
        }
        if (ords != null) {
            objects.remove(ords);
        }
        StringBuilder stringBuilder = new StringBuilder("   (");
        for (i = 0; i < objects.size(); ++i) {
            if (0 < i) {
                stringBuilder.append(" or ");
            }
            object = objects.get(i);
            owner = null;
            pos = ((String)object).indexOf(46);
            if (0 < pos) {
                owner = ((String)object).substring(0, pos);
                object = ((String)object).substring(pos + 1);
            }
            if (owner != null) {
                object = (String)object + "' and all_objects.owner = '" + owner;
            }
            String objectPredicate2 = " all_objects.object_name = '" + (String)object + "'\n";
            stringBuilder.append(objectPredicate2);
        }
        stringBuilder.append(")");
        if (0 < i) {
            ret.add(stringBuilder.toString());
        }
        StringBuilder stringBuilder2 = new StringBuilder("   (");
        for (i = 0; i < objects.size(); ++i) {
            if (0 < i) {
                stringBuilder2.append(" or ");
            }
            object = objects.get(i);
            owner = null;
            pos = ((String)object).indexOf(46);
            if (0 < pos) {
                owner = ((String)object).substring(0, pos);
                object = ((String)object).substring(pos + 1);
            }
            obj = object;
            if (owner != null) {
                obj = (String)object + "' and all_indexes.table_owner = '" + owner;
            }
            objectPredicate = " all_indexes.table_name = '" + (String)obj + "'\n";
            stringBuilder2.append(objectPredicate);
            if (owner != null) {
                obj = (String)object + "' and all_indexes.object_owner = '" + owner;
            }
            objectPredicate = " or all_indexes.object_name = '" + (String)obj + "'\n";
            stringBuilder2.append(objectPredicate);
        }
        stringBuilder2.append(")");
        if (0 < i) {
            ret.add(stringBuilder2.toString());
        }
        StringBuilder stringBuilder3 = new StringBuilder("   (");
        for (i = 0; i < objects.size(); ++i) {
            if (0 < i) {
                stringBuilder3.append(" or ");
            }
            object = objects.get(i);
            owner = null;
            pos = ((String)object).indexOf(46);
            if (0 < pos) {
                owner = ((String)object).substring(0, pos);
                object = ((String)object).substring(pos + 1);
            }
            obj = object;
            if (owner != null) {
                obj = (String)object + "' and all_triggers.table_owner = '" + owner;
            }
            objectPredicate = " all_triggers.table_name = '" + (String)obj + "'\n";
            stringBuilder3.append(objectPredicate);
            if (owner != null) {
                obj = (String)object + "' and all_triggers.object_owner = '" + owner;
            }
            objectPredicate = " or all_triggers.object_name = '" + (String)obj + "'\n";
            stringBuilder3.append(objectPredicate);
        }
        stringBuilder3.append(")");
        if (0 < i) {
            ret.add(stringBuilder3.toString());
        }
        StringBuilder stringBuilder4 = new StringBuilder("   (");
        for (i = 0; i < objects.size(); ++i) {
            if (0 < i) {
                stringBuilder4.append(" or ");
            }
            object = objects.get(i);
            owner = null;
            pos = ((String)object).indexOf(46);
            if (0 < pos) {
                owner = ((String)object).substring(0, pos);
                object = ((String)object).substring(pos + 1);
            }
            if (owner != null) {
                object = (String)object + "' and owner = '" + owner;
            }
            String objectPredicate2 = " all_queue_tables.queue_table in (\n         select queue_table from all_queues where name = '" + (String)object + "')\n";
            stringBuilder4.append(objectPredicate2);
            objectPredicate2 = " or all_queue_tables.queue_table = '" + (String)object + "'\n";
            stringBuilder4.append(objectPredicate2);
        }
        stringBuilder4.append(")");
        if (0 < i) {
            ret.add(stringBuilder4.toString());
        }
        Filters.constrainExportType(objects, ret, "all_constraints", "table_name");
        Filters.constrainExportType(objects, ret, "all_tab_comments", "name");
        Filters.constrainExportType(objects, ret, "all_col_comments", "name");
        Filters.constrainExportType(objects, ret, "all_tab_privs", "table_name");
        Filters.constrainExportType(objects, ret, "all_mview_logs", "master");
        Filters.constrainExportType(objects, ret, "all_queues", "name");
        if (ret.size() == 0) {
            ret.add("export_type not in ('ALL_OBJECTS','ALL_INDEXES','ALL_TRIGGERS','ALL_TAB_PRIVS','ALL_TAB_COMMENTS','ALL_COL_COMMENTS','ALL_MVIEW_LOGS','ALL_QUEUES','ALL_QUEUE_TABLES')");
        }
        StringBuilder stringBuilder5 = new StringBuilder("application_id in (");
        for (i = 0; i < apexIds.size(); ++i) {
            int pos2;
            if (0 < i) {
                stringBuilder5.append(",");
            }
            if (0 < (pos2 = ((String)(object = (String)apexIds.get(i))).indexOf(46))) {
                object = ((String)object).substring(pos2 + 1);
            }
            if ("*".equals(object)) {
                Object var5_12 = null;
                break;
            }
            stringBuilder5.append((String)object);
        }
        if (var5_13 != null) {
            var5_13.append(")");
        }
        if (0 < i && var5_13 != null) {
            ret.add(var5_13.toString());
        } else if (var5_13 != null) {
            ret.add("export_type != 'APEX_APPLICATIONS'");
        }
        if (0 < ret.size()) {
            ret.add("export_type != 'USER'");
            if (ords == null) {
                ret.add("export_type != 'ORDS_SCHEMA'");
            } else if (objects.size() == 0) {
                ret.add("export_type = 'ORDS_SCHEMA'");
            }
        }
        return ret;
    }

    private static void constrainExportType(List<String> objects, List<String> ret, String view, String column) {
        int i;
        StringBuilder sb = new StringBuilder("   (");
        for (i = 0; i < objects.size(); ++i) {
            if (0 < i) {
                sb.append(" or ");
            }
            String object = objects.get(i);
            String owner = null;
            int pos = object.indexOf(46);
            if (0 < pos) {
                owner = object.substring(0, pos);
                object = object.substring(pos + 1);
            }
            if (owner == null) {
                sb.append(view + "." + column + " = '" + object + "'");
                continue;
            }
            if (view.toLowerCase().contains("_privs")) {
                sb.append("(" + view + ".grantor = '" + owner + "' or " + view + ".OWNER_TMP = '" + owner + "') and " + view + "." + column + " = '" + object + "'");
                continue;
            }
            sb.append(view + ".owner = '" + owner + "' and " + view + "." + column + " = '" + object + "'");
        }
        sb.append(")");
        if (0 < i) {
            ret.add(sb.toString());
        }
    }

    public static Pair<String, String> qualifiedObject(String objectName) {
        int pos = objectName.indexOf(46);
        String owner = null;
        if (0 < pos) {
            owner = objectName.substring(0, pos);
            objectName = objectName.substring(pos + 1);
            owner = owner.charAt(0) == '\"' ? owner.substring(1, owner.length() - 1) : owner.toUpperCase();
        }
        objectName = objectName.charAt(0) == '\"' ? objectName.substring(1, objectName.length() - 1) : objectName.toUpperCase();
        return new Pair((Object)owner, (Object)objectName);
    }
}

