/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.export;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import oracle.arbori.util.CharOffsets;
import oracle.arbori.util.DbObjNames;
import oracle.arbori.util.DictionaryViews;
import oracle.arbori.util.IO;
import oracle.arbori.util.Pair;
import oracle.dbtools.extension.project.commands.export.CancelExport;
import oracle.dbtools.extension.project.commands.export.DDL;
import oracle.dbtools.extension.project.commands.export.DbObj;
import oracle.dbtools.extension.project.commands.export.DbmsMetadata;
import oracle.dbtools.extension.project.commands.export.ExportMessages;
import oracle.dbtools.extension.project.commands.export.Filters;
import oracle.dbtools.extension.project.commands.export.Ords;
import oracle.dbtools.extension.project.commands.export.Report;
import oracle.dbtools.extension.project.commands.export.UnarySqlPredicate;
import oracle.dbtools.extension.project.commands.stage.transforms.ObjectTypes;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.messages.GeneralMessages;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.extension.project.core.utils.Format;
import oracle.dbtools.extension.project.core.utils.ProjectFileUtils;
import oracle.dbtools.extension.project.core.utils.ProjectUtils;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.util.SpinningWheel;

public class Export {
    private static final String OBJECTS_EXPORT_OPTION = " -objects export option";
    public static final String APEX_APPLICATIONS = "APEX_APPLICATIONS";
    public static final String ORDS_SCHEMA = "ORDS_SCHEMA";
    public static final String ALL_OBJECTS = "ALL_OBJECTS";
    public static final String ALL_INDEXES = "ALL_INDEXES";
    public static final String ALL_TRIGGERS = "ALL_TRIGGERS";
    public static final String ALL_SYNONYMS = "ALL_SYNONYMS";
    public static final String ALL_TAB_COMMENTS = "ALL_TAB_COMMENTS";
    public static final String ALL_COL_COMMENTS = "ALL_COL_COMMENTS";
    public static final String ALL_TAB_COL_COMMENTS = "ALL_TAB_COL_COMMENTS";
    public static final String USER_SYS_PRIVS = "USER_SYS_PRIVS";
    public static final String ALL_TAB_PRIVS = "ALL_TAB_PRIVS";
    public static final String ALL_DEPENDENCIES = "ALL_DEPENDENCIES";
    public static final String ALL_MVIEW_LOGS = "ALL_MVIEW_LOGS";
    public static final String ALL_QUEUE_TABLES = "ALL_QUEUE_TABLES";
    public static final String ALL_QUEUES = "ALL_QUEUES";
    public static boolean test = false;
    DbmsMetadata[] workers;
    Queue<DbObj> workQueue;
    Map<DbObj, Pair<String, String>> ret;
    int threads;
    ScriptRunnerContext ctx;
    final Connection conn;
    Map<String, String> filters;
    DictionaryViews dictViews;
    String projectPath;
    boolean listOnly;
    Map<String, Object> ddlParams;
    Report report;
    private String typ;
    private String nam;

    boolean isAPI() {
        return this.ddlParams != null;
    }

    /*
     * WARNING - void declaration
     */
    public Export(ScriptRunnerContext ctx, List<String> schemas, List<String> objects, int threads, boolean listOnly) throws Exception {
        List<Object> tmp;
        List<String> configSchemas;
        block24: {
            this.workQueue = new LinkedList<DbObj>();
            this.ret = new ConcurrentHashMap<DbObj, Pair<String, String>>();
            this.filters = new HashMap<String, String>();
            this.ddlParams = null;
            this.typ = "null";
            this.nam = "null";
            this.threads = threads;
            this.ctx = ctx;
            this.listOnly = listOnly;
            this.projectPath = ProjectFileUtils.findProjectRoot(ctx);
            if (this.projectPath == null) {
                throw new Exception(ExportMessages.getString("EXPORT_PROJECT_NOT_IDENTIFIED"));
            }
            if (!this.projectPath.endsWith("/")) {
                this.projectPath = this.projectPath + "/";
            }
            this.conn = ProjectUtils.getConnection(ctx, true);
            if (null == this.conn) {
                return;
            }
            this.report = new Report(this);
            this.dictViews = new DictionaryViews(this.conn);
            configSchemas = ProjectSettings.getSettingAsList("schemas");
            if (configSchemas.size() == 0) {
                throw new Exception(ExportMessages.getString("EXPORT_PROJECT_SETTINGS_NO_SCHEMAS"));
            }
            tmp = new LinkedList();
            String configFiltersDir = this.projectPath + File.separator + ".dbtools" + File.separator + "filters";
            try {
                boolean bl;
                String canonicalInternalFilters = ProjectFileUtils.getResourcesFileContent(Paths.get("export/filters/internal.fixed.filters", new String[0]));
                boolean bl2 = false;
                for (File file : IO.visitor4Directory((String)configFiltersDir, (String[])new String[]{"filter", "filters", "condition", "conditions"})) {
                    void var13_34;
                    String string = file.toString();
                    String content = IO.readFile((String)string);
                    int pos = string.lastIndexOf(File.separator);
                    if (0 < pos) {
                        String string2 = string.substring(pos + 1);
                    }
                    if (var13_34.contains("internal")) {
                        bl = true;
                        int lineDiff = CharOffsets.lineDiff((String)content, (String)canonicalInternalFilters);
                        if (-1 < lineDiff) {
                            Report.warning(ctx, ExportMessages.getString("INTERNAL_FILTERS_FOUND"));
                        }
                    }
                    if ((tmp = Filters.parse(content, (String)var13_34)) == null) {
                        return;
                    }
                    for (String string3 : tmp) {
                        this.filters.put(string3, (String)var13_34);
                    }
                }
                if (!bl) {
                    String string = "sqlcl internal.fixed.filters";
                    tmp = Filters.parse(canonicalInternalFilters, string);
                    for (String string4 : tmp) {
                        this.filters.put(string4, string);
                    }
                }
            }
            catch (IOException e) {
                if (!ProjectConfig.isDebug()) break block24;
                Report.warning(ctx, "Warning: " + e.getMessage() + " not found\n");
            }
        }
        if (schemas.size() == 0 && objects.size() == 0) {
            if (configSchemas != null && 0 < configSchemas.size()) {
                tmp = Filters.addSchemas(configSchemas);
                for (String string : tmp) {
                    this.filters.put(string, "config schemas");
                }
            } else {
                LinkedList<String> ts = new LinkedList<String>();
                ts.add(this.conn.getSchema());
                tmp = Filters.addSchemas(ts);
                for (String string : tmp) {
                    this.filters.put(string, "current connection");
                }
            }
        } else {
            boolean bl;
            String cmt = " -schemas export option";
            tmp = Filters.addSchemas(schemas);
            boolean bl3 = false;
            for (String string : objects) {
                if (0 >= string.indexOf(46)) continue;
                bl = true;
                break;
            }
            if (tmp.size() == 0 && !bl) {
                cmt = "config schemas";
                tmp = Filters.addSchemas(configSchemas);
            }
            for (String string : tmp) {
                this.filters.put(string, cmt);
            }
            tmp = Filters.addObjects(objects);
            for (String string : tmp) {
                this.filters.put(string, OBJECTS_EXPORT_OPTION);
            }
        }
    }

    public Export(ScriptRunnerContext ctx, Connection conn, Map<String, Object> ddlParams) {
        this.workQueue = new LinkedList<DbObj>();
        this.ret = new ConcurrentHashMap<DbObj, Pair<String, String>>();
        this.filters = new HashMap<String, String>();
        this.ddlParams = null;
        this.typ = "null";
        this.nam = "null";
        this.threads = 5;
        this.ctx = ctx;
        this.listOnly = false;
        this.conn = conn;
        this.ddlParams = ddlParams == null ? new HashMap<String, Object>() : ddlParams;
        this.report = new Report(this);
        this.projectPath = null;
        this.dictViews = new DictionaryViews(conn);
    }

    public static Map<DbObj, Pair<String, String>> export(ScriptRunnerContext ctx, Connection conn, Map<String, String> filters, Map<String, Object> ddlParams) throws SyntaxError, Exception {
        Export export = new Export(ctx, conn, ddlParams);
        export.filters = filters;
        export.export();
        return export.ret;
    }

    void export() throws Exception, SyntaxError {
        try {
            this.doExport();
            this.waitWorkers();
        }
        finally {
            this.quitWorkers();
            if (this.report != null) {
                this.report.summary();
                if (0 < this.report.invalid.size()) {
                    Report.warning(this.ctx, "The following objects have status \"invalid\":");
                }
                for (DbObj obj : this.report.invalid) {
                    Report.warning(this.ctx, obj.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExport() throws Exception {
        String type;
        String name;
        String owner;
        ResultSet rs;
        Statement stmt;
        long t1;
        Object query;
        String priorType;
        ScriptExecutor sqlcl;
        block165: {
            String type2;
            boolean emitSchema = Boolean.TRUE.equals(ProjectSettings.getSettingAsBoolean("export.setTransform.emitSchema"));
            Filters.verify(this.filters);
            sqlcl = (ScriptExecutor)this.ctx.getProperty("runner");
            String objectColumns = "    OWNER, OBJECT_NAME, SUBOBJECT_NAME, OBJECT_ID, DATA_OBJECT_ID,\n    OBJECT_TYPE, CREATED, LAST_DDL_TIME, TIMESTAMP, STATUS,\n    TEMPORARY, GENERATED, SECONDARY, NAMESPACE, EDITION_NAME,\n    SHARING, EDITIONABLE, ORACLE_MAINTAINED, APPLICATION, DEFAULT_COLLATION,\n    DUPLICATED, SHARDED, CREATED_APPID, CREATED_VSNID,\n    MODIFIED_APPID, MODIFIED_VSNID";
            SpinningWheel.start((ScriptRunnerContext)this.ctx);
            priorType = "N/A";
            HashSet<String> objects = new HashSet<String>();
            HashSet<String> tables = new HashSet<String>();
            HashSet<CallSite> mvs = new HashSet<CallSite>();
            HashSet<String> owners = new HashSet<String>();
            query = "select * from (SELECT " + objectColumns + " , 'ALL_OBJECTS' EXPORT_TYPE \nFROM   all_objects) all_objects\nORDER BY case \n            when object_type = 'MATERIALIZED VIEW' then 'A1' \n            when object_type = 'TABLE'             then 'A2' \n            when object_type = 'VIEW'              then 'A3' \n            else object_type          end,\n         owner, \n         object_name";
            query = Filters.apply((String)query, this.filters);
            query = this.dictViews.translate((String)query);
            t1 = System.currentTimeMillis();
            if (this.isApplicable(ALL_OBJECTS)) {
                GeneralMessages.debugMessage("/* Main dictionary query against ALL_OBJECTS: */\n" + (String)query);
                try (Statement stmt2 = this.conn.createStatement();
                     ResultSet rs2 = stmt2.executeQuery((String)query);){
                    GeneralMessages.debugMessage("Elapsed = " + (System.currentTimeMillis() - t1) / 1000L + "s");
                    while (rs2.next()) {
                        if (sqlcl != null && sqlcl.getInterrupted()) {
                            this.cancelExport();
                        }
                        String owner2 = rs2.getString("owner");
                        String name2 = rs2.getString("object_name");
                        String type3 = rs2.getString("object_type");
                        String status = rs2.getString("status");
                        if ("INVALID".equals(status)) {
                            this.report.invalid.add(new DbObj(owner2, name2, type3));
                        }
                        this.nam = name2;
                        this.typ = type3;
                        String qualifiedName = owner2 + "." + name2;
                        objects.add(qualifiedName);
                        if ("MATERIALIZED VIEW".equals(type3)) {
                            mvs.add((CallSite)((Object)qualifiedName));
                        }
                        if ("TABLE".equals(type3)) {
                            if (mvs.contains(qualifiedName)) continue;
                            tables.add(qualifiedName);
                        }
                        owners.add(owner2);
                        priorType = type3;
                        this.handle(new DbObj(owner2, name2, type3));
                    }
                }
                catch (Throwable e) {
                    Report.processException(this.ctx, e, this.typ, this.nam);
                    return;
                }
            }
            HashSet<String> tablesAndMvs = new HashSet<String>(tables);
            tablesAndMvs.addAll(mvs);
            priorType = this.queryDependentType(sqlcl, priorType, tablesAndMvs, owners, "INDEX");
            if (priorType == null) {
                return;
            }
            if ((priorType = this.queryDependentType(sqlcl, priorType, tablesAndMvs, owners, "TRIGGER")) == null) {
                return;
            }
            if ((priorType = this.queryDependentType(sqlcl, priorType, objects, owners, "SYNONYM")) == null) {
                return;
            }
            for (String owner2 : owners) {
                if (this.listOnly || !this.isApplicable("USER")) break;
                Object ddl = "create user " + owner2 + " no authentication;\n";
                ddl = DbmsMetadata.appendSxmlAndHash(this.conn.getSchema(), "USER", owner2, (String)ddl, null);
                DbmsMetadata.saveDbObject(this, owner2, "USER", owner2, (String)ddl);
            }
            String template = "'comment on table HR.COUNTRIES is '''||REPLACE(comments,'''','''''')||''';'";
            template = emitSchema ? template.replace("HR.COUNTRIES", "'||owner||'.'||table_name||'") : template.replace("HR.COUNTRIES", "'||table_name||'");
            String type4 = "COMMENT";
            query = "/* Query ALL_TAB_COMMENTS: */\nSELECT * from (select owner, table_name name, " + template + " ddl, \n'ALL_TAB_COMMENTS' export_type \nFROM   all_tab_comments \nWHERE  comments is not null) all_tab_comments\n\n";
            Map<String, String> object2ddl = new DDL((String)query, this).generate(type4, null, tables);
            template = "'comment on column HR.COUNTRIES.'||column_name||' is '''||REPLACE(comments,'''','''''')||''';'";
            template = emitSchema ? template.replace("HR.COUNTRIES", "'||owner||'.'||table_name||'") : template.replace("HR.COUNTRIES", "'||table_name||'");
            query = "/* Query ALL_COL_COMMENTS: */\nSELECT * from (select owner, table_name name, column_name, " + template + " ddl, \n'ALL_COL_COMMENTS' export_type \nFROM   all_col_comments \nWHERE  comments is not null) all_col_comments\norder by name, column_name\n";
            SpinningWheel.start((ScriptRunnerContext)this.ctx);
            if (this.isApplicable(ALL_COL_COMMENTS)) {
                object2ddl = new DDL((String)query, this).generate(null, object2ddl, tables);
                if (!this.listOnly) {
                    DbmsMetadata.saveObjects(object2ddl, type4, this);
                }
            }
            query = "select * from (SELECT          LOG_OWNER OWNER,\n         MASTER,\n         LOG_TABLE,\n         LOG_TRIGGER,\n         ROWIDS,\n         PRIMARY_KEY,\n         OBJECT_ID,\n         FILTER_COLUMNS,\n         SEQUENCE,\n         INCLUDE_NEW_VALUES,\n         PURGE_ASYNCHRONOUS,\n         PURGE_DEFERRED,\n         PURGE_START,\n         PURGE_INTERVAL,\n         LAST_PURGE_DATE,\n         LAST_PURGE_STATUS,\n         NUM_ROWS_PURGED,\n         COMMIT_SCN_BASED,\n         STAGING_LOG\n          , 'ALL_MVIEW_LOGS' EXPORT_TYPE \nFROM   all_mview_logs) all_mview_logs\nORDER BY OWNER, MASTER";
            query = Filters.apply((String)query, this.filters);
            query = this.dictViews.translate((String)query);
            t1 = System.currentTimeMillis();
            if (this.isApplicable(ALL_MVIEW_LOGS)) {
                GeneralMessages.debugMessage("/* Main dictionary query against ALL_MVIEW_LOGS: */\n" + (String)query);
                try {
                    stmt = this.conn.createStatement();
                    try {
                        rs = stmt.executeQuery((String)query);
                        try {
                            GeneralMessages.debugMessage("Elapsed = " + (System.currentTimeMillis() - t1) / 1000L + "s");
                            while (rs.next()) {
                                if (sqlcl != null && sqlcl.getInterrupted()) {
                                    this.cancelExport();
                                }
                                owner = rs.getString("owner");
                                name = rs.getString("master");
                                String log_table = rs.getString("log_table");
                                if (!tables.contains(owner + "." + name) && !mvs.contains(owner + "." + name)) continue;
                                type2 = "MATERIALIZED_VIEW_LOG";
                                this.nam = log_table;
                                this.typ = type2;
                                priorType = type2;
                                this.handle(new DbObj(owner, log_table, type2));
                            }
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                    }
                    finally {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                }
                catch (Throwable e) {
                    Report.processException(this.ctx, e, this.typ, this.nam);
                    return;
                }
            }
            query = "select * from (SELECT owner, constraint_name, table_name, \n       r_owner, r_constraint_name, generated \n , 'ALL_OBJECTS' EXPORT_TYPE \nFROM   sys.all_constraints \nWHERE  constraint_type in ('R') \n) all_constraints \n";
            query = Filters.apply((String)query, this.filters);
            query = this.dictViews.translate((String)query);
            t1 = System.currentTimeMillis();
            SpinningWheel.start((OutputStream)this.ctx.getOutputStream());
            if (this.isApplicable(ALL_OBJECTS)) {
                GeneralMessages.debugMessage("/* Query ALL_CONSTRAINTS: */\n" + (String)query);
                stmt = this.conn.createStatement();
                try {
                    rs = stmt.executeQuery((String)query);
                    try {
                        GeneralMessages.debugMessage("Elapsed = " + (System.currentTimeMillis() - t1) / 1000L + "s");
                        while (rs.next()) {
                            if (sqlcl != null && sqlcl.getInterrupted()) {
                                this.cancelExport();
                            }
                            owner = rs.getString("owner");
                            name = rs.getString("constraint_name");
                            String table_name = rs.getString("table_name");
                            type2 = "REF_CONSTRAINT";
                            if (!tables.contains(owner + "." + table_name)) continue;
                            priorType = type2;
                            this.handle(new DbObj(owner, name, type2));
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            query = "select * from (select GRANTOR, -- need explicit select terms for filter application \n       GRANTEE, \n       TABLE_SCHEMA  OWNER_TMP,   --<-- inconsistent dictionary views column name\n       TABLE_NAME         , \n       PRIVILEGE          ,  \n       GRANTABLE          ,   \n       HIERARCHY          ,   \n       COMMON             ,   \n       TYPE               ,  \n       INHERITED             \n , 'ALL_TAB_PRIVS' EXPORT_TYPE \nfrom   ALL_TAB_PRIVS where type != 'USER') ALL_TAB_PRIVS \n";
            query = Filters.apply((String)query, this.filters);
            if (((String)(query = this.dictViews.translate((String)query))).contains("Dba_tab_privs")) {
                query = ((String)query).replace("TABLE_SCHEMA", "OWNER");
            }
            query = ((String)query).replace("OWNER_TMP", "OWNER");
            SpinningWheel.start((ScriptRunnerContext)this.ctx);
            t1 = System.currentTimeMillis();
            if (this.isApplicable(ALL_TAB_PRIVS)) {
                GeneralMessages.debugMessage("/* Query ALL_TAB_PRIVS: */\n" + (String)query);
                stmt = this.conn.createStatement();
                try {
                    rs = stmt.executeQuery((String)query);
                    try {
                        GeneralMessages.debugMessage("Elapsed = " + (System.currentTimeMillis() - t1) / 1000L + "s");
                        HashMap<CallSite, CallSite> file2ddl = new HashMap<CallSite, CallSite>();
                        while (rs.next()) {
                            if (sqlcl != null && sqlcl.getInterrupted()) {
                                this.cancelExport();
                            }
                            String grant = "GRANT";
                            this.report.incrTypeCnt("GRANT");
                            priorType = "GRANT";
                            String grantee = rs.getString("grantee");
                            String grantor = rs.getString("grantor");
                            String table_schema = rs.getString("owner");
                            if (table_schema == null) {
                                throw new Exception("table_schema == null");
                            }
                            String table_name = rs.getString("table_name");
                            String grantable = rs.getString("grantable");
                            String privilege = rs.getString("privilege");
                            String type5 = rs.getString("type");
                            Object ddl = "grant " + privilege + " on " + (String)("DIRECTORY".equals(type5 = DbmsMetadata.toMetadataTypeName(type5)) ? type5 + " " : "") + (String)(emitSchema ? table_schema + "." : "") + DbObjNames.addDoubleQuote((String)table_name) + " to " + grantee + ("YES".equals(grantable) ? " with grant option" : "") + ";";
                            if (this.listOnly) continue;
                            try {
                                long t11 = System.currentTimeMillis();
                                ddl = Format.format((String)ddl);
                                this.report.formatTiming += System.currentTimeMillis() - t11;
                            }
                            catch (Exception e) {
                                Report.warning(this.ctx, "Failed formatting grants");
                            }
                            String filename = "object_grants_as_grantor." + table_schema + "." + type5 + "." + table_name.replaceAll("/", "_");
                            String tmp = (String)file2ddl.get(table_schema + "." + filename);
                            if (tmp == null) {
                                tmp = "";
                            }
                            file2ddl.put((CallSite)((Object)(table_schema + "." + filename)), (CallSite)((Object)(tmp + (String)ddl + "\n\n")));
                        }
                        for (String key : file2ddl.keySet()) {
                            int pos = key.indexOf(".");
                            String ddl = (String)file2ddl.get(key);
                            try {
                                ddl = DbmsMetadata.appendSxmlAndHash(this.conn.getSchema(), "OBJECT_GRANT", key.substring(pos + 1), ddl, null);
                            }
                            catch (NoSuchAlgorithmException e) {
                                Report.error(this.ctx, e.getMessage());
                            }
                            DbmsMetadata.saveDbObject(this, key.substring(0, pos), "OBJECT_GRANT", key.substring(pos + 1), ddl);
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            query = "select * from (select  APPLICATION_ID,   \n       APPLICATION_NAME, \n       OWNER          , \n       WORKSPACE             , \n       WORKSPACE_DISPLAY_NAME ,\n       ALIAS,\n       APPLICATION_GROUP,\n       APPLICATION_GROUP_ID,\n       IS_WORKING_COPY,\n       MAIN_APPLICATION_ID,\n'APEX_APPLICATIONS' EXPORT_TYPE \nfrom   APEX_APPLICATIONS) APEX_APPLICATIONS\n";
            query = Filters.apply((String)query, this.filters);
            t1 = System.currentTimeMillis();
            if (this.isApplicable(APEX_APPLICATIONS)) {
                GeneralMessages.debugMessage("/* Query APEX_APPLICATIONS: */\n" + (String)query);
                try {
                    stmt = this.conn.createStatement();
                    try {
                        rs = stmt.executeQuery((String)query);
                        try {
                            GeneralMessages.debugMessage("Elapsed = " + (System.currentTimeMillis() - t1) / 1000L + "s");
                            while (rs.next()) {
                                if (!APEX_APPLICATIONS.equals(priorType)) {
                                    this.report.writeExportType(this.ctx, "*** APEX_APPLICATIONS ***");
                                }
                                SpinningWheel.start((ScriptRunnerContext)this.ctx);
                                priorType = APEX_APPLICATIONS;
                                if (sqlcl != null && sqlcl.getInterrupted()) {
                                    this.cancelExport();
                                }
                                String id = rs.getString("application_id");
                                String apex_owner = rs.getString("owner").toLowerCase();
                                if (this.listOnly) {
                                    this.ctx.writeln("application_id=" + id);
                                    continue;
                                }
                                this.handle(new DbObj(apex_owner, id, "APEX"));
                            }
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                    }
                    finally {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                }
                catch (Exception e) {
                    if (e.getMessage().contains("ORA-00942")) {
                        if (ProjectConfig.isDebug()) {
                            Report.warning(this.ctx, (String)query + "\n" + e.getMessage());
                        }
                        break block165;
                    }
                    throw e;
                }
                finally {
                    Report.write(this.ctx, "");
                }
            }
        }
        t1 = System.currentTimeMillis();
        query = "select * from ( \n SELECT ords_metadata.ords_export.export_schema() out, \n                        'ORDS_SCHEMA'\n                          EXPORT_TYPE \n  FROM dual)";
        query = Filters.apply((String)query, this.filters);
        if (this.isApplicable(ORDS_SCHEMA)) {
            SpinningWheel.start((ScriptRunnerContext)this.ctx);
            GeneralMessages.debugMessage("/* Query ORDS: */\n" + (String)query);
            try {
                stmt = this.conn.createStatement();
                try {
                    rs = stmt.executeQuery((String)query);
                    try {
                        rs.next();
                        String ords = rs.getString(1);
                        this.report.writeExportType(this.ctx, "*** ORDS_SCHEMA ***");
                        priorType = ORDS_SCHEMA;
                        if (!this.listOnly) {
                            Object path = DbmsMetadata.makeSrcDatabaseOwnerDir(this, this.conn.getSchema());
                            path = (String)path + "/ords";
                            String name3 = "ords";
                            File f = new File((String)path);
                            if (!f.exists()) {
                                f.mkdirs();
                            }
                            Path file = Paths.get((String)path, name3 + ".sql");
                            ords = Ords.postprocess(ords, this.conn);
                            ords = DbmsMetadata.appendSxmlAndHash(this.conn.getSchema(), ORDS_SCHEMA, name3, ords, null);
                            ProjectFileUtils.createFileWithContent(file, ords);
                        }
                        this.report.incrTypeCnt(ORDS_SCHEMA);
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            catch (Exception e) {
                if (e.getMessage().contains("ORA-00904") && ProjectConfig.isDebug()) {
                    Report.warning(this.ctx, (String)query + "\n" + e.getMessage());
                }
                if (!"Result set after last row".equals(e.getMessage()) && ProjectConfig.isDebug()) {
                    Report.warning(this.ctx, "Failed to export ords  due to " + e.getMessage());
                }
            }
            finally {
                Report.write(this.ctx, "");
                GeneralMessages.debugMessage("Elapsed = " + (System.currentTimeMillis() - t1) / 1000L + "s");
            }
        }
        query = "select * from (select  OWNER,\nQUEUE_TABLE,\nTYPE,\nOBJECT_TYPE QUEUE_OBJECT_TYPE,\n'AQ QUEUE TABLE' OBJECT_TYPE,\nSORT_ORDER,\nRECIPIENTS,\nMESSAGE_GROUPING,\nREPLICATION_MODE,\nCOMPATIBLE,\nPRIMARY_INSTANCE,\nSECONDARY_INSTANCE,\nOWNER_INSTANCE,\nUSER_COMMENT,\nSECURE, 'ALL_QUEUE_TABLES' EXPORT_TYPE \nfrom   ALL_QUEUE_TABLES) ALL_QUEUE_TABLES\n";
        query = Filters.apply((String)query, this.filters);
        query = this.dictViews.translate((String)query);
        t1 = System.currentTimeMillis();
        SpinningWheel.start((OutputStream)this.ctx.getOutputStream());
        if (this.isApplicable(ALL_QUEUE_TABLES)) {
            GeneralMessages.debugMessage("/* Query ALL_QUEUE_TABLES: */\n" + (String)query);
            stmt = this.conn.createStatement();
            try {
                rs = stmt.executeQuery((String)query);
                try {
                    GeneralMessages.debugMessage("Elapsed = " + (System.currentTimeMillis() - t1) / 1000L + "s");
                    while (rs.next()) {
                        if (sqlcl != null && sqlcl.getInterrupted()) {
                            this.cancelExport();
                        }
                        owner = rs.getString("owner");
                        name = rs.getString("QUEUE_TABLE");
                        priorType = type = "AQ_QUEUE_TABLE";
                        this.handle(new DbObj(owner, name, type));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        query = "select * from (select  OWNER,\nNAME,\nQUEUE_TABLE,\nQID,\nQUEUE_TYPE,\nMAX_RETRIES,\nRETRY_DELAY,\nENQUEUE_ENABLED,\nDEQUEUE_ENABLED,\nRETENTION,\nUSER_COMMENT,\nNETWORK_NAME,\nSHARDED,\n'' OBJECT_TYPE,\n'ALL_QUEUES' EXPORT_TYPE \nfrom   ALL_QUEUES) ALL_QUEUES\n";
        query = Filters.apply((String)query, this.filters);
        query = this.dictViews.translate((String)query);
        t1 = System.currentTimeMillis();
        SpinningWheel.start((OutputStream)this.ctx.getOutputStream());
        if (this.isApplicable(ALL_QUEUES)) {
            GeneralMessages.debugMessage("/* Query ALL_QUEUES: */\n" + (String)query);
            stmt = this.conn.createStatement();
            try {
                rs = stmt.executeQuery((String)query);
                try {
                    GeneralMessages.debugMessage("Elapsed = " + (System.currentTimeMillis() - t1) / 1000L + "s");
                    while (rs.next()) {
                        if (sqlcl != null && sqlcl.getInterrupted()) {
                            this.cancelExport();
                        }
                        owner = rs.getString("owner");
                        name = rs.getString("name");
                        priorType = type = "AQ_QUEUE";
                        this.handle(new DbObj(owner, name, type));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    private boolean isApplicable(String view) throws Exception {
        UnarySqlPredicate pred = new UnarySqlPredicate(this.conn, "export_type", new String[]{view});
        String probe = pred.eval(this.filters);
        if (probe != null) {
            GeneralMessages.debugMessage("Query against " + view + " is skipped due to the empty result set from: \n" + probe);
        }
        if (this.workers == null && probe == null) {
            this.initWorkers();
        }
        return probe == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String queryDependentType(ScriptExecutor sqlcl, String priorType, Set<String> objects, Set<String> owners, String objType) throws Exception {
        if (!this.isApplicable("ALL_" + ObjectTypes.plural(objType))) {
            return priorType;
        }
        Object extraAttributes = "";
        if ("INDEX".equals(objType)) {
            extraAttributes = (String)extraAttributes + "GENERATED,SECONDARY,CONSTRAINT_INDEX, \n";
        }
        if ("INDEX".equals(objType) || "TRIGGER".equals(objType)) {
            extraAttributes = (String)extraAttributes + objType + "_TYPE, STATUS, \n";
        }
        Object query = "select * from (SELECT \n" + objType + "_NAME OBJECT_NAME, \n" + objType + "_NAME NAME, \n OWNER, \n OWNER OBJECT_OWNER, \n OWNER " + objType + "_OWNER, \nTABLE_NAME, \nTABLE_OWNER, \n" + (String)extraAttributes + "'" + objType + "' OBJECT_TYPE \n , 'ALL_" + ObjectTypes.plural(objType) + "' EXPORT_TYPE \nFROM  ALL_" + ObjectTypes.plural(objType) + ") ALL_" + ObjectTypes.plural(objType) + "\n";
        query = Filters.apply((String)query, this.filters);
        query = this.dictViews.translate((String)query);
        GeneralMessages.debugMessage("/* Dictionary query against ALL_" + ObjectTypes.plural(objType) + ": */\n" + (String)query);
        long t1 = System.currentTimeMillis();
        try {
            try (Statement stmt = this.conn.createStatement();
                 ResultSet rs = stmt.executeQuery((String)query);){
                GeneralMessages.debugMessage("Elapsed = " + (System.currentTimeMillis() - t1) / 1000L + "s");
                while (rs.next()) {
                    String type;
                    String name;
                    String owner;
                    block25: {
                        if (sqlcl != null && sqlcl.getInterrupted()) {
                            this.cancelExport();
                        }
                        owner = rs.getString("owner");
                        name = rs.getString("object_name");
                        type = rs.getString("object_type");
                        try {
                            String status = rs.getString("status");
                            if ("INVALID".equals(status)) {
                                this.report.invalid.add(new DbObj(owner, name, type));
                            }
                        }
                        catch (SQLException e) {
                            if (e.getErrorCode() == 17006) break block25;
                            throw e;
                        }
                    }
                    this.nam = name;
                    this.typ = type;
                    String tName = rs.getString("table_name");
                    String fullTName = rs.getString("table_owner") + "." + tName;
                    if (!objects.contains(fullTName) && (!this.filters.containsValue(OBJECTS_EXPORT_OPTION) || "SYNONYM".equals(objType)) || "SYNONYM".equals(objType) && tName.toLowerCase().equals(name)) continue;
                    owners.add(owner);
                    priorType = type;
                    this.handle(new DbObj(owner, name, type));
                }
                return priorType;
            }
            catch (Throwable e) {
                Report.processException(this.ctx, e, this.typ, this.nam);
                Object var11_13 = null;
                return var11_13;
            }
        }
        finally {
            return priorType;
        }
    }

    void initWorkers() throws SQLException {
        this.workers = new DbmsMetadata[this.threads];
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i] = new DbmsMetadata(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(DbObj obj) {
        if (this.listOnly) {
            this.report.incrTypeCnt(obj);
            Report.writeln(this.ctx, obj.owner + "." + obj.name);
            return;
        }
        Queue<DbObj> queue = this.workQueue;
        synchronized (queue) {
            this.workQueue.add(obj);
        }
    }

    void cancelExport() throws CancelExport {
        this.workQueue.clear();
        throw new CancelExport();
    }

    void waitWorkers() {
        if (this.workers == null) {
            return;
        }
        SpinningWheel.start();
        ScriptExecutor sqlcl = (ScriptExecutor)this.ctx.getProperty("runner");
        while (!this.workQueue.isEmpty()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (sqlcl == null || !sqlcl.getInterrupted()) continue;
            SpinningWheel.stop();
            return;
        }
    }

    void quitWorkers() {
        if (this.workers == null) {
            return;
        }
        SpinningWheel.start();
        ScriptExecutor sqlcl = (ScriptExecutor)this.ctx.getProperty("runner");
        for (DbmsMetadata dm : this.workers) {
            dm.quit = true;
        }
        block3: while (true) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (sqlcl != null && sqlcl.getInterrupted()) {
                SpinningWheel.stop();
                return;
            }
            for (DbmsMetadata dm : this.workers) {
                if (!dm.finished) continue block3;
            }
            break;
        }
        SpinningWheel.stop();
        this.workers = null;
    }
}

