/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.export;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.StringTokenizer;
import oracle.arbori.util.DbObjNames;
import oracle.arbori.util.DictionaryViews;
import oracle.arbori.util.Pair;
import oracle.dbtools.arbori.ScriptException;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.extension.apex.core.APEXExport;
import oracle.dbtools.extension.project.commands.export.ApexExportWrapper;
import oracle.dbtools.extension.project.commands.export.CancelExport;
import oracle.dbtools.extension.project.commands.export.DbObj;
import oracle.dbtools.extension.project.commands.export.Export;
import oracle.dbtools.extension.project.commands.export.ExportCommand;
import oracle.dbtools.extension.project.commands.export.Report;
import oracle.dbtools.extension.project.commands.export.SkipObject;
import oracle.dbtools.extension.project.commands.stage.transforms.ObjectTypes;
import oracle.dbtools.extension.project.core.messages.GeneralMessages;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.extension.project.core.utils.Format;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.Substitutions;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.ParsedSql;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class DbmsMetadata {
    private static final String IGNORE_TABLE = "Ignore table";
    static final String EXPORT_SET_TRANSFORM_EMIT_SCHEMA = "export.setTransform.emitSchema";
    static final String SRC_DATABASE = "/src/database";
    static int cnt = 0;
    static long dbmsMetadataTiming = 0L;
    static long plsTiming = 0L;
    private final DictionaryViews dictViews;
    public boolean quit = false;
    public boolean finished = false;
    ScriptRunnerContext ctx;
    int instance;
    Thread metadataThread;
    Export export;
    private Connection conn = null;

    public DbmsMetadata(Export export) {
        this.dictViews = export.dictViews;
        this.ctx = export.ctx;
        this.export = export;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetadata() throws SQLException {
        if (this.conn == null) {
            HashMap<String, Object> dbmsMetadataParameters = new HashMap<String, Object>();
            Map<String, Object> configs = ProjectSettings.getConfigSubMap("export.setTransform");
            if (this.export.ddlParams != null) {
                configs = this.export.ddlParams;
            }
            for (String string : configs.keySet()) {
                int dotPos = string.lastIndexOf(46);
                dbmsMetadataParameters.put(ProjectSettings.toKabobCase(string.substring(dotPos + 1)), configs.get(string));
            }
            dbmsMetadataParameters.put("ref_constraints", false);
            dbmsMetadataParameters.put("insert", false);
            try {
                ScriptRunnerContext scriptRunnerContext = this.ctx;
                synchronized (scriptRunnerContext) {
                    this.conn = this.ctx.cloneCLIConnection();
                }
            }
            catch (SQLException e) {
                this.conn = this.ctx.getCurrentConnection();
            }
            Object transform = "begin\n";
            for (String param : dbmsMetadataParameters.keySet()) {
                Object object = dbmsMetadataParameters.get(param);
                if (object instanceof String) {
                    object = "'" + String.valueOf(object) + "'";
                }
                transform = (String)transform + " DBMS_METADATA.SET_TRANSFORM_PARAM(DBMS_METADATA.SESSION_TRANSFORM,'" + param.toUpperCase() + "'," + String.valueOf(object) + "); \n     ";
            }
            transform = (String)transform + "end;";
            try (Statement statement = this.conn.createStatement();){
                statement.execute((String)transform);
            }
        }
    }

    public static String generateHash(String ddl) throws NoSuchAlgorithmException {
        Object normalized = ddl;
        if (ddl.length() < 1000000) {
            normalized = "";
            List src = Lexer.parse((String)ddl, (boolean)true);
            for (LexerToken t : src) {
                if (t.type == Token.WS) continue;
                normalized = (String)normalized + " " + t.content;
            }
        }
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] hash = md.digest(((String)normalized).getBytes());
        Object hashString = "";
        for (int i = 0; i < hash.length; ++i) {
            hashString = (String)hashString + Integer.toString((hash[i] & 0xFF) + 256, 16).substring(1);
        }
        return hashString;
    }

    public static String appendSxmlAndHash(String owner, String objectType, String objectName, String ddl, String sxml) throws NoSuchAlgorithmException {
        if (sxml == null) {
            sxml = "";
        }
        String hashString = DbmsMetadata.generateHash((String)ddl);
        ddl = (String)ddl + "\n\n\n";
        ddl = (String)ddl + "-- sqlcl_snapshot {";
        ddl = (String)ddl + "\"hash\":\"" + hashString + "\",\"type\":\"" + objectType + "\",\"name\":\"" + objectName + "\",\"schemaName\":\"" + owner + "\"";
        if (sxml != null) {
            ddl = (String)ddl + ",\"sxml\":\"";
            ddl = (String)ddl + sxml;
            ddl = (String)ddl + "\"";
        }
        ddl = (String)ddl + "}";
        return ddl;
    }

    static void saveObjects(Map<String, String> object2ddl, String type, Export export) throws IOException {
        for (String qualifiedName : object2ddl.keySet()) {
            List src = Lexer.parse((String)qualifiedName);
            String owner = ((LexerToken)src.get((int)0)).content.toLowerCase();
            String name = ((LexerToken)src.get((int)2)).content.toLowerCase();
            String ddl = object2ddl.get(qualifiedName);
            try {
                long t11 = System.currentTimeMillis();
                ddl = Format.format(ddl);
                export.report.formatTiming += System.currentTimeMillis() - t11;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ddl = DbmsMetadata.appendSxmlAndHash(owner, type, name, ddl, null);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            DbmsMetadata.saveDbObject(export, owner, type, name, ddl);
        }
    }

    static void saveDbObject(Export export, DbObj obj, Pair<String, String> ddlSxml) throws IOException {
        String ddl = (String)ddlSxml.first();
        int cut = 200;
        cut = Integer.min(cut, ddl.length());
        String prefix = ddl.toLowerCase().substring(0, cut);
        if (prefix.indexOf("wrapped") < 0 && !"MLE_MODULE".equals(obj.type)) {
            try {
                long t11 = System.currentTimeMillis();
                ddl = Format.format_(ddl);
                export.report.formatTiming += System.currentTimeMillis() - t11;
            }
            catch (SyntaxError e) {
                export.report.addFailedFormat(obj, "Failed to format, syntax error");
            }
            catch (Exception e) {
                export.report.errors.put(obj, e.toString());
            }
        }
        if (export.isAPI()) {
            export.ret.put(obj, (Pair<String, String>)new Pair((Object)ddl, ddlSxml.second()));
            return;
        }
        try {
            String sxml = (String)ddlSxml.second();
            if ("TRIGGER".equals(obj.type)) {
                sxml = "";
            }
            ddl = DbmsMetadata.appendSxmlAndHash(obj.owner, obj.type, obj.name, ddl, sxml);
        }
        catch (NoSuchAlgorithmException e) {
            export.report.errors.put(obj, e.getMessage());
            ddl = (String)ddlSxml.first();
        }
        DbmsMetadata.saveDbObject(export, obj.owner, obj.type, obj.fileName, ddl);
    }

    static void saveDbObject(Export export, String owner, String objectType, String fileName, String ddl) throws IOException {
        File f;
        if ("REF_CONSTRAINT".equals(objectType)) {
            String pattern = ",\"name\":\"";
            int begin = ((String)ddl).indexOf(",\"name\":\"") + ",\"name\":\"".length();
            int end = ((String)ddl).indexOf(34, begin);
            ddl = ((String)ddl).substring(0, begin) + fileName.toUpperCase() + ((String)ddl).substring(end);
        }
        Object path = DbmsMetadata.makeSrcDatabaseOwnerDir(export, owner);
        if (objectType != null && !(f = new File((String)(path = (String)path + File.separator + ObjectTypes.plural(objectType).toLowerCase()))).exists()) {
            f.mkdirs();
        }
        String ext = DbmsMetadata.fileExtension(objectType);
        f = DbmsMetadata.createFileWDir((String)path, fileName, ext);
        f.createNewFile();
        int pos = ((String)path).indexOf(SRC_DATABASE) + SRC_DATABASE.length();
        String relativeFileName = f.getAbsolutePath().substring(pos);
        if (relativeFileName.startsWith("/")) {
            relativeFileName.substring(1);
        }
        export.report.files.add(relativeFileName);
        FileWriter fw = new FileWriter(f.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write((String)ddl);
        bw.close();
        export.report.incrTypeCnt(new DbObj(owner, fileName, objectType));
    }

    static String makeSrcDatabaseOwnerDir(Export export, String owner) {
        String path = export.projectPath + "/src";
        File f = new File(path);
        if (!f.exists()) {
            f.mkdirs();
        }
        if (!(f = new File(path = export.projectPath + SRC_DATABASE)).exists()) {
            f.mkdirs();
        }
        if (!(f = new File(path = path + File.separator + owner.toLowerCase())).exists()) {
            f.mkdirs();
        }
        return path;
    }

    static File createFileWDir(String path, String objectName, String ext) {
        boolean isCaseSensitive = false;
        StringTokenizer st = new StringTokenizer(objectName, "/", false);
        File f = null;
        while (st.hasMoreElements()) {
            String token = st.nextToken();
            if (!isCaseSensitive) {
                token = token.toLowerCase();
            }
            path = (String)path + "/" + token;
            if (!st.hasMoreElements()) {
                path = (String)path + ext;
            }
            if (!(f = new File((String)path)).exists() && st.hasMoreElements()) {
                f.mkdirs();
            }
            if (!f.exists() || st.hasMoreElements()) continue;
            f.delete();
        }
        return f;
    }

    static String fileExtension(String objectType) {
        String ext = ".sql";
        return ext;
    }

    private static String editTemplate(String template, String pattern, ResultSet rs) {
        try {
            String tmp = rs.getString(pattern);
            if (tmp == null) {
                tmp = "";
            }
            template = template.replace("$" + pattern, tmp);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return template;
    }

    public static String toMetadataTypeName(String typ) {
        String ret = typ;
        if ("DOMAIN".equals(ret)) {
            ret = "SQL_DOMAIN";
        }
        if ("PACKAGE".equals(ret)) {
            ret = "PACKAGE_SPEC";
        }
        if ("TYPE".equals(ret)) {
            ret = "TYPE_SPEC";
        }
        if ("MLE ENVIRONMENT".equals(ret)) {
            ret = "MLE_ENV";
        }
        ret = ret.replace(' ', '_');
        return ret;
    }

    private Pair<String, String> transformRefConstraint(Pair<String, String> ddlSxml, DbObj obj) {
        return new Pair((Object)this.transformRefConstraint((String)ddlSxml.first(), obj), (Object)((String)ddlSxml.second()));
    }

    String transformRefConstraint(String ddl, DbObj obj) {
        if ("REF_CONSTRAINT".equals(obj.type) && obj.name.startsWith("SYS_C")) {
            ParsedSql target = new ParsedSql(ddl);
            String prg = "table: [node) table ->\nreferences: [node) identifier & [node^) references_clause ->\n";
            try {
                final LinkedList tmp = new LinkedList();
                SqlProgram program = new SqlProgram("table: [node) table ->\nreferences: [node) identifier & [node^) references_clause ->\n");
                program.eval((Parsed)target, new Object(){

                    public void table(Parsed target, Map<String, ParseNode> tuple) {
                        String content = tuple.get("node").content(target.getSrc());
                        if (content.indexOf(34) == 0) {
                            content = content.substring(1, content.length() - 1);
                        }
                        tmp.add(content);
                    }

                    public void references(Parsed target, Map<String, ParseNode> tuple) {
                        String content = tuple.get("node").content(target.getSrc());
                        if (content.indexOf(34) == 0) {
                            content = content.substring(1, content.length() - 1);
                        }
                        tmp.add(content);
                    }
                });
                Object newName = "";
                for (String t : tmp) {
                    newName = (String)newName + t + ".";
                }
                obj.fileName = newName = ((String)newName).substring(0, ((String)newName).length() - 1);
            }
            catch (IOException | ScriptException throwable) {
                // empty catch block
            }
        }
        return ddl;
    }

    private Pair<String, String> transformMLE(Pair<String, String> ddlSxml, DbObj obj) {
        return new Pair((Object)this.transformMLE((String)ddlSxml.first(), obj), (Object)((String)ddlSxml.second()));
    }

    String transformMLE(String ddl, DbObj obj) {
        if ("MLE_MODULE".equals(obj.type) && ddl.length() < 10000) {
            ParsedSql target = new ParsedSql(ddl);
            List src = target.getSrc();
            LexerToken last1 = (LexerToken)src.subList(src.size() - 2, src.size() - 1).get(0);
            if ("/".equals(last1.content)) {
                ddl = ddl.substring(0, last1.end);
            }
        }
        return ddl;
    }

    Pair<String, String> transformSequence(Pair<String, String> ddlSxml, DbObj obj) {
        if ("SEQUENCE".equals(obj.type)) {
            Object ddl = (String)ddlSxml.first();
            List src = Lexer.parse((String)ddl);
            int begin = -1;
            int end = -1;
            String digits = "";
            for (LexerToken t : src) {
                if (begin == -1 && "start".equalsIgnoreCase(t.content)) {
                    begin = t.begin;
                    continue;
                }
                if (0 >= begin || t.type != Token.DIGITS) continue;
                end = t.end;
                digits = t.content;
                break;
            }
            String replacement = "/* start with n */";
            ddl = ((String)ddl).substring(0, begin) + replacement + ((String)ddl).substring(end);
            Object sxml = (String)ddlSxml.second();
            begin = ((String)sxml).indexOf("<START_WITH>");
            end = ((String)sxml).indexOf("</START_WITH>") + "</START_WITH>".length();
            sxml = ((String)sxml).substring(0, begin) + ((String)sxml).substring(end);
            return new Pair(ddl, sxml);
        }
        return ddlSxml;
    }

    Pair<String, String> transformDirectory(Pair<String, String> ddlSxml, DbObj obj) {
        if ("DIRECTORY".equals(obj.type) && ExportCommand.isRdbmsDiffProject()) {
            Object ddl = (String)ddlSxml.first();
            List src = Lexer.parse((String)ddl);
            int begin = -1;
            int end = -1;
            for (LexerToken t : src) {
                if (t.type != Token.QUOTED_STRING) continue;
                begin = t.begin;
                end = t.end;
                break;
            }
            ddl = ((String)ddl).substring(0, begin) + "'/ade/b/0123456789/oracle/rdbms/admin'" + ((String)ddl).substring(end);
            return new Pair(ddl, (Object)((String)ddlSxml.second()));
        }
        return ddlSxml;
    }

    Pair<String, String> transformOperator(Pair<String, String> ddlSxml, DbObj obj) {
        if ("OPERATOR".equals(obj.type) && ExportCommand.isRdbmsDiffProject()) {
            Object ddl = ((String)ddlSxml.first()).trim();
            ddl = ((String)ddl).substring(0, ((String)ddl).length() - 1);
            ddl = "declare\n  dependent_objects exception;\n  pragma exception_init(dependent_objects, -29809);\nbegin\nexecute immediate '" + (String)ddl + "';\n  exception\n    when dependent_objects then NULL;\n    when others then\n      SYS.DBMS_SYSTEM.KSDWRT(SYS.DBMS_SYSTEM.TRACE_FILE,\n                             'EXCEPTION[prvtoper.sql(' || $$PLSQL_LINE || ')8]: ' || SQLERRM); RAISE;\n      return;\nend;\n/";
            return new Pair(ddl, (Object)((String)ddlSxml.second()));
        }
        return ddlSxml;
    }

    private Pair<String, String> transformMV(Pair<String, String> ddlSxml, DbObj obj) {
        if (!"MATERIALIZED_VIEW".equals(obj.type)) {
            return ddlSxml;
        }
        String ddl = (String)ddlSxml.first();
        ParsedSql target = new ParsedSql(ddl);
        final Substitutions replace = new Substitutions((Parsed)target);
        String prg = "physical_properties: [node) physical_properties \n       &  ![node^) physical_properties \n; \nphysical_attributes_clause: [node) physical_attributes_clause \n       &  ![node^) physical_attributes_clause \n; \nalter_trigger: [child) alter_trigger \n       &  child^= node \n; \nrollback_segment: [gchild) 'SEGMENT' & [gchild^-1) 'USING'\n                               &  gchild^^= node \n; \ntmp: physical_properties | alter_trigger | physical_attributes_clause | rollback_segment\n; \ndelete: [*[)) node(tmp)->";
        try {
            SqlProgram program = new SqlProgram(prg);
            program.eval((Parsed)target, new Object(){

                public void delete(Parsed target, Map<String, ParseNode> tuple) {
                    ParseNode node = tuple.get("node");
                    replace.replace(node, "");
                }
            });
        }
        catch (IOException | ScriptException e) {
            Report.warning(this.ctx, e);
        }
        ddl = replace.transformInput();
        Object sxml = (String)ddlSxml.second();
        int from = ((String)sxml).indexOf("<SUBQUERY>");
        int to = ((String)sxml).indexOf("</SUBQUERY>") + "</SUBQUERY>".length();
        sxml = ((String)sxml).substring(0, from) + ((String)sxml).substring(to);
        return new Pair((Object)ddl, sxml);
    }

    private Pair<String, String> transformTrigger(Pair<String, String> ddlSxml, DbObj obj) {
        return new Pair((Object)this.transformTrigger((String)ddlSxml.first(), (String)ddlSxml.second(), obj), (Object)((String)ddlSxml.second()));
    }

    private String transformTrigger(String ddl, String sxml, DbObj obj) {
        if (!"TRIGGER".equals(obj.type)) {
            return ddl;
        }
        ParsedSql target = new ParsedSql(ddl);
        Substitutions replace = new Substitutions((Parsed)target);
        boolean emit_schema = Boolean.TRUE.equals(ProjectSettings.getSettingAsBoolean(EXPORT_SET_TRANSFORM_EMIT_SCHEMA));
        String prg = "triggerOwner: [node) identifier & [node+1) '.'\n              & [node^) decl_id\n              & [node^^) trigger\n->\ntableOwner: [node^) dml_event_clause & \n            [node-1) 'ON' &  [node) identifier & [node+1) '.'\n->\ntrigger: [node) decl_id & [node) identifier & \n         [node^) trigger\n->\ntable: [node^) dml_event_clause & \n      (  [node-1) 'ON' &  [node) identifier & ![node+1) '.'\n      )\n->\n";
        try {
            int pos;
            final ParseNode[] table = new ParseNode[1];
            final ParseNode[] trigger = new ParseNode[1];
            final ParseNode[] tableOwner = new ParseNode[1];
            final ParseNode[] triggerOwner = new ParseNode[1];
            SqlProgram program = new SqlProgram(prg);
            program.eval((Parsed)target, new Object(){

                public void trigger(Parsed target, Map<String, ParseNode> tuple) {
                    trigger[0] = tuple.get("node");
                }

                public void table(Parsed target, Map<String, ParseNode> tuple) {
                    table[0] = tuple.get("node");
                }

                public void triggerOwner(Parsed target, Map<String, ParseNode> tuple) {
                    triggerOwner[0] = tuple.get("node");
                }

                public void tableOwner(Parsed target, Map<String, ParseNode> tuple) {
                    tableOwner[0] = tuple.get("node");
                }
            });
            String key = "<SCHEMA>";
            int start = sxml.indexOf(key) + key.length();
            int end = sxml.indexOf("</SCHEMA>", start);
            String schema1 = obj.owner;
            start = sxml.indexOf(key, end) + key.length();
            end = sxml.indexOf("</SCHEMA>", start);
            String schema2 = obj.owner;
            if (trigger[0] != null && emit_schema) {
                pos = ((LexerToken)target.getSrc().get((int)trigger[0].from)).begin;
                replace.put(pos, pos, schema1 + ".");
            }
            if (triggerOwner[0] != null && emit_schema && !schema1.equals(schema2)) {
                replace.replace(triggerOwner[0], schema1);
            }
            if (table[0] != null && emit_schema) {
                pos = ((LexerToken)target.getSrc().get((int)table[0].from)).begin;
                replace.put(pos, pos, schema2 + ".");
            }
            if (tableOwner[0] != null && emit_schema && !schema1.equals(schema2)) {
                replace.replace(tableOwner[0], schema2);
            }
            if (tableOwner[0] != null && !emit_schema && schema1.equals(schema2)) {
                replace.replace(((LexerToken)target.getSrc().get((int)tableOwner[0].from)).begin, ((LexerToken)target.getSrc().get((int)tableOwner[0].to)).end, "");
            }
        }
        catch (IOException | ScriptException e) {
            Report.warning(this.ctx, e);
        }
        catch (Throwable e) {
            Report.debug(this.ctx, ddl);
            Report.processException(this.ctx, e, obj);
        }
        ddl = replace.transformInput();
        return ddl;
    }

    private Pair<String, String> transformTable(Pair<String, String> ddlSxml, final DbObj obj) {
        if (!"TABLE".equals(obj.type)) {
            return ddlSxml;
        }
        final boolean emit_schema = Boolean.TRUE.equals(ProjectSettings.getSettingAsBoolean(EXPORT_SET_TRANSFORM_EMIT_SCHEMA));
        String ddl = (String)ddlSxml.first();
        final ParsedSql target = new ParsedSql(ddl);
        String prg = "usage_clauses: [node) usage_clause \n->\nconstraint_clause: [node) constraint_clauses \n->\nidentity_options: [node) identity_options & ![node^) identity_options \n->\ndotted_function_call: [node) dotted_expr & [node^) function_call \n->\n";
        final LinkedList constraintStatements = new LinkedList();
        final LinkedList orderedConstraints = new LinkedList();
        final boolean[] usageClauseFound = new boolean[]{false};
        final Substitutions replace = new Substitutions((Parsed)target);
        try {
            SqlProgram program = new SqlProgram("usage_clauses: [node) usage_clause \n->\nconstraint_clause: [node) constraint_clauses \n->\nidentity_options: [node) identity_options & ![node^) identity_options \n->\ndotted_function_call: [node) dotted_expr & [node^) function_call \n->\n");
            program.eval((Parsed)target, new Object(){

                public void usage_clauses(Parsed target, Map<String, ParseNode> tuple) {
                    usageClauseFound[0] = true;
                }

                public void constraint_clause(Parsed target, Map<String, ParseNode> tuple) {
                    constraintStatements.add(tuple.get("node").parent().parent());
                    orderedConstraints.add(tuple.get("node").parent().parent());
                }

                public void identity_options(Parsed target, Map<String, ParseNode> tuple) {
                    replace.replace(tuple.get("node"), "");
                }

                public void dotted_function_call(Parsed target, Map<String, ParseNode> tuple) {
                    if (emit_schema) {
                        return;
                    }
                    String functionName = ((LexerToken)target.getSrc().get((int)(tuple.get((Object)"node").to - 1))).content;
                    String schema = ((LexerToken)target.getSrc().get((int)tuple.get((Object)"node").from)).content;
                    if (!DbObjNames.handleMixedCase((String)schema).equals(obj.owner)) {
                        return;
                    }
                    replace.replace(tuple.get("node"), functionName);
                }
            });
        }
        catch (AssertionError e) {
            throw new SkipObject(((Throwable)((Object)e)).getMessage());
        }
        catch (IOException | ScriptException e) {
            Report.warning(this.ctx, e.getMessage());
        }
        if (usageClauseFound[0]) {
            throw new SkipObject("found usage clause");
        }
        Collections.sort(orderedConstraints, new Comparator<ParseNode>(){

            @Override
            public int compare(ParseNode p1, ParseNode p2) {
                String s1 = target.content(p1);
                String s2 = target.content(p2);
                return s1.compareTo(s2);
            }
        });
        for (int i = 0; i < orderedConstraints.size(); ++i) {
            replace.put((ParseNode)constraintStatements.get(i), target.content((ParseNode)orderedConstraints.get(i)));
        }
        ddl = replace.transformInput();
        Object sxml = (String)ddlSxml.second();
        int begin = ((String)sxml).indexOf("<GENERATION>");
        int end = ((String)sxml).indexOf("</SCALE>");
        if (0 < begin && 0 < end) {
            sxml = ((String)sxml).substring(0, begin) + ((String)sxml).substring(end + "</SCALE>".length());
        }
        return new Pair((Object)ddl, sxml);
    }

    private Pair<String, String> transformView(Pair<String, String> ddlSxml, DbObj obj) {
        if (!"VIEW".equals(obj.type)) {
            return ddlSxml;
        }
        Object ddl = (String)ddlSxml.first();
        if (ProjectSettings.getSettingAsBoolean("export.setTransform.sqlterminator").booleanValue()) {
            List src = Lexer.parse((String)ddl);
            LexerToken last = (LexerToken)src.get(src.size() - 1);
            if (last.type != Token.OPERATION) {
                ddl = (String)ddl + "\n;";
            }
        }
        if (!ProjectSettings.getSettingAsBoolean("export.format.enable").booleanValue()) {
            ddl = ((String)ddl).replace(" \n", " ");
        }
        String sxml = (String)ddlSxml.second();
        return new Pair(ddl, (Object)sxml);
    }

    Pair<String, String> transformAQ(Pair<String, String> ddlSxml, DbObj obj) {
        if (!"AQ_QUEUE".equals(obj.type) && !"AQ_QUEUE_TABLE".equals(obj.type)) {
            return ddlSxml;
        }
        String ddl = (String)ddlSxml.first();
        ddl = ddl.replaceAll("(?<!SYS\\.)\\bDBMS_AQADM\\b", "SYS.DBMS_AQADM");
        String sxml = (String)ddlSxml.second();
        return new Pair((Object)ddl, (Object)sxml);
    }

    protected void init() {
        try {
            this.instance = cnt++;
            this.metadataThread = new Thread("DbmsMetadata# " + this.instance){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DbmsMetadata.this.quit = false;
                    while (!DbmsMetadata.this.quit) {
                        String name = "N/A";
                        String type = "N/A";
                        try {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            ScriptExecutor sqlcl = (ScriptExecutor)DbmsMetadata.this.ctx.getProperty("runner");
                            DbObj obj = null;
                            Queue<DbObj> queue = DbmsMetadata.this.export.workQueue;
                            synchronized (queue) {
                                if (sqlcl != null && sqlcl.getInterrupted()) {
                                    DbmsMetadata.this.quit = true;
                                    DbmsMetadata.this.export.workQueue.clear();
                                    break;
                                }
                                if (DbmsMetadata.this.export.workQueue.isEmpty()) {
                                    continue;
                                }
                                obj = DbmsMetadata.this.export.workQueue.remove();
                            }
                            obj.type = DbmsMetadata.toMetadataTypeName(obj.type);
                            name = obj.name;
                            type = obj.type;
                            try {
                                DbmsMetadata.this.initMetadata();
                            }
                            catch (SQLException e) {
                                Report.error(DbmsMetadata.this.ctx, e.getMessage());
                                DbmsMetadata.this.quit = false;
                            }
                            Pair<String, String> ddlSxml = null;
                            if ("CONTEXT".equals(type)) {
                                ddlSxml = new Pair<String, String>((Object)DbmsMetadata.this.getContext(obj), (Object)"");
                            } else if ("SCHEDULE".equals(type)) {
                                ddlSxml = new Pair((Object)DbmsMetadata.this.getSchedule(obj), (Object)"");
                            } else if ("DIRECTORY".equals(type)) {
                                ddlSxml = new Pair<String, String>((Object)DbmsMetadata.this.getDirectory(obj), (Object)"");
                            } else if ("EDITION".equals(type)) {
                                ddlSxml = new Pair((Object)DbmsMetadata.this.getEdition(obj), (Object)"");
                            } else {
                                if ("APEX".equals(type)) {
                                    DbmsMetadata.this.exportApex(obj);
                                    continue;
                                }
                                if ("PROCEDURE".equals(type) || "FUNCTION".equals(type) || "PACKAGE_SPEC".equals(type) || "PACKAGE_BODY".equals(type) || "TYPE_SPEC".equals(type) || "TYPE_BODY".equals(type) || "LIBRARY".equals(type)) {
                                    String ddl = DbmsMetadata.this.getPlsql(obj);
                                    if (ddl == null) {
                                        String msg = "No ddl found in all_source";
                                        DbmsMetadata.this.export.report.errors.put(obj, "No ddl found in all_source");
                                        continue;
                                    }
                                    ddlSxml = new Pair<String, String>((Object)ddl, (Object)"");
                                } else {
                                    if (type == null) {
                                        DbmsMetadata.this.export.report.errors.put(obj, "object_type == null --> ORA-31600");
                                        continue;
                                    }
                                    ddlSxml = DbmsMetadata.this.getMetadata(obj);
                                    if (ddlSxml == null) {
                                        if (DbmsMetadata.this.export.report.errors.get(obj) != null) continue;
                                        DbmsMetadata.this.export.report.errors.put(obj, "ddlSxml == null");
                                        continue;
                                    }
                                }
                            }
                            ddlSxml = DbmsMetadata.this.transformAQ(ddlSxml, obj);
                            ddlSxml = DbmsMetadata.this.transformMV(ddlSxml, obj);
                            ddlSxml = DbmsMetadata.this.transformTrigger(ddlSxml, obj);
                            ddlSxml = DbmsMetadata.this.transformTable(ddlSxml, obj);
                            ddlSxml = DbmsMetadata.this.transformRefConstraint(ddlSxml, obj);
                            ddlSxml = DbmsMetadata.this.transformMLE(ddlSxml, obj);
                            ddlSxml = DbmsMetadata.this.transformSequence(ddlSxml, obj);
                            ddlSxml = DbmsMetadata.this.transformDirectory(ddlSxml, obj);
                            ddlSxml = DbmsMetadata.this.transformView(ddlSxml, obj);
                            ddlSxml = DbmsMetadata.this.transformOperator(ddlSxml, obj);
                            if (ddlSxml.first() == null) {
                                Report.verbose(DbmsMetadata.this.ctx, obj.owner + "." + name + " -- ddl == null; skipped");
                                DbmsMetadata.this.export.report.errors.put(obj, "ddl == null");
                                continue;
                            }
                            DbmsMetadata.saveDbObject(DbmsMetadata.this.export, obj, ddlSxml);
                        }
                        catch (CancelExport e) {
                            DbmsMetadata.this.quit = true;
                        }
                        catch (IOException e) {
                            Report.error(DbmsMetadata.this.ctx, type, name, e);
                        }
                        catch (SkipObject e) {
                            Report.debug(DbmsMetadata.this.ctx, "skipped " + type + "   " + name + " -- " + e.getMessage());
                            Report.debug(DbmsMetadata.this.ctx, e.getMessage());
                        }
                    }
                    try {
                        if (DbmsMetadata.this.conn != DbmsMetadata.this.ctx.getCurrentConnection() && DbmsMetadata.this.conn != null && !DbmsMetadata.this.conn.isClosed()) {
                            DbmsMetadata.this.conn.close();
                        }
                    }
                    catch (SQLException e) {
                        if (e.getErrorCode() != 3113) {
                            Report.warning(DbmsMetadata.this.ctx, "Failed to close connection");
                            Report.debug(DbmsMetadata.this.ctx, e);
                        }
                    }
                    finally {
                        DbmsMetadata.this.finished = true;
                    }
                }
            };
            this.metadataThread.start();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    private Pair<String, String> getMetadata(DbObj obj) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPlsql(DbObj obj) {
        boolean emit_schema = Boolean.TRUE.equals(ProjectSettings.getSettingAsBoolean(EXPORT_SET_TRANSFORM_EMIT_SCHEMA));
        long t1 = System.currentTimeMillis();
        String objectType = obj.type;
        if ("PACKAGE_SPEC".equals(objectType)) {
            objectType = "PACKAGE";
        }
        if ("TYPE_SPEC".equals(objectType)) {
            objectType = "TYPE";
        }
        objectType = objectType.replace('_', ' ');
        Object ret = "create or replace \n";
        Object query = "WITH src AS (SELECT ROWNUM,LINE,TEXT,origin_con_id FROM SYS.ALL_SOURCE \n\tWHERE TYPE = '" + objectType + "' \nAND OWNER = '" + obj.owner + "' \nAND NAME = '" + obj.name + "')\n\tSELECT line,text FROM src, (SELECT max(origin_con_id) max_orig FROM src)  \n\tWHERE origin_con_id = max_orig \n\tORDER BY LINE";
        query = this.dictViews.translate((String)query);
        int line = -1;
        try (Statement stmt = this.conn.createStatement();
             ResultSet rs = stmt.executeQuery((String)query);){
            while (rs.next()) {
                String text = rs.getString("text");
                line = rs.getInt("line");
                ret = (String)ret + text;
            }
        }
        catch (Throwable e) {
            this.processException(e, obj);
        }
        finally {
            plsTiming += System.currentTimeMillis() - t1;
        }
        if (line < 0) {
            throw new SkipObject("line < 0");
        }
        List src = Lexer.parse((String)ret);
        String prior = null;
        int i = -1;
        for (LexerToken t : src) {
            ++i;
            String current = t.content.toUpperCase();
            if (current.equals("BODY")) {
                prior = current;
                continue;
            }
            if (prior != null && (prior.equals("PACKAGE") || prior.equals("BODY") || prior.equals("TYPE") || prior.equals("FUNCTION") || prior.equals("PROCEDURE") || prior.equals("LIBRARY") || prior.equals("TRIGGER"))) break;
            prior = current;
        }
        if (emit_schema) {
            if (i < src.size() - 1 && !".".equals(((LexerToken)src.get((int)(i + 1))).content)) {
                try {
                    int pos = ((LexerToken)src.get((int)i)).begin;
                    ret = ((String)ret).substring(0, pos) + obj.owner + "." + ((String)ret).substring(pos);
                }
                catch (StringIndexOutOfBoundsException e) {
                    System.out.println("StringIndexOutOfBoundsException: " + obj.owner + "." + obj.name);
                }
            }
        } else if (i < src.size() - 1 && ".".equals(((LexerToken)src.get((int)(i + 1))).content)) {
            try {
                int start = ((LexerToken)src.get((int)i)).begin;
                int finish = ((LexerToken)src.get((int)(i + 1))).end;
                ret = ((String)ret).substring(0, start) + ((String)ret).substring(finish);
            }
            catch (StringIndexOutOfBoundsException e) {
                System.out.println("StringIndexOutOfBoundsException: " + obj.owner + "." + obj.name);
            }
        }
        if ("LIBRARY".equals(objectType)) {
            ret = ((String)ret).replace(";", "");
        }
        if (!((String)ret).endsWith("\n")) {
            ret = (String)ret + "\n";
        }
        return (String)ret + "/\n";
    }

    private String getSchedule(DbObj obj) {
        String ret = "BEGIN\n      DBMS_SCHEDULER.create_schedule (\n         schedule_name => '" + obj.name + "' \n ";
        Object query = "SELECT start_date,  \n end_date,  \n repeat_interval, \n comments \nFROM all_scheduler_schedules \n\tWHERE OWNER = '" + obj.owner + "' \nAND SCHEDULE_NAME = '" + obj.name + "'\n";
        query = this.dictViews.translate((String)query);
        try (Statement stmt = this.conn.createStatement();
             ResultSet rs = stmt.executeQuery((String)query);){
            while (rs.next()) {
                String column = "start_date";
                Timestamp tvalue = rs.getTimestamp(column);
                Object value = null;
                if (tvalue != null) {
                    value = "timestamp '" + String.valueOf(tvalue) + "'";
                }
                ret = ret + "," + column + "=>" + (String)value + "\n";
                column = "end_date";
                tvalue = rs.getTimestamp(column);
                if (tvalue != null) {
                    value = "timestamp '" + String.valueOf(tvalue) + "'";
                }
                ret = ret + "," + column + "=>" + (String)value + "\n";
                column = "repeat_interval";
                value = rs.getString(column);
                if (value != null) {
                    value = "'" + (String)value + "'";
                }
                ret = ret + "," + column + "=>" + (String)value + "\n";
                column = "comments";
                value = rs.getString(column);
                if (value != null) {
                    value = "'" + (String)value + "'";
                }
                ret = ret + "," + column + "=>" + (String)value + "\n";
            }
        }
        catch (Throwable e) {
            this.processException(e, obj);
        }
        ret = ret + ");\n    END;\n/\n";
        return ret;
    }

    private void exportApex(DbObj obj) {
        try {
            LinkedHashMap<String, APEXExport.RowDetails> exported = ApexExportWrapper.ExportApplication(obj.name, this.ctx, this.conn);
            Object path = DbmsMetadata.makeSrcDatabaseOwnerDir(this.export, obj.owner);
            path = (String)path + "/apex_apps";
            File f = new File((String)path);
            if (!f.exists()) {
                f.mkdirs();
            }
            boolean success = false;
            for (String key : exported.keySet()) {
                APEXExport.RowDetails row = exported.get(key);
                if (row == null) {
                    Report.error(this.ctx, "row == null for the key " + key);
                    continue;
                }
                String appPath = (String)path + "/f" + row.getAppId();
                f = new File(appPath);
                if (!f.exists()) {
                    f.mkdirs();
                }
                String content = !(f = DbmsMetadata.createFileWDir(appPath, row.getFileName(), "")).toString().contains("readable") ? DbmsMetadata.appendSxmlAndHash(this.conn.getSchema(), "APEX_APPLICATIONS", "f" + row.getAppId(), row.getContents(), null) : row.getContents();
                GeneralMessages.debugMessage("saving " + f.toString());
                f.createNewFile();
                FileWriter fw = new FileWriter(f.getAbsoluteFile());
                BufferedWriter bw = new BufferedWriter(fw);
                bw.write(content);
                bw.close();
                success = true;
            }
            if (success) {
                this.export.report.incrTypeCnt(ObjectTypes.singular("APEX_APPLICATIONS"));
            }
        }
        catch (Exception e) {
            Report.error(this.ctx, e, "Failed to export application_id = " + obj.name + " due to " + e.getMessage());
        }
    }

    String getContext(DbObj obj) throws CancelExport {
        String query = "select * from dba_context where namespace = '" + obj.name + "'";
        String template = "create or replace context " + obj.name + " using $schema.$package $type;";
        return this.makeDDL(template, query, new String[]{"type", "schema", "package"}, obj);
    }

    String getDirectory(DbObj obj) throws CancelExport {
        String query = "select * from all_directories  where owner = '" + obj.owner + "'  and directory_name = '" + obj.name + "'";
        String template = "create or replace directory " + obj.name + " as '$directory_path';";
        return this.makeDDL(template, query, new String[]{"directory_path"}, obj);
    }

    String getEdition(DbObj obj) throws CancelExport {
        String query = "select 'AS CHILD OF '|| parent_edition_name asOfParentEditionName  from all_editions  where edition_name = '" + obj.name + "'";
        String template = "create edition " + obj.name + " $asChildOf_ParentName;";
        return this.makeDDL(template, query, new String[]{"asChildOf_ParentName"}, obj);
    }

    String getLockdownProfile(DbObj obj) throws CancelExport {
        String query = "select * from dBa_LOCKDOWN_PROFILES where profile_name = '" + obj.name + "'";
        String template = "create lockdown profile " + obj.name + ";";
        return this.makeDDL(template, query, new String[0], obj);
    }

    String makeDDL(String template, String query, String[] columns, DbObj obj) throws CancelExport {
        query = this.dictViews.translate(query);
        try (Statement stmt = this.conn.createStatement();
             ResultSet rs = stmt.executeQuery(query);){
            rs.next();
            for (String col : columns) {
                template = DbmsMetadata.editTemplate(template, col, rs);
            }
        }
        catch (Throwable e) {
            this.processException(e, obj);
            this.export.cancelExport();
        }
        return template;
    }

    private void processException(Throwable t, DbObj obj) {
        Report.processException(this.ctx, t, obj.type, obj.name);
        String typ = obj.type;
        if (typ == null) {
            typ = "null";
        }
        this.export.report.errors.put(new DbObj(obj.owner, obj.name, typ), t.getMessage());
    }

    void error(ScriptRunnerContext ctx, String msg) {
        Report.error(ctx, msg);
    }
}

