/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import oracle.apexlang.APEXLangCompiler;
import oracle.apexlang.FileLoader;
import oracle.apexlang.core.APEXLangCompilationResult;
import oracle.apexlang.core.Component;
import oracle.apexlang.core.ComponentParameter;
import oracle.apexlang.metametadata.Plugins;

public class APEXLangNativePluginsLoader {
    private Map<String, String> source;
    private Map<String, Map<String, Component>> pluginTypesMap;
    private Map<Component, List<Component>> pluginsChildren;

    public APEXLangNativePluginsLoader(APEXLangCompiler compiler) {
        Plugins plugins = compiler.getMetametadata().getPlugins();
        try {
            this.source = new HashMap<String, String>();
            this.pluginsChildren = new HashMap<Component, List<Component>>();
            try (InputStream input = compiler.getClass().getClassLoader().getResourceAsStream("apexlang.zip");){
                List<String> filters = Collections.singletonList("^apexlangmeta/native-plugins/.*/[^/.]*[.]apx$");
                Map<String, String> pluginsInZip = new FileLoader().getFilesFromZipInputStream(input, filters);
                HashSet<String> paths = new HashSet<String>(pluginsInZip.keySet());
                for (String path : paths) {
                    String[] chunks = path.split("/");
                    String filename = chunks[chunks.length - 1];
                    String content = pluginsInZip.get(path);
                    this.source.put(filename, content);
                }
            }
            APEXLangCompilationResult result = compiler.compile(this.source);
            this.pluginTypesMap = new HashMap<String, Map<String, Component>>();
            for (Component component : result.getComponentsParameters()) {
                if (component.getTypeId().equals(plugins.getComponentTypeId())) {
                    ComponentParameter typePropertyId = component.getParameters().get(plugins.getTypePropertyId());
                    if (typePropertyId == null) continue;
                    String pluginType = typePropertyId.getValue();
                    if (this.pluginTypesMap.get(pluginType) == null) {
                        this.pluginTypesMap.put(pluginType, new HashMap());
                    }
                    String pluginName = component.getParameters().get(plugins.getApexLangNamePropertyId()).getValue();
                    this.pluginTypesMap.get(pluginType).put(pluginName, component);
                    this.pluginsChildren.put(component, new ArrayList());
                }
                if (!component.getTypeId().equals(plugins.getCustomAttributes().getComponentTypeId()) || this.pluginsChildren.get(component.getParent()) == null) continue;
                this.pluginsChildren.get(component.getParent()).add(component);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Map<String, String> getSource() {
        return this.source;
    }

    public Map<String, Map<String, Component>> getPluginTypesMap() {
        return this.pluginTypesMap;
    }

    public Map<Component, List<Component>> getPluginsChildren() {
        return this.pluginsChildren;
    }
}

