/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import java.util.ArrayList;
import java.util.logging.Logger;
import oracle.apexlang.core.APEXLangSyntaxError;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.LexerNoViableAltException;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;

public class APEXLangErrorListener
extends BaseErrorListener {
    private static final Logger LOGGER = Logger.getLogger(APEXLangErrorListener.class.getName());
    private ArrayList<APEXLangSyntaxError> errors;
    private String filename;

    public APEXLangErrorListener(String filename) {
        this.filename = filename;
        this.errors = new ArrayList();
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        Token token = (Token)offendingSymbol;
        if (token == null) {
            try {
                LexerNoViableAltException exp = (LexerNoViableAltException)e;
                int start = exp.getStartIndex();
                String message = exp.getMessage();
                this.errors.add(new APEXLangSyntaxError(line, charPositionInLine, msg, start, msg, 0, 0, this.filename, APEXLangSyntaxError.ErrorType.SYNTAX));
            }
            catch (Exception x) {
                LOGGER.warning(x.getMessage());
            }
        } else {
            this.errors.add(new APEXLangSyntaxError(line, charPositionInLine, "Invalid token: " + token.getText(), 0, msg, token.getStartIndex(), token.getStopIndex(), this.filename, APEXLangSyntaxError.ErrorType.SYNTAX));
        }
    }

    public ArrayList<APEXLangSyntaxError> getErrors() {
        return this.errors;
    }
}

