/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import oracle.apexlang.antlr.APEXLangBaseListener;
import oracle.apexlang.antlr.APEXLangParser;
import oracle.apexlang.core.APEXLangSyntaxError;
import oracle.apexlang.core.ComponentGroup;
import oracle.apexlang.core.ParsingUtil;
import oracle.apexlang.core.Range;
import oracle.apexlang.core.RawComponent;
import org.antlr.v4.runtime.tree.TerminalNode;

public class APEXLangListener
extends APEXLangBaseListener {
    private List<APEXLangSyntaxError> errors;
    private String filename;
    private List<RawComponent> rawComponents;
    private Stack<RawComponent> currentRawComponentStack;

    public APEXLangListener(String filename) {
        this.filename = filename;
        this.errors = new ArrayList<APEXLangSyntaxError>();
        this.rawComponents = new ArrayList<RawComponent>();
        this.currentRawComponentStack = new Stack();
    }

    public List<APEXLangSyntaxError> getErrors() {
        return this.errors;
    }

    public List<RawComponent> getRawComponents() {
        return this.rawComponents;
    }

    private void addParameter(TerminalNode terminalNode, String groupName, boolean isArray) {
        if (terminalNode == null) {
            return;
        }
        RawComponent topComponent = this.currentRawComponentStack.peek();
        topComponent.getRawParameters().add(ParsingUtil.contentParser(terminalNode, groupName, isArray));
    }

    private void handleComponentExit() {
        this.currentRawComponentStack.pop();
    }

    @Override
    public void enterComponent(APEXLangParser.ComponentContext ctx) {
        Integer rangeStart = ctx.getStart().getStartIndex();
        Integer rangeEnd = ctx.getStop().getStopIndex();
        Integer line = ctx.getStart().getLine();
        Integer column = ctx.getStart().getCharPositionInLine();
        TerminalNode declarationNode = ctx.COMPONENT_DECLARATION();
        String componentLine = declarationNode != null ? declarationNode.getText() : "";
        String[] componentLineElements = componentLine.split("\\s+");
        String componentTypeName = componentLineElements[0];
        int startQuoteIndex = componentLine.indexOf("\"");
        int endQuoteIndex = componentLine.indexOf("\"", startQuoteIndex + 1);
        String id = startQuoteIndex > 0 ? componentLine.substring(startQuoteIndex + 1, endQuoteIndex) : (componentLineElements.length > 1 ? componentLineElements[1] : "");
        RawComponent rawComponent = new RawComponent(componentTypeName, this.filename, line, column, rangeStart, rangeEnd);
        if (!this.currentRawComponentStack.isEmpty()) {
            rawComponent.setParent(this.currentRawComponentStack.peek());
        }
        try {
            if (!id.equals("}")) {
                rawComponent.setExternalIdentifierRange(ParsingUtil.externalIDRange(declarationNode));
                rawComponent.setExternalIdentifierKeyRange(ParsingUtil.externalIDKeyRange(declarationNode));
                rawComponent.setExternalIdentifierValueRange(ParsingUtil.externalIDValueRange(declarationNode));
                rawComponent.setExternalIdentifierValue(ParsingUtil.externalIDValue(id));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.currentRawComponentStack.push(rawComponent);
        this.rawComponents.add(rawComponent);
        APEXLangParser.ComponentBodyContext bodyCtx = ctx.componentBody();
        if (bodyCtx != null) {
            for (APEXLangParser.ParamLineContext paramCtx : bodyCtx.paramLine()) {
                TerminalNode paramNode;
                TerminalNode arrayNode = paramCtx.ARRAY();
                if (arrayNode != null) {
                    this.addParameter(arrayNode, null, true);
                }
                if ((paramNode = paramCtx.LINE_UNKNOWN()) == null) continue;
                this.addParameter(paramNode, null, false);
            }
        }
    }

    @Override
    public void exitComponent(APEXLangParser.ComponentContext ctx) {
        this.handleComponentExit();
    }

    @Override
    public void enterComponentBodyGroup(APEXLangParser.ComponentBodyGroupContext ctx) {
        TerminalNode groupStart = ctx.GROUP_IDENTIFICATION();
        String groupToken = groupStart.getText();
        groupToken = groupToken.substring(0, groupToken.length() - 1).trim();
        TerminalNode groupEnd = ctx.CLOSE_GROUP();
        if (groupEnd != null) {
            RawComponent topComponent = this.currentRawComponentStack.peek();
            int start = groupStart.getSymbol().getStartIndex();
            int end = groupEnd.getSymbol().getStopIndex();
            Range range = new Range(start, end + 1);
            Range nameRange = new Range(start, start + groupToken.length());
            ComponentGroup grp = new ComponentGroup(groupToken, range, nameRange);
            topComponent.getComponentGroups().add(grp);
        }
        for (APEXLangParser.ParamLineContext paramCtx : ctx.paramLine()) {
            TerminalNode paramNode;
            TerminalNode arrayNode = paramCtx.ARRAY();
            if (arrayNode != null) {
                this.addParameter(arrayNode, groupToken, true);
            }
            if ((paramNode = paramCtx.LINE_UNKNOWN()) == null) continue;
            this.addParameter(paramNode, groupToken, false);
        }
    }
}

