/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import oracle.apexlang.APEXLangListener;
import oracle.apexlang.FileLoader;
import oracle.apexlang.antlr.APEXLangLexer;
import oracle.apexlang.antlr.APEXLangParser;
import oracle.apexlang.core.APEXLangCentralThemeLoader;
import oracle.apexlang.core.APEXLangCompilationResult;
import oracle.apexlang.core.APEXLangCompilerContext;
import oracle.apexlang.core.APEXLangDataType;
import oracle.apexlang.core.APEXLangDataTypeFactory;
import oracle.apexlang.core.APEXLangErrorListener;
import oracle.apexlang.core.APEXLangException;
import oracle.apexlang.core.APEXLangIntegerDataType;
import oracle.apexlang.core.APEXLangManifest;
import oracle.apexlang.core.APEXLangManifestObject;
import oracle.apexlang.core.APEXLangNativePluginsLoader;
import oracle.apexlang.core.APEXLangNumericDataType;
import oracle.apexlang.core.APEXLangStringDataType;
import oracle.apexlang.core.APEXLangSyntaxError;
import oracle.apexlang.core.Component;
import oracle.apexlang.core.ComponentParameter;
import oracle.apexlang.core.ComponentPlugin;
import oracle.apexlang.core.Location;
import oracle.apexlang.core.PluginType;
import oracle.apexlang.core.Position;
import oracle.apexlang.core.Range;
import oracle.apexlang.core.RawComponent;
import oracle.apexlang.core.RawParameter;
import oracle.apexlang.core.Transpiler;
import oracle.apexlang.metametadata.ComponentType;
import oracle.apexlang.metametadata.Group;
import oracle.apexlang.metametadata.LOVValue;
import oracle.apexlang.metametadata.Metametadata;
import oracle.apexlang.metametadata.MetametadataParser;
import oracle.apexlang.metametadata.Property;
import oracle.apexlang.metametadata.PropertyType;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class APEXLangCompiler {
    private static final Logger LOGGER = Logger.getLogger(APEXLangCompiler.class.getName());
    public static Set<String> componentTypesToBeIgnored = Set.of("1005", "2040", "3150", "5110", "7320", "7420", "7710", "7720", "7940");
    private static final Object LOCK = new Object();
    private static Metametadata cachedMetametadata;
    private static APEXLangNativePluginsLoader cachedPluginsLoader;
    private static Map<String, APEXLangCompilerContext> cachedCentralThemes;
    private Metametadata metametadata;
    private APEXLangNativePluginsLoader pluginsLoader;
    private Map<String, APEXLangCompilerContext> centralThemes;
    private static String LOV_TYPE_STATIC;
    private static String LOV_TYPE_COMPONENT;
    private static String LOV_TYPE_PLUGIN;
    private String LOV_SCOPE_WORKSPACE = "WORKSPACE";
    private String LOV_SCOPE_REGION = "REGION";
    private String LOV_SCOPE_PAGE = "PAGE";
    private String LOV_SCOPE_PAGE_AND_GLOBAL = "PAGE_AND_GLOBAL";
    private String LOV_SCOPE_APPLICATION = "APPLICATION";
    private String LOV_SCOPE_COMPONENT = "COMPONENT";
    private String LOV_SCOPE_PARENT = "PARENT";
    private String LOV_SCOPE_THEME = "THEME";
    private String LOV_SCOPE_WF_VERSION = "WF_VERSION";
    private String LOV_SCOPE_INSTANCE = "INSTANCE";
    public static String APEX_VERSION;
    public static String API_VERSION;
    public static String APP_ID;
    public static String DEFAULT_ID_OFFSET;
    public static String DEFAULT_OWNER;
    public static String WORKSPACE_ID;
    public static String MANIFEST_FILENAME;
    public static String[] APEX_EXTENSIONS;
    public static Pattern MLT_REGEX;
    private final Pattern KEY_VALUE_REGEX = Pattern.compile("^([^\\s:]+)\\s*:\\s*(.*)$", 40);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APEXLangCompiler() {
        Object object = LOCK;
        synchronized (object) {
            if (cachedMetametadata == null) {
                this.metametadata = cachedMetametadata = new MetametadataParser().getMetametadata();
                cachedPluginsLoader = new APEXLangNativePluginsLoader(this);
                cachedCentralThemes = new APEXLangCentralThemeLoader(this).getCentralThemes();
            }
        }
        this.metametadata = cachedMetametadata;
        this.pluginsLoader = cachedPluginsLoader;
        this.centralThemes = cachedCentralThemes;
    }

    public Metametadata getMetametadata() {
        return this.metametadata;
    }

    public APEXLangNativePluginsLoader getPluginsLoader() {
        return this.pluginsLoader;
    }

    Collection<Component> readParameters(String source, String filename, List<APEXLangSyntaxError> errors, Map<Integer, Component> previouslyParsedComponents) {
        APEXLangErrorListener errorListener = new APEXLangErrorListener(filename);
        CodePointCharStream input = CharStreams.fromString((String)source);
        APEXLangLexer lexer = new APEXLangLexer((CharStream)input);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        APEXLangParser parser = new APEXLangParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        APEXLangParser.ProgramContext tree = parser.program();
        errors.addAll(errorListener.getErrors());
        APEXLangListener listener = new APEXLangListener(filename);
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)listener, (ParseTree)tree);
        if (listener.getErrors().size() > 0) {
            errors.addAll(listener.getErrors());
        }
        List<RawComponent> rawComponents = listener.getRawComponents();
        Map parsedComponents = this.convertRawComponentsToComponents(rawComponents, errors, filename, previouslyParsedComponents);
        parsedComponents = parsedComponents.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.comparing(Component::getInsertOrder))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        Collection<Component> components = parsedComponents.values();
        return components;
    }

    private String findComponentTypeId(RawComponent rawComponent, Map<RawComponent, Component> componentLookupMap) {
        Component parentComponent = componentLookupMap.get(rawComponent.getParent());
        Collection<String> candidates = this.findComponentsWithName(rawComponent.getComponentTypeName());
        if (candidates.size() == 0) {
            return "";
        }
        if (candidates.size() == 1) {
            return candidates.iterator().next();
        }
        for (String componentTypeId : candidates) {
            ComponentType componentType = this.getMetametadata().getComponentTypes().get(componentTypeId);
            if (!this.matchCandidateWithComponentType(componentTypeId, rawComponent.getFilename(), parentComponent, componentType)) continue;
            return componentTypeId;
        }
        return "";
    }

    private boolean matchCandidateWithComponentType(String componentTypeId, String filename, Component parentComponent, ComponentType componentType) {
        boolean match;
        return parentComponent == null ? this.matchCandidateWithFilename(filename, componentType.getFilePath()) : componentType.getParent() != null && (match = this.isValidParent(parentComponent, componentType));
    }

    private boolean matchCandidateWithFilename(String filename, String componentFilepath) {
        String filepathDotApx = componentFilepath.replace("#ext#", ".apx");
        return filename.equals(filepathDotApx);
    }

    private Collection<String> findComponentsWithName(String componentTypeName) {
        ArrayList<String> candidates = new ArrayList<String>();
        for (Map.Entry<String, ComponentType> componentTypeEntry : this.metametadata.getComponentTypes().entrySet()) {
            ComponentType componentType = componentTypeEntry.getValue();
            if (!componentType.getName().getSingular().equals(componentTypeName)) continue;
            candidates.add(componentTypeEntry.getKey());
        }
        return candidates;
    }

    private boolean isValidParent(Component parentComponent, ComponentType componentType) {
        boolean isValid = componentType.getParent().getComponentTypeId().equals(parentComponent.getTypeId());
        if (!isValid) {
            return isValid;
        }
        if (componentType.getParent().getDependingOn() != null) {
            isValid = this.isParameterVisibleAccordingDependOnRule(parentComponent, componentType.getParent().getDependingOn());
        }
        return isValid;
    }

    private Map<Integer, Component> convertRawComponentsToComponents(Collection<RawComponent> rawComponents, List<APEXLangSyntaxError> errors, String filename, Map<Integer, Component> previouslyParsedComponents) {
        RawComponent rawParent;
        HashMap<Integer, Component> parsedComponents = new HashMap<Integer, Component>();
        HashMap<RawComponent, Component> componentLookUpMap = new HashMap<RawComponent, Component>();
        Integer componentCounter = 1;
        for (RawComponent rawComponent : rawComponents) {
            try {
                String componentTypeId;
                rawParent = rawComponent.getParent();
                Component parentComponent = (Component)componentLookUpMap.get(rawParent);
                String parentExternalIdentifier = "";
                if (rawParent != null) {
                    parentExternalIdentifier = rawParent.getExternalIdentifierValue();
                }
                if ((componentTypeId = this.findComponentTypeId(rawComponent, componentLookUpMap)).equals("")) {
                    if (parentComponent != null && componentTypesToBeIgnored.contains(parentComponent.getTypeId())) {
                        LOGGER.warning("Error on: " + filename + " for component " + rawComponent.getComponentTypeName() + " (soft error): Not found children for " + rawParent.getComponentTypeName() + " L" + rawComponent.getLine());
                        continue;
                    }
                    throw new Exception("Component: " + rawComponent.getComponentTypeName() + " not found");
                }
                Boolean ignoreErrors = componentTypesToBeIgnored.contains(componentTypeId);
                ComponentType compType = this.metametadata.getComponentTypes().get(componentTypeId);
                Component parsedComponent = this.createComponentFromRawComponent(rawComponent, componentTypeId, compType, parentExternalIdentifier);
                Integer n = componentCounter;
                componentCounter = componentCounter + 1;
                parsedComponents.put(n, parsedComponent);
                componentLookUpMap.put(rawComponent, parsedComponent);
                this.addComponentParametersFromRawComponent(parsedComponent, compType, rawComponent, ignoreErrors, errors, parsedComponents, componentCounter, previouslyParsedComponents);
            }
            catch (Exception e) {
                Range externalIdentifierRange = rawComponent.getExternalIdentifierRange();
                if (externalIdentifierRange == null) {
                    externalIdentifierRange = new Range(rawComponent.getRangeStart(), rawComponent.getRangeEnd());
                }
                errors.add(new APEXLangSyntaxError(rawComponent.getLine(), rawComponent.getColumn(), "Invalid property: " + rawComponent.getExternalIdentifierValue() + "\n" + e.getMessage(), externalIdentifierRange.getStart(), rawComponent.getExternalIdentifierValue(), externalIdentifierRange.getStart(), externalIdentifierRange.getEnd(), filename, APEXLangSyntaxError.ErrorType.INVALID_PROPERTY));
            }
        }
        for (RawComponent rawComponent : rawComponents) {
            rawParent = rawComponent.getParent();
            if (rawParent == null) continue;
            Component component = (Component)componentLookUpMap.get(rawComponent);
            Component parent = (Component)componentLookUpMap.get(rawParent);
            if (component == null || parent == null) continue;
            component.setParent(parent);
        }
        return parsedComponents;
    }

    private void addComponentParametersFromRawComponent(Component parsedComponent, ComponentType compType, RawComponent rawComponent, boolean ignoreErrors, List<APEXLangSyntaxError> errors, Map<Integer, Component> parsedComponents, int componentCounter, Map<Integer, Component> previouslyParsedComponents) throws APEXLangException {
        String string;
        ArrayList<RawParameter> rawParametersForSecondPass = new ArrayList<RawParameter>();
        for (RawParameter rawParameter : rawComponent.getRawParameters()) {
            if (this.addParameterIntoComponent(parsedComponent, rawParameter, rawComponent.getRawParameters(), errors, rawComponent.getFilename(), true, ignoreErrors, previouslyParsedComponents)) continue;
            rawParametersForSecondPass.add(rawParameter);
        }
        ArrayList<RawParameter> rawParametersForNextPass = new ArrayList<RawParameter>();
        for (RawParameter rawParameter : rawParametersForSecondPass) {
            if (this.addParameterIntoComponent(parsedComponent, rawParameter, rawComponent.getRawParameters(), errors, rawComponent.getFilename(), false, ignoreErrors, previouslyParsedComponents)) continue;
            rawParametersForNextPass.add(rawParameter);
        }
        if (rawComponent.getExternalIdentifierRange() != null && (string = compType.getExternalIdentifierPropertyId()) != null) {
            String expression;
            Property property = this.metametadata.getProperties().get(string);
            PropertyType propertyType = this.metametadata.getPropertyTypes().get(property.getType());
            ComponentType.ComponentProperty componentProperty = compType.getProperties().get(string);
            ComponentType.ApiParameter apiParameter = componentProperty.getApiParameter();
            String dataType = apiParameter == null ? null : apiParameter.getDataType();
            String string2 = expression = apiParameter == null ? null : apiParameter.getExpression();
            if (dataType == null) {
                dataType = "string";
            }
            APEXLangDataType data = APEXLangDataTypeFactory.createDataType(rawComponent.getExternalIdentifierValue(), propertyType.getDataType(), "", "", dataType, false, "");
            ComponentParameter externalIdentifierParameter = new ComponentParameter(parsedComponent, data, expression, rawComponent.getExternalIdentifierKeyRange().getStart(), rawComponent.getExternalIdentifierKeyRange().getEnd(), rawComponent.getExternalIdentifierValueRange().getStart(), rawComponent.getExternalIdentifierValueRange().getEnd(), rawComponent.getLine(), rawComponent.getColumn(), true, false, property, false, true);
            parsedComponent.getParameters().put(compType.getExternalIdentifierPropertyId(), externalIdentifierParameter);
        }
        Set<String> set = compType.getProperties().keySet();
        for (String componentPropertyId : set) {
            this.addDefaultValueRecursiveForDependsOn(parsedComponents, "" + (componentCounter - 1), componentPropertyId, parsedComponent.getTypeId(), previouslyParsedComponents);
        }
        ComponentPlugin componentPlugin = parsedComponent.getComponentPlugin();
        if (componentPlugin != null) {
            for (ComponentPlugin.CustomAttribute customAttribute : componentPlugin.getCustomAttributes()) {
                String propertyId = customAttribute.getGroupName() + "#" + customAttribute.getPropertyName();
                ComponentParameter parameterCustomAttribute = parsedComponent.getParameters().get(propertyId);
                if (parameterCustomAttribute != null || !customAttribute.getComponentProperty().getIsRequired().booleanValue() || customAttribute.getComponentProperty().getDefaultValue() == null) continue;
                ComponentType.ComponentProperty componentProperty = customAttribute.getComponentProperty();
                ComponentType.ApiParameter apiParameter = componentProperty.getApiParameter();
                String dataType = apiParameter == null ? null : apiParameter.getDataType();
                String expression = apiParameter == null ? "" : apiParameter.getExpression();
                String value = componentProperty.getDefaultValue();
                String yesValue = "true";
                String noValue = "false";
                PropertyType propertyType = this.metametadata.getPropertyTypes().get(customAttribute.getProperty().getType());
                String propertyDataType = "string";
                if (propertyType != null) {
                    propertyDataType = propertyType.getDataType();
                }
                if ("boolean".equals(customAttribute.getProperty().getType()) && componentProperty.getDefaultValue() != null) {
                    value = componentProperty.getDefaultValue().equals(yesValue) ? "true" : "false";
                }
                parsedComponent.addParameter(propertyId, new ComponentParameter(parsedComponent, APEXLangDataTypeFactory.createDataType(value, propertyDataType, yesValue, noValue, dataType, false, ""), expression, parsedComponent.getRange().getStart(), parsedComponent.getRange().getEnd(), parsedComponent.getRange().getStart(), parsedComponent.getRange().getEnd(), parsedComponent.getLine(), parsedComponent.getColumn(), false, true, customAttribute.getProperty(), true, false));
            }
        }
        if (rawParametersForNextPass.size() > 0) {
            for (RawParameter rawParameter : rawParametersForNextPass) {
                if (this.addParameterIntoComponent(parsedComponent, rawParameter, rawComponent.getRawParameters(), errors, rawComponent.getFilename(), false, ignoreErrors, previouslyParsedComponents) || ignoreErrors) continue;
                throw new APEXLangException(" Ambiguos property error: " + rawParameter.getGroupName() + "{ " + rawParameter.getKey() + ": " + rawParameter.getValue() + " }");
            }
        }
    }

    private Component createComponentFromRawComponent(RawComponent rawComponent, String componentTypeId, ComponentType compType, String parentExternalIdentifier) {
        String parentTypeId = compType.getParent() != null ? compType.getParent().getComponentTypeId() : "";
        Component parsedComponent = new Component(rawComponent.getComponentTypeName(), componentTypeId, parentTypeId, compType.getInsertOrder(), compType.getApi().getExpression(), rawComponent.getRangeStart(), rawComponent.getRangeEnd(), rawComponent.getLine(), rawComponent.getColumn(), compType.getExternalIdentifierPropertyId(), rawComponent.getFilename(), parentExternalIdentifier, rawComponent.getComponentGroups());
        if (compType.getPlugin() != null) {
            parsedComponent.setPluginType(new PluginType(compType.getPlugin().getTypes()[0], compType.getPlugin().getPropertyId(), compType.getPlugin().getApi()));
            Property pluginPropertyType = this.metametadata.getProperties().get(parsedComponent.getPluginType().getPropertyId());
            if (pluginPropertyType != null) {
                Group pluginGroup = this.metametadata.getGroups().get("" + pluginPropertyType.getGroupId());
                for (RawParameter rawParameter : rawComponent.getRawParameters()) {
                    Map<String, Component> pluginsFound;
                    Component pluginFound;
                    String groupName = rawParameter.getGroupName();
                    if (groupName == null) {
                        Group defaultGroup = this.metametadata.getGroups().get(compType.getDefaultGroupId());
                        String string = groupName = defaultGroup != null ? defaultGroup.getName() : "";
                    }
                    if (!pluginGroup.getName().equals(groupName) || !pluginPropertyType.getName().equals(rawParameter.getKey()) || (pluginFound = (pluginsFound = this.pluginsLoader.getPluginTypesMap().get(parsedComponent.getPluginType().getType())) == null ? null : pluginsFound.get(rawParameter.getValue())) == null) continue;
                    parsedComponent.setComponentPlugin(new ComponentPlugin(pluginFound, compType.getPlugin().getApi().getExpression(), this.pluginsLoader.getPluginsChildren(), cachedMetametadata));
                }
            }
        }
        return parsedComponent;
    }

    /*
     * WARNING - void declaration
     */
    private boolean addParameterIntoComponent(Component component, RawParameter rawParameter, List<RawParameter> rawParametersList, List<APEXLangSyntaxError> errors, String filename, boolean firstPass, boolean ignoreErrors, Map<Integer, Component> previoslyParsedComponents) {
        String expression;
        void var15_22;
        HashMap<Object, PropertyCandidate> candidates = new HashMap<Object, PropertyCandidate>();
        String componentTypeId = component.getTypeId();
        ComponentType componentType = this.metametadata.getComponentTypes().get(componentTypeId);
        if (componentType == null) {
            LOGGER.warning("Something is wrong with metametadata!");
            return false;
        }
        boolean implicitGroup = false;
        String groupName = rawParameter.getGroupName();
        if (groupName == null) {
            Group defaultGroup = this.metametadata.getGroups().get(componentType.getDefaultGroupId());
            groupName = defaultGroup != null ? defaultGroup.getName() : "";
            implicitGroup = defaultGroup != null;
        }
        for (String string : componentType.getProperties().keySet()) {
            Property property = this.metametadata.getProperties().get(string);
            if (property == null) {
                LOGGER.warning("Something is wrong with metametadata!");
                continue;
            }
            Group propertyGroup = this.metametadata.getGroups().get("" + property.getGroupId());
            if (!property.getName().equals(rawParameter.getKey()) || propertyGroup == null || !propertyGroup.getName().equals(groupName)) continue;
            candidates.put(string, new PropertyCandidate(property, componentType.getProperties().get(string), false));
        }
        ComponentPlugin componentPlugin = component.getComponentPlugin();
        if (componentPlugin != null) {
            for (ComponentPlugin.CustomAttribute customAttribute : componentPlugin.getCustomAttributes()) {
                if (!customAttribute.getGroupName().equals(groupName) || !customAttribute.getPropertyName().equals(rawParameter.getKey())) continue;
                ComponentType.ComponentProperty customProperty = new ComponentType.ComponentProperty();
                customProperty.setApiParameter(customAttribute.getComponentProperty().getApiParameter());
                candidates.put(customAttribute.getGroupName() + "#" + customAttribute.getName(), new PropertyCandidate(customAttribute.getProperty(), customProperty, true));
            }
        }
        if (candidates.size() == 0) {
            if (firstPass) {
                return false;
            }
            if (ignoreErrors) {
                LOGGER.warning("Error on: " + filename + " for component " + componentType.getName().getSingular() + " it has an invalid property (soft error): For property: " + rawParameter.getKey() + " L" + rawParameter.getLine());
            } else {
                errors.add(new APEXLangSyntaxError(rawParameter.getLine(), rawParameter.getColumn(), "Invalid property: " + rawParameter.getKey(), rawParameter.getStart(), rawParameter.getKey(), rawParameter.getStart(), rawParameter.getEnd(), filename, APEXLangSyntaxError.ErrorType.INVALID_PROPERTY));
            }
            return true;
        }
        Object var15_18 = null;
        String propertyId = "";
        ComponentType.ComponentProperty componentProperty = null;
        Boolean pluginParameter = false;
        if (candidates.size() == 1) {
            propertyId = (String)candidates.keySet().iterator().next();
            Property property = ((PropertyCandidate)candidates.get(propertyId)).getProperty();
            componentProperty = ((PropertyCandidate)candidates.get(propertyId)).getComponentProperty();
            pluginParameter = ((PropertyCandidate)candidates.get(propertyId)).isPluginProperty();
        } else if (candidates.size() > 1) {
            void var15_21;
            if (firstPass) {
                return false;
            }
            for (Map.Entry candidateProperty : candidates.entrySet()) {
                if (!this.isParameterVisibleAccordingDependOnRule(component, ((PropertyCandidate)candidateProperty.getValue()).getComponentProperty().getDependingOn())) continue;
                Property property = ((PropertyCandidate)candidateProperty.getValue()).getProperty();
                propertyId = (String)candidateProperty.getKey();
                componentProperty = ((PropertyCandidate)candidates.get(propertyId)).getComponentProperty();
                pluginParameter = ((PropertyCandidate)candidates.get(propertyId)).isPluginProperty();
                break;
            }
            if (var15_21 == null) {
                return false;
            }
        }
        if (var15_22 == null) {
            if (ignoreErrors) {
                LOGGER.warning("Error on: " + filename + " for component " + componentType.getName().getSingular() + " it has an invalid property (soft error): For property: " + rawParameter.getKey() + " L" + rawParameter.getLine());
            } else {
                errors.add(new APEXLangSyntaxError(rawParameter.getLine(), rawParameter.getColumn(), "Invalid property: " + rawParameter.getKey(), rawParameter.getStart(), rawParameter.getKey(), rawParameter.getStart(), rawParameter.getEnd(), filename, APEXLangSyntaxError.ErrorType.INVALID_PROPERTY));
            }
            return true;
        }
        PropertyType propertyType = this.metametadata.getPropertyTypes().get(var15_22.getType());
        ComponentType.ApiParameter apiParameter = componentProperty.getApiParameter();
        String dataType = apiParameter == null ? null : apiParameter.getDataType();
        String string = expression = apiParameter == null ? "" : apiParameter.getExpression();
        if (dataType == null) {
            dataType = "string";
        }
        try {
            String multivalueDelimiter;
            String noValue;
            String yesValue = var15_22.getYesValue();
            if (yesValue == null || yesValue.equals("")) {
                yesValue = propertyType.getDefaultYesValue();
            }
            if ((noValue = var15_22.getNoValue()) == null || noValue.equals("")) {
                noValue = propertyType.getDefaultNoValue();
            }
            if ((multivalueDelimiter = var15_22.getMultiValueDelimiter()) == null) {
                multivalueDelimiter = propertyType.getDefaultMultiValueDelimiter();
            }
            Object value = rawParameter.getValue();
            if (propertyType.isMultiLine() && ((String)value).startsWith("```")) {
                Matcher m = MLT_REGEX.matcher((CharSequence)value);
                Object errMsg = null;
                if (m.matches()) {
                    String annotation = m.group(1);
                    if (annotation != null && annotation.isEmpty()) {
                        annotation = null;
                    }
                    String lang = propertyType.getLanguage();
                    ArrayList<String> supportedLangTags = new ArrayList<String>();
                    if (lang != null) {
                        supportedLangTags.add(lang);
                        int dashPos = lang.indexOf("-");
                        if (dashPos > 0) {
                            supportedLangTags.add(lang.substring(0, dashPos));
                        }
                    }
                    if (supportedLangTags.isEmpty() && annotation != null) {
                        errMsg = "Language annotation should not be set for this property";
                    } else if (!supportedLangTags.isEmpty() && annotation != null && !supportedLangTags.contains(annotation)) {
                        if (supportedLangTags.size() == 1) {
                            errMsg = "Language annotation should be \"" + lang + "\" for this property";
                        } else {
                            String langs = supportedLangTags.stream().map(t -> "\"" + t + "\"").collect(Collectors.joining(","));
                            errMsg = "Language annotation should be one of " + langs + " for this property";
                        }
                    }
                } else {
                    errMsg = "Badly formatted multiline text block";
                }
                if (errMsg != null) {
                    errors.add(new APEXLangSyntaxError(rawParameter.getLine(), rawParameter.getColumn(), (String)errMsg, rawParameter.getStart(), rawParameter.getKey(), rawParameter.getStart(), rawParameter.getEnd(), filename, APEXLangSyntaxError.ErrorType.INVALID_PROPERTY));
                }
            }
            if (var15_22.getLov() != null && var15_22.getLov().getType().equals(LOV_TYPE_STATIC)) {
                value = this.resolveStaticLovs(propertyId, rawParameter, filename, errors);
            }
            if (var15_22.getLov() != null && var15_22.getLov().getType().equals(LOV_TYPE_PLUGIN)) {
                Component pluginFound;
                if (component.getPluginType() == null || component.getPluginType().getPropertyId() == propertyId) {
                    throw new APEXLangException("invalid plugin type");
                }
                String pluginType = component.getPluginType().getType();
                Map<String, Component> pluginsFound = this.pluginsLoader.getPluginTypesMap().get(pluginType);
                Component component2 = pluginFound = pluginsFound == null ? null : pluginsFound.get(value);
                if (pluginFound == null) {
                    Object validPlugins = "Valid plugins are: \n";
                    if (pluginsFound != null) {
                        for (String pluginName : pluginsFound.keySet()) {
                            validPlugins = (String)validPlugins + pluginName + "\n";
                        }
                    } else {
                        validPlugins = (String)validPlugins + "Plugin type: " + pluginType + " invalid \n";
                    }
                    errors.add(new APEXLangSyntaxError(rawParameter.getLine(), rawParameter.getColumn(), "Plugin not found for " + componentType.getName().getSingular() + " component: " + (String)value + "\n" + (String)validPlugins, rawParameter.getStart(), "", rawParameter.getStart(), rawParameter.getEnd(), filename, APEXLangSyntaxError.ErrorType.PLUGIN_NOT_FOUND));
                } else {
                    String internalName = pluginFound.getParameters().get("1959").getValue();
                    value = "NATIVE_" + internalName;
                }
            }
            APEXLangDataType data = APEXLangDataTypeFactory.createDataType((String)value, propertyType.getDataType(), yesValue, noValue, dataType, rawParameter.isArray(), multivalueDelimiter);
            data.validate((Property)var15_22, propertyType);
            String tokenString = rawParameter.getToken().getText();
            Matcher m = this.KEY_VALUE_REGEX.matcher(tokenString);
            int keyEndOffset = 0;
            int valueStartOffset = 0;
            if (m.matches()) {
                keyEndOffset = m.end(1);
                valueStartOffset = m.start(2);
            }
            component.addParameter(propertyId, new ComponentParameter(component, data, expression, rawParameter.getStart(), rawParameter.getStart() + keyEndOffset, rawParameter.getStart() + valueStartOffset, rawParameter.getEnd() + 1, rawParameter.getLine(), rawParameter.getColumn(), true, implicitGroup, (Property)var15_22, pluginParameter, false));
        }
        catch (APEXLangException x) {
            errors.add(new APEXLangSyntaxError(rawParameter.getLine(), rawParameter.getColumn(), "Invalid property (" + x.getMessage() + "): " + rawParameter.getKey(), rawParameter.getStart(), rawParameter.getKey(), rawParameter.getStart(), rawParameter.getEnd(), filename, APEXLangSyntaxError.ErrorType.INVALID_PROPERTY));
        }
        return true;
    }

    private String resolveStaticLovs(String propertyId, RawParameter rawParameter, String filename, List<APEXLangSyntaxError> errors) {
        String result = rawParameter.getValue();
        if (this.metametadata.getProperties().get(propertyId).getLov() != null && this.metametadata.getProperties().get(propertyId).getLov().getType().equals(LOV_TYPE_STATIC)) {
            List<LOVValue> lov = this.metametadata.getProperties().get(propertyId).getLov().getValues();
            Property property = this.getMetametadata().getProperties().get(propertyId);
            PropertyType propertyType = this.getMetametadata().getPropertyTypes().get(property.getType());
            Group group = this.getMetametadata().getGroups().get("" + property.getGroupId());
            boolean lovFound = false;
            Object validLovs = "";
            if (!rawParameter.isArray()) {
                for (LOVValue value : lov) {
                    validLovs = (String)validLovs + "\n- " + value.getName();
                    if (!value.getName().equals(rawParameter.getValue())) continue;
                    result = value.getR();
                    lovFound = true;
                }
                if (!lovFound) {
                    errors.add(new APEXLangSyntaxError(rawParameter.getLine(), rawParameter.getColumn(), "Invalid LOV required parameter (" + propertyId + "): " + group.getName() + " - " + property.getName() + " (" + propertyType.getDataType() + ")\nValid parameters are: " + (String)validLovs, rawParameter.getStart(), "", rawParameter.getStart(), rawParameter.getEnd(), filename, APEXLangSyntaxError.ErrorType.LOV_NOT_FOUND));
                }
            } else {
                String[] entries;
                ArrayList<String> arrayResult = new ArrayList<String>();
                for (String entry : entries = rawParameter.getValue().split("\n")) {
                    for (LOVValue value : lov) {
                        if (!value.getName().equals(entry)) continue;
                        arrayResult.add(value.getR());
                        lovFound = true;
                        break;
                    }
                    if (lovFound) continue;
                    errors.add(new APEXLangSyntaxError(rawParameter.getLine(), rawParameter.getColumn(), "Invalid LOV required parameter (" + propertyId + "): " + group.getName() + " - " + property.getName() + " (" + propertyType.getDataType() + ")\nValid parameters are: " + (String)validLovs, rawParameter.getStart(), "", rawParameter.getStart(), rawParameter.getEnd(), filename, APEXLangSyntaxError.ErrorType.LOV_NOT_FOUND));
                }
                result = String.join((CharSequence)"\n", arrayResult);
            }
        }
        return result;
    }

    void resolveReferences(Map<Integer, Component> componentsParameters, List<APEXLangSyntaxError> errors, APEXLangCompilerContext appCtx) {
        for (Component currentComponent : componentsParameters.values()) {
            for (Map.Entry<String, ComponentParameter> componentParameterEntry : currentComponent.getParameters().entrySet()) {
                ComponentParameter componentParameter = componentParameterEntry.getValue();
                Property property = componentParameter.getProperty();
                if (property.getLov() == null || !property.getLov().getType().equals(LOV_TYPE_COMPONENT)) continue;
                String lovScope = property.getLov().getScope();
                try {
                    if (componentParameter.getData().getClass() != APEXLangStringDataType.class) {
                        LOGGER.warning("Invalidate LOV (only supported from Strings) " + componentParameter.getData().getClass().getName());
                        throw new Exception("Invalid reference");
                    }
                    APEXLangStringDataType data = (APEXLangStringDataType)componentParameter.getData();
                    String ref = data.getData();
                    if (ref.charAt(0) != '@') {
                        throw new Exception("Invalid reference");
                    }
                    String[] chunks = ref.substring(1).split("/");
                    String componentId = chunks[chunks.length - 1];
                    if (chunks.length < 3) {
                        Map<String, Location> availableReferences = this.getAvailableReferenceLocations(property, componentParameter, appCtx);
                        if (availableReferences.containsKey(ref)) {
                            data.setData(componentId);
                            data.setCentral(chunks.length == 2);
                            continue;
                        }
                        Map<String, Location> debug = this.getAvailableReferenceLocations(property, componentParameter, appCtx);
                        throw new Exception("Reference not found:" + ref);
                    }
                    if (chunks.length == 3) {
                        if (!this.LOV_SCOPE_WORKSPACE.equals(lovScope) && !"INSTANCE".equals(lovScope)) {
                            throw new Exception("External reference not supported property with scope " + lovScope);
                        }
                        data.setRefAppId(chunks[1]);
                        data.setData(chunks[2]);
                        data.setCentral(false);
                        continue;
                    }
                    if (chunks.length <= 3) continue;
                    throw new Exception("Invalid reference");
                }
                catch (Exception e) {
                    errors.add(new APEXLangSyntaxError(currentComponent.getLine(), currentComponent.getColumn(), e.getMessage(), currentComponent.getRange().getStart(), "", currentComponent.getRange().getStart(), currentComponent.getRange().getEnd(), currentComponent.getFilename(), APEXLangSyntaxError.ErrorType.REFERENCE_NOT_FOUND));
                }
            }
        }
    }

    private Map<String, Location> getAvailableReferenceLocations(Property property, ComponentParameter componentParameter, APEXLangCompilerContext appCtx) {
        if (property.getLov() != null && property.getLov().getType().equals(LOV_TYPE_COMPONENT)) {
            String componentTypeId = property.getLov().getComponentTypeId();
            String lovScope = property.getLov().getScope();
            return this.getAvailableReferenceLocations(componentParameter, appCtx, lovScope, componentTypeId);
        }
        return Collections.emptyMap();
    }

    Map<String, Location> getAvailableReferenceLocations(ComponentParameter componentParameter, APEXLangCompilerContext appCtx, String lovScope, String componentTypeId) {
        HashMap<String, Location> ret = new HashMap<String, Location>();
        String componentType = componentParameter.getComponent().getTypeId();
        Function<ComponentParameter, Boolean> scopeChecker = cp -> true;
        if (lovScope != null && !lovScope.equals(this.LOV_SCOPE_APPLICATION)) {
            if (this.LOV_SCOPE_COMPONENT.equals(lovScope)) {
                Component component = componentParameter.getComponent();
                String id = component.getExternalIdentifier();
                scopeChecker = cp -> {
                    Component cpComponent = cp.getComponent();
                    Component testComponent = cpComponent == null ? null : cpComponent.getParent();
                    return id != null && id.equals(testComponent.getExternalIdentifier());
                };
            } else if ("GRAND_PARENT".equals(lovScope) || "WF_VERSION".equals(lovScope)) {
                Component parent = componentParameter.getComponent();
                Component gParent = parent == null ? null : parent.getParent();
                scopeChecker = cp -> {
                    Component parent2 = cp.getComponent();
                    Component gParent2 = parent2 == null ? null : parent2.getParent();
                    return gParent2 == gParent;
                };
            } else if (this.LOV_SCOPE_REGION.equals(lovScope)) {
                String regionPropId = null;
                String paramRegion = null;
                for (Map.Entry<String, Object> entry : componentParameter.getComponent().getParameters().entrySet()) {
                    Property property = this.metametadata.getProperties().get(entry.getKey());
                    if (!"region".equals(property.getName())) continue;
                    paramRegion = ((ComponentParameter)entry.getValue()).getValue();
                    regionPropId = entry.getKey();
                }
                String regionPropId2 = regionPropId;
                String string = paramRegion;
                scopeChecker = cp -> {
                    ComponentParameter regionCp = cp.getComponent().getParameters().get(regionPropId2);
                    String region = regionCp == null ? null : regionCp.getValue();
                    return region != null && region.equals(paramRegion2);
                };
            } else if (this.LOV_SCOPE_PAGE.equals(lovScope) || this.LOV_SCOPE_PAGE_AND_GLOBAL.equals(lovScope)) {
                Component paramPage = this.getPage(componentParameter);
                scopeChecker = cp -> {
                    Component page = this.getPage((ComponentParameter)cp);
                    return page != null && page == paramPage;
                };
            } else if (this.LOV_SCOPE_THEME.equals(lovScope)) {
                ThemeDefinition td = this.getThemeDefinition("current", componentParameter);
                scopeChecker = cp -> td != null && td.refAppId.length() == 0;
            }
        }
        for (Map.Entry<String, Map<String, Map<String, ComponentParameter>>> entry : appCtx.getReferencablesMap().entrySet()) {
            Map<String, Map<String, ComponentParameter>> componentTypeMap = entry.getValue();
            Map<String, ComponentParameter> map = componentTypeMap.get(componentTypeId);
            if (map == null) continue;
            for (Map.Entry<String, ComponentParameter> entry2 : map.entrySet()) {
                Position pos;
                ComponentParameter cp2 = entry2.getValue();
                if (scopeChecker.apply(cp2).booleanValue()) {
                    pos = new Position(cp2.getLine(), cp2.getColumn());
                    ret.put("@" + entry2.getKey(), new Location(entry.getKey(), pos));
                    continue;
                }
                if (!this.LOV_SCOPE_PAGE_AND_GLOBAL.equals(lovScope) || !this.onGlobalPage(appCtx, cp2)) continue;
                pos = new Position(cp2.getLine(), cp2.getColumn());
                ret.put("@/" + entry2.getKey(), new Location(entry.getKey(), pos));
            }
        }
        Map<Object, Object> additionalReferencablesMap = Collections.emptyMap();
        Function<ComponentParameter, Boolean> additionalScopeChecker = null;
        if (componentType.equals("2000")) {
            ThemeDefinition td = this.getThemeDefinition("subscribedFrom", componentParameter);
            if (td != null && this.centralThemes.containsKey(td.refAppId)) {
                additionalReferencablesMap = this.centralThemes.get(td.refAppId).getReferencablesMap();
                additionalScopeChecker = cp -> true;
            }
        } else if (this.LOV_SCOPE_THEME.equals(lovScope) || this.LOV_SCOPE_PAGE_AND_GLOBAL.equals(lovScope) || componentType.equals("2040")) {
            for (Map.Entry<String, Map<String, Map<String, ComponentParameter>>> entry : appCtx.getReferencablesMap().entrySet()) {
                String sf;
                Map<String, Map<String, ComponentParameter>> componentTypeMap = entry.getValue();
                Map<String, ComponentParameter> referencables = componentTypeMap.get(sf = this.metametadata.getMapping().getTheme().get("subscribedFrom").getComponentTypeId());
                if (referencables == null) continue;
                for (Map.Entry<String, ComponentParameter> entry2 : referencables.entrySet()) {
                    ComponentParameter cp2 = entry2.getValue();
                    ThemeDefinition td = this.getThemeDefinition("subscribedFrom", cp2);
                    if (td == null || !this.centralThemes.containsKey(td.refAppId)) continue;
                    additionalReferencablesMap = this.centralThemes.get(td.refAppId).getReferencablesMap();
                    additionalScopeChecker = cp -> true;
                    break;
                }
                if (additionalScopeChecker == null) continue;
                break;
            }
            if (additionalScopeChecker == null) {
                if (this.LOV_SCOPE_THEME.equals(lovScope)) {
                    additionalScopeChecker = cp -> true;
                } else if (this.LOV_SCOPE_PAGE_AND_GLOBAL.equals(lovScope)) {
                    additionalScopeChecker = cp -> true;
                } else if (componentType.equals("2040")) {
                    additionalScopeChecker = cp -> true;
                }
            }
        }
        for (Map.Entry<String, Map<String, Map<String, ComponentParameter>>> entry : additionalReferencablesMap.entrySet()) {
            Map<String, ComponentParameter> referencables = entry.getValue().get(componentTypeId);
            if (referencables == null) continue;
            for (Map.Entry<String, ComponentParameter> entry2 : referencables.entrySet()) {
                if (!additionalScopeChecker.apply(entry2.getValue()).booleanValue()) continue;
                ret.put("@/" + entry2.getKey(), null);
            }
        }
        return ret;
    }

    private Component getPage(ComponentParameter componentParameter) {
        Component parent;
        for (parent = componentParameter.getComponent(); parent != null; parent = parent.getParent()) {
            String componentTypeId = parent.getTypeId();
            String componentType = this.metametadata.getComponentTypes().get(componentTypeId).getName().getSingular();
            if ("page".equals(componentType)) break;
        }
        return parent;
    }

    private boolean onGlobalPage(APEXLangCompilerContext appCtx, ComponentParameter componentParameter) {
        ComponentParameter cp;
        Component page;
        Integer globalPageNum = appCtx.getGlobalPage();
        if (globalPageNum != null && (page = this.getPage(componentParameter)) != null && (cp = page.getParameters().get(page.getExternalIdentifierPropertyId())) != null) {
            APEXLangNumericDataType data = (APEXLangNumericDataType)cp.getData();
            Integer pageNum = data.getNumber().intValue();
            return globalPageNum.equals(pageNum);
        }
        return false;
    }

    private ThemeDefinition getThemeDefinition(String type, ComponentParameter componentParameter) {
        String subscriptionProp = this.metametadata.getMapping().getTheme().get(type).getPropertyId();
        ComponentParameter subsParam = componentParameter.getComponent().getParameters().get(subscriptionProp);
        APEXLangDataType data = subsParam == null ? null : subsParam.getData();
        ThemeDefinition ret = null;
        if (data instanceof APEXLangStringDataType) {
            String ref = ((APEXLangStringDataType)data).getData();
            if (ref.startsWith("@/")) {
                Pattern p = Pattern.compile("^@/([^/]+)/([^/]+)$");
                Matcher m = p.matcher(data.toString());
                if (m.matches()) {
                    ret = new ThemeDefinition();
                    ret.refAppId = m.group(1);
                    ret.themeId = m.group(2);
                }
            } else {
                String refAppId = ((APEXLangStringDataType)data).getRefAppId();
                if (refAppId != null) {
                    ret = new ThemeDefinition();
                    ret.refAppId = refAppId;
                    ret.themeId = ((APEXLangStringDataType)data).getData();
                }
            }
        }
        return ret;
    }

    void checkPropertyVisibleComponentParameters(Map<Integer, Component> componentsParameters) {
        HashSet<String> componentPropertyToBeDeleted = new HashSet<String>();
        for (Component currentComponent : componentsParameters.values()) {
            for (Map.Entry<String, ComponentParameter> currentParameter : currentComponent.getParameters().entrySet()) {
                ComponentType.ComponentProperty componentProperty = this.metametadata.getComponentTypes().get(currentComponent.getTypeId()).getProperties().get(currentParameter.getKey());
                boolean propertyVisible = this.isParameterVisibleAccordingDependOnRule(currentComponent, componentProperty.getDependingOn());
                if (propertyVisible) continue;
                componentPropertyToBeDeleted.add(currentParameter.getKey());
            }
            for (String deletedPropertyKey : componentPropertyToBeDeleted) {
                currentComponent.getParameters().remove(deletedPropertyKey);
            }
        }
    }

    private boolean isParameterVisibleAccordingDependOnRule(Component component, ComponentType.DependingOn[] dependingOnList) {
        boolean propertyVisible = true;
        if (dependingOnList == null) {
            return propertyVisible;
        }
        for (ComponentType.DependingOn dependingOn : dependingOnList) {
            String propertyId = dependingOn.getPropertyId();
            ComponentParameter dependingOnParameter = component.getParameters().get(propertyId);
            if (dependingOn.isHasToExist()) {
                boolean inFeature = false;
                switch (dependingOn.getType()) {
                    case "EQUALS": {
                        propertyVisible &= dependingOnParameter != null && dependingOnParameter.getValue().equals(dependingOn.getValue());
                        break;
                    }
                    case "IN_LIST": {
                        if (Arrays.asList(dependingOn.getValues()).contains("$FEATURE$") && component.getPluginType() != null && component.getPluginType().getPropertyId().equals(dependingOn.getPropertyId())) {
                            inFeature = true;
                        }
                        propertyVisible &= dependingOnParameter != null && (Arrays.asList(dependingOn.getValues()).contains(dependingOnParameter.getValue()) || inFeature);
                        break;
                    }
                    case "IN_LIST_LIKE": {
                        if (Arrays.asList(dependingOn.getValues()).contains("$FEATURE$") && component.getPluginType() != null && component.getPluginType().getPropertyId().equals(dependingOn.getPropertyId())) {
                            inFeature = true;
                        }
                        propertyVisible &= dependingOnParameter != null && (Arrays.asList(dependingOn.getValues()).contains(dependingOnParameter.getValue()) || inFeature);
                        break;
                    }
                    case "NOT_NULL": {
                        propertyVisible &= dependingOnParameter != null;
                        break;
                    }
                    case "NOT_EQUALS": {
                        propertyVisible &= !dependingOn.getValue().equals(dependingOnParameter != null ? dependingOnParameter.getValue() : null);
                        break;
                    }
                    case "NOT_IN_LIST": {
                        propertyVisible &= dependingOnParameter != null && !Arrays.asList(dependingOn.getValues()).contains(dependingOnParameter.getValue());
                    }
                }
                continue;
            }
            propertyVisible &= dependingOnParameter == null;
        }
        return propertyVisible;
    }

    void addDefaultValues(Map<Integer, Component> componentParameters, Map<Integer, Component> previouslyParsedComponents) {
        for (Map.Entry<Integer, Component> currentComponentEntry : componentParameters.entrySet()) {
            Component currentComponent = currentComponentEntry.getValue();
            Set<String> componentPropertyIds = this.metametadata.getComponentTypes().get(currentComponent.getTypeId()).getProperties().keySet();
            for (String componentPropertyId : componentPropertyIds) {
                this.addDefaultValueRecursiveForDependsOn(componentParameters, String.valueOf(currentComponentEntry.getKey()), componentPropertyId, currentComponent.getTypeId(), previouslyParsedComponents);
            }
        }
    }

    void addDefaultValueRecursiveForDependsOn(Map<Integer, Component> componentParameters, String componentId, String parameterId, String componentTypeId, Map<Integer, Component> previouslyParsedComponents) {
        Object component = componentParameters.get(Integer.parseInt(componentId));
        ComponentParameter parameter = ((Component)component).getParameters().get(parameterId);
        if (parameter != null) {
            return;
        }
        ComponentType componentType = null;
        if (!((Component)component).getTypeId().equals(componentTypeId)) {
            Object componentCursor = component;
            while (((Component)componentCursor).getParent() != null) {
                if (!((Component)(componentCursor = ((Component)componentCursor).getParent())).getTypeId().equals(componentTypeId)) continue;
                componentType = this.metametadata.getComponentTypes().get(((Component)componentCursor).getTypeId());
                component = componentCursor;
                break;
            }
        } else {
            componentType = this.metametadata.getComponentTypes().get(componentTypeId);
        }
        if (componentType == null) {
            for (Map.Entry entry : previouslyParsedComponents.entrySet()) {
                Component previoslyParsedComponent = (Component)entry.getValue();
                if (!previoslyParsedComponent.getTypeId().equals(componentTypeId)) continue;
                componentType = this.metametadata.getComponentTypes().get(previoslyParsedComponent.getTypeId());
                component = previoslyParsedComponent;
                break;
            }
        }
        if (componentType == null) {
            return;
        }
        ComponentType.ComponentProperty componentPropety = componentType.getProperties().get(parameterId);
        Property property = this.metametadata.getProperties().get(parameterId);
        PropertyType propertyType = this.metametadata.getPropertyTypes().get(property.getType());
        if (componentPropety == null) {
            return;
        }
        if (componentPropety.getIsRequired().booleanValue() && componentPropety.getDefaultValue() != null) {
            if (componentPropety.getDependingOn() != null) {
                for (ComponentType.DependingOn dependingOn : componentPropety.getDependingOn()) {
                    this.addDefaultValueRecursiveForDependsOn(componentParameters, componentId, dependingOn.getPropertyId(), dependingOn.getComponentTypeId(), previouslyParsedComponents);
                }
            }
            if (this.isParameterVisibleAccordingDependOnRule((Component)component, componentPropety.getDependingOn())) {
                String noValue;
                String yesValue = property.getYesValue();
                if (yesValue == null || yesValue.equals("")) {
                    yesValue = propertyType.getDefaultYesValue();
                }
                if ((noValue = property.getNoValue()) == null || noValue.equals("")) {
                    noValue = propertyType.getDefaultNoValue();
                }
                try {
                    ComponentType.ComponentProperty componentProperty = componentType.getProperties().get(parameterId);
                    ComponentType.ApiParameter apiParameter = componentProperty.getApiParameter();
                    String dataType = apiParameter == null ? null : apiParameter.getDataType();
                    String expression = apiParameter == null ? "" : apiParameter.getExpression();
                    String value = componentPropety.getDefaultValue();
                    if ("boolean".equals(propertyType.getDataType())) {
                        value = componentPropety.getDefaultValue().equals(yesValue) ? "true" : "false";
                    }
                    ((Component)component).addParameter(parameterId, new ComponentParameter((Component)component, APEXLangDataTypeFactory.createDataType(value, propertyType.getDataType(), yesValue, noValue, dataType, false, ""), expression, ((Component)component).getRange().getStart(), ((Component)component).getRange().getEnd(), ((Component)component).getRange().getStart(), ((Component)component).getRange().getEnd(), ((Component)component).getLine(), ((Component)component).getColumn(), false, true, property, false, false));
                }
                catch (Exception x) {
                    LOGGER.warning("Something wrong with metametadata: " + String.valueOf(x));
                }
            }
        }
    }

    void checkRequiredAttributes(Map<Integer, Component> componentParameters, List<APEXLangSyntaxError> errors) {
        for (Map.Entry<Integer, Component> componentEntry : componentParameters.entrySet()) {
            Component component = componentEntry.getValue();
            ComponentType componentType = this.getMetametadata().getComponentTypes().get(componentEntry.getValue().getTypeId());
            for (Map.Entry<String, ComponentType.ComponentProperty> entryProperty : componentType.getProperties().entrySet()) {
                ComponentParameter componentParameter;
                ComponentType.ComponentProperty componentProperty = entryProperty.getValue();
                Property property = this.getMetametadata().getProperties().get(entryProperty.getKey());
                PropertyType propertyType = this.getMetametadata().getPropertyTypes().get(property.getType());
                Group group = this.getMetametadata().getGroups().get("" + property.getGroupId());
                if (componentProperty == null || !componentProperty.getIsRequired().booleanValue() || !this.isParameterVisibleAccordingDependOnRule(component, componentProperty.getDependingOn()) || (componentParameter = componentEntry.getValue().getParameters().get(entryProperty.getKey())) != null) continue;
                errors.add(new APEXLangSyntaxError(component.getLine(), component.getColumn(), "Missing required parameter (" + entryProperty.getKey() + "): " + group.getName() + " - " + property.getName() + " (" + propertyType.getDataType() + ")", component.getRange().getStart(), "", component.getRange().getStart(), component.getRange().getEnd(), component.getFilename(), APEXLangSyntaxError.ErrorType.MISSING_REQUIRED_PROPERTY));
            }
            if (component.getComponentPlugin() == null || component.getComponentPlugin().getCustomAttributes() == null) continue;
            for (ComponentPlugin.CustomAttribute customAttribute : component.getComponentPlugin().getCustomAttributes()) {
                ComponentParameter componentParameter;
                boolean isVisible = this.isParameterVisibleAccordingDependOnRule(component, customAttribute.getComponentProperty().getDependingOn());
                if (!isVisible || !customAttribute.getComponentProperty().getIsRequired().booleanValue() || (componentParameter = componentEntry.getValue().getParameters().get(customAttribute.getGroupName() + "#" + customAttribute.getPropertyName())) != null) continue;
                errors.add(new APEXLangSyntaxError(component.getLine(), component.getColumn(), "Missing required parameter: " + customAttribute.getGroupName() + " - " + customAttribute.getPropertyName(), component.getRange().getStart(), "", component.getRange().getStart(), component.getRange().getEnd(), component.getFilename(), APEXLangSyntaxError.ErrorType.MISSING_REQUIRED_PROPERTY));
            }
        }
    }

    private APEXLangCompilationResult compile(Map<String, String> fileMap, APEXLangCompilerContext appCtx, boolean appStateOnly) {
        ArrayList<Component> componentsFromSource = new ArrayList<Component>();
        APEXLangCompilerContext currAppCtx = appCtx == null ? new APEXLangCompilerContext() : appCtx;
        ArrayList<APEXLangSyntaxError> errors = new ArrayList<APEXLangSyntaxError>();
        Map<Integer, Component> componentsParameters = new HashMap<Integer, Component>();
        Integer componentCounter = 0;
        APEXLangManifest manifest = new APEXLangManifest();
        ArrayList<String> filenames = new ArrayList<String>(fileMap.keySet());
        Collections.sort(filenames);
        for (String filename : filenames) {
            if (filename.endsWith(APEX_EXTENSIONS[0]) || filename.endsWith(APEX_EXTENSIONS[1])) {
                currAppCtx.getReferencablesMap().remove(filename);
                Collection<Component> originalComponentsParameters = this.readParameters(fileMap.get(filename), filename, errors, componentsParameters);
                for (Component component2 : originalComponentsParameters) {
                    Integer n = componentCounter;
                    componentCounter = componentCounter + 1;
                    componentsParameters.put(n, component2);
                    componentsFromSource.add(component2);
                }
                HashMap referencables = new HashMap();
                for (Component component3 : originalComponentsParameters) {
                    String componentExternalIdentifierPropertyId = component3.getExternalIdentifierPropertyId();
                    ComponentParameter externalIdentifierParameter = component3.getParameters().get(componentExternalIdentifierPropertyId);
                    HashMap<String, ComponentParameter> componentTypeDependencies = (HashMap<String, ComponentParameter>)referencables.get(component3.getTypeId());
                    if (componentTypeDependencies == null) {
                        componentTypeDependencies = new HashMap<String, ComponentParameter>();
                        referencables.put(component3.getTypeId(), componentTypeDependencies);
                    }
                    if (externalIdentifierParameter == null) continue;
                    String externalIdentifier = externalIdentifierParameter.getData().toString();
                    componentTypeDependencies.put(externalIdentifier, externalIdentifierParameter);
                }
                if (referencables.isEmpty()) continue;
                currAppCtx.getReferencablesMap().put(filename, referencables);
                continue;
            }
            if (!filename.endsWith(MANIFEST_FILENAME)) continue;
            try {
                String manifestFile = fileMap.get(filename);
                ObjectMapper mapper = new ObjectMapper();
                APEXLangManifestObject aPEXLangManifestObject = (APEXLangManifestObject)mapper.readValue(manifestFile, APEXLangManifestObject.class);
                String importStatement = this.metametadata.getPreImport();
                String endStatement = this.getMetametadata().getPostImport();
                manifest = new APEXLangManifest(aPEXLangManifestObject.getApex_version(), aPEXLangManifestObject.getApi_version(), aPEXLangManifestObject.getApp_id(), aPEXLangManifestObject.getDefault_id_offset(), aPEXLangManifestObject.getDefault_owner(), aPEXLangManifestObject.getWorkspace_id(), importStatement, endStatement);
            }
            catch (Exception x) {
                LOGGER.warning("Error reading manifest");
            }
        }
        String currThemeProp = this.metametadata.getMapping().getTheme().get("current").getPropertyId();
        String globalPageProp = this.metametadata.getMapping().getPage().get("globalPageId").getPropertyId();
        for (Map.Entry c : componentsParameters.entrySet()) {
            Map<String, ComponentParameter> map = ((Component)c.getValue()).getParameters();
            ComponentParameter currentThemeCP = map.get(currThemeProp);
            ComponentParameter globalPageCP = map.get(globalPageProp);
            if (currentThemeCP != null) {
                appCtx.setCurrentTheme(currentThemeCP.getValue());
            }
            if (globalPageCP == null) continue;
            APEXLangIntegerDataType data = (APEXLangIntegerDataType)globalPageCP.getData();
            appCtx.setGlobalPage(data.getNumber().intValue());
        }
        if (appStateOnly) {
            return null;
        }
        componentsParameters = componentsParameters.entrySet().stream().filter(component -> !componentTypesToBeIgnored.contains(((Component)component.getValue()).getTypeId())).sorted(Map.Entry.comparingByValue(Comparator.comparing(Component::getInsertOrder))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        this.resolveReferences(componentsParameters, errors, currAppCtx);
        this.addDefaultValues(componentsParameters, componentsParameters);
        this.checkRequiredAttributes(componentsParameters, errors);
        return new APEXLangCompilationResult(Transpiler.transpile(componentsParameters, manifest), errors.toArray(new APEXLangSyntaxError[errors.size()]), componentsFromSource);
    }

    public APEXLangCompilationResult compile(Map<String, String> fileMap) {
        APEXLangCompilerContext appCtx = new APEXLangCompilerContext();
        return this.compile(fileMap, appCtx, false);
    }

    public APEXLangCompilationResult compile(InputStream zip) throws Exception {
        Map<String, String> fileMap = new FileLoader().getFilesFromZipInputStream(zip);
        return this.compile(fileMap);
    }

    public APEXLangCompilationResult compile(String source) {
        HashMap<String, String> fileMap = new HashMap<String, String>();
        fileMap.put("file.apx", source);
        return this.compile(fileMap);
    }

    public APEXLangCompilationResult compile(Map<String, String> fileMap, APEXLangCompilerContext appCtx) {
        return this.compile(fileMap, appCtx, false);
    }

    public APEXLangCompilerContext getCompilerContext(Map<String, String> fileMap) {
        APEXLangCompilerContext appCtx = new APEXLangCompilerContext();
        this.compile(fileMap, appCtx, true);
        return appCtx;
    }

    public List<String> getAvailableReferences(Property property, ComponentParameter componentParameter, APEXLangCompilerContext appCtx) {
        Map<String, Location> refLocations = this.getAvailableReferenceLocations(property, componentParameter, appCtx);
        ArrayList<String> ret = new ArrayList<String>(refLocations.keySet());
        ret.sort(Comparator.naturalOrder());
        return ret;
    }

    public Location getReferenceLocation(Property property, ComponentParameter componentParameter, APEXLangCompilerContext appCtx, String reference) {
        Map<String, Location> refLocations = this.getAvailableReferenceLocations(property, componentParameter, appCtx);
        return refLocations.get(reference);
    }

    static {
        LOV_TYPE_STATIC = "STATIC";
        LOV_TYPE_COMPONENT = "COMPONENT";
        LOV_TYPE_PLUGIN = "PLUGINS";
        APEX_VERSION = "apex_version";
        API_VERSION = "api_version";
        APP_ID = "app_id";
        DEFAULT_ID_OFFSET = "default_id_offset";
        DEFAULT_OWNER = "default_owner";
        WORKSPACE_ID = "workspace_id";
        MANIFEST_FILENAME = "config.json";
        APEX_EXTENSIONS = new String[]{".apx", ".apex"};
        MLT_REGEX = Pattern.compile("^```([a-zA-Z][a-zA-Z\\-]*)?(.*)```$", 40);
    }

    private class PropertyCandidate {
        private Property property;
        private ComponentType.ComponentProperty componentProperty;
        private Boolean pluginProperty;

        public PropertyCandidate(Property property, ComponentType.ComponentProperty componentProperty, Boolean pluginProperty) {
            this.property = property;
            this.componentProperty = componentProperty;
            this.pluginProperty = pluginProperty;
        }

        public Boolean isPluginProperty() {
            return this.pluginProperty;
        }

        public Property getProperty() {
            return this.property;
        }

        public ComponentType.ComponentProperty getComponentProperty() {
            return this.componentProperty;
        }
    }

    private static class ThemeDefinition {
        String refAppId;
        String themeId;

        private ThemeDefinition() {
        }
    }
}

