/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci.search;

import com.oracle.bmc.resourcesearch.model.ResourceSummary;
import oracle.dbtools.core.oci.search.ResourceType;

public final class SearchResult {
    private final String id;
    private final ResourceType resourceType;
    private final String displayName;

    private SearchResult(Builder builder) {
        this.id = builder.id;
        this.resourceType = builder.resourceType;
        this.displayName = builder.displayName;
    }

    static Builder builder() {
        return new Builder();
    }

    static Builder builder(ResourceSummary summary) {
        return new Builder().id(summary.getIdentifier()).resourceType(ResourceType.valueOf(summary.getResourceType())).displayName(summary.getDisplayName());
    }

    public String getResourceId() {
        return this.id;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    static class Builder {
        private String id;
        private ResourceType resourceType;
        private String displayName;

        Builder() {
        }

        Builder id(String id) {
            this.id = id;
            return this;
        }

        Builder resourceType(ResourceType resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        SearchResult build() {
            return new SearchResult(this);
        }
    }
}

