/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci.objectstorage;

import com.oracle.bmc.objectstorage.responses.PutObjectResponse;
import java.time.Instant;

public class ObjectPutResult {
    private final String etag;
    private final Instant lastModified;
    private final String objectName;
    private final String opcClientRequestId;
    private final int statusCode;
    private final String versionId;

    private ObjectPutResult(Builder builder) {
        this.etag = builder.etag;
        this.lastModified = builder.lastModified;
        this.objectName = builder.objectName;
        this.opcClientRequestId = builder.opcClientRequestId;
        this.statusCode = builder.statusCode;
        this.versionId = builder.versionId;
    }

    public String getETag() {
        return this.etag;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public Instant getLastModified() {
        return this.lastModified;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getVersionId() {
        return this.versionId;
    }

    static Builder builder() {
        return new Builder();
    }

    static Builder builder(PutObjectResponse response, String name) {
        return new Builder().eTag(response.getETag()).lastModified(response.getLastModified() != null ? response.getLastModified().toInstant() : null).objectName(name).opcClientRequestId(response.getOpcClientRequestId()).statusCode(response.get__httpStatusCode__()).versionId(response.getVersionId());
    }

    static class Builder {
        private String etag;
        private String objectName;
        private Instant lastModified;
        private String opcClientRequestId;
        private int statusCode;
        private String versionId;

        Builder() {
        }

        public ObjectPutResult build() {
            return new ObjectPutResult(this);
        }

        public Builder eTag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder objectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public Builder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }
    }
}

