/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci.objectstorage;

import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.objectstorage.ObjectStorageClient;
import com.oracle.bmc.objectstorage.ObjectStoragePaginators;
import com.oracle.bmc.objectstorage.model.ChecksumAlgorithm;
import com.oracle.bmc.objectstorage.model.ObjectSummary;
import com.oracle.bmc.objectstorage.model.StorageTier;
import com.oracle.bmc.objectstorage.requests.DeleteObjectRequest;
import com.oracle.bmc.objectstorage.requests.GetObjectRequest;
import com.oracle.bmc.objectstorage.requests.ListObjectsRequest;
import com.oracle.bmc.objectstorage.requests.PutObjectRequest;
import com.oracle.bmc.objectstorage.responses.DeleteObjectResponse;
import com.oracle.bmc.objectstorage.responses.GetObjectResponse;
import com.oracle.bmc.objectstorage.responses.ListObjectsResponse;
import com.oracle.bmc.objectstorage.responses.PutObjectResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.core.oci.AuthenticationProvider;
import oracle.dbtools.core.oci.Messages;
import oracle.dbtools.core.oci.OCIClient;
import oracle.dbtools.core.oci.OCIUtils;
import oracle.dbtools.core.oci.objectstorage.ObjectDeleteOptions;
import oracle.dbtools.core.oci.objectstorage.ObjectDeleteResult;
import oracle.dbtools.core.oci.objectstorage.ObjectGetOptions;
import oracle.dbtools.core.oci.objectstorage.ObjectGetResult;
import oracle.dbtools.core.oci.objectstorage.ObjectListOptions;
import oracle.dbtools.core.oci.objectstorage.ObjectPutOptions;
import oracle.dbtools.core.oci.objectstorage.ObjectPutResult;
import oracle.dbtools.core.oci.objectstorage.ObjectStorageUtils;
import oracle.dbtools.core.oci.objectstorage.ObjectSummaryResult;

public class OCIObjectStorageClient
extends OCIClient {
    private final ObjectStorageClient client;

    private OCIObjectStorageClient(Builder builder) {
        super(builder);
        ObjectStorageClient.Builder objStorageBuilder = ObjectStorageClient.builder();
        this.configureClient(objStorageBuilder);
        this.client = objStorageBuilder.build(this.getAuthenticationProvider().getAuthenticationProvider());
    }

    public ObjectDeleteResult deleteObject(ObjectDeleteOptions param) {
        DeleteObjectRequest.Builder deleteBuilder = DeleteObjectRequest.builder();
        deleteBuilder.namespaceName(param.getNamespace()).bucketName(param.getBucketName()).objectName(param.getObjectName());
        deleteBuilder.ifMatch(param.getETag()).opcClientRequestId(param.getOpcClientRequestId()).versionId(param.getVersionId());
        try {
            DeleteObjectRequest request = deleteBuilder.build();
            DeleteObjectResponse response = this.client.deleteObject(request);
            ObjectDeleteResult result = ObjectDeleteResult.builder(response, param.getNamespace(), param.getBucketName(), param.getObjectName()).build();
            return result;
        }
        catch (BmcException be) {
            String clientMsg = Messages.format("OBJECTSTORAGE_ERROR_DELETE_OBJECT", param.getObjectName(), param.getBucketName());
            ObjectStorageUtils.rethrowException(be.getCause(), be.getUnmodifiedMessage(), clientMsg);
            return null;
        }
    }

    public ObjectGetResult getObject(ObjectGetOptions param) {
        GetObjectRequest.Builder getBuilder = GetObjectRequest.builder();
        getBuilder.namespaceName(param.getNamespace()).bucketName(param.getBucketName()).objectName(param.getObjectName());
        getBuilder.httpResponseCacheControl(param.getOverrideCacheControl()).httpResponseContentDisposition(param.getOverrideContentDisposition()).httpResponseContentEncoding(param.getOverrideContentEncoding()).httpResponseContentLanguage(param.getOverrideContentLanguage()).httpResponseContentType(param.getOverrideContentType()).ifMatch(param.getETag()).ifNoneMatch(param.getAvoidEtag()).opcClientRequestId(param.getOpcClientRequestId());
        try {
            GetObjectRequest request = getBuilder.build();
            GetObjectResponse response = this.client.getObject(request);
            ObjectGetResult result = ObjectGetResult.builder(response, param.getNamespace(), param.getBucketName(), param.getObjectName(), param.getFilePath(), param.storeInMemory()).build();
            return result;
        }
        catch (BmcException be) {
            String clientMsg = Messages.format("OBJECTSTORAGE_ERROR_GET_OBJECT", param.getObjectName(), param.getBucketName(), param.getFilePath());
            ObjectStorageUtils.rethrowException(be.getCause(), be.getUnmodifiedMessage(), clientMsg);
            return null;
        }
    }

    public List<ObjectSummaryResult> listObjects(ObjectListOptions param) {
        ListObjectsRequest.Builder listBuilder = ListObjectsRequest.builder();
        listBuilder.namespaceName(param.getNamespace()).bucketName(param.getBucketName());
        listBuilder.prefix(param.getPrefix()).start(param.getStart()).end(param.getEnd()).opcClientRequestId(param.getOpcClientRequestId());
        if (param.getFields() != null) {
            String fields = param.getFields().replace(" ", "");
            listBuilder.fields(fields);
        }
        if (param.getLimit() != null && param.getLimit() >= 1) {
            listBuilder.limit(param.getLimit());
        }
        HashMap objSummaryStatus = new HashMap();
        ListObjectsRequest request = listBuilder.build();
        try {
            if (param.allObjects()) {
                ObjectStoragePaginators paginators = this.client.getPaginators();
                Iterable listObjsResponseIt = paginators.listObjectsResponseIterator(request);
                listObjsResponseIt.forEach(listObjsResponse -> {
                    List objSummaries = listObjsResponse.getListObjects().getObjects();
                    int statusCode = listObjsResponse.get__httpStatusCode__();
                    objSummaries.forEach(objSummary -> objSummaryStatus.put(objSummary, statusCode));
                });
            } else {
                ListObjectsResponse response = this.client.listObjects(request);
                int statusCode = response.get__httpStatusCode__();
                List objSummaries = response.getListObjects().getObjects();
                objSummaries.forEach(objSummary -> objSummaryStatus.put(objSummary, statusCode));
            }
        }
        catch (BmcException be) {
            String clientMsg = Messages.format("OBJECTSTORAGE_ERROR_LIST_OBJECT", param.getBucketName());
            ObjectStorageUtils.rethrowException(be.getCause(), be.getUnmodifiedMessage(), clientMsg);
            return null;
        }
        ArrayList<ObjectSummaryResult> results = new ArrayList<ObjectSummaryResult>();
        objSummaryStatus.entrySet().forEach(entry -> results.add(ObjectSummaryResult.builder((ObjectSummary)entry.getKey()).statusCode((Integer)entry.getValue()).build()));
        results.sort((o1, o2) -> o1.getObjecttName().toLowerCase().compareTo(o2.getObjecttName().toLowerCase()));
        return results;
    }

    public ObjectPutResult putObject(ObjectPutOptions param) {
        PutObjectRequest.Builder putBuilder = PutObjectRequest.builder();
        putBuilder.namespaceName(param.getNamespace()).bucketName(param.getBucketName()).objectName(param.getObjectName()).contentLength(param.getContentLength()).putObjectBody(param.getInputStream());
        putBuilder.cacheControl(param.getCacheControl()).contentDisposition(param.getContentDisposition()).contentEncoding(param.getContentEncoding()).contentLanguage(param.getContentLanguage()).contentMD5(param.getContentMD5()).contentType(param.getContentType()).ifMatch(param.getETag()).opcClientRequestId(param.getOpcClientRequestId());
        String noOverwrite = param.noOverwrite() ? "*" : null;
        putBuilder.ifNoneMatch(noOverwrite);
        StorageTier storage = param.getStorageTier() != null ? StorageTier.create((String)param.getStorageTier()) : null;
        putBuilder.storageTier(storage);
        ChecksumAlgorithm checksumAlgorithm = param.getChecksumAlgorithm() != null ? ChecksumAlgorithm.create((String)param.getChecksumAlgorithm()) : null;
        String checksumContent = param.getChecksumContent();
        if (checksumAlgorithm != null && !OCIUtils.isEmpty(checksumContent)) {
            putBuilder.opcChecksumAlgorithm(checksumAlgorithm);
            switch (checksumAlgorithm) {
                case Crc32C: {
                    putBuilder.opcContentCrc32c(checksumContent);
                    break;
                }
                case Sha256: {
                    putBuilder.opcContentSha256(checksumContent);
                    break;
                }
                case Sha384: {
                    putBuilder.opcContentSha384(checksumContent);
                }
            }
        }
        PutObjectRequest request = putBuilder.build();
        try {
            PutObjectResponse response = this.client.putObject(request);
            ObjectPutResult result = ObjectPutResult.builder(response, param.getObjectName()).build();
            return result;
        }
        catch (BmcException be) {
            String clientMsg = Messages.format("OBJECTSTORAGE_ERROR_PUT_OBJECT", param.getObjectName(), param.getBucketName());
            ObjectStorageUtils.rethrowException(be.getCause(), be.getUnmodifiedMessage(), clientMsg);
            return null;
        }
    }

    public static Builder builder(AuthenticationProvider provider) {
        return new Builder(provider);
    }

    public static final class Builder
    extends OCIClient.Builder<Builder, OCIObjectStorageClient> {
        private Builder(AuthenticationProvider provider) {
            super(provider);
        }

        @Override
        public OCIObjectStorageClient build() {
            return new OCIObjectStorageClient(this);
        }
    }
}

