/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.cpat.common;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.cpat.commands.MigrateAdvisorOptions;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class CpatOptionValues {
    private ParsedCommand _parsedCommand;
    private HashMap<Id, List<String>> _commandOptionsStringList = new HashMap(Map.of());
    private HashMap<Id, String> _commandOptionsString = new HashMap(Map.of());
    private HashMap<Id, Boolean> _commandOptionsBoolean = new HashMap(Map.of());

    public CpatOptionValues(ParsedCommand parsedCommand) {
        this._parsedCommand = parsedCommand;
        if (this.optionHasNonNullValue(MigrateAdvisorOptions.Symbol.MIGRATIONMETHOD)) {
            this._commandOptionsStringList.put(MigrateAdvisorOptions.Symbol.MIGRATIONMETHOD, this.getOptionValueStringList(MigrateAdvisorOptions.Symbol.MIGRATIONMETHOD));
        }
        if (this.optionHasNonNullValue(MigrateAdvisorOptions.Symbol.REPORTFORMAT)) {
            this._commandOptionsStringList.put(MigrateAdvisorOptions.Symbol.REPORTFORMAT, this.getOptionValueStringList(MigrateAdvisorOptions.Symbol.REPORTFORMAT));
        }
        if (this.optionHasNonNullValue(MigrateAdvisorOptions.Symbol.SCHEMAS)) {
            this._commandOptionsStringList.put(MigrateAdvisorOptions.Symbol.SCHEMAS, this.getOptionValueStringList(MigrateAdvisorOptions.Symbol.SCHEMAS));
        }
        if (this.optionHasNonNullValue(MigrateAdvisorOptions.Symbol.EXCLUDESCHEMAS)) {
            this._commandOptionsStringList.put(MigrateAdvisorOptions.Symbol.EXCLUDESCHEMAS, this.getOptionValueStringList(MigrateAdvisorOptions.Symbol.EXCLUDESCHEMAS));
        }
        if (this.optionHasNonNullValue(MigrateAdvisorOptions.Symbol.TARGETTYPE)) {
            this._commandOptionsString.put(MigrateAdvisorOptions.Symbol.TARGETTYPE, this.getOptionValueString(MigrateAdvisorOptions.Symbol.TARGETTYPE));
        }
        if (this.optionHasNonNullValue(MigrateAdvisorOptions.Symbol.ANALYSISPROPS)) {
            this._commandOptionsString.put(MigrateAdvisorOptions.Symbol.ANALYSISPROPS, this.getOptionValueString(MigrateAdvisorOptions.Symbol.ANALYSISPROPS));
        }
        if (this.optionHasNonNullValue(MigrateAdvisorOptions.Symbol.MAXRELEVANTOBJECTS)) {
            this._commandOptionsString.put(MigrateAdvisorOptions.Symbol.MAXRELEVANTOBJECTS, this.getOptionValueString(MigrateAdvisorOptions.Symbol.MAXRELEVANTOBJECTS));
        }
        if (this.optionHasNonNullValue(MigrateAdvisorOptions.Symbol.MAXTEXTDATAROWS)) {
            this._commandOptionsString.put(MigrateAdvisorOptions.Symbol.MAXTEXTDATAROWS, this.getOptionValueString(MigrateAdvisorOptions.Symbol.MAXTEXTDATAROWS));
        }
        if (this.optionHasNonNullValue(MigrateAdvisorOptions.Symbol.OUTDIR)) {
            this._commandOptionsString.put(MigrateAdvisorOptions.Symbol.OUTDIR, this.getOptionValueString(MigrateAdvisorOptions.Symbol.OUTDIR));
        }
        if (this.optionHasNonNullValue(MigrateAdvisorOptions.Symbol.OUTFILEPREFIX)) {
            this._commandOptionsString.put(MigrateAdvisorOptions.Symbol.OUTFILEPREFIX, this.getOptionValueString(MigrateAdvisorOptions.Symbol.OUTFILEPREFIX));
        }
        if (this.optionHasNonNullValue(MigrateAdvisorOptions.Symbol.FULL)) {
            this._commandOptionsBoolean.put(MigrateAdvisorOptions.Symbol.FULL, this.getOptionValueBoolean(MigrateAdvisorOptions.Symbol.FULL));
        }
        if (this.optionHasNonNullValue(MigrateAdvisorOptions.Symbol.SQLTEXT)) {
            this._commandOptionsBoolean.put(MigrateAdvisorOptions.Symbol.SQLTEXT, this.getOptionValueBoolean(MigrateAdvisorOptions.Symbol.SQLTEXT));
        }
        if (this.optionHasNonNullValue(MigrateAdvisorOptions.Symbol.VERBOSE)) {
            this._commandOptionsBoolean.put(MigrateAdvisorOptions.Symbol.VERBOSE, this.getOptionValueBoolean(MigrateAdvisorOptions.Symbol.VERBOSE));
        }
    }

    private List<String> getOptionValueStringList(Id optionId) {
        return (List)this._parsedCommand.getOptionValue(optionId);
    }

    public List<String> getOptionStringList(Id optionId) {
        return this._commandOptionsStringList.get(optionId);
    }

    public void setOptionStringList(Id optionId, List<String> value) {
        this._commandOptionsStringList.put(optionId, value);
    }

    private boolean optionHasNonNullValue(Id optionId) {
        try {
            return this.getOption(optionId) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private <T> T getOption(Id optionId) {
        return (T)this._parsedCommand.getOptionValue(optionId);
    }

    private String getOptionValueString(Id optionId) {
        return (String)this._parsedCommand.getOptionValue(optionId);
    }

    public String getOptionString(Id optionId) {
        return this._commandOptionsString.get(optionId);
    }

    public void setOptionString(Id optionId, String value) {
        this._commandOptionsString.put(optionId, value);
    }

    public Integer getOptionInteger(Id optionId) {
        String value = this._commandOptionsString.get(optionId);
        if (value == null) {
            return null;
        }
        return Integer.parseInt(value);
    }

    public void setOptionInteger(Id optionId, Integer value) {
        this._commandOptionsString.put(optionId, value.toString());
    }

    private Boolean getOptionValueBoolean(Id optionId) {
        return (Boolean)this._parsedCommand.getOptionValue(optionId);
    }

    public Boolean getOptionBoolean(Id optionId) {
        Boolean value = this._commandOptionsBoolean.get(optionId);
        if (value != null) {
            return value;
        }
        return false;
    }

    public void setOptionBoolean(Id optionId, Boolean value) {
        this._commandOptionsBoolean.put(optionId, value);
    }
}

