/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.parser;

import jakarta.json.JsonException;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import oracle.json.common.JsonFactoryProvider;
import oracle.json.parser.PathParser;
import oracle.json.parser.QueryException;
import oracle.json.parser.QueryMessage;
import oracle.json.util.ByteArray;

public class ProjectionSpec {
    private final InputStream source;
    private final JsonParserFactory factory;
    private boolean is_parsed = false;
    private boolean is_checked_for_array_steps = false;
    private boolean is_checked_for_paths_overlap = false;
    private boolean is_validated = false;
    private String rendition = null;
    private boolean includeSeen = false;
    private boolean excludeSeen = false;
    private boolean badValueSeen = false;
    private boolean arrayStepSeen = false;
    private boolean overlappingPathsSeen = false;
    private ArrayList<String[]> paths = new ArrayList();

    public ProjectionSpec(JsonFactoryProvider jsonFactoryProvider, InputStream inputStream) {
        this.factory = jsonFactoryProvider.getParserFactory();
        this.source = inputStream;
    }

    private void makeException(QueryMessage queryMessage, Object ... objectArray) throws QueryException {
        QueryException.throwSyntaxException(queryMessage, objectArray);
    }

    private void close() throws QueryException {
        try {
            this.source.close();
        }
        catch (IOException iOException) {
            throw new QueryException(QueryMessage.EX_INVALID_PROJECTION.get(new Object[0]), iOException);
        }
    }

    public String getAsString() throws QueryException {
        if (this.rendition == null) {
            try {
                ByteArray byteArray = ByteArray.loadStream(this.source);
                this.rendition = byteArray.getString();
            }
            catch (IOException iOException) {
                throw new QueryException(QueryMessage.EX_INVALID_PROJECTION.get(new Object[0]), iOException);
            }
        }
        return this.rendition;
    }

    public boolean hasIncludeRules() {
        return this.includeSeen;
    }

    public boolean hasExcludeRules() {
        return this.excludeSeen;
    }

    public boolean hasArraySteps() {
        if (this.is_checked_for_array_steps) {
            return this.arrayStepSeen;
        }
        for (String[] stringArray : this.paths) {
            this.arrayStepSeen = this.hasArrayStep(stringArray);
            if (!this.arrayStepSeen) continue;
            this.is_checked_for_array_steps = true;
            return this.arrayStepSeen;
        }
        this.is_checked_for_array_steps = true;
        return this.arrayStepSeen;
    }

    public boolean hasOverlappingPaths() {
        int n = this.paths.size();
        if (this.is_checked_for_paths_overlap) {
            return this.overlappingPathsSeen;
        }
        for (int i = 0; i < n; ++i) {
            String[] stringArray = this.paths.get(i);
            for (int j = i + 1; j < n; ++j) {
                if (!ProjectionSpec.isPrefix(stringArray, this.paths.get(j))) continue;
                this.overlappingPathsSeen = true;
                break;
            }
            if (this.overlappingPathsSeen) break;
        }
        this.is_checked_for_paths_overlap = true;
        return this.overlappingPathsSeen;
    }

    private static boolean isPrefix(String[] stringArray, String[] stringArray2) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = n = stringArray.length <= stringArray2.length ? stringArray.length : stringArray2.length;
        while (n2 < stringArray.length && n3 < stringArray2.length) {
            if (stringArray[n2].startsWith("[") && stringArray2[n3].startsWith("[")) {
                if (!stringArray[n2].equals(stringArray2[n3])) {
                    return false;
                }
                ++n2;
                ++n3;
                continue;
            }
            if (stringArray[n2].startsWith("[")) {
                ++n2;
                continue;
            }
            if (stringArray2[n3].startsWith("[")) {
                ++n3;
                continue;
            }
            if (!(stringArray[n2].equals(stringArray2[n3]) || stringArray[n2].equals("*") || stringArray2[n3].equals("*"))) {
                return false;
            }
            ++n2;
            ++n3;
        }
        return true;
    }

    private boolean hasArrayStep(String[] stringArray) {
        for (String string : stringArray) {
            if (!string.startsWith("[")) continue;
            return true;
        }
        return false;
    }

    public boolean validate(boolean bl) throws QueryException {
        StringReader stringReader = null;
        JsonParser jsonParser = null;
        if (this.is_validated) {
            return !this.badValueSeen;
        }
        String string = this.getAsString();
        QueryException queryException = null;
        this.badValueSeen = false;
        this.excludeSeen = false;
        this.includeSeen = false;
        this.paths.clear();
        try {
            int n = 0;
            stringReader = new StringReader(string);
            jsonParser = this.factory.createParser((Reader)stringReader);
            block22: while (jsonParser.hasNext()) {
                JsonParser.Event event = jsonParser.next();
                switch (event) {
                    case START_OBJECT: {
                        if (n > 0) {
                            throw new QueryException(QueryMessage.EX_INVALID_PROJECTION.get(new Object[0]));
                        }
                        ++n;
                        continue block22;
                    }
                    case END_OBJECT: {
                        --n;
                        continue block22;
                    }
                    case START_ARRAY: 
                    case END_ARRAY: {
                        throw new QueryException(QueryMessage.EX_INVALID_PROJECTION.get(new Object[0]));
                    }
                    case KEY_NAME: {
                        String string2 = jsonParser.getString();
                        if (!bl) continue block22;
                        Object object = new PathParser(string2);
                        String[] stringArray = ((PathParser)object).splitAndSQLEscape();
                        if (stringArray == null) {
                            this.makeException(QueryMessage.EX_INDEX_ILLEGAL_PATH, string2);
                        }
                        this.paths.add(stringArray);
                        continue block22;
                    }
                    case VALUE_TRUE: {
                        this.includeSeen = true;
                        continue block22;
                    }
                    case VALUE_FALSE: {
                        this.excludeSeen = true;
                        continue block22;
                    }
                    case VALUE_NUMBER: {
                        Object object = jsonParser.getBigDecimal();
                        if (((BigDecimal)object).compareTo(BigDecimal.ZERO) == 0) {
                            this.excludeSeen = true;
                            continue block22;
                        }
                        if (((BigDecimal)object).compareTo(BigDecimal.ONE) == 0) {
                            this.includeSeen = true;
                            continue block22;
                        }
                        this.badValueSeen = true;
                        continue block22;
                    }
                    case VALUE_STRING: {
                        String[] stringArray = jsonParser.getString();
                        if (stringArray.equals("include")) {
                            this.includeSeen = true;
                            continue block22;
                        }
                        if (stringArray.equals("exclude")) {
                            this.excludeSeen = true;
                            continue block22;
                        }
                        this.badValueSeen = true;
                        continue block22;
                    }
                }
                this.badValueSeen = true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new QueryException(QueryMessage.EX_INVALID_PROJECTION.get(new Object[0]), illegalArgumentException);
        }
        catch (JsonException jsonException) {
            throw new QueryException(QueryMessage.EX_INVALID_PROJECTION.get(new Object[0]), (Exception)((Object)jsonException));
        }
        finally {
            try {
                if (jsonParser != null) {
                    jsonParser.close();
                }
                if (stringReader != null) {
                    stringReader.close();
                }
                this.close();
            }
            catch (JsonException jsonException) {
                queryException = new QueryException(QueryMessage.EX_INVALID_PROJECTION.get(new Object[0]), (Exception)((Object)jsonException));
            }
            catch (QueryException queryException2) {
                queryException = queryException2;
            }
        }
        if (queryException != null) {
            throw queryException;
        }
        this.is_validated = true;
        return !this.badValueSeen;
    }
}

