/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.parser;

import jakarta.json.JsonException;
import jakarta.json.stream.JsonGenerationException;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParsingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import oracle.json.common.JsonFactoryProvider;
import oracle.json.parser.Evaluator;
import oracle.json.parser.QueryException;
import oracle.json.parser.QueryMessage;

public class FindSpecification {
    private boolean is_filter = true;
    private boolean need_12_2 = false;
    private String projection = null;
    private String jsonpatch = null;
    private String jsonmerge = null;
    private HashSet<String> idList = null;

    public FindSpecification(InputStream inputStream, JsonFactoryProvider jsonFactoryProvider) throws QueryException {
        this.parse(inputStream, jsonFactoryProvider);
    }

    private void makeException(QueryMessage queryMessage, Object ... objectArray) throws QueryException {
        QueryException.throwSyntaxException(queryMessage, objectArray);
    }

    private void findKeys(JsonParser jsonParser) throws QueryException, JsonParsingException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        boolean bl = false;
        while (jsonParser.hasNext()) {
            if (bl) {
                this.makeException(QueryMessage.EX_EXTRA_INPUT, new Object[0]);
            }
            JsonParser.Event event = jsonParser.next();
            switch (event) {
                case VALUE_STRING: {
                    String string2 = jsonParser.getString();
                    arrayList.add(string2);
                    break;
                }
                case VALUE_NUMBER: {
                    BigDecimal bigDecimal = jsonParser.getBigDecimal();
                    arrayList.add(bigDecimal.toString());
                    break;
                }
                case END_ARRAY: {
                    bl = true;
                    break;
                }
                case START_ARRAY: {
                    string = "array";
                    break;
                }
                case START_OBJECT: {
                    string = "array";
                    break;
                }
                case VALUE_TRUE: {
                    string = "true";
                    break;
                }
                case VALUE_FALSE: {
                    string = "false";
                    break;
                }
                case VALUE_NULL: {
                    string = "null";
                    break;
                }
                default: {
                    string = event.toString();
                }
            }
            if (string == null) continue;
            this.makeException(QueryMessage.EX_INVALID_ARRAY_KEY, string);
        }
        this.idList = new HashSet(arrayList.size());
        for (String string2 : arrayList) {
            this.idList.add(string2);
        }
    }

    private void splitDocuments(JsonParser jsonParser, JsonFactoryProvider jsonFactoryProvider) throws QueryException, JsonParsingException, JsonGenerationException {
        String string = null;
        StringWriter stringWriter = null;
        JsonGenerator jsonGenerator = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        while (jsonParser.hasNext()) {
            JsonParser.Event event = jsonParser.next();
            if (event == JsonParser.Event.KEY_NAME) {
                string = jsonParser.getString();
                if (Evaluator.requires_12_2(string)) {
                    this.need_12_2 = true;
                }
                if (n != 0) continue;
                if (string.equals("$project")) {
                    stringWriter = new StringWriter();
                    jsonGenerator = jsonFactoryProvider.createGenerator(stringWriter);
                    bl = true;
                    if (this.jsonpatch != null || this.jsonmerge != null) {
                        this.makeException(QueryMessage.EX_INVALID_PROJECTION, new Object[0]);
                    }
                    string = null;
                    continue;
                }
                if (string.equals("$patch")) {
                    stringWriter = new StringWriter();
                    jsonGenerator = jsonFactoryProvider.createGenerator(stringWriter);
                    bl2 = true;
                    if (this.jsonmerge != null) {
                        this.makeException(QueryMessage.EX_INVALID_PATCH, new Object[0]);
                    }
                    if (this.projection != null) {
                        this.makeException(QueryMessage.EX_INVALID_PROJECTION, new Object[0]);
                    }
                    string = null;
                    continue;
                }
                if (!string.equals("$merge")) continue;
                stringWriter = new StringWriter();
                jsonGenerator = jsonFactoryProvider.createGenerator(stringWriter);
                bl3 = true;
                if (this.jsonpatch != null) {
                    this.makeException(QueryMessage.EX_INVALID_PATCH, new Object[0]);
                }
                if (this.projection != null) {
                    this.makeException(QueryMessage.EX_INVALID_PROJECTION, new Object[0]);
                }
                string = null;
                continue;
            }
            if (jsonGenerator == null) {
                if (event == JsonParser.Event.START_ARRAY || event == JsonParser.Event.START_OBJECT) {
                    ++n;
                } else if (event == JsonParser.Event.END_ARRAY || event == JsonParser.Event.END_OBJECT) {
                    --n;
                }
                string = null;
                continue;
            }
            if (event == JsonParser.Event.START_OBJECT) {
                if (bl2 && n == 0) {
                    this.makeException(QueryMessage.EX_INVALID_PATCH, new Object[0]);
                }
                if (string == null || n == 0) {
                    jsonGenerator.writeStartObject();
                } else {
                    jsonGenerator.writeStartObject(string);
                }
                ++n;
                string = null;
                continue;
            }
            if (event == JsonParser.Event.START_ARRAY) {
                if (bl && n == 0) {
                    this.makeException(QueryMessage.EX_INVALID_PROJECTION, new Object[0]);
                }
                if (string == null) {
                    jsonGenerator.writeStartArray();
                } else {
                    jsonGenerator.writeStartArray(string);
                }
                ++n;
                string = null;
                continue;
            }
            if (n == 0) {
                if (bl) {
                    this.makeException(QueryMessage.EX_INVALID_PROJECTION, new Object[0]);
                } else if (bl2 || bl3) {
                    this.makeException(QueryMessage.EX_INVALID_PATCH, new Object[0]);
                }
            }
            if (event == JsonParser.Event.VALUE_STRING) {
                if (string != null) {
                    jsonGenerator.write(string, jsonParser.getString());
                } else {
                    jsonGenerator.write(jsonParser.getString());
                }
            } else if (event == JsonParser.Event.VALUE_NUMBER) {
                BigDecimal bigDecimal = jsonParser.getBigDecimal();
                if (bigDecimal.stripTrailingZeros().scale() <= 0) {
                    if (string != null) {
                        jsonGenerator.write(string, bigDecimal.toBigInteger());
                    } else {
                        jsonGenerator.write(bigDecimal.toBigInteger());
                    }
                } else if (string != null) {
                    jsonGenerator.write(string, bigDecimal);
                } else {
                    jsonGenerator.write(bigDecimal);
                }
            } else if (event == JsonParser.Event.VALUE_TRUE) {
                if (string != null) {
                    jsonGenerator.write(string, true);
                } else {
                    jsonGenerator.write(true);
                }
            } else if (event == JsonParser.Event.VALUE_FALSE) {
                if (string != null) {
                    jsonGenerator.write(string, false);
                } else {
                    jsonGenerator.write(false);
                }
            } else if (event == JsonParser.Event.VALUE_NULL) {
                if (string != null) {
                    jsonGenerator.writeNull(string);
                } else {
                    jsonGenerator.writeNull();
                }
            } else if (event == JsonParser.Event.END_OBJECT) {
                --n;
                jsonGenerator.writeEnd();
            } else if (event == JsonParser.Event.END_ARRAY) {
                --n;
                jsonGenerator.writeEnd();
            }
            string = null;
            if (n != 0) continue;
            jsonGenerator.flush();
            jsonGenerator.close();
            if (stringWriter != null) {
                if (bl) {
                    this.projection = stringWriter.toString();
                } else if (bl2) {
                    this.jsonpatch = stringWriter.toString();
                } else if (bl3) {
                    this.jsonmerge = stringWriter.toString();
                }
                bl3 = false;
                bl2 = false;
                bl = false;
            }
            stringWriter = null;
            jsonGenerator = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(InputStream inputStream, JsonFactoryProvider jsonFactoryProvider) throws QueryException {
        JsonParser jsonParser = null;
        boolean bl = true;
        QueryException queryException = null;
        if (inputStream == null) {
            this.makeException(QueryMessage.EX_SYNTAX_ERROR, new Object[0]);
        } else {
            try {
                jsonParser = jsonFactoryProvider.createParser(inputStream);
                JsonParser.Event event = jsonParser.next();
                if (event == JsonParser.Event.START_OBJECT) {
                    this.splitDocuments(jsonParser, jsonFactoryProvider);
                } else if (event == JsonParser.Event.START_ARRAY) {
                    this.findKeys(jsonParser);
                    this.is_filter = false;
                } else {
                    this.makeException(QueryMessage.EX_SYNTAX_ERROR, new Object[0]);
                }
                bl = false;
            }
            catch (JsonException jsonException) {
                queryException = new QueryException(QueryMessage.EX_SYNTAX_ERROR.get(new Object[0]), (Exception)((Object)jsonException));
            }
            finally {
                block19: {
                    try {
                        jsonParser.close();
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        if (bl) break block19;
                        queryException = new QueryException(QueryMessage.EX_SYNTAX_ERROR.get(new Object[0]), iOException);
                    }
                }
            }
        }
        if (queryException != null) {
            throw queryException;
        }
    }

    public boolean isFilter() {
        return this.is_filter;
    }

    public boolean requires_12_2() {
        return this.need_12_2;
    }

    public HashSet<String> getKeys() {
        return this.idList;
    }

    public String getProjection() {
        return this.projection;
    }

    public String getPatch() {
        return this.jsonpatch;
    }

    public String getMerge() {
        return this.jsonmerge;
    }
}

