/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.model;

import com.oracle.bmc.ClientRuntime;
import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.http.internal.HttpDateUtils;
import com.oracle.bmc.model.SdkRuntimeException;
import com.oracle.bmc.util.internal.StringUtils;
import java.util.Date;
import java.util.Map;

public class BmcException
extends SdkRuntimeException {
    public static final String OPC_REQUEST_ID_HEADER = "opc-request-id";
    private final int statusCode;
    private final String serviceCode;
    private final boolean timeout;
    private final String opcRequestId;
    private final boolean isClientSide;
    private final String originalMessage;
    private final String originalMessageTemplate;
    private final Map<String, String> messageArguments;
    private final ServiceDetails serviceDetails;

    public BmcException(int statusCode, String serviceCode, String message, String opcRequestId, Throwable cause) {
        this(message, cause, statusCode, serviceCode, false, opcRequestId, false, null);
    }

    public BmcException(int statusCode, String serviceCode, String message, String opcRequestId, Throwable cause, ServiceDetails serviceDetails) {
        this(message, cause, statusCode, serviceCode, false, opcRequestId, false, serviceDetails);
    }

    public BmcException(int statusCode, String serviceCode, String message, String opcRequestId) {
        this(message, null, statusCode, serviceCode, false, opcRequestId, false, null);
    }

    public BmcException(int statusCode, String serviceCode, String message, String opcRequestId, ServiceDetails serviceDetails) {
        this(message, null, statusCode, serviceCode, false, opcRequestId, false, serviceDetails);
    }

    public BmcException(int statusCode, String serviceCode, String message, String opcRequestId, ServiceDetails serviceDetails, String originalMessage, String originalMessageTemplate, Map<String, String> messageArguments) {
        this(message, null, statusCode, serviceCode, false, opcRequestId, false, serviceDetails, originalMessage, originalMessageTemplate, messageArguments);
    }

    public BmcException(boolean timeout, String message, Throwable cause, String opcRequestId) {
        this(message, cause, -1, null, timeout, opcRequestId, true, null);
    }

    private BmcException(String message, Throwable cause, int statusCode, String serviceCode, boolean timeout, String opcRequestId, boolean isClientSide, ServiceDetails serviceDetails) {
        this(message, cause, statusCode, serviceCode, timeout, opcRequestId, isClientSide, serviceDetails, null, null, null);
    }

    public BmcException(String message, Throwable cause, int statusCode, String serviceCode, boolean timeout, String opcRequestId, boolean isClientSide, ServiceDetails serviceDetails, String originalMessage, String originalMessageTemplate, Map<String, String> messageArguments) {
        super(message, cause);
        this.statusCode = statusCode;
        this.serviceCode = serviceCode;
        this.opcRequestId = opcRequestId;
        this.timeout = timeout;
        this.isClientSide = isClientSide;
        this.serviceDetails = serviceDetails;
        this.originalMessage = originalMessage;
        this.originalMessageTemplate = originalMessageTemplate;
        this.messageArguments = messageArguments;
    }

    public static BmcException createClientSide(String message, Throwable cause, String opcRequestId, ServiceDetails serviceDetails) {
        return new BmcException(message, cause, -1, null, false, opcRequestId, true, serviceDetails);
    }

    @Override
    public String getMessage() {
        String requestId;
        String string = this.opcRequestId != null ? " (" + (this.isClientSide ? "outbound " : "") + "opc-request-id: " + this.opcRequestId + ")" : (requestId = "");
        if (null != this.serviceDetails) {
            String targetService = this.serviceDetails.getServiceName();
            String timestamp = HttpDateUtils.formatAlwaysIncludeMillis(new Date());
            String clientVersion = ClientRuntime.getRuntime().getClientInfo();
            String errorTroubleshootingLink = String.format("https://docs.oracle.com/en-us/iaas/Content/API/References/apierrors.htm#apierrors_%s__%s_%s", this.statusCode, this.statusCode, StringUtils.isNotBlank(this.serviceCode) ? this.serviceCode.toLowerCase() : "");
            return String.format("Error returned by %s operation in %s service.(%s, %s, %s) %s%s\nTimestamp: %s\nClient version: %s\nRequest Endpoint: %s\nTroubleshooting Tips: See %s for more information about resolving this error\nAlso see %s for details on this operation's requirements.\nTo get more info on the failing request, you can enable debug level logs as mentioned in `Using SLF4J for Logging section` in https://docs.oracle.com/en-us/iaas/Content/API/SDKDocs/javasdkconfig.htm.\nIf you are unable to resolve this %s issue, please contact Oracle support and provide them this full error message.", this.serviceDetails.getOperationName(), targetService, this.statusCode, this.serviceCode, this.timeout, super.getMessage(), requestId, timestamp, clientVersion, this.serviceDetails.getRequestEndpoint(), errorTroubleshootingLink, this.serviceDetails.getApiReferenceLink(), targetService);
        }
        return String.format("(%s, %s, %s) %s%s", this.statusCode, this.serviceCode, this.timeout, super.getMessage(), requestId);
    }

    public String getUnmodifiedMessage() {
        return super.getMessage();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getServiceCode() {
        return this.serviceCode;
    }

    public boolean isTimeout() {
        return this.timeout;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public boolean isClientSide() {
        return this.isClientSide;
    }

    public ServiceDetails getServiceDetails() {
        return this.serviceDetails;
    }

    public String getOriginalMessage() {
        return this.originalMessage;
    }

    public String getOriginalMessageTemplate() {
        return this.originalMessageTemplate;
    }

    public Map<String, String> getMessageArguments() {
        return this.messageArguments;
    }
}

