/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.circuitbreaker.CallNotAllowedException;
import com.oracle.bmc.circuitbreaker.OciCircuitBreaker;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.HttpClient;
import com.oracle.bmc.http.client.HttpRequest;
import com.oracle.bmc.http.client.HttpResponse;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.client.Serializer;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.internal.HttpDateUtils;
import com.oracle.bmc.http.internal.ParamEncoder;
import com.oracle.bmc.http.internal.ResponseErrorBmcExceptionFactory;
import com.oracle.bmc.http.internal.ResponseErrorRuntimeExceptionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.SyncFutureWaiter;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.model.Range;
import com.oracle.bmc.model.SdkRuntimeException;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.requests.HasContentLength;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.responses.BmcResponse;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.StringUtils;
import com.oracle.bmc.waiter.MaxAttemptsTerminationStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.WaiterScheduler;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;

public final class ClientCall<REQ extends BmcRequest<?>, RESP extends BmcResponse, RESP_BUILDER extends BmcResponse.Builder<RESP>> {
    private static final String OPC_CLIENT_RETRIES_HEADER = "opc-client-retries";
    private static final String OPC_REQUEST_ID_HEADER = "opc-request-id";
    private static final String EVENT_STREAM_MEDIA_TYPE = "text/event-stream";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String APPLICATION_OCTET_STREAM_TYPE = "application/octet-stream";
    private static final String APPLICATION_JSON_TYPE = "application/json";
    private final HttpClient httpClient;
    private ClientConfigurator clientConfigurator;
    private OciCircuitBreaker circuitBreaker;
    private HttpRequest httpRequest;
    private REQ request;
    private boolean responseBodyList;
    private Class<?> responseBodyUnwrappedType;
    private BiConsumer<RESP_BUILDER, Object> responseBodyHandler;
    private Logger logger;
    private String serviceDetailsServiceName;
    private String serviceDetailsOperationName;
    private String serviceDetailsApiReferenceLink;
    private boolean hasBinaryRequestBody;
    private boolean operationUsesDefaultRetries;
    private boolean sendRetryToken;
    private SigningStrategy obmcsSigningStrategy;
    private AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private Supplier<BmcRequest.Builder<? extends REQ, ?>> requestBuilder;
    private Supplier<RESP_BUILDER> responseBuilder;
    private Set<String> headers = new HashSet<String>();
    private Map<String, BiConsumer<RESP_BUILDER, String>> responseHeaders = new HashMap<String, BiConsumer<RESP_BUILDER, String>>();
    private Map<String, BiConsumer<RESP_BUILDER, Map<String, String>>> responseHeadersMulti = new HashMap<String, BiConsumer<RESP_BUILDER, Map<String, String>>>();
    private UnaryOperator<RESP> interceptResponse;
    private RetryConfiguration retryConfiguration;
    private WaiterScheduler waiterScheduler = WaiterScheduler.UNSUPPORTED;
    private Executor offloadExecutor = null;
    private boolean firstAttempt = true;
    private BiConsumer<RESP_BUILDER, Object> responseEventStreamHandler;
    private ResponseErrorRuntimeExceptionFactory responseErrorExceptionFactory = ResponseErrorBmcExceptionFactory.INSTANCE;

    private ClientCall(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public static <REQ extends BmcRequest<?>, RESP extends BmcResponse, RESP_BUILDER extends BmcResponse.Builder<RESP>> ClientCall<REQ, RESP, RESP_BUILDER> builder(HttpClient httpClient, REQ request, Supplier<RESP_BUILDER> responseBuilder) {
        return super.responseBuilder(responseBuilder);
    }

    private ClientCall<REQ, RESP, RESP_BUILDER> request(REQ request) {
        this.request = request;
        return this;
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> clientConfigurator(ClientConfigurator clientConfigurator) {
        this.clientConfigurator = clientConfigurator;
        return this;
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> circuitBreaker(@Nullable OciCircuitBreaker circuitBreaker) {
        this.circuitBreaker = circuitBreaker;
        return this;
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> logger(Logger logger, String nickname) {
        this.logger = logger;
        if (logger.isTraceEnabled()) {
            logger.trace("Called async {}", (Object)nickname);
        }
        return this;
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> serviceDetails(String serviceName, String operationName, String apiReferenceLink) {
        this.serviceDetailsServiceName = serviceName;
        this.serviceDetailsOperationName = operationName;
        this.serviceDetailsApiReferenceLink = apiReferenceLink;
        return this;
    }

    private ServiceDetails buildServiceDetails() {
        if (this.serviceDetailsServiceName == null) {
            return ServiceDetails.UNKNOWN_SERVICE_DETAILS;
        }
        return new ServiceDetails(this.serviceDetailsServiceName, this.serviceDetailsOperationName, this.httpRequest.uri().toString(), this.serviceDetailsApiReferenceLink);
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> method(Method method) {
        this.httpRequest = this.httpClient.createRequest(method);
        return this;
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> hasBinaryRequestBody() {
        this.hasBinaryRequestBody = true;
        RetryConfiguration preferredRetryConfiguration = Retriers.getPreferredRetryConfiguration(((BmcRequest)this.request).getRetryConfiguration(), this.retryConfiguration, this.operationUsesDefaultRetries);
        if (Retriers.shouldPrepareForRetryBecauseOfRetryConfiguration(preferredRetryConfiguration) || this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            this.request = Retriers.wrapBodyInputStreamIfNecessary(this.request, this.requestBuilder.get(), preferredRetryConfiguration);
        }
        return this;
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> hasBody() {
        Object body = ((BmcRequest)this.request).getBody$();
        if (this.request instanceof HasContentLength) {
            Long contentLength = ((HasContentLength)this.request).getContentLength();
            if (contentLength != null) {
                this.httpRequest.body((InputStream)body, contentLength.longValue());
            } else {
                this.httpRequest.body(body);
            }
        } else {
            this.httpRequest.body(body);
        }
        if (!this.headers.contains("content-type")) {
            if (body instanceof InputStream) {
                this.appendHeader(CONTENT_TYPE_HEADER, APPLICATION_OCTET_STREAM_TYPE);
            } else {
                this.appendHeader(CONTENT_TYPE_HEADER, APPLICATION_JSON_TYPE);
            }
        }
        if (((BmcRequest)this.request).supportsExpect100Continue() && !this.headers.contains("expect")) {
            this.appendHeader("Expect", "100-continue");
        }
        return this;
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> operationUsesDefaultRetries() {
        this.operationUsesDefaultRetries = true;
        return this;
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> obmcsSigningStrategy(SigningStrategy obmcsSigningStrategy) {
        this.obmcsSigningStrategy = obmcsSigningStrategy;
        this.httpRequest.attribute("x-obmcs-internal-signing-strategy-name", (Object)obmcsSigningStrategy);
        return this;
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> authenticationDetailsProvider(AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        return this;
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> retryConfiguration(RetryConfiguration retryConfiguration) {
        this.retryConfiguration = retryConfiguration;
        return this;
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> requestBuilder(Supplier<BmcRequest.Builder<? extends REQ, ?>> requestBuilder) {
        this.requestBuilder = requestBuilder;
        return this;
    }

    private ClientCall<REQ, RESP, RESP_BUILDER> responseBuilder(Supplier<RESP_BUILDER> responseBuilder) {
        this.responseBuilder = responseBuilder;
        return this;
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> interceptResponse(UnaryOperator<RESP> interceptResponse) {
        this.interceptResponse = interceptResponse;
        return this;
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> basePath(String basePath) {
        return this.appendPathPart(basePath);
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> appendPathPart(String pathPart) {
        this.httpRequest.appendPathPart(pathPart);
        return this;
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> appendPathParam(String pathParamValue) {
        return this.appendPathPart(ParamEncoder.encodePathParam(pathParamValue));
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> appendPathParam(Number pathParamValue) {
        return this.appendPathParam(pathParamValue.toString());
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> appendPathParam(UUID pathParamValue) {
        return this.appendPathParam(pathParamValue.toString());
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> appendQueryParam(String name, Object value) {
        if (value != null) {
            this.httpRequest.query(name, ClientCall.encodeObjectQueryParam(value));
        }
        return this;
    }

    private static String encodeObjectQueryParam(Object value) {
        if (value instanceof Date) {
            value = HttpDateUtils.format((Date)value);
        }
        return ParamEncoder.encodeQueryParam(String.valueOf(value));
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> appendEnumQueryParam(String name, BmcEnum value) {
        if (value != null) {
            this.appendQueryParam(name, value.getValue());
        }
        return this;
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> appendListQueryParam(String name, List<?> values, CollectionFormatType collectionFormatType) {
        return this.appendListParameter(name, values, collectionFormatType, (paramName, value) -> this.appendQueryParam((String)paramName, value));
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> appendMapQueryParam(String prefix, Map<String, ?> values) {
        if (values != null) {
            if (prefix == null) {
                prefix = "";
            }
            for (Map.Entry<String, ?> entry : values.entrySet()) {
                String name = prefix + entry.getKey();
                if (entry.getValue() instanceof Collection) {
                    for (Object value : (Collection)entry.getValue()) {
                        this.httpRequest.query(name, String.valueOf(value));
                    }
                    continue;
                }
                this.httpRequest.query(name, String.valueOf(entry.getValue()));
            }
        }
        return this;
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> accept(String ... contentType) {
        StringJoiner joiner = new StringJoiner(", ");
        for (String s : contentType) {
            int extraPos = s.indexOf(59);
            if (extraPos != -1) {
                s = s.substring(0, extraPos);
            }
            joiner.add(s);
        }
        this.httpRequest.header("Accept", joiner.toString());
        return this;
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> appendHeader(String name, String value) {
        return this.appendHeader(name, (Object)value);
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> appendHeader(String name, Range value) {
        return this.appendHeader(name, (Object)value);
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> appendHeader(String name, Number value) {
        return this.appendHeader(name, (Object)value);
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> appendHeader(String name, Date value) {
        return this.appendHeader(name, (Object)value);
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> appendHeader(String name, Boolean value) {
        return this.appendHeader(name, (Object)value);
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> appendHeader(String name, BmcEnum value) {
        if (value != null) {
            this.appendHeader(name, value.getValue());
        }
        return this;
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> appendEnumHeader(String name, BmcEnum value) {
        if (value != null) {
            this.appendHeader(name, value.getValue());
        }
        return this;
    }

    private ClientCall<REQ, RESP, RESP_BUILDER> appendHeader(String name, Object value) {
        if (name.equalsIgnoreCase("opc-retry-token")) {
            this.sendRetryToken = true;
        }
        if (value != null) {
            this.headers.add(name.toLowerCase(Locale.ROOT));
            this.httpRequest.header(name, String.valueOf(value));
        }
        return this;
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> appendMapHeader(String prefix, Map<String, ?> queryParam) {
        if (prefix == null) {
            prefix = "";
        }
        if (queryParam != null) {
            for (Map.Entry<String, ?> e : queryParam.entrySet()) {
                this.appendMapHeaderParamValue(prefix + e.getKey(), e.getValue());
            }
        }
        return this;
    }

    public <T> ClientCall<REQ, RESP, RESP_BUILDER> appendListHeader(String headerParamName, List<T> values, CollectionFormatType collectionFormatType) {
        return this.appendListParameter(headerParamName, values, collectionFormatType, (paramName, value) -> this.appendHeader((String)paramName, value));
    }

    private <T> ClientCall<REQ, RESP, RESP_BUILDER> appendListParameter(String paramName, List<T> values, CollectionFormatType collectionFormatType, BiFunction<String, Object, ClientCall<REQ, RESP, RESP_BUILDER>> appendMethod) {
        if (StringUtils.isBlank(paramName)) {
            throw new IllegalArgumentException("A non-blank paramName must be provided");
        }
        if (values != null && !values.isEmpty()) {
            ArrayList<String> valuesToUse = new ArrayList<String>();
            for (T v : values) {
                if (v == null) continue;
                if (v instanceof BmcEnum) {
                    String rawValue = ((BmcEnum)v).getValue();
                    if (rawValue != null) {
                        valuesToUse.add(rawValue);
                        continue;
                    }
                    throw new IllegalArgumentException(String.format("Could not get the correct value for enum %s", v.getClass().getCanonicalName()));
                }
                valuesToUse.add((String)v);
            }
            if (valuesToUse.isEmpty()) {
                return this;
            }
            if (collectionFormatType == CollectionFormatType.CommaSeparated) {
                appendMethod.apply(paramName, StringUtils.join(valuesToUse, ","));
            } else if (collectionFormatType == CollectionFormatType.PipeSeparated) {
                appendMethod.apply(paramName, StringUtils.join(valuesToUse, "|"));
            } else if (collectionFormatType == CollectionFormatType.SpaceSeparated) {
                appendMethod.apply(paramName, StringUtils.join(valuesToUse, " "));
            } else if (collectionFormatType == CollectionFormatType.TabSeparated) {
                appendMethod.apply(paramName, StringUtils.join(valuesToUse, "\t"));
            } else if (collectionFormatType == CollectionFormatType.Multi) {
                for (int i = 0; i < valuesToUse.size(); ++i) {
                    appendMethod.apply(paramName, valuesToUse.get(i));
                }
            } else {
                throw new IllegalArgumentException(String.format("Unknown collection format type: %s", new Object[]{collectionFormatType}));
            }
        }
        return this;
    }

    private ClientCall<REQ, RESP, RESP_BUILDER> appendMapHeaderParamValue(String prefixedKey, Object value) {
        String name = ParamEncoder.encodeQueryParam(prefixedKey);
        if (value instanceof Collection) {
            Collection c = (Collection)value;
            for (Object v : c) {
                this.appendHeader(name, ClientCall.encodeObjectQueryParam(v));
            }
        } else {
            this.appendHeader(name, ClientCall.encodeObjectQueryParam(value));
        }
        return this;
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> appendHeaders(Map<String, String> values) {
        if (values != null) {
            for (Map.Entry<String, String> entry : values.entrySet()) {
                this.appendHeader(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public <RESP_BODY> ClientCall<REQ, RESP, RESP_BUILDER> handleEventStream(BiConsumer<RESP_BUILDER, RESP_BODY> handle) {
        this.responseEventStreamHandler = handle;
        return this;
    }

    public <RESP_BODY> ClientCall<REQ, RESP, RESP_BUILDER> handleBody(Class<RESP_BODY> type, BiConsumer<RESP_BUILDER, RESP_BODY> handle) {
        this.responseBodyList = false;
        this.responseBodyUnwrappedType = type;
        this.responseBodyHandler = handle;
        return this;
    }

    @Deprecated
    public <RESP_BODY> ClientCall<REQ, RESP, RESP_BUILDER> handleBodyMap(Class<RESP_BODY> type, BiConsumer<RESP_BUILDER, Map<String, RESP_BODY>> handle) {
        this.responseBodyList = true;
        this.responseBodyUnwrappedType = type;
        this.responseBodyHandler = handle;
        return this;
    }

    public <RESP_BODY> ClientCall<REQ, RESP, RESP_BUILDER> handleBodyList(Class<RESP_BODY> type, BiConsumer<RESP_BUILDER, List<RESP_BODY>> handle) {
        this.responseBodyList = true;
        this.responseBodyUnwrappedType = type;
        this.responseBodyHandler = handle;
        return this;
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> handleResponseHeaderString(String name, BiConsumer<RESP_BUILDER, String> handle) {
        this.responseHeaders.put(name, handle);
        return this;
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> handleResponseHeaderInteger(String name, BiConsumer<RESP_BUILDER, Integer> handle) {
        return this.handleResponseHeaderString(name, (b, s) -> handle.accept(b, Integer.valueOf(s)));
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> handleResponseHeaderLong(String name, BiConsumer<RESP_BUILDER, Long> handle) {
        return this.handleResponseHeaderString(name, (b, s) -> handle.accept(b, Long.valueOf(s)));
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> handleResponseHeaderFloat(String name, BiConsumer<RESP_BUILDER, Float> handle) {
        return this.handleResponseHeaderString(name, (b, s) -> handle.accept(b, Float.valueOf(s)));
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> handleResponseHeaderDouble(String name, BiConsumer<RESP_BUILDER, Double> handle) {
        return this.handleResponseHeaderString(name, (b, s) -> handle.accept(b, Double.valueOf(s)));
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> handleResponseHeaderBoolean(String name, BiConsumer<RESP_BUILDER, Boolean> handle) {
        return this.handleResponseHeaderString(name, (b, s) -> handle.accept(b, Boolean.valueOf(s)));
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> handleResponseHeaderDate(String name, BiConsumer<RESP_BUILDER, Date> handle) {
        return this.handleResponseHeaderString(name, (b, s) -> handle.accept(b, HttpDateUtils.parse(name, s)));
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> handleResponseHeaderRange(String name, BiConsumer<RESP_BUILDER, Range> handle) {
        return this.handleResponseHeaderString(name, (b, s) -> handle.accept(b, Range.parse(s)));
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> handleResponseHeaderBigDecimal(String name, BiConsumer<RESP_BUILDER, BigDecimal> handle) {
        return this.handleResponseHeaderString(name, (b, s) -> handle.accept(b, new BigDecimal((String)s)));
    }

    public <E> ClientCall<REQ, RESP, RESP_BUILDER> handleResponseHeaderEnum(String name, Function<String, E> parse, BiConsumer<RESP_BUILDER, E> handle) {
        return this.handleResponseHeaderString(name, (b, s) -> handle.accept(b, parse.apply((String)s)));
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> handleResponseHeadersMap(String prefix, BiConsumer<RESP_BUILDER, Map<String, String>> handle) {
        this.responseHeadersMulti.put(prefix, handle);
        return this;
    }

    public ClientCall<REQ, RESP, RESP_BUILDER> responseErrorExceptionFactory(ResponseErrorRuntimeExceptionFactory responseErrorExceptionFactory) {
        this.responseErrorExceptionFactory = responseErrorExceptionFactory;
        return this;
    }

    private CompletionStage<RESP> transformResponse(HttpResponse rawResponse) {
        CompletionStage<Object> future;
        CompletionStage failure = this.checkError(rawResponse);
        if (failure != null) {
            return failure;
        }
        BmcResponse.Builder builder = (BmcResponse.Builder)this.responseBuilder.get();
        builder.__httpStatusCode__(rawResponse.status());
        builder.headers(rawResponse.headers());
        boolean notModified = rawResponse.status() == 304;
        builder.isNotModified(notModified);
        for (Map.Entry<String, BiConsumer<RESP_BUILDER, String>> entry : this.responseHeaders.entrySet()) {
            String header = rawResponse.header(entry.getKey());
            if (header == null) continue;
            entry.getValue().accept(builder, header);
        }
        for (Map.Entry<String, BiConsumer<RESP_BUILDER, Object>> entry : this.responseHeadersMulti.entrySet()) {
            HashMap found = new HashMap();
            for (Map.Entry header : rawResponse.headers().entrySet()) {
                if (!((String)header.getKey()).toLowerCase(Locale.ROOT).startsWith(entry.getKey())) continue;
                found.put(header.getKey(), ((List)header.getValue()).get(0));
            }
            if (found.isEmpty()) continue;
            entry.getValue().accept(builder, found);
        }
        if (this.responseBodyUnwrappedType == null || notModified) {
            if (!ClientCall.isContentLengthSet(rawResponse)) {
                rawResponse.close();
            }
            return CompletableFuture.completedFuture(this.finalizeResponse(builder));
        }
        if (this.responseBodyList) {
            future = rawResponse.listBody(this.responseBodyUnwrappedType);
        } else {
            if (this.responseEventStreamHandler != null && rawResponse.header(CONTENT_TYPE_HEADER).equals(EVENT_STREAM_MEDIA_TYPE)) {
                future = rawResponse.streamBody();
                return future.thenApply(deserialized -> {
                    this.responseEventStreamHandler.accept(builder, deserialized);
                    return this.finalizeResponse(builder);
                });
            }
            if (this.responseBodyUnwrappedType == InputStream.class) {
                future = rawResponse.streamBody();
            } else if (this.responseBodyUnwrappedType == String.class) {
                future = rawResponse.textBody();
                if (APPLICATION_JSON_TYPE.equalsIgnoreCase(rawResponse.header(CONTENT_TYPE_HEADER))) {
                    future = this.thenApply(future, deserialized -> {
                        if (((String)deserialized).startsWith("\"") && ((String)deserialized).endsWith("\"")) {
                            try {
                                return Serializer.getDefault().readValue((String)deserialized, String.class);
                            }
                            catch (IOException e) {
                                this.logger.error("Unable to extract string response", (Throwable)e);
                            }
                        }
                        return deserialized;
                    });
                }
            } else {
                future = rawResponse.body(this.responseBodyUnwrappedType);
            }
        }
        return future.thenApply(deserialized -> {
            this.responseBodyHandler.accept(builder, deserialized);
            return this.finalizeResponse(builder);
        });
    }

    private static boolean isContentLengthSet(HttpResponse rawResponse) {
        for (Map.Entry header : rawResponse.headers().entrySet()) {
            if (!((String)header.getKey()).equalsIgnoreCase("Content-Length")) continue;
            return true;
        }
        return false;
    }

    private RESP finalizeResponse(RESP_BUILDER builder) {
        Object built = builder.build();
        if (this.interceptResponse != null) {
            built = (BmcResponse)this.interceptResponse.apply(built);
        }
        return (RESP)built;
    }

    private static <T> CompletionStage<T> failedFuture(Throwable t) {
        CompletableFuture res = new CompletableFuture();
        res.completeExceptionally(t);
        return res;
    }

    private <T> CompletionStage<T> checkError(HttpResponse response) {
        int status = response.status();
        if (status >= 200 && status < 300 || status == 304) {
            return null;
        }
        String opcRequestId = response.header(OPC_REQUEST_ID_HEADER);
        String contentType = response.header("content-type");
        if (contentType == null || !contentType.startsWith(APPLICATION_JSON_TYPE)) {
            CompletionStage<String> responseBody = response.textBody().exceptionally(e -> {
                this.logger.warn("Unable to read response body", e);
                return "Cannot read response body!";
            });
            return this.thenCompose(responseBody, s -> ClientCall.failedFuture(this.responseErrorExceptionFactory.createRuntimeException(status, "Unknown", String.format("Unexpected Content-Type: %s instead of %s. Response body: %s", contentType, APPLICATION_JSON_TYPE, s), opcRequestId, this.buildServiceDetails())));
        }
        return response.body(this.responseErrorExceptionFactory.getResponseErrorModelType()).handle((ecm, t) -> {
            if (t != null) {
                CompletionStage<String> msgFuture = response.textBody().thenApply(s -> "Unable to parse error response: " + s).exceptionally(e -> "Unable to parse error response.");
                return this.thenCompose(msgFuture, msg -> ClientCall.failedFuture(this.responseErrorExceptionFactory.createRuntimeException(status, "Unknown", (String)msg, opcRequestId, (Throwable)t, this.buildServiceDetails())));
            }
            if (ecm == null) {
                String defaultMessage = ResponseHelper.DEFAULT_ERROR_MESSAGES.getOrDefault(status, "Detailed exception information not available");
                return ClientCall.failedFuture(this.responseErrorExceptionFactory.createRuntimeException(status, "Unknown", defaultMessage, opcRequestId, this.buildServiceDetails()));
            }
            return ClientCall.failedFuture(this.responseErrorExceptionFactory.createRuntimeException(status, opcRequestId, ecm, this.buildServiceDetails()));
        }).thenCompose(Function.identity());
    }

    public Future<RESP> callAsync(AsyncHandler<REQ, RESP> handler) {
        try {
            return this.callAsync0(handler).toCompletableFuture();
        }
        catch (CompletionException ce) {
            throw ClientCall.tryUnwrapBmcException(ce);
        }
    }

    public static RuntimeException tryUnwrapBmcException(CompletionException ce) {
        Throwable t = ce;
        while (t.getCause() != null) {
            if (t.getCause() instanceof BmcException) {
                BmcException cause = (BmcException)ce.getCause();
                return cause;
            }
            t = t.getCause();
        }
        return ce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<RESP> callAsync0(AsyncHandler<REQ, RESP> handler) {
        CompletionStage<Object> stage;
        boolean discardImmediately = true;
        if (this.httpRequest != null && this.httpRequest.uri() != null && this.httpRequest.method() != null) {
            this.logger.debug("HTTP request method and URI: {} {}", (Object)this.httpRequest.method(), (Object)this.httpRequest.uri());
        }
        try {
            stage = this.callAsyncWithRetrier();
            stage.whenComplete((resp, exc) -> this.tryDiscardHttpRequest());
            discardImmediately = false;
        }
        finally {
            if (discardImmediately) {
                this.tryDiscardHttpRequest();
            }
        }
        if (handler != null) {
            stage = stage.whenComplete((resp, exc) -> {
                try {
                    if (exc != null) {
                        handler.onError(this.request, (Throwable)exc);
                    } else {
                        handler.onSuccess(this.request, resp);
                    }
                }
                catch (Exception e) {
                    this.logger.error("Handler threw exception", (Throwable)e);
                }
            });
        }
        return stage;
    }

    private void tryDiscardHttpRequest() {
        try {
            this.httpRequest.discard();
        }
        catch (Exception e) {
            this.logger.error("Failed to discard main request", (Throwable)e);
        }
    }

    private CompletionStage<RESP> callAsyncWithRetrier() {
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(((BmcRequest)this.request).getRetryConfiguration(), this.retryConfiguration, this.operationUsesDefaultRetries);
        if (!this.headers.contains(OPC_CLIENT_RETRIES_HEADER.toLowerCase(Locale.ROOT))) {
            TerminationStrategy terminationStrategy = retrier.getWaiter().getWaiterConfiguration().getTerminationStrategy();
            boolean sendOpcClientRetries = terminationStrategy instanceof MaxAttemptsTerminationStrategy && ((MaxAttemptsTerminationStrategy)terminationStrategy).getMaxAttempts() > 1;
            this.appendHeader(OPC_CLIENT_RETRIES_HEADER, sendOpcClientRetries);
        }
        return retrier.executeAsync(this.waiterScheduler, this, ClientCall::callAsyncTokenRefresh);
    }

    private CompletionStage<RESP> callAsyncTokenRefresh() {
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            TokenRefreshRetrier retrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return retrier.executeAsync(this.waiterScheduler, this, ClientCall::callAsyncImpl);
        }
        return this.callAsyncImpl();
    }

    private CompletionStage<RESP> callAsyncImpl() {
        CompletionStage upstream;
        List present;
        if (!this.firstAttempt && this.hasBinaryRequestBody) {
            Retriers.tryResetStreamForRetry((InputStream)this.httpRequest.body(), true);
        }
        this.firstAttempt = false;
        String requestId = ClientCall.generateRequestId();
        if (this.sendRetryToken) {
            RetryTokenUtils.addRetryToken(this.httpRequest);
        }
        HttpRequest transientRequest = this.httpRequest.copy();
        RequestInterceptor invocationCallback = ((BmcRequest)this.request).getInvocationCallback();
        if (invocationCallback != null) {
            invocationCallback.intercept(transientRequest);
        }
        if ((present = transientRequest.headers().getOrDefault(OPC_REQUEST_ID_HEADER, Collections.emptyList())).isEmpty()) {
            this.logger.debug("Generated request ID: {} for URI {}", (Object)requestId, (Object)this.httpRequest.uri());
            transientRequest.header(OPC_REQUEST_ID_HEADER, requestId);
        } else {
            this.logger.debug("User-set request ID: {}", present.get(0));
        }
        if (this.circuitBreaker == null) {
            CompletionStage upstream2;
            try {
                upstream2 = transientRequest.execute().handle((r, t) -> {
                    if (this.isProcessingException((Throwable)t)) {
                        throw new BmcException(true, t.getMessage(), (Throwable)t, requestId);
                    }
                    if (t != null) {
                        return ClientCall.failedFuture(t);
                    }
                    return CompletableFuture.completedFuture(r);
                }).thenCompose(Function.identity());
            }
            catch (Exception e) {
                return ClientCall.failedFuture(e);
            }
            return upstream2.thenCompose(this::transformResponse);
        }
        if (!this.circuitBreaker.tryAcquirePermission()) {
            CallNotAllowedException callNotAllowed = this.circuitBreaker.createCallNotAllowedException();
            return ClientCall.failedFuture(BmcException.createClientSide(this.circuitBreaker.circuitBreakerCallNotPermittedErrorMessage(this.httpRequest.uri().toString()), (Throwable)callNotAllowed, null, this.buildServiceDetails()));
        }
        long start = this.circuitBreaker.getCurrentTimestamp();
        try {
            upstream = transientRequest.execute().handle((r, t) -> {
                if (this.isProcessingException((Throwable)t)) {
                    this.addToHistory((Throwable)t);
                    this.circuitBreaker.onError(this.circuitBreaker.getCurrentTimestamp() - start, this.circuitBreaker.getTimestampUnit(), t);
                    throw new BmcException(true, t.getMessage(), (Throwable)t, requestId);
                }
                if (t != null) {
                    return ClientCall.failedFuture(t);
                }
                return CompletableFuture.completedFuture(r);
            }).thenCompose(Function.identity());
        }
        catch (Exception e) {
            this.addToHistory(e);
            this.circuitBreaker.onError(this.circuitBreaker.getCurrentTimestamp() - start, this.circuitBreaker.getTimestampUnit(), (Throwable)e);
            return ClientCall.failedFuture(e);
        }
        return this.thenCompose(upstream, resp -> {
            try {
                return this.transformResponse((HttpResponse)resp).whenComplete((r, t) -> {
                    if (t instanceof CompletionException) {
                        t = t.getCause();
                    }
                    if (t == null) {
                        this.circuitBreaker.onResult(this.circuitBreaker.getCurrentTimestamp() - start, this.circuitBreaker.getTimestampUnit(), resp);
                    } else {
                        this.addToHistory((Throwable)t);
                        this.circuitBreaker.onError(this.circuitBreaker.getCurrentTimestamp() - start, this.circuitBreaker.getTimestampUnit(), t);
                    }
                });
            }
            catch (Exception e) {
                this.addToHistory(e);
                this.circuitBreaker.onError(this.circuitBreaker.getCurrentTimestamp() - start, this.circuitBreaker.getTimestampUnit(), (Throwable)e);
                throw e;
            }
        });
    }

    private boolean isProcessingException(Throwable throwable) {
        while (throwable != null) {
            if (this.httpClient.isProcessingException((Exception)throwable)) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    private void addToHistory(Throwable throwable) {
        LinkedHashMap<String, String> messages = new LinkedHashMap<String, String>();
        Integer status = null;
        messages.put("serviceName", this.serviceDetailsServiceName);
        if (throwable instanceof BmcException) {
            BmcException bmcException = (BmcException)throwable;
            messages.put("message", bmcException.getUnmodifiedMessage());
            messages.put("serviceCode", bmcException.getServiceCode());
            status = bmcException.getStatusCode();
        } else {
            messages.put("message", throwable.getMessage());
        }
        if (this.httpRequest != null && this.httpRequest.uri() != null) {
            messages.put("URL", this.httpRequest.uri().toString());
        }
        this.circuitBreaker.addToHistory(throwable, status, messages);
    }

    public RESP callSync() {
        this.waiterScheduler = WaiterScheduler.SYNC;
        SyncFutureWaiter futureWaiter = new SyncFutureWaiter();
        this.offloadExecutor = futureWaiter;
        this.httpRequest = this.httpRequest.offloadExecutor(this.offloadExecutor);
        try {
            return (RESP)((BmcResponse)futureWaiter.listenForResult(this.callAsync0(null)));
        }
        catch (SdkRuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw BmcException.createClientSide("Unknown error", e, null, this.buildServiceDetails());
        }
    }

    public static String generateRequestId() {
        return UUID.randomUUID().toString().replace("-", "").toUpperCase();
    }

    private <T, U> CompletionStage<U> thenApply(CompletionStage<T> stage, Function<? super T, ? extends U> fn) {
        if (this.offloadExecutor == null) {
            return stage.thenApply(fn);
        }
        return stage.thenApplyAsync(fn, this.offloadExecutor);
    }

    private <T, U> CompletionStage<U> thenCompose(CompletionStage<T> stage, Function<? super T, ? extends CompletionStage<U>> fn) {
        if (this.offloadExecutor == null) {
            return stage.thenCompose(fn);
        }
        return stage.thenComposeAsync(fn, this.offloadExecutor);
    }
}

