/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.location;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.http.CloudStorageUrl;
import oracle.dbtools.raptor.deployment.DbmsCloudAPI;
import oracle.dbtools.raptor.deployment.DbmsCloudQuery;
import oracle.dbtools.raptor.deployment.DbmsCloudResources;
import oracle.dbtools.transfer.TransferManager;
import oracle.dbtools.transfer.TransferMessages;
import oracle.dbtools.transfer.file.FileInfo;
import oracle.dbtools.transfer.location.Location;
import oracle.dbtools.transfer.location.LocationTestInfo;
import oracle.dbtools.transfer.location.StoreAndForwardStorageLocation;
import oracle.dbtools.transfer.task.TransferTaskProgressMonitor;
import oracle.dbtools.transfer.utility.InputStreamProgressWrapper;
import oracle.dbtools.transfer.utility.MD5;
import oracle.dbtools.transfer.utility.ScriptOutput;
import oracle.dbtools.util.Logger;

public class OracleDbmsCloudStorageLocation
extends StoreAndForwardStorageLocation {
    private static final String BUCKETS = "b";
    private static final String COMPARTMENTS = "c";
    private static final String OBJECTS = "o";
    private CloudStorageUrl storageUrl;
    private String namespace = "";
    private String connName;
    private Connection conn = null;
    private boolean lock;
    private String credential;

    public OracleDbmsCloudStorageLocation(CloudStorageUrl storageUrl, String credential, Connection conn) {
        super(storageUrl, credential, conn);
        assert (storageUrl != null);
        assert (credential != null);
        assert (conn != null);
        this.storageUrl = storageUrl;
        this.credential = credential;
        this.conn = conn;
    }

    @Override
    public Location clone() {
        OracleDbmsCloudStorageLocation clone = new OracleDbmsCloudStorageLocation(this.storageUrl, this.credential, this.conn);
        return clone;
    }

    @Override
    public void connectImpl() throws IOException {
        try {
            URL namespaceUrl = this.storageUrl.getNamespaceUrl();
            if (!namespaceUrl.getProtocol().equalsIgnoreCase("https")) {
                throw new UnsupportedOperationException("Protocol MUST be https");
            }
            this.namespace = namespaceUrl.toString();
            Logger.info(this.getClass(), (String)this.toString());
        }
        catch (Throwable t) {
            throw OracleDbmsCloudStorageLocation.asIOException(t);
        }
        try {
            if (null == this.conn || this.conn.isClosed()) {
                throw new IOException();
            }
        }
        catch (Throwable t) {
            String msg = TransferMessages.getString("DbmsCloud_CONN_NOT_AVAILABLE");
            Logger.severe(this.getClass(), (String)msg, (Throwable)t);
            throw new IOException(msg, t);
        }
    }

    @Override
    public InputStream asInputStream(Path path, long position, long size) throws IOException {
        return this.asInputStream(path, position, size, null);
    }

    private InputStream asInputStream(Path path, long position, long size, TransferTaskProgressMonitor progressMonitor) throws IOException {
        InputStream in = null;
        try {
            CloudStorageUrl target = this.getTargetUrl(path);
            target.validateUrlAsObject();
            URL targetUrl = target.getFinalUrl();
            if (this.conn == null) {
                throw new UnsupportedOperationException("Connection is required");
            }
            this.lock = LockManager.lock((Connection)this.conn);
            if (!this.lock) {
                throw new IOException(TransferMessages.getString("DbmsCloud_CONN_NOT_AVAILABLE"));
            }
            Blob data = null;
            String query = DbmsCloudQuery.getQuery((String)"dbms_cloudGetObject", (Connection)this.conn);
            if (query == null) {
                throw new SQLException(DbmsCloudResources.getString((String)"DBMS_CLOUD_PKG_ERR"));
            }
            CallableStatement stmt = null;
            try {
                stmt = this.conn.prepareCall(query);
                long endPos = size + position;
                stmt.registerOutParameter(1, 2004);
                stmt.setString(2, this.credential);
                stmt.setString(3, targetUrl.toString());
                stmt.setBigDecimal(4, new BigDecimal(position));
                stmt.setBigDecimal(5, new BigDecimal(endPos > 0L ? endPos : 0L));
                stmt.execute();
                data = stmt.getBlob(1);
                in = data.getBinaryStream();
            }
            catch (Throwable t) {
                throw OracleDbmsCloudStorageLocation.asIOException(t);
            }
            if (progressMonitor != null) {
                in = new InputStreamProgressWrapper(in, progressMonitor, size);
            }
        }
        catch (Throwable t) {
            throw OracleDbmsCloudStorageLocation.asIOException(t);
        }
        finally {
            if (this.lock) {
                LockManager.unlock((Connection)this.conn);
            }
        }
        return in;
    }

    @Override
    public long copy(InputStream in, String target, TransferTaskProgressMonitor progressMonitor, CopyOption ... options) throws IOException {
        Logger.info(this.getClass(), (String)target);
        long length = in.available();
        try {
            CloudStorageUrl csUrl = this.getTargetUrl(null == target ? null : Paths.get(target, new String[0]));
            csUrl.validateUrlAsObject();
            if (progressMonitor != null) {
                in = new InputStreamProgressWrapper(in, progressMonitor, length);
            }
            DbmsCloudAPI dcApi = new DbmsCloudAPI();
            try {
                dcApi.startService(null, this.conn);
                dcApi.putObject(this.credential, csUrl.getFinalUrlAsSwift().toString(), in);
            }
            catch (Exception e) {
                String msg = e.getLocalizedMessage();
                throw new IOException(msg);
            }
            finally {
                dcApi.finishService();
            }
        }
        catch (Throwable t) {
            throw OracleDbmsCloudStorageLocation.asIOException(t);
        }
        return length;
    }

    @Override
    public void delete(String qualifier) throws IOException {
        Logger.info(this.getClass(), (String)qualifier);
        try {
            CloudStorageUrl csUrl = this.getTargetUrl(qualifier);
            csUrl.validateUrlAsObject();
            DbmsCloudAPI dcApi = new DbmsCloudAPI();
            try {
                dcApi.startService(null, this.conn);
                dcApi.deleteObject(this.credential, csUrl.getFinalUrlAsSwift().toString());
            }
            catch (Exception e) {
                String msg = e.getLocalizedMessage();
                throw new IOException(msg);
            }
            finally {
                dcApi.finishService();
            }
        }
        catch (Throwable t) {
            throw OracleDbmsCloudStorageLocation.asIOException(t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Map<?, ?>> list(String type, String target) throws IOException {
        Logger.info(this.getClass(), (String)target);
        try {
            String t = null;
            CloudStorageUrl csUrl = this.getTargetUrl(t);
            URL targetUrl = csUrl.getFinalUrlAsSwift();
            switch (type.toLowerCase()) {
                case "b": {
                    Logger.info(this.getClass(), (String)target);
                    throw new UnsupportedOperationException(TransferMessages.format("TransferUnsupportedOp", "list buckets"));
                }
                case "c": {
                    Logger.info(this.getClass(), (String)target);
                    throw new UnsupportedOperationException(TransferMessages.format("TransferUnsupportedOp", "list compartments"));
                }
                case "o": {
                    csUrl.validateUrlAsBucket();
                    DBUtil dbUtil = null;
                    try {
                        if (this.conn == null) {
                            throw new UnsupportedOperationException(TransferMessages.format("TransferUnsupportedOp", TransferMessages.getString("DbmsCloud_CON_REQ")));
                        }
                        this.lock = LockManager.lock((Connection)this.conn);
                        if (!this.lock) {
                            throw new IOException(TransferMessages.getString("DbmsCloud_CONN_NOT_AVAILABLE"));
                        }
                        LinkedHashMap<String, String> objectsMap = new LinkedHashMap<String, String>();
                        ArrayList listMap = new ArrayList();
                        ResultSet rs = null;
                        HashMap<String, String> binds = new HashMap<String, String>();
                        binds.clear();
                        binds.put("CREDENTIAL", this.credential);
                        binds.put("URL", targetUrl.toString());
                        String query = DbmsCloudQuery.getQuery((String)"dbms_cloudListObjects", (Connection)this.conn);
                        if (query == null) {
                            throw new SQLException(DbmsCloudResources.getString((String)"DBMS_CLOUD_PKG_ERR"));
                        }
                        dbUtil = DBUtil.getInstance((Connection)this.conn);
                        rs = dbUtil.executeQuery(query, binds);
                        if (rs != null) {
                            while (true) {
                                if (!rs.next()) {
                                    ArrayList arrayList = listMap;
                                    return arrayList;
                                }
                                objectsMap.put("name", rs.getString(1));
                                objectsMap.put("bytes", rs.getString(2));
                                listMap.add(objectsMap);
                                objectsMap = new LinkedHashMap();
                            }
                        }
                    }
                    catch (Throwable t2) {
                        throw OracleDbmsCloudStorageLocation.asIOException(t2);
                    }
                    finally {
                        SQLException ex;
                        if (this.lock) {
                            LockManager.unlock((Connection)this.conn);
                        }
                        if ((ex = dbUtil.getLastException()) != null) {
                            throw OracleDbmsCloudStorageLocation.asIOException(ex);
                        }
                    }
                }
            }
            return Collections.emptyList();
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (Throwable t) {
            throw OracleDbmsCloudStorageLocation.asIOException(t);
        }
    }

    @Override
    public ScriptOutput logExecuteScript(String tagName, String executeScriptStr, String scriptName, String targetDir) {
        throw new UnsupportedOperationException(TransferMessages.format("TransferUnsupportedOp", "logExecuteScript"));
    }

    @Override
    public ScriptOutput executeScript(String executeScriptStr, String scriptName, String targetDir) {
        throw new UnsupportedOperationException(TransferMessages.format("TransferUnsupportedOp", "executeScript"));
    }

    @Override
    public MD5 getMd5(Path path, long offset, long size) {
        throw new UnsupportedOperationException("getMD5");
    }

    @Override
    public String toString() {
        return this.connName + "." + this.credential + "@" + this.namespace + " " + super.toString();
    }

    @Override
    public boolean doPreProcessing(String transferId, List<FileInfo> fileInfos, String targetDir) throws IOException {
        return super.doPreProcessing(transferId, fileInfos, targetDir);
    }

    public static LocationTestInfo testBucketUrl(String swiftBucketUrl) {
        return OracleDbmsCloudStorageLocation.testBucketUrl(swiftBucketUrl, false);
    }

    public static LocationTestInfo testBucketUrl(String swiftBucketUrlIn, boolean promptUserForAdd) {
        throw new UnsupportedOperationException("testBucketUrl");
    }

    public static void main(String[] args) {
        TransferManager.INSTANCE.setPackageLogStream(System.out, false);
        TransferManager.INSTANCE.setPackageLogLevel(Level.INFO);
    }
}

