/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdv.ddl;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.common.utils.StringUtils;
import oracle.dbtools.crest.model.PropertiesObject;
import oracle.dbtools.crest.model.scheduling.JSONToPropertiesObject;
import oracle.dbtools.jdv.ddl.Quoting;
import oracle.dbtools.jdv.ddl.SQLProcessor;
import oracle.dbtools.jdv.model.JDVConstants;
import oracle.dbtools.jdv.model.JDVElement;
import oracle.dbtools.jdv.model.JDVView;
import oracle.dbtools.mle_js.ExpNode;

public class SqlGenerator
implements JDVConstants {
    private static String WITH_CHECK_OPTION = " WITH CHECK OPTION";

    public static String getSqlQuery(String json, boolean includeSchema) {
        JDVView view = SqlGenerator.getView(json);
        return SqlGenerator.getSqlQuery(view, includeSchema, false);
    }

    public static String getSqlQuery(JDVView view, boolean includeSchema, boolean queryOnly) {
        ExpNode.StringAdd res = new ExpNode.StringAdd();
        if (view.getDefinition() != null) {
            view.getDefinition().initIdForTables(1000);
            HashMap<String, String> idToAlias = SqlGenerator.createAliasesMap(view);
            SqlGenerator.addTable(view.getDefinition(), 0, res, null, idToAlias, includeSchema, queryOnly);
        }
        return res.toString().trim();
    }

    public static String getViewDefinition(String json, boolean update, boolean includeSchema) {
        return SqlGenerator.getViewDefinition(json, update, includeSchema, false, false);
    }

    public static String getViewDefinition(String json, boolean update, boolean includeSchema, boolean queryOnly, boolean checkMixedCase) {
        JDVView view = SqlGenerator.getView(json);
        return SqlGenerator.getViewDefinition(view, update, includeSchema, queryOnly, checkMixedCase);
    }

    public static String getViewDefinition(JDVView view, boolean update, boolean includeSchema, boolean queryOnly, boolean checkMixedCase) {
        if (view.getDefinition() != null) {
            view.applyViewOwnerToTables();
            if (!queryOnly) {
                return SqlGenerator.getCreatePart(view, update, includeSchema, checkMixedCase) + SqlGenerator.getSqlQuery(view, includeSchema, queryOnly) + "\n;" + (String)(view.hasCommentInRdbmsDefined() ? "\n\n" + SqlGenerator.getCommentDDL(view, checkMixedCase) : "");
            }
            return SqlGenerator.getSqlQuery(view, includeSchema, queryOnly) + "\n;";
        }
        return "-- error - null definition";
    }

    public static String getCommentDDL(JDVView view, boolean checkMixedCase) {
        if (view.hasCommentInRdbmsDefined()) {
            return "COMMENT ON TABLE " + SqlGenerator.getDDLName(view, checkMixedCase) + " IS '" + SqlGenerator.replaceSingleQuote(view.getCommentInRDBMS()) + "'\n;";
        }
        return "";
    }

    public static String replaceSingleQuote(String input) {
        return input.replaceAll("\\'", "\\'\\'");
    }

    public static String getDDLName(JDVView view, boolean checkMixedCase) {
        Object res = "";
        if (view.getView_owner() != null && !view.getView_owner().isEmpty()) {
            res = SqlGenerator.getName(view.getView_owner(), checkMixedCase) + ".";
        }
        if (view.getView_name() != null && !view.getView_name().isEmpty()) {
            res = (String)res + SqlGenerator.getName(view.getView_name(), checkMixedCase);
        }
        return res;
    }

    private static String getCreatePart(JDVView view, boolean update, boolean includeSchema, boolean checkMixedCase) {
        Object res = "CREATE";
        if (update) {
            res = (String)res + " OR REPLACE";
        }
        res = (String)res + " FORCE";
        res = SqlGenerator.getBoolean(view.getEditionable(), true) ? (String)res + " EDITIONABLE" : (String)res + " NONEDITIONABLE";
        res = (String)res + " JSON RELATIONAL DUALITY VIEW ";
        if (includeSchema && view.getView_owner() != null) {
            res = (String)res + SqlGenerator.getName(view.getView_owner()) + ".";
        }
        res = (String)res + SqlGenerator.getName(view.getView_name(), checkMixedCase);
        res = (String)res + "\n AS ";
        return res;
    }

    private static void addTable(JDVElement table, int position, ExpNode.StringAdd res, JDVElement parentTable, HashMap<String, String> idToAlias, boolean includeSchema, boolean queryOnly) {
        String join;
        String key;
        String openChar = "";
        String closeChar = "";
        String tableName = StringUtils.unQuote((String)table.getName());
        String alias = idToAlias.get(table.getTableId());
        if (parentTable != null) {
            if ("nested".equalsIgnoreCase(table.getRelationship())) {
                openChar = "[ ";
                closeChar = " ]";
            } else {
                openChar = "( ";
                closeChar = " )";
            }
        }
        if ((key = SqlGenerator.getKey(table.getJson_key_name())) == null || key.isEmpty()) {
            key = SqlGenerator.getKey(SqlGenerator.getColumnNameToKey(tableName));
        }
        if (SqlGenerator.getBoolean(table.getUnnested(), false) && parentTable != null) {
            openChar = "( ";
            closeChar = " )";
            res.addTabs("UNNEST", position);
            res.addNL_Tabs(openChar + "SELECT JSON {", position + 1);
        } else if (key != null && !key.isEmpty() && parentTable != null) {
            res.addTabs(key, position);
            res.addNL_Tabs(openChar + "SELECT JSON {", position + 1);
        } else if (parentTable == null) {
            res.addNL_Tabs(openChar + "SELECT JSON {", position + 1);
        }
        SqlGenerator.addElements(table, position + 1, res, idToAlias, includeSchema, queryOnly);
        Object withClause = "";
        if (table.isCheckSet() && !SqlGenerator.getBoolean(table.getCheck(), true)) {
            withClause = (String)withClause + " NOCHECK";
        }
        if (table.isInsertSet() && SqlGenerator.getBoolean(table.getAllow_insert(), false)) {
            withClause = (String)withClause + " INSERT";
        }
        if (table.isUpdateSet() && SqlGenerator.getBoolean(table.getAllow_update(), false)) {
            withClause = (String)withClause + " UPDATE";
        }
        if (table.isDeleteSet() && SqlGenerator.getBoolean(table.getAllow_delete(), false)) {
            withClause = (String)withClause + " DELETE";
        }
        if (parentTable == null) {
            res.addNL_Tabs("}" + (queryOnly ? " AS dv_data " : ""), position + 1);
        } else {
            res.addNL_Tabs("}", position + 1);
        }
        boolean addSchema = includeSchema || table.getTable_owner() != null && !table.getTable_owner().equals(table.getView_owner());
        res.addNL_Tabs("FROM " + SqlGenerator.getTable_DDL_Name(table, addSchema) + " " + alias, position + 1);
        if (!queryOnly && !((String)withClause).isEmpty()) {
            res.addNL_Tabs(" WITH " + (String)withClause, position + 2);
        }
        if ((join = SqlGenerator.getJoinExpression(table, parentTable, idToAlias, queryOnly)) != null && !join.isEmpty()) {
            res.addNL_Tabs(" WHERE " + join, position + 1);
        }
        res.addNL_Tabs(closeChar, position);
    }

    public static String getTable_DDL_Name(JDVElement table, boolean includeSchema) {
        if (includeSchema) {
            Object longName = "";
            if (table.getTable_owner() != null) {
                longName = SqlGenerator.getName(table.getTable_owner()) + ".";
            }
            longName = (String)longName + SqlGenerator.getName(table.getTable_name());
            return longName;
        }
        return SqlGenerator.getName(table.getTable_name());
    }

    private static String getJoinExpression(JDVElement table, JDVElement parentTable, HashMap<String, String> idToAlias, boolean queryOnly) {
        String filter;
        if (parentTable != null) {
            String[] tableColumns = null;
            String[] parentTableColumns = null;
            boolean unnested = SqlGenerator.getBoolean(table.getUnnested(), false);
            if ("nested".equalsIgnoreCase(table.getRelationship()) || unnested && table.isOneToOneCardinality()) {
                parentTableColumns = parentTable.getPKColumns();
                tableColumns = table.getForeignKeyColumns();
            } else {
                parentTableColumns = table.getForeignKeyColumns();
                tableColumns = table.getPKColumns();
            }
            if (parentTableColumns.length == tableColumns.length) {
                String tableAlias = idToAlias.get(table.getTableId());
                String parentTableAlias = idToAlias.get(parentTable.getTableId());
                Object join = " ";
                for (int i = 0; i < tableColumns.length; ++i) {
                    join = " ".equals(join) ? (String)join + tableAlias + "." + tableColumns[i] + " = " + parentTableAlias + "." + parentTableColumns[i] + " " : (String)join + "AND " + tableAlias + "." + tableColumns[i] + " = " + parentTableAlias + "." + parentTableColumns[i] + " ";
                }
                String filter2 = SqlGenerator.getTableFilterExpression(table, false);
                if (filter2 != null) {
                    return (String)join + filter2 + (queryOnly ? "" : WITH_CHECK_OPTION);
                }
                return join;
            }
        }
        if ((filter = SqlGenerator.getTableFilterExpression(table, true)) != null) {
            return filter + (queryOnly ? "" : WITH_CHECK_OPTION);
        }
        return null;
    }

    private static String getTableFilterExpression(JDVElement table, boolean isRootTable) {
        String filter = table.getTableFilter();
        if (filter != null && !filter.trim().isEmpty()) {
            String upFilter = filter.trim().toUpperCase(Locale.ROOT);
            if (upFilter.startsWith("OR ")) {
                int ind = filter.toUpperCase(Locale.ROOT).indexOf("OR ");
                if (isRootTable) {
                    return " " + filter.substring(ind);
                }
                return " AND " + filter;
            }
            if (!isRootTable) {
                if (upFilter.startsWith("AND ")) {
                    return " " + filter;
                }
                return " AND " + filter;
            }
            if (isRootTable) {
                if (upFilter.startsWith("AND ")) {
                    int ind = filter.toUpperCase(Locale.ROOT).indexOf("AND ");
                    return " " + filter.substring(ind);
                }
                return " " + filter;
            }
        }
        return null;
    }

    private static String getFlexConflictResolution(JDVElement element) {
        if (SqlGenerator.getBoolean(element.getIs_flex_col(), false)) {
            String choice = element.getConflictResolutionOnFlex();
            if (choice != null) {
                choice = choice.toUpperCase(Locale.ROOT);
            }
            switch (choice) {
                case "ARRAY": {
                    return "ARRAY ON NAME CONFLICT";
                }
                case "IGNORE": {
                    return "IGNORE ON NAME CONFLICT";
                }
                case "ERROR": {
                    return "ERROR  ON NAME CONFLICT";
                }
            }
            return "KEEP NESTED ON NAME CONFLICT";
        }
        return "";
    }

    private static void addColumn(JDVElement element, int position, ExpNode.StringAdd res, JDVElement table, String tableAlias, boolean queryOnly) {
        boolean tableCheck = SqlGenerator.getBoolean(table.getCheck(), true);
        boolean tableUpdate = SqlGenerator.getBoolean(table.getAllow_update(), false);
        String key = SqlGenerator.getKey(element.getJson_key_name());
        if (key == null || key.isEmpty() && !SqlGenerator.getBoolean(element.getIs_flex_col(), false)) {
            key = SqlGenerator.getKey(SqlGenerator.getColumnNameToKey(element.getColumn_name()));
        }
        if (!(key == null || key.isEmpty() || element.isFlexColumn() || element.isGenerated())) {
            res.addTabs(key, position);
            res.addText(tableAlias + "." + SqlGenerator.getName(element.getColumn_name()));
        } else if (element.isGenerated()) {
            key = SqlGenerator.getKey(element.getJson_keyOrColumn_name());
            res.addTabs(key, position);
            String type = element.getGenerateType();
            Object expr = element.getGeneratedExpression();
            Object gen = " GENERATED USING ";
            if (!(type == null || type.isEmpty() || type.equalsIgnoreCase("directive") || expr == null || ((String)expr).isEmpty())) {
                if ("path".equalsIgnoreCase(type)) {
                    gen = (String)gen + "PATH ";
                    expr = "'" + ((String)expr).stripTrailing() + "'";
                    res.addText((String)gen);
                    res.addNL_Tabs((String)expr, position + key.length() / 4 + 1);
                    if (SqlGenerator.getBoolean(element.getHidden(), false)) {
                        res.addNL_Tabs(" HIDDEN ", position + key.length() / 4 + 1);
                    }
                } else {
                    res.addText((String)gen);
                    String shifted = SQLProcessor.indentString((String)expr, position * 4 + key.length() + 1).stripTrailing();
                    res.addNL().addText(shifted);
                    if (SqlGenerator.getBoolean(element.getHidden(), false)) {
                        res.addNL().addText(SQLProcessor.indentString(" HIDDEN", position * 4 + key.length() + 1).stripTrailing());
                    }
                }
            }
        }
        if (SqlGenerator.getBoolean(element.getIs_flex_col(), false)) {
            res.addTabs(tableAlias + "." + SqlGenerator.getName(element.getColumn_name()) + " AS FLEX COLUMN " + SqlGenerator.getFlexConflictResolution(element), position);
        } else if (!element.isGenerated() && SqlGenerator.getBoolean(element.getHidden(), false)) {
            res.addText(" HIDDEN ");
        }
        if (!element.isGenerated()) {
            Object withClause = "";
            if (!element.isPkColumn() && element.isCheckSet()) {
                withClause = !SqlGenerator.getBoolean(element.getCheck(), false) ? (String)withClause + (tableCheck ? " NOCHECK" : "") : (String)withClause + (!tableCheck ? " CHECK" : "");
            }
            if (!element.isPkColumn() && element.isUpdateSet()) {
                withClause = !SqlGenerator.getBoolean(element.getAllow_update(), false) ? (String)withClause + (tableUpdate ? " NOUPDATE" : "") : (String)withClause + (!tableUpdate ? " UPDATE" : "");
            }
            if (!queryOnly && !((String)withClause).isEmpty()) {
                res.addText(" WITH" + (String)withClause);
            }
        }
    }

    private static void addElements(JDVElement table, int position, ExpNode.StringAdd res, HashMap<String, String> idToAlias, boolean includeSchema, boolean queryOnly) {
        List<JDVElement> list = table.getElements();
        HashSet<String> addedNested = new HashSet<String>();
        Map<String, List<JDVElement>> nested = SqlGenerator.createNestingMap(list);
        String alias = idToAlias.get(table.getTableId());
        boolean first = true;
        for (JDVElement element : list) {
            if (!element.isTable()) {
                if (element.getNestedKey() != null && !element.getNestedKey().isEmpty()) {
                    if (addedNested.contains(element.getJson_key_name())) continue;
                    if (!first) {
                        res.addText(",");
                    } else {
                        first = false;
                    }
                    SqlGenerator.addNestedColumns(table, element.getNestedKey(), nested, addedNested, position + 1, res, alias, queryOnly);
                    addedNested.add(element.getJson_key_name());
                    continue;
                }
                if (!first) {
                    res.addText(",");
                } else {
                    first = false;
                }
                res.addNL();
                SqlGenerator.addColumn(element, position + 1, res, table, alias, queryOnly);
                continue;
            }
            if (!first) {
                res.addText(",");
            } else {
                first = false;
            }
            res.addNL();
            SqlGenerator.addTable(element, position + 1, res, table, idToAlias, includeSchema, queryOnly);
        }
    }

    private static void addNestedColumns(JDVElement table, String nestedKey, Map<String, List<JDVElement>> nested, Set<String> addedNested, int position, ExpNode.StringAdd res, String tableAlias, boolean queryOnly) {
        String key = SqlGenerator.getKey(nestedKey);
        List<JDVElement> list = nested.get(nestedKey);
        if (key != null && !key.isEmpty() && list != null && list.size() > 0) {
            res.addNL_Tabs(key, position);
            res.addText(" {");
            boolean first = true;
            for (JDVElement el : list) {
                if (!SqlGenerator.getBoolean(el.getIs_flex_col(), false)) {
                    if (!first) {
                        res.addText(",");
                    } else {
                        first = false;
                    }
                    res.addNL();
                    SqlGenerator.addColumn(el, position + 1, res, table, tableAlias, queryOnly);
                }
                addedNested.add(el.getJson_key_name());
            }
            res.addNL_Tabs("}", position);
        }
    }

    private static Map<String, List<JDVElement>> createNestingMap(List<JDVElement> list) {
        HashMap<String, List<JDVElement>> map = new HashMap<String, List<JDVElement>>();
        for (JDVElement el : list) {
            if (el.getNestedKey() == null || el.getNestedKey().isEmpty()) continue;
            ArrayList<JDVElement> nested = (ArrayList<JDVElement>)map.get(el.getNestedKey());
            if (nested == null) {
                nested = new ArrayList<JDVElement>();
                map.put(el.getNestedKey(), nested);
            }
            nested.add(el);
        }
        return map;
    }

    private static boolean getBoolean(String value, boolean defValue) {
        if (value == null) {
            return defValue;
        }
        return "true".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value);
    }

    private static String getName(String name) {
        return SqlGenerator.getName(name, false);
    }

    private static String getName(String name, boolean checkMixedCase) {
        if (!Quoting.isValidIdentifier(name) || checkMixedCase && Quoting.isMixedCase(name)) {
            if (!Quoting.isQuoted(name)) {
                return "\"" + name + "\"";
            }
            return name;
        }
        return name;
    }

    private static String getColumnNameToKey(String name) {
        return name.toLowerCase(Locale.ROOT);
    }

    private static String getKey(String key) {
        if (key != null && !key.isEmpty()) {
            return "'" + key + "' : ";
        }
        return "";
    }

    public static JsonObject getJSON(String json) {
        ByteArrayInputStream stream = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
        return Json.createReader((InputStream)stream).readObject();
    }

    public static JDVView getView(String json) {
        JDVView view = new JDVView();
        JSONToPropertiesObject transformer = new JSONToPropertiesObject();
        transformer.transformToObject((PropertiesObject)view, json);
        return view;
    }

    static String getPossibleTableAlias(String name) {
        Object alias = name;
        if (name.indexOf(95) > 0) {
            String[] parts = name.split("_");
            alias = "";
            for (String part : parts) {
                alias = (String)alias + part.charAt(0);
            }
        } else {
            alias = name.substring(0, 1);
        }
        return ((String)alias).toLowerCase(Locale.ROOT);
    }

    static HashMap<String, String> createAliasesMap(JDVView view) {
        HashMap<String, String> res = new HashMap<String, String>();
        HashSet<String> aliases = new HashSet<String>();
        SqlGenerator.addAliasesToMap(res, aliases, view.getDefinition());
        return res;
    }

    static void addAliasesToMap(HashMap<String, String> idToAlias, HashSet<String> aliases, JDVElement table) {
        String tableName = StringUtils.unQuote((String)table.getName());
        String alias = table.getTableAlias();
        if (alias == null || alias.isEmpty()) {
            alias = SqlGenerator.getPossibleTableAlias(tableName);
            alias = SqlGenerator.getUniqueAlias(aliases, alias);
        }
        idToAlias.put(table.getTableId(), alias);
        aliases.add(alias);
        for (JDVElement element : table.getElements()) {
            if (!element.isTable()) continue;
            SqlGenerator.addAliasesToMap(idToAlias, aliases, element);
        }
    }

    static String getUniqueAlias(HashSet<String> aliases, String alias) {
        if (!aliases.contains(alias)) {
            return alias;
        }
        int maxTriesOnSuffix = 99;
        for (int i = 1; i <= 99; ++i) {
            String str = alias + i;
            if (aliases.contains(str)) continue;
            return str;
        }
        return alias + "991";
    }
}

