/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.dmweb;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.crest.imports.metadata.DiagramProcessor;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.StringDimension;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TVLabel;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;
import oracle.dbtools.crest.util.options.format.DefaultLineWidthAndColor;
import oracle.dbtools.crest.util.string.StringUtilities;

public class DiagramToSVG {
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND = new Color(255, 255, 180);
    public static final Color DEFAULT_DATATYPE_COLOR = new Color(0, 128, 0);
    public static final Color DEFAULT_ALLOW_NULL_COLOR = Color.RED;
    public static Font FONT_DIALOG = new Font("Dialog", 0, 10);
    public static Font FONT_ARIAL = new Font("Arial", 0, 10);
    public static final String NOT_NULL = "*";
    public static final int TYPE_LEFT = 5;
    public static final int ROW_SPACING = 3;
    public static final int MORE_ARROW_PADDING = 4;
    public static final int MORE_ARROW_WIDTH = 8;
    public static final int MORE_ARROW_HEIGHT = 8;
    public static final int COLUMN_LEFT = 25;
    public static float OPACITY_BGR = 0.15f;
    public static float OPACITY_TABLE_BGR = 0.2f;
    public static float OPACITY_ICON = 1.0f;
    public static float OPACITY_FK_ICON = 1.0f;
    public static float OPACITY_FK_LINE = 0.4f;
    public static float OPACITY_SCHEMA = 0.4f;
    public static float OPACITY_NAME = 0.8f;
    public static float OPACITY_TABLE_NAME = 1.0f;
    public static float OPACITY_PK_NAME = 1.0f;
    public static float OPACITY_BORDER = 0.1f;
    public static float OPACITY_DATA_TYPE = 0.4f;
    public static Color COLOR_TABLE = Color.decode("#FBCE4A");
    public static Color COLOR_EXT_TABLE = Color.decode("#12B6CF");
    public static Color COLOR_ORACLE_LOG_TABLE = Color.decode("#E4E4E4");
    public static Color COLOR_MVIEW = Color.decode("#5A68AD");
    public static Color COLOR_VIEW = Color.decode("#81BB5F");
    public static Color COLOR_NOTE = Color.decode("#81BB5F");
    public static Color COLOR_BLACK = Color.decode("#000000");
    public static Color COLOR_PK_NAME = Color.decode("#309FDB");
    public static Color COLOR_NNC = Color.decode("#E95B54");
    public static Color COLOR_PK_ICON = Color.decode("#ED813E");
    public static Color COLOR_UK_ICON = Color.decode("#309FDB");
    public static Color COLOR_FK_ICON = Color.decode("#3CAF85");
    public static Color COLOR_NOTNULL_ICON = Color.decode("#E95B54");
    public static String PK_PATH = "<path d=\"M418.119,331.046c4.094,4.374,7.766,8.186,10.996,11.416c3.237,3.238,6.714,6.376,10.427,9.422   c3.71,3.042,6.427,4.568,8.135,4.568c3.241,0,9.517-4.661,18.843-13.99c9.328-9.321,13.989-15.604,13.989-18.842   c0-1.523-2.714-5.421-8.138-11.704c-5.421-6.276-12.364-13.702-20.838-22.271c-8.473-8.565-16.703-16.744-24.694-24.55   c-8.001-7.81-15.8-15.373-23.417-22.703c-7.611-7.327-11.992-11.56-13.135-12.703c-1.902-1.902-4.093-2.853-6.563-2.853   c-3.237,0-9.521,4.661-18.843,13.988c-9.328,9.322-13.989,15.605-13.989,18.843c0,1.711,1.522,4.421,4.568,8.138   c3.046,3.71,6.188,7.187,9.421,10.424c3.23,3.23,7.047,6.899,11.42,10.992c4.377,4.093,6.848,6.423,7.423,6.995l-27.408,27.404   L254.954,222.268c24.94-33.498,37.408-68.236,37.408-104.211c0-31.024-9.761-56.293-29.263-75.801   c-19.512-19.511-44.778-29.265-75.805-29.265c-30.454,0-60.244,9.042-89.363,27.119c-29.121,18.083-52.727,41.686-70.808,70.808   C9.042,140.038,0,169.828,0,200.28c0,31.029,9.753,56.286,29.265,75.803c19.511,19.517,44.777,29.27,75.801,29.27   c35.976,0,70.71-12.467,104.212-37.407l191.574,191.579c5.332,5.328,11.796,7.994,19.417,7.994c7.991,0,15.704-3.72,23.12-11.14   c7.426-7.426,11.143-15.129,11.143-23.127c0-7.617-2.666-14.092-7.994-19.417l-62.811-62.811l27.405-27.404   C411.699,324.195,414.033,326.666,418.119,331.046z M221.556,161.458c-10.656,10.657-23.601,15.987-38.828,15.987   c-7.996,0-15.896-1.812-23.7-5.43c3.617,7.808,5.426,15.706,5.426,23.7c0,15.229-5.327,28.171-15.987,38.828   c-10.66,10.655-23.606,15.986-38.831,15.986c-15.227,0-28.168-5.325-38.828-15.986c-10.657-10.657-15.987-23.599-15.987-38.828   c0-15.227,5.327-28.171,15.987-38.828C81.464,146.23,94.409,140.9,109.636,140.9c7.992,0,15.893,1.809,23.695,5.424   c-3.616-7.804-5.424-15.706-5.424-23.699c0-15.227,5.327-28.171,15.987-38.828c10.66-10.657,23.604-15.987,38.831-15.987   c15.227,0,28.171,5.327,38.828,15.987c10.657,10.66,15.987,23.601,15.987,38.828C237.539,137.852,232.209,150.797,221.556,161.458z   \" fill=\"#ff8345\"/>";
    public static String FK_PATH = "<path d=\"M40.332,31.592c-2.377,0-4.515,1-6.033,2.598l-17.737-8.686c0.061-0.406,0.103-0.82,0.103-1.246    c0-0.414-0.04-0.818-0.098-1.215l17.711-8.589c1.519,1.609,3.666,2.619,6.054,2.619c4.603,0,8.333-3.731,8.333-8.333    c0-4.603-3.73-8.333-8.333-8.333s-8.333,3.73-8.333,8.333c0,0.414,0.04,0.817,0.098,1.215l-17.709,8.589    c-1.519-1.609-3.666-2.619-6.054-2.619C3.73,15.925,0,19.656,0,24.258c0,4.603,3.73,8.333,8.333,8.333    c2.377,0,4.515-1,6.033-2.596l17.736,8.685c-0.062,0.406-0.104,0.82-0.104,1.245c0,4.604,3.73,8.333,8.333,8.333    s8.333-3.729,8.333-8.333C48.665,35.322,44.935,31.592,40.332,31.592z\" fill=\"#13bf3b\"/>";
    public static String UK_PATH = "\t<polygon points=\"236.99,11.41 0,246.348 236.99,478.678 236.99,350.609 129.864,245 236.99,139.391  \" fill=\"#0064fb\"/>\n<polygon points=\"253.01,478.59 490,243.651 253.01,11.322 253.01,139.391 360.136,245 253.01,350.609  \" fill=\"#0064fb\"/>";
    static String FK_SYM_OPEN_SVG = "<svg id=\"fk_sym\" viewBox=\"0 0 48.665 48.665\" style=\"enable-background:new 0 0 48.665 48.665;\" >";
    public static String FK_SYM_SVG = FK_SYM_OPEN_SVG + "\n<g>\n" + FK_PATH + "\n</g>\n</svg>";
    public static Color FK_SYM_COLOR = new Color(19, 192, 159);
    static String PK_SYM_OPEN_SVG = "<svg id=\"pk_sym\" viewBox=\"0 0 480.509 480.509\" style=\"enable-background:new 0 0 480.509 480.509;\" >";
    public static String PK_SYM_SVG = PK_SYM_OPEN_SVG + "\n<g>\n" + PK_PATH + "\n</g>\n</svg>";
    public static Color PK_SYM_COLOR = new Color(255, 131, 69);
    static String UK_SYM_OPEN_SVG = "<svg id=\"uk_sym\" viewBox=\"0 0 490 490\" style=\"enable-background:new 0 0 490 490;\" >";
    public static String UK_SYM_SVG = UK_SYM_OPEN_SVG + "\n<g>\n" + UK_PATH + "\n</g>\n</svg>";
    public static Color UK_SYM_COLOR = new Color(0, 100, 251);
    public static String CSS_CLASS_TABLE_NAME = "t_name";
    public static String CSS_CLASS_COLUMN_NAME = "c_name";
    public static String CSS_CLASS_COLUMN_DT = "column_dt";
    public static String CSS_CLASS_PK_NAME = "pk_name";
    public static String CSS_CLASS_NNC = "nnc";
    public static String STYLE = "<style type=\"text/css\" >\n <![CDATA[ \n text.c_name,text.column_dt,text.pk_name,text.nnc,text.t_name  { stroke: none; \n    fill: black; \n    fill-opacity: 0.8; \n     font-size: 10; }\n text.column_dt{ fill-opacity: 0.4; }\n text.pk_name{ fill: #309FDB; fill-opacity: 1.0; }\n text.nnc{ fill: #E95B54; fill-opacity: 1.0; }\n text.t_name{ fill-opacity: 1.0; }\n ]]>\n </style>";
    public static final String ALLOW_NULL = "";
    public static String SHAPE_TYPE_TABLE = "table";
    public static String SHAPE_TYPE_VIEW = "view";
    public static String SHAPE_TYPE_NOTE = "note";
    public static final int TITLE_PADDING = 3;
    public static String THUMBNAIL_TEST = "<figure>\n  <figcaption>25x25</figcaption>\n  <div>\n    <svg viewBox=\"0 0 def_width def_height\" width=\"25\" height=\"25\">\n      <use xlink:href=\"#diagramxxxid\"/>\n    </svg>\n  </div>\n</figure>\n<figure>\n  <figcaption>50x25</figcaption>\n  <div>\n    <svg viewBox=\"0 0 def_width def_height\" width=\"50\" height=\"25\">\n      <use xlink:href=\"#diagramxxxid\"/>\n    </svg>\n  </div>\n</figure>\n<figure>\n  <figcaption>50x50</figcaption>\n  <div>\n    <svg viewBox=\"0 0 def_width def_height\" width=\"50\" height=\"50\">\n      <use xlink:href=\"#diagramxxxid\"/>\n    </svg>\n  </div>\n</figure>\n<figure>\n  <figcaption>100x50</figcaption>\n  <div>\n    <svg viewBox=\"0 0 def_width def_height\" width=\"100\" height=\"50\">\n      <use xlink:href=\"#diagramxxxid\"/>\n    </svg>\n  </div>\n</figure>\n<figure>\n  <figcaption>100x100</figcaption>\n  <div>\n    <svg viewBox=\"0 0 def_width def_height\" width=\"100\" height=\"100\">\n      <use xlink:href=\"#diagramxxxid\"/>\n    </svg>\n  </div>\n</figure>\n<figure>\n  <figcaption>200x100</figcaption>\n  <div>\n    <svg viewBox=\"0 0 def_width def_height\" width=\"200\" height=\"100\">\n      <use xlink:href=\"#diagramxxxid\"/>\n    </svg>\n  </div>\n</figure>\n<figure>\n  <figcaption>200x200</figcaption>\n  <div>\n    <svg viewBox=\"0 0 def_width def_height\" width=\"200\" height=\"200\">\n      <use xlink:href=\"#diagramxxxid\"/>\n    </svg>\n  </div>\n</figure>\n<figure>\n  <figcaption>Real Size</figcaption>\n  <div>\n    <svg viewBox=\"0 0 def_width def_height\" width=\"def_width\" height=\"def_height\">\n      <use xlink:href=\"#diagramxxxid\"/>\n    </svg>\n  </div>\n</figure>";
    protected transient Color defaultForeground;
    protected transient Color defaultBackground;
    protected transient Color bordercolor;
    protected transient Color datatypeColor;
    protected transient Color allowNullColor;
    protected transient Color typeColor;
    Table table;
    TopView tv;
    Writer sb;
    DesignPartView dpv;
    Graphics2D g;
    private static final int LEFT_SIDE = 0;
    private static final int TOP_SIDE = 1;
    private static final int RIGHT_SIDE = 2;
    private static final int BOTTOM_SIDE = 3;

    public static void generateTableView(AbstractView table, TopView tv, Writer sb, Graphics2D g, boolean createLinks, String id_suffix, boolean dmwebdef) {
        Object keyName;
        int keyIconYOffset;
        Iterator it;
        int[] yPts;
        int[] xPts;
        int top;
        int bottom;
        int center;
        DesignPartView dpv = tv.getDesignPartView();
        Color bgcol = DiagramToSVG.getBackgroundColor(table, tv, dmwebdef);
        Color fgcol = DiagramToSVG.getTableForegroundColor(table, tv);
        Color bcol = DiagramToSVG.getBorderColor(table, tv);
        float bgopacity = (float)bgcol.getAlpha() / 255.0f;
        float fgopacity = (float)fgcol.getAlpha() / 255.0f;
        int borderWidth = 1;
        Rectangle bounds = null;
        bounds = tv.getBounds();
        if (dmwebdef) {
            bcol = COLOR_BLACK;
        }
        int titlePosition = 20;
        int yCursor = 0;
        int xCursor = 0;
        int width = bounds.width;
        int height = bounds.height;
        Object longName = null;
        if (tv != null) {
            longName = tv.toString();
            if (tv.getDesignPartView().showSchemaName() && table.getSchemaObject() != null) {
                longName = table.getSchemaObject().getName() + "." + (String)longName;
            }
        }
        if (table.isBST()) {
            longName = (String)longName + " (" + table.getBasedOnStructuredTypeName() + ")";
        }
        String cid = DiagramToSVG.getClipPathID(tv);
        DiagramToSVG.addWhiteLayer(bounds, sb, cid, 20, 20);
        DiagramToSVG.addShape(bgcol, bcol, bounds, sb, cid, bgopacity, fgopacity);
        DiagramToSVG.addRect(fgcol, width, height, 20, 20, sb, fgopacity);
        Font titleFont = DiagramToSVG.getTitleFont(table, tv);
        Font keyFont = DiagramToSVG.getFont(table, tv, EditableFonts.FO_KEY);
        StringDimension fm = DiagramToSVG.getStringDimension(titleFont);
        int colTextHeight = fm.getHeight();
        yCursor = Math.max(colTextHeight, titleFont.getSize());
        xCursor = (width - fm.stringWidth((String)longName)) / 2;
        if (xCursor < titlePosition) {
            xCursor = titlePosition;
        }
        Color tcolor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_TITLE);
        String[] wrappedTitle = DiagramToSVG.wrapText((String)longName, DiagramToSVG.getMaxChars((String)longName, fm, width - titlePosition - 5));
        for (int t = 0; t < wrappedTitle.length; ++t) {
            String text = wrappedTitle[t];
            if (t == 0) {
                String id = table.getShortObjectID() + id_suffix;
                if (dmwebdef) {
                    DiagramToSVG.addTextWithClass(text, xCursor, yCursor, sb, CSS_CLASS_TABLE_NAME, createLinks, table.getShortObjectID(), id);
                } else {
                    DiagramToSVG.addText(text, xCursor, yCursor, tcolor, sb, titleFont, createLinks, table.getShortObjectID(), id, table.isDeprecated());
                }
            } else if (dmwebdef) {
                DiagramToSVG.addTextWithClass(text, xCursor, yCursor, sb, CSS_CLASS_TABLE_NAME);
            } else {
                DiagramToSVG.addText(text, xCursor, yCursor, tcolor, sb, titleFont);
            }
            yCursor += colTextHeight;
        }
        yCursor -= colTextHeight;
        DiagramToSVG.addLine(0, yCursor += 3 + borderWidth, width - 2, yCursor, bcol, sb, fgopacity);
        ArrayList<ContainedObject> visibleColumns = new ArrayList<ContainedObject>();
        TypeSubstitution ts = table.getTypeSubstitution();
        ContainerObject co = null;
        if (ts != null) {
            co = ts.getParentContainerObject();
        }
        if (co != null) {
            for (ContainedObject column : table.getElementsCollection()) {
                if (co.getElementByName(column.getName()) != null) continue;
                visibleColumns.add(column);
            }
        } else {
            visibleColumns.addAll(table.getElementsCollection());
        }
        ContainedObject[] elements = visibleColumns.toArray(new ContainedObject[0]);
        String longestName = DesignPartView.getLongestName(elements, dpv.isExpandComplexTypes());
        Font colFont = DiagramToSVG.getFont(table, tv, EditableFonts.FO_ELEMENT);
        fm = DiagramToSVG.getStringDimension(colFont);
        int nameSize = fm.stringWidth(longestName);
        int nnPos = fm.stringWidth("KW");
        int namePos = 3 + fm.stringWidth("KWN");
        int dtPos = 20 + namePos + nameSize;
        Color nnColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_NOT_NULL);
        Color pkColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_PK);
        Color ukColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_UK);
        Color fkColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_FK);
        Color dtColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_DATATYPE);
        Color elemColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_ELEMENT);
        Color keyColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_KEY);
        colTextHeight = fm.getHeight();
        if (table.getBasedOnStructuredType() != null && table.getTypeSubstitution() != null) {
            StructuredType st = table.getBasedOnStructuredType();
            if (st != null) {
                TypeElement[] elems = st.getElements();
                longestName = DesignPartView.getLongestTypeName(elems);
                colTextHeight = fm.getMaxAscent() - fm.getMaxDescent() + 3;
                for (int i = 0; i < elems.length; ++i) {
                    TypeElement elm = elems[i];
                    yCursor += fm.getHeight();
                    if (dmwebdef) {
                        DiagramToSVG.addTextWithClass(elm.getName(), 25, yCursor, sb, CSS_CLASS_COLUMN_NAME);
                    } else {
                        DiagramToSVG.addText(elm.getName(), 25, yCursor, elemColor, sb, colFont);
                    }
                    int anLeft = fm.stringWidth(longestName) + 50;
                    if (dmwebdef) {
                        DiagramToSVG.addTextWithClass(elm.getDataType(), anLeft, yCursor, sb, CSS_CLASS_COLUMN_DT);
                        continue;
                    }
                    DiagramToSVG.addText(elm.getDataType(), anLeft, yCursor, dtColor, sb, colFont);
                }
            }
        } else {
            for (int i = 0; i < elements.length; ++i) {
                boolean partOfFK;
                String text;
                ContainedObjectWithDomain element = (ContainedObjectWithDomain)elements[i];
                if (element.isOid() || dpv.showKeyElements() && !element.isPKElement() && !element.isFKElement() && !element.isUnique()) continue;
                yCursor += fm.getHeight();
                int anLeft = nnPos;
                String string = text = element.getNullsAllowed() ? ALLOW_NULL : NOT_NULL;
                if (!text.isEmpty()) {
                    if (dmwebdef) {
                        DiagramToSVG.addTextWithClass(text, anLeft, yCursor, sb, CSS_CLASS_NNC);
                    } else {
                        DiagramToSVG.addText(text, anLeft, yCursor, nnColor, sb, colFont);
                    }
                }
                boolean key = false;
                String type = " ";
                Color color = elemColor;
                boolean bl = partOfFK = table instanceof FKContainer && element.isPartOfUnresolvedFK(table);
                if (element.isPKElement()) {
                    type = "P";
                    color = pkColor;
                    key = true;
                    if (element.isFKElement() || partOfFK) {
                        type = type.concat("F");
                    }
                } else if (element.isUnique()) {
                    type = "U";
                    color = ukColor;
                    key = true;
                    if (element.isFKElement() || partOfFK) {
                        type = type.concat("F");
                    }
                } else if (element.isFKElement() || partOfFK) {
                    type = "F";
                    color = fkColor;
                }
                if (!" ".equals(type)) {
                    if (dmwebdef) {
                        if (key) {
                            DiagramToSVG.addTextWithClass(type, anLeft, yCursor, sb, CSS_CLASS_PK_NAME);
                        } else {
                            DiagramToSVG.addTextWithClass(type, anLeft, yCursor, sb, CSS_CLASS_TABLE_NAME);
                        }
                    } else {
                        DiagramToSVG.addText(type, 5, yCursor, color, sb, colFont);
                    }
                }
                anLeft = namePos;
                if (dmwebdef) {
                    DiagramToSVG.addTextWithClass(element.getName(), anLeft, yCursor, sb, key ? CSS_CLASS_PK_NAME : CSS_CLASS_COLUMN_NAME);
                } else {
                    DiagramToSVG.addText(element.getName(), anLeft, yCursor, elemColor, sb, colFont);
                }
                if (dpv.showAllDetails() || dpv.showDatatype()) {
                    anLeft = dtPos;
                    if (dmwebdef) {
                        DiagramToSVG.addTextWithClass(DiagramToSVG.getDataType(element, table).toUpperCase(), anLeft, yCursor, sb, CSS_CLASS_COLUMN_DT);
                    } else {
                        DiagramToSVG.addText(DiagramToSVG.getDataType(element, table).toUpperCase(), anLeft, yCursor, dtColor, sb, colFont);
                    }
                }
                if (yCursor <= height) continue;
                int right = width - 4;
                int left = right - 8;
                center = right - 4;
                bottom = height - 4;
                top = bottom - 8;
                xPts = new int[]{center, left, right};
                yPts = new int[]{bottom, top, top};
                DiagramToSVG.addPolygon(fgcol, xPts, yPts, 1, sb, true);
                break;
            }
        }
        if (dpv.showAllDetails() || dpv.showKeys()) {
            List keys = DiagramToSVG.getKeys(table.getKeys());
            it = null;
            if (keys.size() > 0) {
                if (dpv.showAllDetails() || dpv.showElements()) {
                    yCursor += 6;
                    it = keys.iterator();
                    if (it.hasNext()) {
                        g.drawLine(0, yCursor, width - 2, yCursor);
                        DiagramToSVG.addLine(0, yCursor, width - 2, yCursor, bcol, sb, fgopacity);
                    }
                }
                for (KeyObject key : keys) {
                    if (!key.isPK() && !key.isUnique()) continue;
                    int LEFT = 4;
                    fm = DiagramToSVG.getStringDimension(keyFont);
                    yCursor += fm.getHeight();
                    keyIconYOffset = -fm.getHeight() / 2;
                    if (key.isPK()) {
                        DiagramToSVG.addUseOfDef("pk_sym", LEFT, yCursor + keyIconYOffset, 8, 8, sb);
                    } else {
                        DiagramToSVG.addUseOfDef("uk_sym", LEFT, yCursor + keyIconYOffset, 8, 8, sb);
                    }
                    keyName = key.getName();
                    if (dpv.showAllDetails() || dpv.showKeyAndIndexColumns()) {
                        Index ind;
                        ContainedObject[] columns = key.getElements();
                        keyName = (String)keyName + " (";
                        String expr = null;
                        if (key instanceof Index && ALLOW_NULL.equals(expr = (ind = (Index)key).getIndexExpression())) {
                            expr = null;
                        }
                        if (expr == null) {
                            for (int j = 0; j < columns.length; ++j) {
                                ContainedObject column = columns[j];
                                String colName = column.getName();
                                if (j > 0) {
                                    keyName = (String)keyName + ", ";
                                }
                                keyName = (String)keyName + colName;
                            }
                        } else {
                            keyName = (String)keyName + expr;
                        }
                        keyName = (String)keyName + ")";
                    }
                    int xname = nnPos;
                    if (dmwebdef) {
                        DiagramToSVG.addTextWithClass((String)keyName, xname, yCursor, sb, CSS_CLASS_COLUMN_NAME);
                    } else {
                        DiagramToSVG.addText((String)keyName, xname, yCursor, keyColor, sb, keyFont);
                    }
                    if (yCursor <= height) continue;
                    int right = width - 4;
                    int left = right - 8;
                    int center2 = right - 4;
                    int bottom2 = height - 4;
                    int top2 = bottom2 - 8;
                    int[] xPts2 = new int[]{center2, left, right};
                    int[] yPts2 = new int[]{bottom2, top2, top2};
                    DiagramToSVG.addPolygon(fgcol, xPts2, yPts2, 1, sb, true);
                    break;
                }
            }
        }
        if (dpv instanceof DPVRelational && (dpv.showAllDetails() || dpv.showFKeys())) {
            List fKeys = DiagramToSVG.getFKeys(table.getKeys());
            it = null;
            if (fKeys.size() > 0) {
                if (dpv.showAllDetails() || dpv.showElements()) {
                    yCursor += 6;
                    it = fKeys.iterator();
                    if (it.hasNext()) {
                        DiagramToSVG.addLine(0, yCursor, width - 2, yCursor, bcol, sb, fgopacity);
                    }
                }
                for (KeyObject key : fKeys) {
                    int LEFT = 4;
                    fm = DiagramToSVG.getStringDimension(keyFont);
                    keyIconYOffset = -fm.getHeight() / 2;
                    DiagramToSVG.addUseOfDef("fk_sym", LEFT, (yCursor += fm.getHeight()) + keyIconYOffset, 8, 8, sb);
                    keyName = key.getName();
                    if (dpv.showAllDetails() || dpv.showKeyAndIndexColumns()) {
                        Index ind;
                        ContainedObject[] columns = key.getElements();
                        keyName = (String)keyName + " (";
                        String expr = null;
                        if (key instanceof Index && ALLOW_NULL.equals(expr = (ind = (Index)key).getIndexExpression())) {
                            expr = null;
                        }
                        if (expr == null) {
                            for (int j = 0; j < columns.length; ++j) {
                                ContainedObject column = columns[j];
                                String colName = column.getName();
                                if (j > 0) {
                                    keyName = (String)keyName + ", ";
                                }
                                keyName = (String)keyName + colName;
                            }
                        } else {
                            keyName = (String)keyName + expr;
                        }
                        keyName = (String)keyName + ")";
                    }
                    int xname = nnPos;
                    FKIndexAssociation fk = key.getFKAssociation();
                    if (fk != null) {
                        FKContainer rcont = fk.getRemoteTable();
                        String rname = null;
                        rname = rcont != null ? rcont.getLongName() : fk.getReferredTableLongName();
                        if (dmwebdef) {
                            DiagramToSVG.addTextWithClass((String)keyName, xname, yCursor, sb, CSS_CLASS_COLUMN_NAME, createLinks, rname, null);
                        } else {
                            DiagramToSVG.addText((String)keyName, xname, yCursor, keyColor, sb, keyFont, createLinks, rname, null);
                        }
                    } else if (dmwebdef) {
                        DiagramToSVG.addTextWithClass((String)keyName, xname, yCursor, sb, CSS_CLASS_NNC);
                    } else {
                        DiagramToSVG.addText((String)keyName, xname, yCursor, keyColor, sb, keyFont);
                    }
                    if (yCursor <= height) continue;
                    int right = width - 4;
                    int left = right - 8;
                    center = right - 4;
                    bottom = height - 4;
                    top = bottom - 8;
                    xPts = new int[]{center, left, right};
                    yPts = new int[]{bottom, top, top};
                    DiagramToSVG.addPolygon(fgcol, xPts, yPts, 1, sb, true);
                    break;
                }
            }
        }
        int COLUMN_LEFT = 10;
        if (dpv.showAllDetails()) {
            String name;
            List usedContainers = null;
            if (!table.isIncorrectSQL() && !table.getUsedTablesAndViews().isEmpty()) {
                usedContainers = table.getUsedTablesAndViews();
                if (usedContainers.size() > 0) {
                    int p = colTextHeight / 5;
                    DiagramToSVG.addLine(0, yCursor += 3 + borderWidth + p, width - 2, yCursor, fgcol, sb, fgopacity);
                    fm = DiagramToSVG.getStringDimension(colFont);
                    for (SQLNameHelper helper : usedContainers) {
                        yCursor += 3 + fm.getMaxAscent();
                        name = helper.getFullName();
                        if (dmwebdef) {
                            DiagramToSVG.addTextWithClass(name, COLUMN_LEFT, yCursor, sb, CSS_CLASS_COLUMN_NAME);
                            continue;
                        }
                        DiagramToSVG.addText(name, COLUMN_LEFT, yCursor, elemColor, sb, colFont, createLinks, name, null);
                    }
                }
            } else {
                usedContainers = table.getUsedContainers();
                if (usedContainers.size() > 0) {
                    int p = colTextHeight / 5;
                    DiagramToSVG.addLine(0, yCursor += 3 + borderWidth + p, width - 2, yCursor, fgcol, sb, fgopacity);
                    for (AbstractView.ContainerHolder holder : usedContainers) {
                        yCursor += 3 + fm.getMaxAscent();
                        name = holder.getContainer().getLongName();
                        if (dmwebdef) {
                            DiagramToSVG.addTextWithClass(name, COLUMN_LEFT, yCursor, sb, CSS_CLASS_COLUMN_NAME);
                            continue;
                        }
                        DiagramToSVG.addText(name, COLUMN_LEFT, yCursor, elemColor, sb, colFont, createLinks, name, null);
                    }
                }
            }
        }
        try {
            sb.write("\n</g>");
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    public static int paintStructuredType(DesignPartView dpv, ContainerObject container, Writer sb, Graphics g, StructuredType st, int level, int yCursor, Color fgcol, Color elemColor, Color nnColor, int dtPos, String rdbms, Font colFont, Color dtColor) {
        StringDimension fm = DiagramToSVG.getStringDimension(colFont);
        int nnPos = fm.stringWidth("KW");
        if (dpv.showAllDetails() || dpv.showDatatype()) {
            // empty if block
        }
        if (dpv != null) {
            TypeElement[] elements = st.getElements();
            for (int i = 0; i < elements.length; ++i) {
                TypeElement te;
                CollectionType ct;
                ContainedObject co;
                TypeElement elm = elements[i];
                yCursor += fm.getHeight();
                boolean mand = elm.isMandatory();
                if (!mand && container != null && (co = container.getNestedElementByStructAttributeID(elm.getObjectID())) != null) {
                    mand = co.isMandatory();
                }
                if (mand) {
                    DiagramToSVG.addText(NOT_NULL, nnPos, yCursor, nnColor, sb, colFont);
                }
                if (StructuredType.UNIONTYPE.equalsIgnoreCase(st.getHiveType())) {
                    DiagramToSVG.addText(">" + elm.getName(), 25 + 12 * level, yCursor, elemColor, sb, colFont);
                } else {
                    DiagramToSVG.addText(elm.getName(), 25 + 12 * level, yCursor, elemColor, sb, colFont);
                }
                if (dpv.showAllDetails() || dpv.showDatatype()) {
                    DiagramToSVG.addText(elm.getDataType(rdbms), dtPos, yCursor, fgcol, sb, colFont);
                }
                if (elm.getType() instanceof StructuredType && !elm.isReference()) {
                    StructuredType st2 = (StructuredType)elm.getType();
                    if (st2 == null) continue;
                    yCursor = DiagramToSVG.paintStructuredType(dpv, container, sb, g, st2, level + 1, yCursor, fgcol, elemColor, nnColor, dtPos, rdbms, colFont, dtColor);
                    continue;
                }
                if (!(elm.getType() instanceof CollectionType) || elm.isReference() || (ct = (CollectionType)elm.getType()) == null || !((te = ct.getElementType()).getType() instanceof StructuredType) || te.isReference()) continue;
                yCursor = DiagramToSVG.paintStructuredType(dpv, container, sb, g, (StructuredType)te.getType(), level + 1, yCursor, fgcol, elemColor, nnColor, dtPos, rdbms, colFont, dtColor);
            }
        }
        return yCursor;
    }

    public static void generateTable(ContainerWithKeyObject table, TopView tv, Writer sb, Graphics2D g, boolean createLinks, String id_suffix, boolean dmwebdef) {
        DesignPartView dpv = tv.getDesignPartView();
        Color bgcol = DiagramToSVG.getBackgroundColor(table, tv, dmwebdef);
        Color fgcol = DiagramToSVG.getTableForegroundColor(table, tv);
        Color bcol = DiagramToSVG.getBorderColor(table, tv);
        float bgopacity = (float)bgcol.getAlpha() / 255.0f;
        float fgopacity = (float)fgcol.getAlpha() / 255.0f;
        int borderWidth = 1;
        Rectangle bounds = null;
        bounds = tv.getBounds();
        int titlePosition = 20;
        int yCursor = 0;
        int xCursor = 0;
        int width = bounds.width;
        int height = bounds.height;
        Object longName = null;
        if (tv != null) {
            longName = tv.toString();
            if (tv.getDesignPartView().showSchemaName() && table.getSchemaObject() != null) {
                longName = table.getSchemaObject().getName() + "." + (String)longName;
            }
        }
        if (table.isBST()) {
            longName = (String)longName + " (" + table.getBasedOnStructuredTypeName() + ")";
        }
        String cid = DiagramToSVG.getClipPathID(tv);
        DiagramToSVG.addWhiteLayer(bounds, sb, cid, 0, 0);
        DiagramToSVG.addShape(bgcol, bcol, bounds, sb, cid, bgopacity, fgopacity);
        DiagramToSVG.addRect(fgcol, width, height, 0, 0, sb, fgopacity);
        Font titleFont = DiagramToSVG.getTitleFont(table, tv);
        if (dmwebdef) {
            titleFont = new Font("Arial", titleFont.getStyle(), titleFont.getSize());
        }
        Font keyFont = DiagramToSVG.getFont(table, tv, EditableFonts.FO_KEY);
        if (dmwebdef) {
            keyFont = new Font("Arial", keyFont.getStyle(), keyFont.getSize());
        }
        StringDimension fm = DiagramToSVG.getStringDimension(titleFont);
        int colTextHeight = fm.getHeight();
        yCursor = Math.max(colTextHeight, titleFont.getSize());
        xCursor = (width - fm.stringWidth((String)longName)) / 2;
        if (xCursor < titlePosition) {
            xCursor = titlePosition;
        }
        Color tcolor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_TITLE);
        String[] wrappedTitle = DiagramToSVG.wrapText((String)longName, DiagramToSVG.getMaxChars((String)longName, fm, width - titlePosition - 5));
        for (int t = 0; t < wrappedTitle.length; ++t) {
            String text = wrappedTitle[t];
            if (t == 0) {
                String id = table.getShortObjectID() + id_suffix;
                if (dmwebdef) {
                    DiagramToSVG.addTextWithClass(text, xCursor, yCursor, sb, CSS_CLASS_TABLE_NAME, createLinks, table.getShortObjectID(), id);
                } else {
                    DiagramToSVG.addText(text, xCursor, yCursor, tcolor, sb, titleFont, createLinks, table.getShortObjectID(), id, table.isDeprecated());
                }
            } else if (dmwebdef) {
                DiagramToSVG.addTextWithClass(text, xCursor, yCursor, sb, CSS_CLASS_TABLE_NAME);
            } else {
                DiagramToSVG.addText(text, xCursor, yCursor, tcolor, sb, titleFont);
            }
            yCursor += colTextHeight;
        }
        if (tv.getHiddenElements().size() > 0) {
            int right = width - 4;
            int left = right - 8;
            int center = right - 4;
            int[] xPts = new int[]{center, left, right};
            int[] yPts = new int[]{2, 10, 10};
            DiagramToSVG.addPolygon(fgcol, xPts, yPts, 1, sb, true);
        }
        yCursor -= colTextHeight;
        yCursor += 3 + borderWidth;
        ContainedObject[] elements = table.getElements();
        String longestName = DesignPartView.getLongestName(elements, dpv.isExpandComplexTypes());
        String longestDTName = DesignPartView.getLongestDTName(elements, table, dpv.isExpandComplexTypes());
        Font colFont = DiagramToSVG.getFont(table, tv, EditableFonts.FO_ELEMENT);
        Font comFont = DiagramToSVG.getFont(table, tv, EditableFonts.FO_COMMENTS);
        colFont = new Font("Arial", colFont.getStyle(), colFont.getSize());
        fm = DiagramToSVG.getStringDimension(colFont);
        int nameSize = fm.stringWidth(longestName);
        int dtNameSize = fm.stringWidth(longestDTName);
        int nnPos = fm.stringWidth("KW");
        int namePos = 3 + fm.stringWidth("KWN");
        int dtPos = 20 + namePos + nameSize;
        int cPos = 20 + namePos + nameSize;
        if (dpv.showAllDetails() || dpv.showDatatype()) {
            cPos = 20 + dtPos + dtNameSize;
        }
        Color nnColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_NOT_NULL);
        Color pkColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_PK);
        Color ukColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_UK);
        Color fkColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_FK);
        Color dtColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_DATATYPE);
        if (dmwebdef) {
            dtColor = COLOR_BLACK;
        }
        Color comColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_COMMENTS);
        Color elemColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_ELEMENT);
        Color keyColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_KEY);
        colTextHeight = fm.getHeight();
        if (!dpv.isShowNamesOnly()) {
            List keys;
            int xname;
            KeyObject key3;
            Iterator it;
            int[] yPts;
            int[] xPts;
            int top;
            int bottom;
            int center;
            DiagramToSVG.addLine(0, yCursor, width - 2, yCursor, bcol, sb, fgopacity);
            if (dpv.isShowClassificationTypes() && table instanceof ContainerWithKeyObject) {
                ContainerWithKeyObject cwk = table;
                String clname = ALLOW_NULL;
                ClassificationType ct = cwk.getClassificationType();
                if (ct != null) {
                    clname = ct.getTypeName();
                }
                Object clnames = ALLOW_NULL;
                List<String> list = cwk.getAdd_ClassificationTypeNames();
                for (int k = 0; k < list.size(); ++k) {
                    clnames = k > 0 ? (String)clnames + ", " + list.get(k) : list.get(0);
                }
                if (!ALLOW_NULL.equals(clname) || !ALLOW_NULL.equals(clnames)) {
                    Object types = !ALLOW_NULL.equals(clname) ? clname + " / " : "- / ";
                    types = !ALLOW_NULL.equals(clnames) ? (String)types + (String)clnames : (String)types + "-";
                    xCursor = (width - fm.stringWidth((String)types)) / 2;
                    if (xCursor < titlePosition) {
                        xCursor = titlePosition;
                    }
                    DiagramToSVG.addText((String)types, xCursor, yCursor += colTextHeight, tcolor, sb, titleFont);
                    DiagramToSVG.addLine(0, yCursor += 3 + borderWidth, width - 2, yCursor, fgcol, sb);
                }
            }
            if (table.isBST() && table.getTypeSubstitution() != null) {
                StructuredType st = table.getBasedOnStructuredType();
                if (st != null) {
                    TypeElement[] elems = st.getElements();
                    longestName = DesignPartView.getLongestTypeName(elems);
                    colTextHeight = fm.getMaxAscent() - fm.getMaxDescent() + 3;
                    for (int i = 0; i < elems.length; ++i) {
                        TypeElement elm = elems[i];
                        yCursor += fm.getHeight();
                        if (dmwebdef) {
                            DiagramToSVG.addTextWithClass(elm.getName(), 25, yCursor, sb, CSS_CLASS_COLUMN_NAME);
                        } else {
                            DiagramToSVG.addText(elm.getName(), 25, yCursor, elemColor, sb, colFont);
                        }
                        int anLeft = fm.stringWidth(longestName) + 50;
                        if (dmwebdef) {
                            DiagramToSVG.addTextWithClass(elm.getDataType(), anLeft, yCursor, sb, CSS_CLASS_COLUMN_DT);
                            continue;
                        }
                        DiagramToSVG.addText(elm.getDataType(), anLeft, yCursor, dtColor, sb, colFont);
                    }
                }
            } else {
                for (int i = 0; i < elements.length; ++i) {
                    TypeElement te;
                    CollectionType ct;
                    String com;
                    boolean partOfFK;
                    String text;
                    ContainedObjectWithDomain element = (ContainedObjectWithDomain)elements[i];
                    if (element.isOid() || dpv.showKeyElements() && !element.isPKElement() && !element.isFKElement() && !element.isUnique()) continue;
                    yCursor += fm.getHeight();
                    int anLeft = nnPos + 2;
                    String string = text = element.getNullsAllowed() ? ALLOW_NULL : NOT_NULL;
                    if (!text.isEmpty()) {
                        if (dmwebdef) {
                            DiagramToSVG.addTextWithClass(text, anLeft, yCursor, sb, CSS_CLASS_NNC);
                        } else {
                            DiagramToSVG.addText(text, anLeft, yCursor, nnColor, sb, colFont);
                        }
                    }
                    String type = " ";
                    Color color = elemColor;
                    boolean key2 = false;
                    boolean bl = partOfFK = table instanceof FKContainer && element.isPartOfUnresolvedFK((FKContainer)table);
                    if (element.isPKElement()) {
                        type = "P";
                        color = pkColor;
                        key2 = true;
                        if (element.isFKElement() || partOfFK) {
                            type = type.concat("F");
                        }
                    } else if (element.isUnique()) {
                        type = "U";
                        color = ukColor;
                        key2 = true;
                        if (element.isFKElement() || partOfFK) {
                            type = type.concat("F");
                        }
                    } else if (element.isFKElement() || partOfFK) {
                        type = "F";
                        color = fkColor;
                    }
                    if (!" ".equals(type)) {
                        if (dmwebdef) {
                            if (key2) {
                                DiagramToSVG.addTextWithClass(type, 5, yCursor, sb, CSS_CLASS_PK_NAME);
                            } else {
                                DiagramToSVG.addTextWithClass(type, 5, yCursor, sb, CSS_CLASS_TABLE_NAME);
                            }
                        } else {
                            DiagramToSVG.addText(type, 5, yCursor, color, sb, colFont, false, null, null, OPACITY_ICON, false);
                        }
                    }
                    anLeft = namePos;
                    if (dmwebdef) {
                        DiagramToSVG.addTextWithClass(element.getName(), anLeft, yCursor, sb, key2 ? CSS_CLASS_PK_NAME : CSS_CLASS_COLUMN_NAME);
                    } else {
                        DiagramToSVG.addText(element.getName(), anLeft, yCursor, elemColor, sb, colFont);
                    }
                    if (dpv.showAllDetails() || dpv.showDatatype()) {
                        anLeft = dtPos;
                        if (dmwebdef) {
                            DiagramToSVG.addTextWithClass(DiagramToSVG.getDataType(element, table).toUpperCase(), anLeft, yCursor, sb, CSS_CLASS_COLUMN_DT);
                        } else {
                            DiagramToSVG.addText(DiagramToSVG.getDataType(element, table).toUpperCase(), anLeft, yCursor, dtColor, sb, colFont, false, null, null, OPACITY_TABLE_NAME, false);
                        }
                    }
                    if (dpv.showComments() && !(com = element.getCommentInRDBMS()).isEmpty()) {
                        anLeft = cPos;
                        if (dmwebdef) {
                            DiagramToSVG.addTextWithClass(com, anLeft, yCursor, sb, CSS_CLASS_COLUMN_NAME);
                        } else {
                            DiagramToSVG.addText(com, anLeft, yCursor, comColor, sb, colFont);
                        }
                    }
                    if (yCursor > height) {
                        int right = width - 4;
                        int left = right - 8;
                        center = right - 4;
                        bottom = height - 4;
                        top = bottom - 8;
                        xPts = new int[]{center, left, right};
                        yPts = new int[]{bottom, top, top};
                        DiagramToSVG.addPolygon(fgcol, xPts, yPts, 1, sb, true);
                        break;
                    }
                    if (dpv.isExpandComplexTypes() && element.getUse() == 3) {
                        StructuredType st = element.getStructuredType();
                        if (st == null) continue;
                        yCursor = DiagramToSVG.paintStructuredType(dpv, table, sb, g, st, 1, yCursor, fgcol, elemColor, nnColor, dtPos, table.getSelectedRDBMSType().toString(), colFont, dtColor);
                        continue;
                    }
                    if (!dpv.isExpandComplexTypes() || element.getUse() != 4 || (ct = element.getCollectionType()) == null || !((te = ct.getElementType()).getType() instanceof StructuredType) || te.isReference()) continue;
                    yCursor = DiagramToSVG.paintStructuredType(dpv, table, sb, g, (StructuredType)te.getType(), 1, yCursor, fgcol, elemColor, nnColor, dtPos, table.getSelectedRDBMSType().toString(), colFont, dtColor);
                }
            }
            if (dpv.showAllDetails() || dpv.showKeys()) {
                List keys2 = DiagramToSVG.getKeys(table.getKeys());
                it = null;
                if (keys2.size() > 0) {
                    if (dpv.showAllDetails() || dpv.showElements() || dpv.showKeyElements()) {
                        yCursor += 6;
                        it = keys2.iterator();
                        if (it.hasNext()) {
                            DiagramToSVG.addLine(0, yCursor, width - 2, yCursor, bcol, sb, fgopacity);
                        }
                    }
                    it = keys2.iterator();
                    while (it.hasNext()) {
                        key3 = (KeyObject)it.next();
                        if (!key3.isPK() && !key3.isUnique()) continue;
                        int LEFT = 4;
                        fm = DiagramToSVG.getStringDimension(keyFont);
                        yCursor += fm.getHeight();
                        int keyIconYOffset = -fm.getHeight() / 2;
                        if (key3.isPK()) {
                            DiagramToSVG.addUseOfDef("pk_sym", LEFT, yCursor + keyIconYOffset, 8, 8, sb);
                        } else {
                            DiagramToSVG.addUseOfDef("uk_sym", LEFT, yCursor + keyIconYOffset, 8, 8, sb);
                        }
                        Object keyName = key3.getName();
                        if (dpv.showAllDetails() || dpv.showKeyAndIndexColumns()) {
                            Index ind;
                            ContainedObject[] columns = key3.getElements();
                            keyName = (String)keyName + " (";
                            String expr = null;
                            if (key3 instanceof Index && ALLOW_NULL.equals(expr = (ind = (Index)key3).getIndexExpression())) {
                                expr = null;
                            }
                            if (expr == null) {
                                for (int j = 0; j < columns.length; ++j) {
                                    ContainedObject column = columns[j];
                                    String colName = column.getName();
                                    if (j > 0) {
                                        keyName = (String)keyName + ", ";
                                    }
                                    keyName = (String)keyName + colName;
                                }
                            } else {
                                keyName = (String)keyName + expr;
                            }
                            keyName = (String)keyName + ")";
                        }
                        xname = nnPos;
                        if (dmwebdef) {
                            DiagramToSVG.addTextWithClass((String)keyName, xname, yCursor, sb, CSS_CLASS_COLUMN_NAME);
                        } else {
                            DiagramToSVG.addText((String)keyName, xname, yCursor, keyColor, sb, keyFont);
                        }
                        if (yCursor <= height) continue;
                        int right = width - 4;
                        int left = right - 8;
                        int center2 = right - 4;
                        int bottom2 = height - 4;
                        int top2 = bottom2 - 8;
                        int[] xPts2 = new int[]{center2, left, right};
                        int[] yPts2 = new int[]{bottom2, top2, top2};
                        DiagramToSVG.addPolygon(fgcol, xPts2, yPts2, 1, sb, true);
                        break;
                    }
                }
            }
            if (dpv instanceof DPVRelational && (dpv.showAllDetails() || dpv.showFKeys())) {
                List fKeys = DiagramToSVG.getFKeys(table.getKeys());
                it = null;
                if (fKeys.size() > 0) {
                    if (dpv.showAllDetails() || dpv.showElements() || dpv.showKeyElements()) {
                        yCursor += 6;
                        it = fKeys.iterator();
                        if (it.hasNext()) {
                            DiagramToSVG.addLine(0, yCursor, width - 2, yCursor, bcol, sb, fgopacity);
                        }
                    }
                    it = fKeys.iterator();
                    while (it.hasNext()) {
                        key3 = (KeyObject)it.next();
                        int LEFT = 4;
                        fm = DiagramToSVG.getStringDimension(keyFont);
                        int keyIconYOffset = -fm.getHeight() / 2;
                        DiagramToSVG.addUseOfDef("fk_sym", LEFT, (yCursor += fm.getHeight()) + keyIconYOffset, 8, 8, sb, OPACITY_ICON);
                        Object keyName = key3.getName();
                        if (dpv.showAllDetails() || dpv.showKeyAndIndexColumns()) {
                            Index ind;
                            ContainedObject[] columns = key3.getElements();
                            keyName = (String)keyName + " (";
                            String expr = null;
                            if (key3 instanceof Index && ALLOW_NULL.equals(expr = (ind = (Index)key3).getIndexExpression())) {
                                expr = null;
                            }
                            if (expr == null) {
                                for (int j = 0; j < columns.length; ++j) {
                                    ContainedObject column = columns[j];
                                    String colName = column.getName();
                                    if (j > 0) {
                                        keyName = (String)keyName + ", ";
                                    }
                                    keyName = (String)keyName + colName;
                                }
                            } else {
                                keyName = (String)keyName + expr;
                            }
                            keyName = (String)keyName + ")";
                        }
                        xname = nnPos;
                        FKIndexAssociation fk = key3.getFKAssociation();
                        if (fk != null) {
                            FKContainer rcont = fk.getRemoteTable();
                            String rname = null;
                            if (rcont != null) {
                                rname = rcont.getShortObjectID();
                            } else {
                                rname = fk.getReferredTableID();
                                if (rname != null && !rname.isEmpty()) {
                                    rname = ModelIDObject.getShortID(rname);
                                }
                            }
                            if (dmwebdef) {
                                DiagramToSVG.addTextWithClass((String)keyName, xname, yCursor, sb, CSS_CLASS_COLUMN_NAME, createLinks, rname, null);
                            } else {
                                DiagramToSVG.addText((String)keyName, xname, yCursor, keyColor, sb, keyFont, createLinks, rname, null);
                            }
                        } else if (dmwebdef) {
                            DiagramToSVG.addTextWithClass((String)keyName, xname, yCursor, sb, CSS_CLASS_COLUMN_NAME);
                        } else {
                            DiagramToSVG.addText((String)keyName, xname, yCursor, keyColor, sb, keyFont);
                        }
                        if (yCursor <= height) continue;
                        int right = width - 4;
                        int left = right - 8;
                        center = right - 4;
                        bottom = height - 4;
                        top = bottom - 8;
                        xPts = new int[]{center, left, right};
                        yPts = new int[]{bottom, top, top};
                        DiagramToSVG.addPolygon(fgcol, xPts, yPts, 1, sb, true);
                        break;
                    }
                }
            }
            if (dpv instanceof DPVRelational && (dpv.showAllDetails() || dpv.showIndexes()) && (keys = DiagramToSVG.getIndexes(table.getKeys())).size() > 0) {
                if ((dpv.showAllDetails() || dpv.showElements() || dpv.showKeys()) && (it = keys.iterator()).hasNext()) {
                    DiagramToSVG.addLine(0, yCursor += 6, width - 2, yCursor, bcol, sb, fgopacity);
                }
                for (KeyObject key3 : keys) {
                    Index ind;
                    fm = DiagramToSVG.getStringDimension(keyFont);
                    yCursor += fm.getHeight();
                    Object keyName = key3.getName();
                    if ((dpv.showAllDetails() || dpv.showKeyAndIndexColumns()) && (dpv.showAllDetails() || dpv.showKeyAndIndexColumns())) {
                        Index ind2;
                        ContainedObject[] columns = key3.getElements();
                        keyName = (String)keyName + " (";
                        String expr = null;
                        if (key3 instanceof Index && ALLOW_NULL.equals(expr = (ind2 = (Index)key3).getIndexExpression())) {
                            expr = null;
                        }
                        if (expr == null) {
                            for (int j = 0; j < columns.length; ++j) {
                                ContainedObject column = columns[j];
                                String colName = column.getName();
                                if (j > 0) {
                                    keyName = (String)keyName + ", ";
                                }
                                keyName = (String)keyName + colName;
                            }
                        } else {
                            keyName = (String)keyName + expr;
                        }
                        keyName = (String)keyName + ")";
                    }
                    String type = " ";
                    if (key3 instanceof Index && "Unique Plain Index".equalsIgnoreCase((ind = (Index)key3).getIndexState())) {
                        type = "U";
                    }
                    if (!" ".equals(type)) {
                        if (dmwebdef) {
                            DiagramToSVG.addTextWithClass(type, 5, yCursor, sb, CSS_CLASS_TABLE_NAME);
                        } else {
                            DiagramToSVG.addText(type, 5, yCursor, keyColor, sb, keyFont);
                        }
                    }
                    int xname2 = nnPos;
                    if (dmwebdef) {
                        DiagramToSVG.addTextWithClass((String)keyName, xname2, yCursor, sb, CSS_CLASS_COLUMN_NAME);
                    } else {
                        DiagramToSVG.addText((String)keyName, xname2, yCursor, keyColor, sb, keyFont);
                    }
                    if (yCursor <= height) continue;
                    int right = width - 4;
                    int left = right - 8;
                    int center3 = right - 4;
                    int bottom3 = height - 4;
                    int top3 = bottom3 - 8;
                    int[] xPts3 = new int[]{center3, left, right};
                    int[] yPts3 = new int[]{bottom3, top3, top3};
                    DiagramToSVG.addPolygon(fgcol, xPts3, yPts3, 1, sb, true);
                    break;
                }
            }
        }
        String comments = table.getCommentInRDBMS().trim();
        if (dpv.showComments() && !ALLOW_NULL.equalsIgnoreCase(comments)) {
            DiagramToSVG.addLine(0, yCursor += 6, width - 2, yCursor, bcol, sb, fgopacity);
            fm = DiagramToSVG.getStringDimension(comFont);
            yCursor += fm.getHeight();
            String[] wrappedComments = DiagramToSVG.wrapText(comments, DiagramToSVG.getMaxChars(comments, fm, width - fm.stringWidth("WWW")));
            for (int t = 0; t < wrappedComments.length; ++t) {
                String text = wrappedComments[t];
                g.drawString(text, 5, yCursor);
                DiagramToSVG.addText(text, 5, yCursor, comColor, sb, comFont);
                yCursor += fm.getHeight();
            }
        }
        try {
            sb.write("\n</g>");
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    public static void generateEntityBarkerNotation(ContainerWithKeyObject table, TopView tv, Writer sb, Graphics2D g, boolean createLinks, String id_suffix, boolean dmwebdef) {
        String text;
        DesignPartView dpv = tv.getDesignPartView();
        Color bgcol = DiagramToSVG.getBackgroundColor(table, tv, dmwebdef);
        Color fgcol = DiagramToSVG.getTableForegroundColor(table, tv);
        Color bcol = DiagramToSVG.getBorderColor(table, tv);
        int borderWidth = 1;
        Rectangle bounds = tv.getBounds();
        int titlePosition = 20;
        int yCursor = 0;
        int xCursor = 0;
        int width = bounds.width;
        int height = bounds.height;
        TopView efo = tv;
        Object longName = table.getLongName();
        if (tv != null) {
            longName = tv.toString();
            if (tv.getDesignPartView().showSchemaName() && table.getSchemaObject() != null) {
                longName = table.getSchemaObject().getName() + "." + (String)longName;
            }
        }
        if (table.isBST()) {
            longName = (String)longName + " (" + table.getBasedOnStructuredType().getName() + ")";
        }
        String cid = DiagramToSVG.getClipPathID(tv);
        DiagramToSVG.addShape(bgcol, bcol, bounds, sb, cid);
        DiagramToSVG.addRect(fgcol, width, height, 20, 20, sb);
        Font titleFont = DiagramToSVG.getTitleFont(table, tv);
        StringDimension fm = DiagramToSVG.getStringDimension(titleFont);
        int colTextHeight = fm.getHeight();
        yCursor = Math.max(colTextHeight, titleFont.getSize());
        xCursor = (width - fm.stringWidth((String)longName)) / 2;
        if (xCursor < titlePosition) {
            xCursor = titlePosition;
        }
        Color tcolor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_TITLE);
        String[] wrappedTitle = DiagramToSVG.wrapText((String)longName, DiagramToSVG.getMaxChars((String)longName, fm, width - titlePosition - 5));
        for (int t = 0; t < wrappedTitle.length; ++t) {
            String text2 = wrappedTitle[t];
            if (t == 0) {
                String id = table.getShortObjectID() + id_suffix;
                DiagramToSVG.addText(text2, xCursor, yCursor, tcolor, sb, titleFont, createLinks, table.getShortObjectID(), id, table.isDeprecated());
            } else {
                DiagramToSVG.addText(text2, xCursor, yCursor, tcolor, sb, titleFont, false, null, null, table.isDeprecated());
            }
            yCursor += colTextHeight;
        }
        if (efo.getHiddenElements().size() > 0) {
            int right = width - 4;
            int left = right - 8;
            int center = right - 4;
            int[] xPts = new int[]{center, left, right};
            int[] yPts = new int[]{2, 10, 10};
            DiagramToSVG.addPolygon(fgcol, xPts, yPts, 1, sb, true);
        }
        yCursor -= colTextHeight;
        int iconXPos = 2;
        if (table.isRemoteObject()) {
            DiagramToSVG.addUseOfDef("link_sym", iconXPos, colTextHeight / 2, 8, 8, sb);
        }
        yCursor += 3 + borderWidth;
        ContainedObject[] elements = table.getElements();
        String longestName = DesignPartView.getLongestName(elements, dpv.isExpandComplexTypes());
        Font colFont = DiagramToSVG.getFont(table, tv, EditableFonts.FO_ELEMENT);
        Font comFont = DiagramToSVG.getFont(table, tv, EditableFonts.FO_COMMENTS);
        fm = DiagramToSVG.getStringDimension(colFont);
        int nameSize = fm.stringWidth(longestName);
        int nnPos = fm.stringWidth("KW");
        int namePos = 3 + fm.stringWidth("KWN");
        int cPos = 20 + namePos + nameSize;
        Color nnColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_NOT_NULL);
        Color pkColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_PK);
        Color ukColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_UK);
        Color fkColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_FK);
        Color dtColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_DATATYPE);
        Color comColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_COMMENTS);
        Color elemColor = DiagramToSVG.getColor(table, tv, EditableFonts.FO_ELEMENT);
        colTextHeight = fm.getHeight();
        if (!dpv.isShowNamesOnly()) {
            if (dpv.isShowClassificationTypes() && table instanceof ContainerWithKeyObject) {
                ContainerWithKeyObject cwk = table;
                String clname = ALLOW_NULL;
                ClassificationType ct = cwk.getClassificationType();
                if (ct != null) {
                    clname = ct.getTypeName();
                }
                Object clnames = ALLOW_NULL;
                List<String> list = cwk.getAdd_ClassificationTypeNames();
                for (int k = 0; k < list.size(); ++k) {
                    clnames = k > 0 ? (String)clnames + ", " + list.get(k) : list.get(0);
                }
                if (!ALLOW_NULL.equals(clname) || !ALLOW_NULL.equals(clnames)) {
                    Object types = !ALLOW_NULL.equals(clname) ? clname + " / " : "- / ";
                    types = !ALLOW_NULL.equals(clnames) ? (String)types + (String)clnames : (String)types + "-";
                    xCursor = (width - fm.stringWidth((String)types)) / 2;
                    if (xCursor < titlePosition) {
                        xCursor = titlePosition;
                    }
                    DiagramToSVG.addText((String)types, xCursor, yCursor += colTextHeight, tcolor, sb, titleFont);
                    DiagramToSVG.addLine(0, yCursor += 3 + borderWidth, width - 2, yCursor, fgcol, sb);
                }
            }
            if (table.isBST() && table.getTypeSubstitution() != null) {
                StructuredType st = table.getBasedOnStructuredType();
                if (st != null) {
                    TypeElement[] elems = st.getElements();
                    longestName = DesignPartView.getLongestTypeName(elems);
                    colTextHeight = fm.getMaxAscent() - fm.getMaxDescent() + 3;
                    for (int i = 0; i < elems.length; ++i) {
                        TypeElement elm = elems[i];
                        DiagramToSVG.addText(elm.getName(), 25, yCursor += fm.getHeight(), elemColor, sb, colFont, false, null, null, elm.isDeprecated());
                        int anLeft = fm.stringWidth(longestName) + 50;
                        DiagramToSVG.addText(elm.getDataType(), anLeft, yCursor, dtColor, sb, colFont);
                    }
                }
            } else {
                for (int i = 0; i < elements.length; ++i) {
                    String com;
                    ContainedObjectWithDomain element = (ContainedObjectWithDomain)elements[i];
                    if (efo.getHiddenElements().contains(element) || element.isOid() || element.isFKElement() || dpv.showKeyElements() && !element.isPKElement() && !element.isFKElement() && !element.isUnique()) continue;
                    int anLeft = nnPos;
                    text = element.getNullsAllowed() ? "o" : NOT_NULL;
                    DiagramToSVG.addText(text, anLeft, yCursor += fm.getHeight(), nnColor, sb, colFont);
                    String type = " ";
                    Color color = elemColor;
                    if (element.isPKElement()) {
                        type = "P";
                        color = pkColor;
                        if (element.isFKElement()) {
                            type = type.concat("F");
                        }
                    } else if (element.isUnique()) {
                        type = "U";
                        color = ukColor;
                        if (element.isFKElement()) {
                            type = type.concat("F");
                        }
                    } else if (element.isFKElement()) {
                        type = "F";
                        color = fkColor;
                    }
                    if (!" ".equals(type)) {
                        DiagramToSVG.addText(type, 5, yCursor, color, sb, colFont);
                    }
                    anLeft = namePos;
                    DiagramToSVG.addText(element.getName(), anLeft, yCursor, elemColor, sb, colFont, false, null, null, element.isDeprecated());
                    if (dpv.showComments() && !(com = element.getCommentInRDBMS()).isEmpty()) {
                        anLeft = cPos;
                        DiagramToSVG.addText(com, anLeft, yCursor, comColor, sb, colFont);
                    }
                    if (yCursor <= height) continue;
                    int right = width - 4;
                    int left = right - 8;
                    int center = right - 4;
                    int bottom = height - 4;
                    int top = bottom - 8;
                    int[] xPts = new int[]{center, left, right};
                    int[] yPts = new int[]{bottom, top, top};
                    DiagramToSVG.addPolygon(fgcol, xPts, yPts, 1, sb, true);
                    break;
                }
            }
        }
        String comments = table.getCommentInRDBMS().trim();
        if (dpv.showComments() && !ALLOW_NULL.equalsIgnoreCase(comments)) {
            DiagramToSVG.addLine(0, yCursor += 6, width - 2, yCursor, comColor, sb);
            fm = DiagramToSVG.getStringDimension(comFont);
            yCursor += fm.getHeight();
            String[] wrappedComments = DiagramToSVG.wrapText(comments, DiagramToSVG.getMaxChars(comments, fm, width - fm.stringWidth("WWW")));
            for (int t = 0; t < wrappedComments.length; ++t) {
                text = wrappedComments[t];
                g.drawString(text, 5, yCursor);
                DiagramToSVG.addText(text, 5, yCursor, comColor, sb, comFont);
                yCursor += fm.getHeight();
            }
        }
        try {
            sb.write("\n</g>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addShape(Color bgcol, Color bordercol, Rectangle bounds, Writer sb, String clipID) {
        float opacity = (float)bgcol.getAlpha() / 255.0f;
        float line_opacity = (float)bordercol.getAlpha() / 255.0f;
        DiagramToSVG.addShape(bgcol, bordercol, bounds, sb, clipID, opacity, line_opacity);
    }

    public static void addShape(Color bgcol, Color bordercol, Rectangle bounds, Writer sb, String clipID, float opacity) {
        DiagramToSVG.addShape(bgcol, bordercol, bounds, sb, clipID, opacity, OPACITY_BORDER);
    }

    public static void addShape(Color bgcol, Color bordercol, Rectangle bounds, Writer sb, String clipID, float opacity, float line_opacity) {
        try {
            sb.write("\n<g ");
            String col = "\"rgb(" + bgcol.getRed() + "," + bgcol.getGreen() + "," + bgcol.getBlue() + ")\"";
            String bordcol = DiagramToSVG.getColor(bordercol);
            opacity = (float)bgcol.getAlpha() / 255.0f;
            line_opacity = (float)bordercol.getAlpha() / 255.0f;
            sb.write(" fill=" + col + " fill-opacity=\"" + opacity + "\" stroke=" + bordcol);
            String tr = " transform=\"translate(" + bounds.x + "," + bounds.y + ")\" stroke-opacity=\"" + line_opacity + "\" >";
            if (clipID != null) {
                tr = " clip-path=\"url(#" + clipID + ")\"" + tr;
            }
            sb.write(tr);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    public static void addRect(Color fgcol, int width, int height, Writer sb) {
        float opacity = (float)fgcol.getAlpha() / 255.0f;
        DiagramToSVG.addRect(fgcol, width, height, 0, 0, sb, opacity);
    }

    public static void addRect(Color fgcol, int width, int height, int rx, int ry, Writer sb) {
        float opacity = (float)fgcol.getAlpha() / 255.0f;
        DiagramToSVG.addRect(fgcol, width, height, rx, ry, sb, opacity);
    }

    public static void addRect(Color fgcol, int width, int height, int rx, int ry, Writer sb, float opacity) {
        try {
            String out = "\n<rect x=\"0\" y=\"0\" width=\"" + (width - 1) + "\" height=\"" + (height - 1) + "\" stroke-opacity=\"" + opacity + "\"";
            if (rx != 0 || ry != 0) {
                out = out + " rx=\"" + rx + "\" ry=\"" + ry + "\"";
            }
            out = out + " />";
            sb.write(out);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    public static void addWhiteLayer(Rectangle bounds, Writer sb, String clipID, int rx, int ry) {
        try {
            sb.write("\n<g fill=\"white\" stroke=\"white\"");
            String tr = " transform=\"translate(" + bounds.x + "," + bounds.y + ")\" >";
            if (clipID != null) {
                tr = " clip-path=\"url(#" + clipID + ")\"" + tr;
            }
            sb.write(tr);
            String out = "\n<rect x=\"0\" y=\"0\" width=\"" + (bounds.width - 1) + "\" height=\"" + (bounds.height - 1) + "\"";
            if (rx != 0 || ry != 0) {
                out = out + " rx=\"" + rx + "\" ry=\"" + ry + "\"";
            }
            out = out + " />";
            sb.write(out);
            sb.write("\n</g>");
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    public static void addNote(Color fgcol, int w, int h, Writer sb) {
        try {
            int f = w / 6;
            String out = "\n<polygon points=\"" + (w - f) + " 0," + (w - f) + " " + f + "," + w + " " + f + " " + w + " " + h + ",0 " + h + ",0 0," + (w - f) + " 0," + w + " " + f + "\"/>";
            sb.write(out);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    public static Color getTableBackgroundColor(ContainerObject container, TopView tv) {
        return DiagramToSVG.getBackgroundColor(container, tv, true);
    }

    public static Color getBackgroundColor(DesignObject container, TopView tv, boolean dmw_def) {
        if (tv != null) {
            if (tv.useDefaultColor() || tv.getBackgroundColor() == null) {
                Color color;
                if (dmw_def && (color = DiagramToSVG.getDMWebDefBGCollor(container)) != null) {
                    return color;
                }
                ClassificationType cf = DiagramToSVG.getClassificationType(container);
                if (cf != null) {
                    return cf.getTypeColor();
                }
                String type = "Table";
                if (container instanceof TableView) {
                    type = "Relational View";
                } else if (container instanceof Note) {
                    type = "Note";
                } else if (container instanceof EntityView) {
                    type = "Logical View";
                } else if (container instanceof Entity) {
                    type = "Entity";
                }
                DefaultFontAndColor dfc = container.getDesign().getDesignLevelSettings().getDefaultFCObject(type);
                if (dfc != null) {
                    return dfc.getBackgroundColor();
                }
            } else {
                return tv.getBackgroundColor();
            }
        }
        return DEFAULT_BACKGROUND;
    }

    public static Color getDMWebDefBGCollor(DesignObject container) {
        String typeID = ALLOW_NULL;
        if (container instanceof ContainerWithKeyObject) {
            typeID = ((ContainerWithKeyObject)container).getTypeID();
        }
        if (typeID != null && !typeID.isEmpty()) {
            if (typeID.equals("4")) {
                return COLOR_MVIEW;
            }
            if (typeID.equals("6")) {
                return COLOR_EXT_TABLE;
            }
            if (typeID.equals("3")) {
                return COLOR_ORACLE_LOG_TABLE;
            }
        }
        if (container instanceof Table) {
            return COLOR_TABLE;
        }
        if (container instanceof TableView) {
            return COLOR_VIEW;
        }
        return null;
    }

    private static ClassificationType getClassificationType(DesignObject container) {
        if (container instanceof ContainerWithKeyObject) {
            return container.getDesign().getDesignLevelSettings().getClassificationTypeByID(((ContainerWithKeyObject)container).getTypeID());
        }
        return null;
    }

    public static Color getTableForegroundColor(DesignObject container, TopView tv) {
        if (tv != null) {
            if (tv.useDefaultColor() || tv.getForegroundColor() == null) {
                DefaultFontAndColor dfc;
                ClassificationType cf = DiagramToSVG.getClassificationType(container);
                if (cf != null) {
                    return cf.getForegroundColor();
                }
                String type = "Table";
                if (container instanceof TableView) {
                    type = "Relational View";
                }
                if ((dfc = container.getDesign().getDesignLevelSettings().getDefaultFCObject(type)) != null) {
                    return dfc.getForegroundColor();
                }
                return DEFAULT_FOREGROUND;
            }
            return tv.getForegroundColor();
        }
        return DEFAULT_FOREGROUND;
    }

    public static Color getForegroundColor(DesignObject container, TopView tv) {
        if (tv != null) {
            if (tv.useDefaultColor() || tv.getForegroundColor() == null) {
                ClassificationType cf;
                if (container instanceof ContainerObject && (cf = DiagramToSVG.getClassificationType((ContainerObject)container)) != null) {
                    return cf.getForegroundColor();
                }
                DefaultFontAndColor dfc = container.getDesign().getDesignLevelSettings().getDefaultFCObject("Table");
                if (dfc != null) {
                    return dfc.getForegroundColor();
                }
                return DEFAULT_FOREGROUND;
            }
            return tv.getForegroundColor();
        }
        return DEFAULT_FOREGROUND;
    }

    public static Color getLineColor(DesignObject container, TopView tv) {
        if (tv != null) {
            if (tv.useDefaultColor() || tv.getDefaultLineColor() == null) {
                DefaultLineWidthAndColor dfc = container.getDesign().getDesignLevelSettings().getDefaultLWCObject(container.getClass().getSimpleName());
                if (dfc == null) {
                    dfc = container instanceof TypeSubstitution ? container.getDesign().getDesignLevelSettings().getDefaultLWCObject("Type Substitution") : container.getDesign().getDesignLevelSettings().getDefaultLWCObject("Relational Foreign Key");
                }
                if (dfc != null) {
                    return dfc.getColor();
                }
                return DEFAULT_FOREGROUND;
            }
            return tv.getForegroundColor();
        }
        return DEFAULT_FOREGROUND;
    }

    public static Font getFont(DesignObject container, TopView tv, String type) {
        if (tv != null) {
            FontObject fo;
            ClassificationType cf;
            if (tv.useDefaultColor() && (cf = DiagramToSVG.getClassificationType(container)) != null && (fo = cf.getDefaultFCObject().getFontObject(type)) != null) {
                return fo.getFont();
            }
            FontObject fo2 = tv.getFontObject(type);
            if (fo2 != null) {
                return fo2.getFont();
            }
        }
        return DiagramToSVG.getObjectFont(container, type);
    }

    public static Font getTitleFont(DesignObject container, TopView tv) {
        return DiagramToSVG.getFont(container, tv, EditableFonts.FO_TITLE);
    }

    public static Font getObjectFont(DesignObject obj, String type) {
        FontObject fo;
        DefaultFontAndColor dfc;
        if (obj instanceof EditableFonts && (dfc = obj.getDesign().getDesignLevelSettings().getDefaultFCObject(((EditableFonts)((Object)obj)).getFCObjectType())) != null && (fo = dfc.getFontObject(type)) != null) {
            return fo.getFont();
        }
        return FONT_ARIAL;
    }

    protected static Color getColor(DesignObject container, TopView tv, String type) {
        if (tv != null) {
            FontObject fo;
            ClassificationType cf;
            if (tv.useDefaultColor() && container instanceof ContainerObject && (cf = DiagramToSVG.getClassificationType((ContainerObject)container)) != null && (fo = cf.getDefaultFCObject().getFontObject(type)) != null) {
                return fo.getColor();
            }
            FontObject fo2 = tv.getFontObject(type);
            if (fo2 != null) {
                return fo2.getColor();
            }
        }
        return DiagramToSVG.getObjectColor(container, type);
    }

    public static Color getObjectColor(DesignObject obj, String type) {
        FontObject fo;
        DefaultFontAndColor dfc;
        if (obj instanceof EditableFonts && (dfc = obj.getDesign().getDesignLevelSettings().getDefaultFCObject(((EditableFonts)((Object)obj)).getFCObjectType())) != null && (fo = dfc.getFontObject(type)) != null) {
            return fo.getColor();
        }
        return Color.BLACK;
    }

    public static int getMaxChars(String text, StringDimension fm, int length) {
        for (int i = 0; i < text.length(); ++i) {
            String subStr = text.substring(0, i);
            int s1 = fm.stringWidth(subStr);
            if (s1 <= length) continue;
            return i;
        }
        return text.length();
    }

    public static String[] wrapText(String text, int length) {
        if (length > 0) {
            Pattern wrapRE = Pattern.compile("([\\S\\S&&[^\\p{Punct}]]{" + length + ",}|.{1," + length + "})(\\p{Punct}+|\\s+|$)");
            LinkedList<String> list = new LinkedList<String>();
            Matcher m = wrapRE.matcher(text);
            while (m.find()) {
                list.add(m.group());
            }
            return list.toArray(new String[list.size()]);
        }
        return new String[]{text};
    }

    private static void addText(String text, int x, int y, Color fgcol, Writer sb, Font font) {
        DiagramToSVG.addText(text, x, y, fgcol, sb, font, false, null, null, OPACITY_TABLE_NAME, false);
    }

    private static void addText(String text, int x, int y, Color fgcol, Writer sb, Font font, boolean createLinks, String idInReport, String id) {
        DiagramToSVG.addText(text, x, y, fgcol, sb, font, createLinks, idInReport, id, OPACITY_TABLE_NAME, false);
    }

    private static void addText(String text, int x, int y, Color fgcol, Writer sb, Font font, boolean createLinks, String idInReport, String id, boolean deprecated) {
        DiagramToSVG.addText(text, x, y, fgcol, sb, font, createLinks, idInReport, id, OPACITY_TABLE_NAME, deprecated);
    }

    private static void addText(String text, int x, int y, Color fgcol, Writer sb, Font font, boolean createLinks, String idInReport, String id, float opacity, boolean deprecated) {
        try {
            String depr = ALLOW_NULL;
            if (deprecated) {
                depr = " text-decoration=\"line-through\"";
            }
            Object sfont = ALLOW_NULL;
            if (font.isItalic()) {
                sfont = " font-style=\"italic\" ";
            }
            if (font.isBold()) {
                sfont = (String)sfont + " font-weight=\"bold\" ";
            }
            int size = font.getSize();
            String col = "\"rgb(" + fgcol.getRed() + "," + fgcol.getGreen() + "," + fgcol.getBlue() + ")\"";
            if (createLinks && idInReport != null) {
                sb.write("<a xlink:href=\"#" + URLEncoder.encode(idInReport, "UTF-8").replace("+", "%20") + "\" >");
            }
            String ntext = StringUtilities.encodeAttributeValue(text);
            if (id != null) {
                sb.write("\n<text" + depr + " id=\"" + id + "\" x=\"" + x + "\" y=\"" + y + "\" fill=" + col + (String)sfont + " fill-opacity=\"" + opacity + "\" font-size=\"" + size + "\" stroke=\"none\">\n" + ntext + "\n</text>");
            } else {
                sb.write("\n<text" + depr + " x=\"" + x + "\" y=\"" + y + "\" fill=" + col + (String)sfont + " fill-opacity=\"" + opacity + "\" font-size=\"" + size + "\" stroke=\"none\">\n" + ntext + "\n</text>");
            }
            if (createLinks && idInReport != null) {
                sb.write("</a>");
            }
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private static void addTextWithStyle(String text, int x, int y, Color fgcol, Writer sb, Font font, boolean createLinks, String idInReport, String id, String fontFamily) {
        try {
            float opacity = (float)fgcol.getAlpha() / 255.0f;
            int size = font.getSize();
            Object col = "\"rgb(" + fgcol.getRed() + "," + fgcol.getGreen() + "," + fgcol.getBlue() + ")\"";
            col = "#";
            String t = Integer.toHexString(fgcol.getRed());
            col = (String)col + (String)(t.length() == 1 ? "0" + t : t);
            t = Integer.toHexString(fgcol.getGreen());
            col = (String)col + (String)(t.length() == 1 ? "0" + t : t);
            t = Integer.toHexString(fgcol.getBlue());
            col = (String)col + (String)(t.length() == 1 ? "0" + t : t);
            if (createLinks && idInReport != null) {
                sb.write("<a xlink:href=\"#" + idInReport + "\" >");
            }
            String ntext = StringUtilities.encodeAttributeValue(text);
            Object family = ALLOW_NULL;
            if (fontFamily != null) {
                family = " font-family: " + fontFamily + "; ";
            }
            String style = " style=\" fill: " + (String)col + "; fill-opacity: " + opacity + "; font-size: " + size + "; " + (String)family + "\"";
            if (id != null) {
                sb.write("\n<text id=\"" + id + "\" x=\"" + x + "\" y=\"" + y + "\" " + style + " stroke=\"none\">\n" + ntext + "\n</text>");
            } else {
                sb.write("\n<text x=\"" + x + "\" y=\"" + y + "\" " + style + " stroke=\"none\">\n" + ntext + "\n</text>");
            }
            if (createLinks && idInReport != null) {
                sb.write("</a>");
            }
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private static void addTextWithClass(String text, int x, int y, Writer sb, String className) {
        DiagramToSVG.addTextWithClass(text, x, y, sb, className, false, null, null);
    }

    private static void addTextWithClass(String text, int x, int y, Writer sb, String className, boolean createLinks, String idInReport, String id) {
        try {
            if (createLinks && idInReport != null) {
                sb.write("<a xlink:href=\"#" + URLEncoder.encode(idInReport, "UTF-8").replace("+", "%20") + "\" >");
            }
            String ntext = StringUtilities.encodeAttributeValue(text);
            if (id != null) {
                if (className != null) {
                    sb.write("\n<text id=\"" + id + "\" x=\"" + x + "\" y=\"" + y + "\" class=\"" + className + "\">\n" + ntext + "\n</text>");
                } else {
                    sb.write("\n<text id=\"" + id + "\" x=\"" + x + "\" y=\"" + y + "\">\n" + ntext + "\n</text>");
                }
            } else if (className != null) {
                sb.write("\n<text x=\"" + x + "\" y=\"" + y + "\" class=\"" + className + "\">\n" + ntext + "\n</text>");
            } else {
                sb.write("\n<text x=\"" + x + "\" y=\"" + y + "\">\n" + ntext + "\n</text>");
            }
            if (createLinks && idInReport != null) {
                sb.write("</a>");
            }
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private static void addLine(int x1, int y1, int x2, int y2, Color fgcol, Writer sb) {
        float opacity = (float)fgcol.getAlpha() / 255.0f;
        DiagramToSVG.addLine(x1, y1, x2, y2, fgcol, sb, opacity);
    }

    private static void addLine(int x1, int y1, int x2, int y2, Color fgcol, Writer sb, float opacity) {
        try {
            String col = "\"rgb(" + fgcol.getRed() + "," + fgcol.getGreen() + "," + fgcol.getBlue() + ")\"";
            sb.write("\n<line x1=\"" + x1 + "\" y1=\"" + y1 + "\" x2=\"" + x2 + "\" y2=\"" + y2 + "\" fill=\"none\" stroke=" + col + " stroke-opacity=\"" + opacity + "\" />");
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    public static Color getBorderColor(DesignObject container, TopView tv) {
        return DiagramToSVG.getTableForegroundColor(container, tv);
    }

    protected static String getDataType(ContainedObjectWithDomain element, ContainerObject container) {
        if (container instanceof Table) {
            String formulaDesc = element.getFormulaDesc();
            if (formulaDesc != null && formulaDesc.length() > 0 && ("Derived".equalsIgnoreCase(element.getSourceType()) || "Aggregate".equalsIgnoreCase(element.getSourceType()) || element instanceof Column && ((Column)element).isComputed().booleanValue())) {
                return formulaDesc;
            }
            if (element instanceof Attribute) {
                return ((Attribute)element).getLogicalRepresentationName();
            }
            if (element.isReference() && element.getDataType() instanceof StructuredType) {
                return "REF " + element.getDataType().toString();
            }
        }
        if (element instanceof ColumnView && !ALLOW_NULL.equalsIgnoreCase(element.getStructAttributeID())) {
            return ((ColumnView)element).getDataTypeString();
        }
        Datatype datatype = element.getDataType();
        if (datatype instanceof DistinctType && element instanceof Column) {
            String rdbmsName = element.getSelectedRDBMSType().toString();
            if (rdbmsName.startsWith("DB2")) {
                return datatype.getName();
            }
            datatype = element.getDataType(rdbmsName);
        }
        if (element instanceof ColumnView) {
            return ((ColumnView)element).getDataTypeString();
        }
        if (element instanceof Column) {
            return ((Column)element).getDatatypeString();
        }
        if (element instanceof AttributeView) {
            return ((AttributeView)element).getDataTypeStr();
        }
        if (element instanceof Attribute) {
            return ((Attribute)element).getLogicalRepresentationName();
        }
        if (datatype != null) {
            return datatype.toString();
        }
        return ALLOW_NULL;
    }

    protected static List getKeys(KeyObject[] keys) {
        ArrayList<KeyObject> list = new ArrayList<KeyObject>();
        for (int i = 0; i < keys.length; ++i) {
            if (!keys[i].isPK() && !keys[i].isUnique()) continue;
            list.add(keys[i]);
        }
        return list;
    }

    protected static List getIndexes(KeyObject[] keys) {
        ArrayList<KeyObject> list = new ArrayList<KeyObject>();
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i].isFK() || keys[i].isPK() || keys[i].isUnique()) continue;
            list.add(keys[i]);
        }
        return list;
    }

    protected static List getFKeys(KeyObject[] keys) {
        ArrayList<KeyObject> list = new ArrayList<KeyObject>();
        for (int i = 0; i < keys.length; ++i) {
            if (!keys[i].isFK()) continue;
            list.add(keys[i]);
        }
        return list;
    }

    public static void dpv_ToSVG(DesignPartView dpv, Writer sb, String id_suffix, boolean dmwebdef) {
        DiagramToSVG.initNumIDs(dpv.getDesignPart());
        Rectangle2D dim = dpv.getTopViewsBounds();
        if (dim == null) {
            return;
        }
        int dx = 0;
        int dy = 0;
        boolean move = true;
        dx = 5 - (int)dim.getX();
        dy = 5 - (int)dim.getY();
        if (move) {
            dpv.move(dx, dy);
        }
        DiagramToSVG.addSVGOpenTag(sb, (int)(dim.getWidth() + 5.0), (int)(dim.getHeight() + 5.0), dmwebdef);
        DiagramToSVG.addDefs(sb, dpv);
        DiagramToSVG.processTVConnectors(dpv, sb, true, dx, dy);
        DiagramToSVG.processT_V_shapes(dpv, sb, true, id_suffix, dmwebdef);
        DiagramToSVG.processArcs(dpv, sb);
        try {
            sb.write("\n");
        }
        catch (IOException e) {
            Logger.error(e);
        }
        DiagramToSVG.addSVGCloseTag(sb);
    }

    public static void diagramToSVG(DesignPartView dpv, String fpath, boolean dmwebdef) {
        try {
            DiagramToSVG.initNumIDs(dpv.getDesignPart());
            FileWriter fw = new FileWriter(fpath);
            fw.write("<html>");
            DiagramToSVG.dpv_ToSVG(dpv, fw, ALLOW_NULL, dmwebdef);
            fw.write("\n</html>");
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    public static void diagramToSVG(DesignPartView dpv, Writer fw, boolean dmwebdef) {
        try {
            fw.write("<html>");
            DiagramToSVG.dpv_ToSVG(dpv, fw, ALLOW_NULL, dmwebdef);
            fw.write("</html>");
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    public static void generateNote(Note note, TopView tv, Writer sb, Graphics2D g, boolean createLinks, String id_suffix, boolean dmw_def) {
        String lt;
        Color bgcol = DiagramToSVG.getBackgroundColor(note, tv, dmw_def);
        Color bcol = DiagramToSVG.getBorderColor(note, tv);
        Rectangle bounds = null;
        bounds = tv.getBounds();
        int yCursor = 0;
        int xCursor = 0;
        int lineWidt = 1;
        int width = bounds.width;
        int height = bounds.height;
        String text = note.getText();
        if (text.indexOf(lt = "\r\n") == -1 && text.indexOf(lt = System.getProperty("line.separator")) == -1) {
            lt = "\n";
        }
        String cid = DiagramToSVG.getClipPathID(tv);
        DiagramToSVG.addShape(bgcol, bcol, bounds, sb, cid);
        Font titleFont = DiagramToSVG.getTitleFont(note, tv);
        StringDimension fm = DiagramToSVG.getStringDimension(titleFont);
        int colTextHeight = fm.getHeight();
        yCursor = titleFont.getSize();
        xCursor = 6;
        Color tcolor = DiagramToSVG.getColor(note, tv, EditableFonts.FO_TITLE);
        String[] splitText = DiagramToSVG.wrapText(text, DiagramToSVG.getMaxChars(text, fm, width - 6 - 5));
        for (int t = 0; t < splitText.length; ++t) {
            String text1 = splitText[t];
            text1 = text1.replaceAll(lt + lt, lt + " " + lt);
            String[] wrt = text1.split(lt);
            for (int k = 0; k < wrt.length; ++k) {
                if (dmw_def) {
                    DiagramToSVG.addTextWithStyle(wrt[k], xCursor, yCursor, tcolor, sb, titleFont, false, null, null, "Arial");
                } else {
                    DiagramToSVG.addTextWithStyle(wrt[k], xCursor, yCursor, tcolor, sb, titleFont, false, null, null, "Arial");
                }
                yCursor += colTextHeight;
            }
        }
        DiagramToSVG.addPath(DiagramToSVG.getPointsForNote(width, height), false, bcol, true, lineWidt, sb);
        try {
            sb.write("\n</g>");
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private static List getPointsForNote(int width, int height) {
        int dx = width / 8;
        int dy = height / 6;
        int xt = width - dx;
        ArrayList<Point> list = new ArrayList<Point>();
        list.add(new Point(xt, 0));
        list.add(new Point(width, dy));
        list.add(new Point(width, height));
        list.add(new Point(0, height));
        list.add(new Point(0, 0));
        list.add(new Point(xt, 0));
        list.add(new Point(xt, dy));
        list.add(new Point(width, dy));
        return list;
    }

    static Color getLabelBackgroundColor(Label label, TopView tv) {
        if (tv.useDefaultColor() || tv.getBackgroundColor() == null) {
            DefaultFontAndColor dfc = null;
            dfc = label.isRelationshipAttributesLabel() ? label.getDesign().getDesignLevelSettings().getDefaultFCObject("Relationship Attributes") : label.getDesign().getDesignLevelSettings().getDefaultFCObject("Label");
            if (dfc != null) {
                return dfc.getBackgroundColor();
            }
            return Color.WHITE;
        }
        return tv.getBackgroundColor();
    }

    static Color getLabelForegroundColorColor(Label label, TopView tv) {
        if (tv.useDefaultColor() || tv.getForegroundColor() == null) {
            DefaultFontAndColor dfc = null;
            dfc = label.isRelationshipAttributesLabel() ? label.getDesign().getDesignLevelSettings().getDefaultFCObject("Relationship Attributes") : label.getDesign().getDesignLevelSettings().getDefaultFCObject("Label");
            if (dfc != null) {
                return dfc.getForegroundColor();
            }
            return Color.WHITE;
        }
        return tv.getForegroundColor();
    }

    private static Color getLabelTextColor(Label label, TopView tv) {
        if (tv != null) {
            FontObject fob = tv.getFontObject(EditableFonts.FO_TEXT);
            if (tv.useDefaultColor() || fob == null) {
                DefaultFontAndColor dfc = label.getDesign().getDesignLevelSettings().getDefaultFCObject(label.getClass().getSimpleName());
                if (dfc == null) {
                    dfc = label.getDesign().getDesignLevelSettings().getDefaultFCObject("Label");
                }
                if (dfc != null) {
                    return dfc.getFontObject(EditableFonts.FO_TEXT).getColor();
                }
                return DEFAULT_FOREGROUND;
            }
            return fob.getColor();
        }
        return DEFAULT_FOREGROUND;
    }

    private static void addLabelShape(Color bgcol, Color bordercol, Rectangle bounds, Writer sb, boolean useDefault, boolean noBG, boolean noFG) {
        try {
            sb.write("\n<g >");
            if (!useDefault) {
                DiagramToSVG.addLabelRectangle(bordercol, bgcol, bounds.x, bounds.y, 1, bounds.width, bounds.height, sb, noBG, noFG);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void generateLabel(Label label, TopView tv, Rectangle2D bounds, Writer sb, Graphics2D g) {
        Color fgcol;
        Color bgcol = DiagramToSVG.getLabelBackgroundColor(label, tv);
        Color bcol = fgcol = DiagramToSVG.getLabelForegroundColorColor(label, tv);
        int yCursor = (int)bounds.getY();
        int xCursor = (int)bounds.getX();
        int width = (int)bounds.getWidth();
        Font txtFont = DiagramToSVG.getFont(label, tv, EditableFonts.FO_TEXT);
        Color txtColor = DiagramToSVG.getLabelTextColor(label, tv);
        StringDimension fm = DiagramToSVG.getStringDimension(txtFont);
        int colTextHeight = fm.getHeight();
        yCursor = yCursor + colTextHeight - 2;
        ++xCursor;
        DiagramToSVG.addLabelShape(bgcol, bcol, bounds.getBounds(), sb, tv.useDefaultColor(), label.getNoBackgroundColor(), label.getNoForegroundColor());
        if (!label.isRelationshipAttributesLabel()) {
            String txt = " " + label.getText();
            String[] wrappedTitle = DiagramToSVG.wrapText(txt, DiagramToSVG.getMaxChars(txt, fm, width - 1));
            for (int t = 0; t < wrappedTitle.length; ++t) {
                String text = wrappedTitle[t];
                if (t == 0) {
                    if (wrappedTitle.length > 1) {
                        yCursor += colTextHeight;
                        text = StringUtilities.ltrim(text);
                    }
                    DiagramToSVG.addText(text, xCursor, yCursor, txtColor, sb, txtFont);
                } else {
                    DiagramToSVG.addText(text, xCursor, yCursor, txtColor, sb, txtFont);
                }
                yCursor += colTextHeight;
            }
        }
        try {
            sb.write("\n</g>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void generateRelationAttributeLabel(Label label, TopView tv, TVConnector tvc, Rectangle bounds, Writer sb, Graphics2D g) {
        Color fgcol;
        DesignPartView dpv = tv.getDesignPartView();
        Color bgcol = DiagramToSVG.getLabelBackgroundColor(label, tv);
        Color bcol = fgcol = DiagramToSVG.getLabelForegroundColorColor(label, tv);
        int yCursor = 5;
        int xCursor = (int)bounds.getX();
        int width = (int)bounds.getWidth();
        int height = (int)bounds.getHeight();
        Font txtFont = DiagramToSVG.getFont(label, tv, EditableFonts.FO_ATTRIBUTE);
        Color nnColor = DiagramToSVG.getColor(label, tv, EditableFonts.FO_NOT_NULL);
        Color txtColor = DiagramToSVG.getLabelTextColor(label, tv);
        StringDimension fm = DiagramToSVG.getStringDimension(txtFont);
        int namePos = 3 + fm.stringWidth("KWN");
        Color dtColor = DiagramToSVG.getColor(label, tv, EditableFonts.FO_DATATYPE);
        ++xCursor;
        String cid = DiagramToSVG.getClipPathID(tvc) + "_C";
        if (label.isRelationshipAttributesLabel()) {
            int notation = dpv.getNotation();
            DiagramToSVG.addShape(bgcol, bcol, bounds, sb, cid);
            if (notation == 1) {
                DiagramToSVG.addRect(fgcol, width, height, 20, 20, sb);
            } else {
                DiagramToSVG.addRect(fgcol, width, height, sb);
            }
            String ALLOW_NULL = ALLOW_NULL;
            if (notation == 1) {
                ALLOW_NULL = "o";
            }
            Collection attributes = ((TVRelation)label.getTVConnector()).getRelationshipAttributes();
            String longestName = DiagramToSVG.getLongestName(attributes);
            int nameSize = fm.stringWidth(longestName);
            int dtPos = 20 + namePos + nameSize;
            if (attributes != null) {
                for (ContainedObjectWithDomain element : attributes) {
                    int anLeft = fm.stringWidth("A");
                    String nntext = element.getNullsAllowed() ? ALLOW_NULL : NOT_NULL;
                    DiagramToSVG.addText(nntext, anLeft, yCursor += 3 + fm.getMaxAscent(), nnColor, sb, txtFont);
                    DiagramToSVG.addText(element.getName(), anLeft += fm.stringWidth(NOT_NULL) + 3, yCursor, txtColor, sb, txtFont, false, null, null, element.isDeprecated());
                    if (notation == 1) continue;
                    anLeft = dtPos;
                    DiagramToSVG.addText(DiagramToSVG.getDataType(element, element.getContainer()).toUpperCase(), anLeft, yCursor, dtColor, sb, txtFont);
                }
            }
            try {
                sb.write("\n</g>");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static String getLongestName(Collection elements) {
        String name = ALLOW_NULL;
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            String n = ((DesignObject)it.next()).getName();
            if (n.length() <= name.length()) continue;
            name = n;
        }
        return name;
    }

    private static void addPolygon(Color col, int[] xPts, int[] yPts, int width, Writer sb, boolean fil) {
        String cols = DiagramToSVG.getColor(col);
        Object points = ALLOW_NULL;
        for (int i = 0; i < xPts.length; ++i) {
            points = i == 0 ? xPts[i] + "," + yPts[i] : (String)points + " " + xPts[i] + "," + yPts[i];
        }
        String out = fil ? "\n<polygon points=\"" + (String)points + "\" stroke-dasharray=\"none\" stroke=" + cols + " fill=" + cols + " stroke-width=\"" + width + "\" />" : "\n<polygon points=\"" + (String)points + "\" stroke-dasharray=\"none\" stroke=" + cols + "  fill=\"none\" stroke-width=\"" + width + "\" />";
        try {
            sb.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void addLabelRectangle(Color col, Color filColor, int x, int y, int lineWidth, int width, int height, Writer sb, boolean noBG, boolean noFG) {
        Object out;
        String cols = "none";
        float strokeOpacity = 1.0f;
        if (!noFG) {
            cols = DiagramToSVG.getColor(col);
        }
        if (!noBG && filColor != null) {
            String fcols = DiagramToSVG.getColor(filColor);
            float opacity = (float)filColor.getAlpha() / 255.0f;
            if (col != null) {
                strokeOpacity = (float)col.getAlpha() / 255.0f;
                out = "\n<rect x=\"" + x + "\" y=\"" + y + "\" width=\"" + width + "\" height=\"" + height + "\" stroke-dasharray=\"none\" stroke=" + cols + " stroke-opacity=\"" + strokeOpacity + "\" fill=" + fcols + " fill-opacity=\"" + opacity + "\" stroke-width=\"" + lineWidth + "\" />";
            } else {
                out = "\n<rect x=\"" + x + "\" y=\"" + y + "\" width=\"" + width + "\" height=\"" + height + "\" stroke-dasharray=\"none\" stroke=\"none\" fill=" + fcols + " stroke-width=\"" + lineWidth + "\" />";
            }
        } else if (col != null) {
            strokeOpacity = (float)col.getAlpha() / 255.0f;
            out = "\n<rect x=\"" + x + "\" y=\"" + y + "\" width=\"" + width + "\" height=\"" + height + "\" stroke-dasharray=\"none\" stroke=" + cols + " stroke-opacity=\"" + strokeOpacity + "\" fill=\"none\" stroke-width=\"" + lineWidth + "\" />";
        } else {
            out = ALLOW_NULL;
        }
        try {
            sb.write((String)out);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    public static void moveLines(List<Line> lines, int dx, int dy) {
        for (Line l : lines) {
            for (Point2D p : l.points) {
                p.setLocation(p.getX() + (double)dx, p.getY() + (double)dy);
            }
        }
    }

    static Point2D getPoint(TVConnector tv, int i) {
        return (Point2D)tv.getActualPoints().get(i);
    }

    static int getPointsCount(TVConnector tv) {
        return tv.getActualPoints().size();
    }

    public static Point2D getRelationPoint(Rectangle bounds, Point2D p1, Point2D p2) {
        double sy;
        Line2D.Double relationLine;
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        Line2D.Double line = new Line2D.Double(x, y, x, y + height);
        if (!(line.intersectsLine(relationLine = new Line2D.Double(p1, p2)) || (line = new Line2D.Double(x, y, x + width, y)).intersectsLine(relationLine) || (line = new Line2D.Double(x + width, y, x + width, y + height)).intersectsLine(relationLine) || (line = new Line2D.Double(x, y + height, x + width, y + height)).intersectsLine(relationLine))) {
            return null;
        }
        double px = line.getX1();
        double py = line.getY1();
        double rx = line.getX2() - px;
        double ry = line.getY2() - py;
        double qx = relationLine.getX1();
        double qy = relationLine.getY1();
        double sx = relationLine.getX2() - qx;
        double det = sx * ry - (sy = relationLine.getY2() - qy) * rx;
        if (det == 0.0) {
            return null;
        }
        double z = (sx * (qy - py) + sy * (px - qx)) / det;
        if (z == 0.0 || z == 1.0) {
            return null;
        }
        return new Point2D.Double(px + z * rx, py + z * ry);
    }

    private static void generateFKArc(Iterator it, TopView view, Writer sb, boolean reverseArc) {
        try {
            DesignPartView dpv = view.getDesignPartView();
            Dimension dim = view.getSize();
            int width = dim.width;
            int height = dim.height;
            Point location = view.getLocation();
            Color color = Color.BLACK;
            Rectangle bounds = new Rectangle(location.x + 3, location.y + 3, width - 7, height - 7);
            if (view != null) {
                sb.write("\n<g fill=\"none\" stroke-opacity=\"1.0\" stroke=\"rgb(0,0,0)\" transform=\"translate(" + location.getX() + "," + location.getY() + ")\" >");
                ArrayList<Point2D> points = new ArrayList<Point2D>();
                while (it.hasNext()) {
                    Point2D p2;
                    DesignObject fkey = (DesignObject)it.next();
                    TVConnector tv = (TVConnector)fkey.getFirstViewForDPV(dpv);
                    if (tv == null || tv.getActualPoints().size() <= 0) continue;
                    Point2D p1 = DiagramToSVG.getPoint(tv, 0);
                    int j = DiagramToSVG.getPointsCount(tv);
                    if (tv.isSelfReference() && !reverseArc) {
                        p1 = DiagramToSVG.getPoint(tv, j - 1);
                        p2 = DiagramToSVG.getPoint(tv, j - 2);
                    } else if (bounds.contains(p1)) {
                        p2 = DiagramToSVG.getPoint(tv, 1);
                    } else {
                        p1 = DiagramToSVG.getPoint(tv, j - 1);
                        p2 = DiagramToSVG.getPoint(tv, j - 2);
                    }
                    Point2D p = DiagramToSVG.getRelationPoint(bounds, p1, p2);
                    if (p == null && j > 2) {
                        if (bounds.contains(DiagramToSVG.getPoint(tv, 0))) {
                            p1 = DiagramToSVG.getPoint(tv, 1);
                            p2 = DiagramToSVG.getPoint(tv, 2);
                        } else {
                            p1 = DiagramToSVG.getPoint(tv, j - 2);
                            p2 = DiagramToSVG.getPoint(tv, j - 3);
                        }
                        p = DiagramToSVG.getRelationPoint(bounds, p1, p2);
                    }
                    if (p == null) continue;
                    points.add(p);
                    double x = 0.0;
                    double y = 0.0;
                    x = p.getX() - (double)location.x - 2.0;
                    y = p.getY() - (double)location.y - 2.0;
                    DiagramToSVG.addCircle(color, 1, sb, 5, true, String.valueOf(x + 1.0), String.valueOf(y + 1.0), 2);
                }
                if (points.size() > 1) {
                    DiagramToSVG.drawArc(view, sb, points, bounds);
                }
                sb.write("\n</g>");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void processArcs(DesignPartView dpv, Writer sb) {
        block7: {
            block6: {
                if (!(dpv instanceof DPVRelational)) break block6;
                RelationalDesign rd = (RelationalDesign)dpv.getDesignPart();
                Iterator it = rd.getArcSet().iterator();
                while (it.hasNext()) {
                    FKArc arc = (FKArc)it.next();
                    TopView tv = arc.getFirstViewForDPV(dpv);
                    if (tv == null) continue;
                    try {
                        DiagramToSVG.generateFKArc(arc.getFkeys().iterator(), tv, sb, arc.isReverse());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                break block7;
            }
            if (!(dpv instanceof DPVLogical)) break block7;
            LogicalDesign rd = (LogicalDesign)dpv.getDesignPart();
            Iterator it = rd.getArcSet().iterator();
            while (it.hasNext()) {
                Arc arc = (Arc)it.next();
                TopView tv = arc.getFirstViewForDPV(dpv);
                if (tv == null) continue;
                try {
                    DiagramToSVG.generateFKArc(arc.getRelations().iterator(), tv, sb, false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static int getPointSide(Rectangle bounds, Point2D p) {
        double t;
        double pi;
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        double xCenter = x + width / 2.0;
        double yCenter = y + height / 2.0;
        double dx = p.getX() - xCenter;
        double dy = p.getY() - yCenter;
        double alpha = Math.atan2(dy, dx);
        if (alpha < -(pi = Math.PI) + (t = Math.atan2(height, width)) || alpha > pi - t) {
            return 0;
        }
        if (alpha < -t) {
            return 1;
        }
        if (alpha < t) {
            return 2;
        }
        return 3;
    }

    private static void drawArc(TopView view, Writer sb, List points, Rectangle bounds) {
        Point location = view.getLocation();
        Rectangle r = view.getBounds();
        Line2D line = DiagramToSVG.getFirstAndLastPoints(points, r);
        Point2D first = line.getP1();
        Point2D last = line.getP2();
        float p1x = (float)first.getX() - (float)location.x;
        float p1y = (float)first.getY() - (float)location.y;
        float pnx = (float)last.getX() - (float)location.x;
        float pny = (float)last.getY() - (float)location.y;
        int angleSize = 14;
        int arcSize = 10;
        float x = bounds.width + 3;
        float y = bounds.height + 3;
        try {
            sb.write("\n<path d=\"");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int p1Side = DiagramToSVG.getPointSide(bounds, first);
        int pnSide = DiagramToSVG.getPointSide(bounds, last);
        if (p1Side == 2) {
            DiagramToSVG.path_moveTo(sb, p1x - (float)arcSize, p1y - (float)(arcSize * 2));
            DiagramToSVG.path_curveTo(sb, p1x - (float)arcSize, p1y - (float)(arcSize * 2), p1x, p1y - (float)(arcSize * 2), p1x, p1y - (float)arcSize);
            if (p1Side == pnSide) {
                DiagramToSVG.path_lineTo(sb, pnx, pny + (float)arcSize);
                DiagramToSVG.path_curveTo(sb, pnx, pny + (float)arcSize, pnx, pny + (float)(arcSize * 2), pnx - (float)arcSize, pny + (float)(arcSize * 2));
            } else {
                DiagramToSVG.path_lineTo(sb, p1x, y - (float)angleSize);
                DiagramToSVG.path_curveTo(sb, p1x, y - (float)angleSize, p1x, y, p1x - (float)angleSize, y);
                if (pnSide == 3) {
                    DiagramToSVG.path_lineTo(sb, pnx - (float)arcSize, pny);
                    DiagramToSVG.path_curveTo(sb, pnx - (float)arcSize, pny, pnx - (float)(arcSize * 2), pny, pnx - (float)(arcSize * 2), pny - (float)arcSize);
                } else if (pnSide == 0) {
                    DiagramToSVG.path_lineTo(sb, pnx + (float)angleSize, y);
                    DiagramToSVG.path_curveTo(sb, angleSize, y, pnx, y, pnx, y - (float)angleSize);
                    DiagramToSVG.path_lineTo(sb, pnx, pny - (float)arcSize);
                    DiagramToSVG.path_curveTo(sb, pnx, pny - (float)arcSize, pnx, pny - (float)(arcSize * 2), pnx + (float)arcSize, pny - (float)(arcSize * 2));
                } else {
                    DiagramToSVG.path_lineTo(sb, 3 + angleSize, y);
                    DiagramToSVG.path_curveTo(sb, 3 + angleSize, y, 3.0f, y, 3.0f, y - (float)angleSize);
                    DiagramToSVG.path_lineTo(sb, 3.0f, 3 + angleSize);
                    DiagramToSVG.path_curveTo(sb, 3.0f, 3 + angleSize, 3.0f, 3.0f, 3 + angleSize, 3.0f);
                    DiagramToSVG.path_lineTo(sb, pnx + (float)arcSize, pny);
                    DiagramToSVG.path_curveTo(sb, pnx + (float)arcSize, pny, pnx + (float)(arcSize * 2), pny, pnx + (float)(arcSize * 2), pny + (float)arcSize);
                }
            }
        } else if (p1Side == 3) {
            DiagramToSVG.path_moveTo(sb, p1x + (float)(arcSize * 2), p1y - (float)arcSize);
            DiagramToSVG.path_curveTo(sb, p1x + (float)(arcSize * 2), p1y - (float)arcSize, p1x + (float)(arcSize * 2), p1y, p1x + (float)arcSize, p1y);
            if (p1Side == pnSide) {
                DiagramToSVG.path_lineTo(sb, pnx - (float)arcSize, pny);
                DiagramToSVG.path_curveTo(sb, pnx - (float)arcSize, pny, pnx - (float)(arcSize * 2), pny, pnx - (float)(arcSize * 2), pny - (float)arcSize);
            } else {
                DiagramToSVG.path_lineTo(sb, angleSize + 3, y);
                DiagramToSVG.path_curveTo(sb, angleSize + 3, y, 3.0f, y, 3.0f, y - (float)angleSize);
                if (pnSide == 0) {
                    DiagramToSVG.path_lineTo(sb, pnx, pny - (float)arcSize);
                    DiagramToSVG.path_curveTo(sb, pnx, pny - (float)arcSize, pnx, pny - (float)(arcSize * 2), pnx + (float)arcSize, pny - (float)(arcSize * 2));
                } else if (pnSide == 1) {
                    DiagramToSVG.path_lineTo(sb, 3.0f, pny + (float)angleSize);
                    DiagramToSVG.path_curveTo(sb, 3.0f, pny + (float)angleSize, 3.0f, 3.0f, 3 + angleSize, 3.0f);
                    DiagramToSVG.path_lineTo(sb, pnx + (float)arcSize, pny);
                    DiagramToSVG.path_curveTo(sb, pnx + (float)arcSize, pny, pnx + (float)(arcSize * 2), pny, pnx + (float)(arcSize * 2), pny + (float)arcSize);
                } else {
                    DiagramToSVG.path_lineTo(sb, 3.0f, 3 + angleSize);
                    DiagramToSVG.path_curveTo(sb, 3.0f, 3 + angleSize, 3.0f, 3.0f, 3 + angleSize, 3.0f);
                    DiagramToSVG.path_lineTo(sb, x - (float)angleSize, 3.0f);
                    DiagramToSVG.path_curveTo(sb, x - (float)angleSize, 3.0f, x, 3.0f, x, 3 + angleSize);
                    DiagramToSVG.path_lineTo(sb, pnx, pny + (float)arcSize);
                    DiagramToSVG.path_curveTo(sb, pnx, pny + (float)arcSize, pnx, pny + (float)(arcSize * 2), pnx - (float)arcSize, pny + (float)(arcSize * 2));
                }
            }
        } else if (p1Side == 0) {
            DiagramToSVG.path_moveTo(sb, p1x + (float)arcSize, p1y + (float)(arcSize * 2));
            DiagramToSVG.path_curveTo(sb, p1x + (float)arcSize, p1y + (float)(arcSize * 2), p1x, p1y + (float)(arcSize * 2), p1x, p1y + (float)arcSize);
            if (p1Side == pnSide) {
                DiagramToSVG.path_lineTo(sb, pnx, pny - (float)arcSize);
                DiagramToSVG.path_curveTo(sb, pnx, pny - (float)arcSize, pnx, pny - (float)(arcSize * 2), pnx + (float)arcSize, pny - (float)(arcSize * 2));
            } else {
                DiagramToSVG.path_lineTo(sb, 3.0f, angleSize);
                DiagramToSVG.path_curveTo(sb, 3.0f, angleSize, 3.0f, 3.0f, 3 + angleSize, 3.0f);
                if (pnSide == 1) {
                    DiagramToSVG.path_lineTo(sb, pnx + (float)arcSize, pny);
                    DiagramToSVG.path_curveTo(sb, pnx + (float)arcSize, pny, pnx + (float)(arcSize * 2), pny, pnx + (float)(arcSize * 2), pny + (float)arcSize);
                } else if (pnSide == 2) {
                    DiagramToSVG.path_lineTo(sb, x - (float)angleSize, 3.0f);
                    DiagramToSVG.path_curveTo(sb, x - (float)angleSize, 3.0f, x, 3.0f, x, 3 + angleSize);
                    DiagramToSVG.path_lineTo(sb, pnx, pny + (float)arcSize);
                    DiagramToSVG.path_curveTo(sb, pnx, pny + (float)arcSize, pnx, pny + (float)(arcSize * 2), pnx - (float)arcSize, pny + (float)(arcSize * 2));
                } else {
                    DiagramToSVG.path_lineTo(sb, x - (float)angleSize, 3.0f);
                    DiagramToSVG.path_curveTo(sb, x - (float)angleSize, 3.0f, x, 3.0f, x, 3 + angleSize);
                    DiagramToSVG.path_lineTo(sb, x, y - (float)angleSize);
                    DiagramToSVG.path_curveTo(sb, x, y - (float)angleSize, x, y, x - (float)angleSize, y);
                    DiagramToSVG.path_lineTo(sb, pnx - (float)arcSize, pny);
                    DiagramToSVG.path_curveTo(sb, pnx - (float)arcSize, pny, pnx - (float)(arcSize * 2), pny, pnx - (float)(arcSize * 2), pny - (float)arcSize);
                }
            }
        } else {
            DiagramToSVG.path_moveTo(sb, p1x - (float)(arcSize * 2), 3 + arcSize);
            DiagramToSVG.path_curveTo(sb, p1x - (float)(arcSize * 2), 3 + arcSize, p1x - (float)(arcSize * 2), 3.0f, p1x - (float)arcSize, 3.0f);
            if (p1Side == pnSide) {
                DiagramToSVG.path_lineTo(sb, pnx + (float)arcSize, pny);
                DiagramToSVG.path_curveTo(sb, pnx + (float)arcSize, pny, pnx + (float)(arcSize * 2), pny, pnx + (float)(arcSize * 2), pny + (float)arcSize);
            } else {
                DiagramToSVG.path_lineTo(sb, x - (float)angleSize, 3.0f);
                DiagramToSVG.path_curveTo(sb, x - (float)angleSize, 3.0f, x, 3.0f, x, 3 + angleSize);
                if (pnSide == 2) {
                    DiagramToSVG.path_lineTo(sb, pnx, pny + (float)arcSize);
                    DiagramToSVG.path_curveTo(sb, pnx, pny + (float)arcSize, pnx, pny + (float)(arcSize * 2), pnx - (float)arcSize, pny + (float)(arcSize * 2));
                } else if (pnSide == 3) {
                    DiagramToSVG.path_lineTo(sb, x, y - (float)angleSize);
                    DiagramToSVG.path_curveTo(sb, x, y - (float)angleSize, x, y, x - (float)angleSize, y);
                    DiagramToSVG.path_lineTo(sb, pnx - (float)arcSize, pny);
                    DiagramToSVG.path_curveTo(sb, pnx - (float)arcSize, pny, pnx - (float)(arcSize * 2), pny, pnx - (float)(arcSize * 2), pny - (float)arcSize);
                } else {
                    DiagramToSVG.path_lineTo(sb, x, y - (float)angleSize);
                    DiagramToSVG.path_curveTo(sb, x, y - (float)angleSize, x, y, x - (float)angleSize, y);
                    DiagramToSVG.path_lineTo(sb, 3 + angleSize, y);
                    DiagramToSVG.path_curveTo(sb, 3 + angleSize, y, 3.0f, y, 3.0f, y - (float)angleSize);
                    DiagramToSVG.path_lineTo(sb, pnx, pny - (float)arcSize);
                    DiagramToSVG.path_curveTo(sb, pnx, pny - (float)arcSize, pnx, pny - (float)(arcSize * 2), pnx + (float)arcSize, pny - (float)(arcSize * 2));
                }
            }
        }
        try {
            sb.write("\"/>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Line2D getFirstAndLastPoints(List points, Rectangle bounds) {
        TreeMap<Double, Point2D.Double> map = new TreeMap<Double, Point2D.Double>();
        for (Point2D.Double p : points) {
            double degree = DiagramToSVG.getDegree(p, bounds);
            map.put(degree, p);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        Iterator<Object> it = map.keySet().iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        int f = 0;
        int l = list.size() - 1;
        Double fd = (Double)list.get(f);
        Double ld = (Double)list.get(l);
        double d1 = fd;
        double d2 = ld;
        int w = 361;
        while (d2 - d1 > 180.0) {
            ++l;
            if (++f >= list.size()) {
                f = 0;
                --w;
            }
            if (l >= list.size()) {
                l = 0;
            }
            fd = (Double)list.get(f);
            ld = (Double)list.get(l);
            d1 = fd;
            if (!(d1 > (d2 = ld.doubleValue()))) continue;
            d2 += (double)w;
        }
        Point2D first = (Point2D)map.get(fd);
        Point2D last = (Point2D)map.get(ld);
        return new Line2D.Float(first, last);
    }

    private static double getDegree(Point2D p, Rectangle bounds) {
        double dx = p.getX() - bounds.getCenterX();
        double dy = p.getY() - bounds.getCenterY();
        double alpha = Math.atan2(dy, dx);
        double d = Math.toDegrees(alpha);
        if (d < 0.0) {
            return d + 360.0;
        }
        return d;
    }

    static void path_lineTo(Writer sb, float x, float y) {
        try {
            sb.write(" L" + x + " " + y);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void path_curveTo(Writer sb, float x1, float y1, float x2, float y2, float x3, float y3) {
        try {
            sb.write(" C " + x1 + " " + y1 + " " + x2 + " " + y2 + " " + x3 + " " + y3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void path_moveTo(Writer sb, float x, float y) {
        try {
            sb.write(" M" + x + " " + y);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getSVGForDiagram(DesignPartView dpv, boolean createLinks, String id_suffix, boolean dmwebdef) {
        return DiagramToSVG.getSVGForDiagram(dpv, createLinks, id_suffix, dmwebdef, null);
    }

    public static String getSVGForDiagram(DesignPartView dpv, boolean createLinks, String id_suffix, boolean dmwebdef, List<Line> lines) {
        DiagramToSVG.initNumIDs(dpv.getDesignPart());
        StringWriter sw = new StringWriter();
        Rectangle2D dim = dpv.getTopViewsBounds();
        if (dim == null) {
            return ALLOW_NULL;
        }
        int dx = 0;
        int dy = 0;
        boolean move = true;
        dx = 5 - (int)dim.getX();
        dy = 5 - (int)dim.getY();
        if (move) {
            dpv.move(dx, dy);
        }
        DiagramToSVG.addSVGOpenTag(sw, (int)(dim.getWidth() + 5.0), (int)(dim.getHeight() + 5.0), dmwebdef);
        DiagramToSVG.addDefs(sw, dpv);
        DiagramToSVG.processTVConnectors(dpv, sw, true, dx, dy);
        if (lines != null && lines.size() > 0) {
            DiagramToSVG.moveLines(lines, dx, dy);
            DiagramToSVG.processLines(lines, sw);
        }
        DiagramToSVG.processT_V_shapes(dpv, sw, createLinks, id_suffix, dmwebdef);
        try {
            sw.write("\n");
        }
        catch (Exception e) {
            Logger.error(e);
        }
        DiagramToSVG.addSVGCloseTag(sw);
        return sw.toString();
    }

    public static String getSVGThumbnailFromModel(DiagramThumbnailModel dm, String id, Rectangle2D dim) {
        return DiagramToSVG.getSVGThumbnailFromModel(dm, id, dim, true, true);
    }

    public static String getSVGThumbnailFromModel(DiagramThumbnailModel dm, String id, Rectangle2D dim, boolean asSymbol, boolean dmwdef) {
        StringWriter sw = new StringWriter();
        dm.setClipID();
        Rectangle2D r = dm.getBounds();
        if (r == null) {
            return ALLOW_NULL;
        }
        dim.setRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        int dx = 0;
        int dy = 0;
        boolean move = true;
        dx = 5 - (int)dim.getX();
        dy = 5 - (int)dim.getY();
        if (move) {
            dm.move(dx, dy);
        }
        if (asSymbol) {
            DiagramToSVG.addSVGAndSymbolOpenTags(id, (int)(dim.getWidth() + 5.0), (int)(dim.getHeight() + 5.0), sw, dmwdef);
        } else {
            DiagramToSVG.addSVGOpenTags(id, (int)(dim.getWidth() + 5.0), (int)(dim.getHeight() + 5.0), sw, dmwdef);
        }
        DiagramToSVG.addThumbnailDefs(sw, dm);
        DiagramToSVG.processLines(dm.lines, sw);
        DiagramToSVG.processShapes(dm, sw, dmwdef);
        try {
            sw.write("\n");
        }
        catch (Exception e) {
            Logger.error(e);
        }
        if (asSymbol) {
            DiagramToSVG.addSymbolCloseTag(sw);
        }
        DiagramToSVG.addSVGCloseTag(sw);
        return sw.toString();
    }

    public static boolean processT_V_shapes(DesignPartView dpv, Writer sb, boolean createLinks, String id_suffix, boolean dmwebdef) {
        boolean processed = false;
        Graphics2D graphics = (Graphics2D)DesignPartView.getGraphics();
        try {
            ContainerObject co;
            ContainerWithKeyObject table;
            TopView tv2;
            Iterator it = null;
            if (dpv instanceof DPVRelational) {
                it = ((DPVRelational)dpv).getTVTables().iterator();
            } else if (dpv instanceof DPVLogical) {
                it = ((DPVLogical)dpv).getTVEntities().iterator();
            }
            while (it.hasNext()) {
                tv2 = (TopView)it.next();
                table = null;
                co = (ContainerObject)tv2.getModel();
                table = (ContainerWithKeyObject)co;
                if (dpv instanceof DPVLogical && dpv.getNotation() == 1) {
                    DiagramToSVG.generateEntityBarkerNotation(table, tv2, sb, graphics, createLinks, id_suffix, dmwebdef);
                } else {
                    DiagramToSVG.generateTable(table, tv2, sb, graphics, createLinks, id_suffix, dmwebdef);
                }
                processed = true;
            }
            if (dpv instanceof DPVRelational) {
                it = ((DPVRelational)dpv).getTVViews().iterator();
            } else if (dpv instanceof DPVLogical) {
                it = ((DPVLogical)dpv).getTVViews().iterator();
            }
            while (it.hasNext()) {
                tv2 = (TopView)it.next();
                table = null;
                co = (ContainerObject)tv2.getModel();
                table = (AbstractView)co;
                DiagramToSVG.generateTableView((AbstractView)table, tv2, sb, graphics, createLinks, id_suffix, dmwebdef);
                processed = true;
            }
            for (TopView tv2 : dpv.getTopviewsList()) {
                if (!(tv2 instanceof TVNote)) continue;
                DiagramToSVG.generateNote((Note)tv2.getModel(), tv2, sb, graphics, createLinks, id_suffix, dmwebdef);
            }
        }
        catch (Exception e) {
            Logger.error(e);
        }
        return processed;
    }

    public static boolean processTVConnectors(DesignPartView dpv, Writer sb, boolean first, int dx, int dy) {
        boolean processed = false;
        try {
            Graphics2D g = (Graphics2D)DesignPartView.getGraphics();
            for (TVConnector tv : dpv.getTVConnectors()) {
                ConnectionInterface ci = (ConnectionInterface)((Object)tv.getModel());
                DesignObject so = ci.getSourceObject();
                DesignObject to = ci.getTargetObject();
                if (so == null || to == null) continue;
                DesignObject co = tv.getModel();
                if (co instanceof FKIndexAssociation) {
                    try {
                        TVLabel tvl;
                        Label label;
                        if (dpv.showLabels() && (label = tv.getCenterLabel()) != null && (tvl = (TVLabel)label.getFirstViewForDPV(dpv)) != null) {
                            Rectangle2D r = tvl.getLabelBounds();
                            DiagramToSVG.generateLabel(label, tvl, r, sb, g);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    DiagramToSVG.generateFK((FKIndexAssociation)co, tv, sb, g);
                    continue;
                }
                if (co instanceof Relation) {
                    Relation cr = (Relation)tv.getModel();
                    if (cr.getSourceEntity().isHierarchicalEntityType() || cr.getTargetEntity().isHierarchicalEntityType() || tv.getActualPoints().size() <= 0) continue;
                    DiagramToSVG.generateRelationShip((Relation)co, tv, sb, g);
                    DiagramToSVG.processRelationLabels(dpv, tv, sb, g, dx, dy);
                    continue;
                }
                if (!(co instanceof TypeSubstitution)) continue;
                DiagramToSVG.generateTypeSubstitution((TypeSubstitution)co, tv, sb, g);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.error(e);
        }
        return processed;
    }

    public static boolean processShapes(DiagramThumbnailModel dm, Writer sb, boolean dmwdef) {
        boolean processed = false;
        Graphics2D graphics = (Graphics2D)DesignPartView.getGraphics();
        try {
            for (Shape tv : dm.shapes) {
                DiagramToSVG.generateShape(tv, sb, graphics, dmwdef);
                processed = true;
            }
        }
        catch (Exception e) {
            Logger.error(e);
        }
        return processed;
    }

    public static boolean processLines(List<Line> lines, Writer sb) {
        boolean processed = false;
        try {
            for (Line line : lines) {
                DiagramToSVG.generateLine(line, sb);
            }
        }
        catch (Exception e) {
            Logger.error(e);
        }
        return processed;
    }

    public static void generateFK(FKIndexAssociation fk, TVConnector tv, Writer sb, Graphics2D g) {
        Color fgcol = DiagramToSVG.getLineColor(fk, tv);
        int width = tv.getLineWidth();
        DiagramToSVG.addSVGstartForLine(sb);
        List list = tv.getActualPoints();
        DiagramToSVG.addPath(list, !fk.isMandatory(), fgcol, width, sb);
        DiagramToSVG.addLineBegin(list, fgcol, width, sb, true, fk.isTransferable());
        int type = DiagramToSVG.getLineEndType(fk);
        int s = list.size();
        Point2D src = (Point2D)list.get(s - 2);
        Point2D dst = (Point2D)list.get(s - 1);
        DiagramToSVG.addLineEnd(list, fgcol, width, sb, type, fk.isTransferable(), !fk.isMandatory(), src, dst);
        DiagramToSVG.addSVGElementCloseTag(sb);
    }

    public static void generateRelationShip(Relation rel, TVConnector tv, Writer sb, Graphics2D g) {
        DesignPartView dpv = tv.getDesignPartView();
        int not = dpv.getNotation();
        Color fgcol = DiagramToSVG.getLineColor(rel, tv);
        int width = tv.getLineWidth();
        DiagramToSVG.addSVGstartForLine(sb);
        int borderWidth = 1;
        List list = tv.getActualPoints();
        if (not == 1) {
            if (rel.isOptionalSource() && rel.isOptionalTarget()) {
                DiagramToSVG.addPath(list, true, fgcol, width, sb);
            } else if (!rel.isOptionalSource() && !rel.isOptionalTarget()) {
                DiagramToSVG.addPath(list, false, fgcol, width, sb);
            } else {
                List nlist = DiagramToSVG.getDashedPoints(list, rel.isOptionalSource(), rel.isOptionalTarget());
                DiagramToSVG.addPath(nlist, true, fgcol, width, sb);
                nlist = DiagramToSVG.getNonDashedPoints(list, rel.isOptionalSource(), rel.isOptionalTarget());
                DiagramToSVG.addPath(nlist, false, fgcol, width, sb);
            }
        } else if (not == 2) {
            DiagramToSVG.addPath(list, !rel.isIdentifying(), fgcol, width, sb);
        } else {
            DiagramToSVG.addPath(list, false, fgcol, width, sb);
        }
        int s = list.size();
        Relation.RelationEndsDescription rd = rel.getRelationEndsDescription(not);
        Point2D src = (Point2D)list.get(1);
        Point2D dst = (Point2D)list.get(0);
        DiagramToSVG.addLineEnd(list, fgcol, borderWidth, sb, rd.beginType, rd.beginTransferable, rd.beginOptional, src, dst);
        src = (Point2D)list.get(s - 2);
        dst = (Point2D)list.get(s - 1);
        DiagramToSVG.addLineEnd(list, fgcol, width, sb, rd.endType, rd.endTransferable, rd.endOptional, src, dst);
        DiagramToSVG.addSVGElementCloseTag(sb);
    }

    public static void generateTypeSubstitution(TypeSubstitution fk, TVConnector tv, Writer sb, Graphics2D g) {
        Color fgcol = DiagramToSVG.getLineColor(fk, tv);
        int width = tv.getLineWidth();
        DiagramToSVG.addSVGstartForLine(sb);
        List list = tv.getActualPoints();
        int s = list.size();
        Point2D srci = (Point2D)list.get(s - 2);
        Point2D dsti = (Point2D)list.get(s - 1);
        int borderWidth = 1;
        int size = 4;
        Point src = new Point((int)srci.getX(), (int)srci.getY());
        Point dst = new Point((int)dsti.getX(), (int)dsti.getY());
        int d = (int)Math.max(1.0, dst.distance(src));
        double ax = -((double)size * (((Point2D)dst).getX() - ((Point2D)src).getX()) / (double)d);
        double ay = -((double)size * (((Point2D)dst).getY() - ((Point2D)src).getY()) / (double)d);
        String cx = String.valueOf((float)(((Point2D)dst).getX() + ax / 2.0 - (double)(size / 2)));
        String cy = String.valueOf((float)(((Point2D)dst).getY() + ay / 2.0 - (double)(size / 2)));
        ((Point2D)dst).setLocation(dsti.getX() + ax, dsti.getY() + ay);
        list.set(s - 1, dst);
        DiagramToSVG.addPath(list, false, fgcol, width, sb);
        DiagramToSVG.addLineBegin(list, fgcol, borderWidth, sb, false, true);
        int type = 5;
        DiagramToSVG.addCircle(fgcol, width, sb, type, false, cx, cy, size);
        DiagramToSVG.addSVGElementCloseTag(sb);
    }

    static void processRelationLabels(DesignPartView dpv, TVConnector tv, Writer sb, Graphics2D g, int dx, int dy) {
        Rectangle bounds;
        Rectangle2D r;
        TopView tvl;
        Label label;
        try {
            if (dpv.showRelAttributes() && (label = tv.getCenterLabel()) != null && label.isRelationshipAttributesLabel() && (tvl = (TVLabel)label.getFirstViewForDPV(dpv)) != null) {
                r = ((TVLabel)tvl).getLabelBounds();
                DiagramToSVG.generateRelationAttributeLabel(label, tvl, tv, r.getBounds(), sb, g);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (dpv.showLabels() && (label = tv.getSourceLabel()) != null && (tvl = label.getFirstViewForDPV(dpv)) != null) {
                r = tv.getLabelBoundsFor(0);
                bounds = DiagramToSVG.moveLocation(r, dx, dy);
                DiagramToSVG.generateLabel(label, tvl, bounds, sb, g);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (dpv.showLabels() && (label = tv.getTargetLabel()) != null && (tvl = label.getFirstViewForDPV(dpv)) != null) {
                r = tv.getLabelBoundsFor(2);
                bounds = DiagramToSVG.moveLocation(r, dx, dy);
                DiagramToSVG.generateLabel(label, tvl, bounds, sb, g);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Rectangle moveLocation(Rectangle2D r, int dx, int dy) {
        Rectangle bounds = r.getBounds();
        return new Rectangle(bounds.x + dx, bounds.y + dy, bounds.width, bounds.height);
    }

    private static List getDashedPoints(List points, boolean sourceOptional, boolean targetOptional) {
        ArrayList<Point2D> list = new ArrayList<Point2D>();
        int size = points.size();
        if (sourceOptional) {
            if (size == 2) {
                Point2D p0 = (Point2D)points.get(0);
                Point2D p1 = (Point2D)points.get(1);
                double x1 = p1.getX() - p0.getX();
                double y1 = p1.getY() - p0.getY();
                x1 = p0.getX() + x1 / 2.0;
                y1 = p0.getY() + y1 / 2.0;
                list.add(p0);
                list.add(new Point2D.Double(x1, y1));
            } else if (size > 2) {
                list.add((Point2D)points.get(0));
                list.add((Point2D)points.get(1));
            }
        } else if (targetOptional) {
            if (size == 2) {
                Point2D p0 = (Point2D)points.get(0);
                Point2D p1 = (Point2D)points.get(1);
                double x1 = p1.getX() - p0.getX();
                double y1 = p1.getY() - p0.getY();
                x1 = p0.getX() + x1 / 2.0;
                y1 = p0.getY() + y1 / 2.0;
                list.add(p1);
                list.add(new Point2D.Double(x1, y1));
            } else if (size > 2) {
                list.add((Point2D)points.get(size - 2));
                list.add((Point2D)points.get(size - 1));
            }
        }
        return list;
    }

    private static List getNonDashedPoints(List points, boolean sourceOptional, boolean targetOptional) {
        ArrayList<Point2D> list;
        block8: {
            int size;
            block6: {
                block7: {
                    list = new ArrayList<Point2D>();
                    size = points.size();
                    if (!sourceOptional) break block6;
                    if (size != 2) break block7;
                    Point2D p0 = (Point2D)points.get(0);
                    Point2D p1 = (Point2D)points.get(1);
                    double x1 = p1.getX() - p0.getX();
                    double y1 = p1.getY() - p0.getY();
                    x1 = p0.getX() + x1 / 2.0;
                    y1 = p0.getY() + y1 / 2.0;
                    list.add(p1);
                    list.add(new Point2D.Double(x1, y1));
                    break block8;
                }
                if (size <= 2) break block8;
                for (int i = 1; i < size; ++i) {
                    list.add((Point2D)points.get(i));
                }
                break block8;
            }
            if (targetOptional) {
                if (size == 2) {
                    Point2D p0 = (Point2D)points.get(0);
                    Point2D p1 = (Point2D)points.get(1);
                    double x1 = p1.getX() - p0.getX();
                    double y1 = p1.getY() - p0.getY();
                    x1 = p0.getX() + x1 / 2.0;
                    y1 = p0.getY() + y1 / 2.0;
                    list.add(p0);
                    list.add(new Point2D.Double(x1, y1));
                } else if (size > 2) {
                    for (int i = 0; i < size - 1; ++i) {
                        list.add((Point2D)points.get(i));
                    }
                }
            }
        }
        return list;
    }

    public static void generateLine(Line line, Writer sb) {
        Color fgcol = line.fgCol;
        int width = line.width;
        DiagramToSVG.addSVGstartForLine(sb);
        int borderWidth = 1;
        List<Point2D> list = line.points;
        DiagramToSVG.addPath(list, line.dashed, fgcol, width, sb);
        DiagramToSVG.addLineBegin(list, fgcol, borderWidth, sb);
        DiagramToSVG.addSVGElementCloseTag(sb);
    }

    public static void generateShape(Shape shape, Writer sb, Graphics2D g, boolean dmwebdef) {
        int colTextHeight;
        Color bgcol = shape.bgCol;
        Color fgcol = shape.fgCol;
        Color bcol = shape.fgCol;
        float bgopacity = (float)bgcol.getAlpha() / 255.0f;
        float fgopacity = (float)fgcol.getAlpha() / 255.0f;
        if (dmwebdef) {
            // empty if block
        }
        int borderWidth = 1;
        Rectangle bounds = null;
        bounds = shape.bounds;
        int titlePosition = 20;
        int yCursor = 0;
        int xCursor = 0;
        int width = bounds.width;
        int height = bounds.height;
        Object longName = ALLOW_NULL;
        longName = shape.schema != null ? shape.schema + "." + shape.name : shape.name;
        if (longName == null) {
            longName = ALLOW_NULL;
        }
        String cid = DiagramToSVG.getClipPathID(shape);
        if (shape.vnum > 0) {
            longName = (String)longName + ":" + shape.vnum;
        }
        DiagramToSVG.addShape(bgcol, bcol, bounds, sb, cid, bgopacity, fgopacity);
        if (SHAPE_TYPE_NOTE.equalsIgnoreCase(shape.type)) {
            DiagramToSVG.addNote(fgcol, width - 1, height - 1, sb);
        } else if (!SHAPE_TYPE_VIEW.equalsIgnoreCase(shape.type)) {
            DiagramToSVG.addRect(bcol, width, height, 0, 0, sb, fgopacity);
        } else {
            DiagramToSVG.addRect(bcol, width, height, 20, 20, sb, fgopacity);
        }
        if (shape.type == SHAPE_TYPE_NOTE) {
            String lt;
            String text;
            Color tcolor = shape.textColor;
            if (tcolor == null) {
                tcolor = Color.BLACK;
            }
            if ((text = shape.text).indexOf(lt = "\r\n") == -1 && text.indexOf(lt = System.getProperty("line.separator")) == -1) {
                lt = "\n";
            }
            xCursor = 6;
            float fsize = shape.textFontSize;
            Font titleFont = FONT_ARIAL.deriveFont(fsize);
            StringDimension fm = DiagramToSVG.getStringDimension(titleFont);
            colTextHeight = fm.getHeight();
            yCursor = (int)fsize;
            String[] splitText = DiagramToSVG.wrapText(text, DiagramToSVG.getMaxChars(text, fm, width - 10));
            for (int t = 0; t < splitText.length; ++t) {
                String text1 = splitText[t];
                text1 = text1.replaceAll(lt + lt, lt + " " + lt);
                String[] wrt = text1.split(lt);
                for (int k = 0; k < wrt.length; ++k) {
                    DiagramToSVG.addTextWithStyle(wrt[k], xCursor, yCursor, tcolor, sb, titleFont, false, null, null, "Arial");
                    yCursor += colTextHeight;
                }
            }
        }
        if (shape.type != SHAPE_TYPE_NOTE) {
            Font titleFont = FONT_ARIAL;
            StringDimension fm = DiagramToSVG.getStringDimension(titleFont);
            colTextHeight = fm.getHeight();
            yCursor = Math.max(colTextHeight, titleFont.getSize());
            xCursor = (width - fm.stringWidth((String)longName)) / 2;
            if (xCursor < titlePosition) {
                xCursor = titlePosition;
            }
            Color tcolor = fgcol;
            String[] wrappedTitle = DiagramToSVG.wrapText((String)longName, DiagramToSVG.getMaxChars((String)longName, fm, width - titlePosition - 5));
            for (int t = 0; t < wrappedTitle.length; ++t) {
                String text = wrappedTitle[t];
                if (dmwebdef) {
                    DiagramToSVG.addTextWithClass(text, xCursor, yCursor, sb, CSS_CLASS_TABLE_NAME);
                } else {
                    DiagramToSVG.addText(text, xCursor, yCursor, tcolor, sb, titleFont);
                }
                yCursor += colTextHeight;
            }
            yCursor -= colTextHeight;
            DiagramToSVG.addLine(0, yCursor += 3 + borderWidth, width - 2, yCursor, bcol, sb, fgopacity);
        }
        try {
            sb.write("\n</g>");
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private static void addLineBegin(List points, Color col, int width, Writer sb) {
        DiagramToSVG.addLineBegin(points, col, width, sb, true, true);
    }

    private static void addLineBegin(List points, Color col, int width, Writer sb, boolean fil, boolean transferable) {
        Point2D src = (Point2D)points.get(1);
        Point2D dst = (Point2D)points.get(0);
        String path = DiagramToSVG.createEndPath(8, 2, src, dst, transferable);
        String cols = DiagramToSVG.getColor(col);
        float opacity = (float)col.getAlpha() / 255.0f;
        String out = fil ? "\n<polygon stroke=" + cols + " stroke-dasharray=\"none\" points=\"" + path + "\" fill=" + cols + " stroke-width=\"" + width + "\" stroke-opacity=\"" + opacity + "\" fill-opacity=\"" + opacity + "\" />" : "\n<polygon stroke=" + cols + " stroke-dasharray=\"none\" points=\"" + path + "\" fill=\"white\" stroke-width=\"" + width + "\" />";
        try {
            sb.write(out);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private static void addLineEnd(List points, Color col, int width, Writer sb, int type, boolean transferable, boolean optional, Point2D src, Point2D dst) {
        float opacity = (float)col.getAlpha() / 255.0f;
        if (type == 14 || type == 2) {
            String path = DiagramToSVG.createEndPath(8, 2, src, dst, transferable);
            String cols = DiagramToSVG.getColor(col);
            Object out = ALLOW_NULL;
            out = optional ? "\n<polygon stroke-dasharray=\"none\" points=\"" + path + "\" stroke=" + cols + " fill=\"white\" stroke-width=\"" + width + "\" stroke-opacity=\"" + opacity + "\"  />" : "\n<polygon stroke-dasharray=\"none\" points=\"" + path + "\" stroke=" + cols + " fill=" + cols + " stroke-width=\"" + width + "\" stroke-opacity=\"" + opacity + "\"  />";
            if (type == 14 && !(path = DiagramToSVG.getIdentityLinedPath(6, type, src, dst)).isEmpty()) {
                out = (String)out + "\n<path stroke-dasharray=\"none\" d=\"" + path + "\" fill=\"none\" stroke-width=\"" + width + "\" stroke-opacity=\"" + opacity + "\" stroke=" + cols + " />";
            }
            try {
                sb.write((String)out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (type == 17 || type == 7 || type == 8 || type == 21 || type == 20 || type == 16 || type == 18 || type == 19 || type == 5 || type == 15) {
            String rest;
            int size = 6;
            String path = DiagramToSVG.createEndPath(size, type, src, dst, transferable);
            String[] parts = path.split("---");
            path = parts[0];
            String cols = DiagramToSVG.getColor(col);
            Object out = ALLOW_NULL;
            if (!path.isEmpty()) {
                out = "\n<path stroke-dasharray=\"none\" d=\"" + path + "\" fill=\"none\" stroke-width=\"" + width + "\" stroke-opacity=\"" + opacity + "\" stroke=" + cols + " />";
            }
            if (parts.length > 1 && !(rest = parts[1]).isEmpty()) {
                if (type == 20) {
                    out = (String)out + "\n<circle " + rest + " fill=\"none\" stroke-width=\"" + width + "\" stroke-opacity=\"" + opacity + "\" stroke=" + cols + " />";
                }
                if (type == 5 || type == 18 || type == 19 || type == 15) {
                    out = optional ? (String)out + "\n<circle " + rest + " fill=\"white\" stroke-width=\"" + width + "\" stroke-opacity=\"" + opacity + "\" stroke=" + cols + " />" : (String)out + "\n<circle " + rest + " fill=" + cols + " stroke-width=\"" + width + "\" stroke-opacity=\"" + opacity + "\" stroke=" + cols + " />";
                }
            }
            try {
                sb.write((String)out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void addCircle(Color col, int width, Writer sb, int type, boolean fil, String cx, String cy, int size) {
        if (type == 5) {
            String cols = DiagramToSVG.getColor(col);
            String out = fil ? "\n<circle stroke-dasharray=\"none\" cx=\"" + cx + "\" cy=\"" + cy + "\" stroke=" + cols + " r=\"" + size + "\" fill=" + cols + " stroke-width=\"" + width + "\" />" : "\n<circle stroke-dasharray=\"none\" cx=\"" + cx + "\" cy=\"" + cy + "\" stroke=" + cols + " r=\"" + size + "\" fill=\"none\" stroke-width=\"" + width + "\" />";
            try {
                sb.write(out);
            }
            catch (IOException e) {
                Logger.error(e);
            }
        }
    }

    private static String getIdentityLinedPath(int size, int style, Point2D srci, Point2D dsti) {
        Object res = ALLOW_NULL;
        Point src = new Point((int)srci.getX(), (int)srci.getY());
        Point dst = new Point((int)dsti.getX(), (int)dsti.getY());
        if (((Point2D)src).getX() == ((Point2D)dst).getX() - 1.0 || ((Point2D)src).getX() == ((Point2D)dst).getX() + 1.0) {
            ((Point2D)dst).setLocation(((Point2D)src).getX(), ((Point2D)dst).getY());
        }
        if (((Point2D)src).getY() == ((Point2D)dst).getY() - 1.0 || ((Point2D)src).getY() == ((Point2D)dst).getY() + 1.0) {
            ((Point2D)dst).setLocation(((Point2D)dst).getX(), ((Point2D)src).getY());
        }
        int d = (int)Math.max(1.0, dst.distance(src));
        int ax = (int)(-((double)size * (((Point2D)dst).getX() - ((Point2D)src).getX()) / (double)d));
        int ay = (int)(-((double)size * (((Point2D)dst).getY() - ((Point2D)src).getY()) / (double)d));
        float offset = 2.1f;
        if (style == 17) {
            res = (String)res + " M" + (((Point2D)dst).getX() + (double)((float)ax * offset) + (double)ay) + " " + (((Point2D)dst).getY() + (double)((float)ay * offset) - (double)ax);
            res = (String)res + " L" + (((Point2D)dst).getX() + (double)((float)ax * offset) - (double)ay) + " " + (((Point2D)dst).getY() + (double)((float)ay * offset) + (double)ax);
        } else if (style == 14) {
            offset = 1.9f;
            res = (String)res + " M" + (((Point2D)dst).getX() + (double)((float)ax * offset) + (double)ay) + " " + (((Point2D)dst).getY() + (double)((float)ay * offset) - (double)ax);
            res = (String)res + " L" + (((Point2D)dst).getX() + (double)((float)ax * offset) - (double)ay) + " " + (((Point2D)dst).getY() + (double)((float)ay * offset) + (double)ax);
        }
        return res;
    }

    private static String createEndPath(int size, int style, Point2D srci, Point2D dsti, boolean transferable) {
        Object res = ALLOW_NULL;
        Point src = new Point((int)srci.getX(), (int)srci.getY());
        Point dst = new Point((int)dsti.getX(), (int)dsti.getY());
        if (((Point2D)src).getX() == ((Point2D)dst).getX() - 1.0 || ((Point2D)src).getX() == ((Point2D)dst).getX() + 1.0) {
            ((Point2D)dst).setLocation(((Point2D)src).getX(), ((Point2D)dst).getY());
        }
        if (((Point2D)src).getY() == ((Point2D)dst).getY() - 1.0 || ((Point2D)src).getY() == ((Point2D)dst).getY() + 1.0) {
            ((Point2D)dst).setLocation(((Point2D)dst).getX(), ((Point2D)src).getY());
        }
        int d = (int)Math.max(1.0, dst.distance(src));
        int ax = (int)(-((double)size * (((Point2D)dst).getX() - ((Point2D)src).getX()) / (double)d));
        int ay = (int)(-((double)size * (((Point2D)dst).getY() - ((Point2D)src).getY()) / (double)d));
        if (style == 2 || style == 1) {
            res = (int)((Point2D)dst).getX() + " " + (int)((Point2D)dst).getY();
            res = (String)res + " " + (int)(((Point2D)dst).getX() + (double)ax + (double)(ay / 2)) + " " + (int)(((Point2D)dst).getY() + (double)ay - (double)(ax / 2));
            Point2D last = (Point2D)dst.clone();
            ((Point2D)dst).setLocation((int)(((Point2D)dst).getX() + (double)ax), (int)(((Point2D)dst).getY() + (double)ay));
            res = (String)res + " " + (int)(last.getX() + (double)ax - (double)(ay / 2)) + " " + (int)(last.getY() + (double)ay + (double)(ax / 2));
        } else if (style == 14) {
            GeneralPath path = new GeneralPath(1, 4);
            res = "M" + (float)(((Point2D)dst).getX() + (double)ax * 1.5 + (double)(ay / 2)) + " " + (float)(((Point2D)dst).getY() + (double)ay * 1.5 - (double)(ax / 2));
            path.moveTo((float)(((Point2D)dst).getX() + (double)ax * 1.5 + (double)(ay / 2)), (float)(((Point2D)dst).getY() + (double)ay * 1.5 - (double)(ax / 2)));
            path.lineTo((float)(((Point2D)dst).getX() + (double)ax * 1.5 - (double)(ay / 2)), (float)(((Point2D)dst).getY() + (double)ay * 1.5 + (double)(ax / 2)));
            Polygon poly = new Polygon();
            poly.addPoint((int)((Point2D)dst).getX(), (int)((Point2D)dst).getY());
            poly.addPoint((int)(((Point2D)dst).getX() + (double)ax + (double)(ay / 2)), (int)(((Point2D)dst).getY() + (double)ay - (double)(ax / 2)));
            Point2D last = (Point2D)dst.clone();
            ((Point2D)dst).setLocation((int)(((Point2D)dst).getX() + (double)ax), (int)(((Point2D)dst).getY() + (double)ay));
            poly.addPoint((int)(last.getX() + (double)ax - (double)(ay / 2)), (int)(last.getY() + (double)ay + (double)(ax / 2)));
            path.append(poly, false);
        } else if (style == 16 || style == 17) {
            res = "M" + (((Point2D)dst).getX() + (double)ay) + " " + (((Point2D)dst).getY() - (double)ax);
            res = (String)res + " L" + (((Point2D)dst).getX() + (double)(ax * 2)) + " " + (((Point2D)dst).getY() + (double)(ay * 2));
            res = (String)res + " L" + (((Point2D)dst).getX() - (double)ay) + " " + (((Point2D)dst).getY() + (double)ax);
            float offset = 2.1f;
            if (style == 17) {
                res = (String)res + " M" + (((Point2D)dst).getX() + (double)((float)ax * offset) + (double)ay) + " " + (((Point2D)dst).getY() + (double)((float)ay * offset) - (double)ax);
                res = (String)res + " L" + (((Point2D)dst).getX() + (double)((float)ax * offset) - (double)ay) + " " + (((Point2D)dst).getY() + (double)((float)ay * offset) + (double)ax);
            }
            if (!transferable) {
                offset = 3.0f;
                res = (String)res + " M" + (((Point2D)dst).getX() + (double)((float)ax * offset)) + " " + ((Point2D)dst).getY();
                res = (String)res + " L" + (((Point2D)dst).getX() + (double)((float)ax * offset)) + " " + (((Point2D)dst).getY() + (double)((float)ay * offset));
                ((Point2D)dst).setLocation(((Point2D)dst).getX() + (double)((float)ax * offset), ((Point2D)dst).getY() + (double)((float)ay * offset));
                float xs = (float)((Point2D)dst).getX();
                float ys = (float)((Point2D)dst).getY();
                res = (String)res + " M" + xs + " " + ys;
                res = (String)res + " L" + (((Point2D)dst).getX() + (double)ax + (double)ay / 1.5) + " " + (((Point2D)dst).getY() + (double)ay - (double)ax / 1.5);
                Point2D last = (Point2D)dst.clone();
                ((Point2D)dst).setLocation(((Point2D)dst).getX() + (double)(ax * 2), ((Point2D)dst).getY() + (double)(ay * 2));
                res = (String)res + " L" + ((Point2D)dst).getX() + " " + ((Point2D)dst).getY();
                res = (String)res + " L" + (last.getX() + (double)ax - (double)ay / 1.5) + " " + (last.getY() + (double)ay + (double)ax / 1.5);
                res = (String)res + " L" + xs + " " + ys;
            }
        } else if (style == 21) {
            res = " M" + (((Point2D)dst).getX() + (double)ay) + " " + (((Point2D)dst).getY() - (double)ax);
            res = (String)res + " L" + (((Point2D)dst).getX() + (double)(ax * 2)) + " " + (((Point2D)dst).getY() + (double)(ay * 2));
            res = (String)res + " L" + (((Point2D)dst).getX() - (double)ay) + " " + (((Point2D)dst).getY() + (double)ax);
            res = (String)res + " M" + (((Point2D)dst).getX() + (double)ax * 2.5 + (double)ay / 1.5) + " " + (((Point2D)dst).getY() + (double)ay * 2.5 - (double)ax / 1.5);
            res = (String)res + " L" + (((Point2D)dst).getX() + (double)ax * 3.5 - (double)ay / 1.5) + " " + (((Point2D)dst).getY() + (double)ay * 3.5 + (double)ax / 1.5);
            res = (String)res + " M" + (((Point2D)dst).getX() + (double)ax * 3.5 + (double)ay / 1.5) + " " + (((Point2D)dst).getY() + (double)ay * 3.5 - (double)ax / 1.5);
            res = (String)res + " L" + (((Point2D)dst).getX() + (double)ax * 2.5 - (double)ay / 1.5) + " " + (((Point2D)dst).getY() + (double)ay * 2.5 + (double)ax / 1.5);
            float offset = 2.1f;
            if (style == 17) {
                res = (String)res + " M" + (((Point2D)dst).getX() + (double)((float)ax * offset) + (double)ay) + " " + (((Point2D)dst).getY() + (double)((float)ay * offset) - (double)ax);
                res = (String)res + " L" + (((Point2D)dst).getX() + (double)((float)ax * offset) - (double)ay) + " " + (((Point2D)dst).getY() + (double)((float)ay * offset) + (double)ax);
            }
            if (!transferable) {
                offset = 3.0f;
                res = (String)res + " M" + (((Point2D)dst).getX() + (double)((float)ax * offset)) + " " + ((Point2D)dst).getY();
                res = (String)res + " L" + (((Point2D)dst).getX() + (double)((float)ax * offset)) + " " + (((Point2D)dst).getY() + (double)((float)ay * offset));
                ((Point2D)dst).setLocation(((Point2D)dst).getX() + (double)((float)ax * offset), ((Point2D)dst).getY() + (double)((float)ay * offset));
                float xs = (float)((Point2D)dst).getX();
                float ys = (float)((Point2D)dst).getY();
                res = (String)res + " M" + xs + " " + ys;
                res = (String)res + " L" + (((Point2D)dst).getX() + (double)ax + (double)ay / 1.5) + " " + (((Point2D)dst).getY() + (double)ay - (double)ax / 1.5);
                Point2D last = (Point2D)dst.clone();
                ((Point2D)dst).setLocation(((Point2D)dst).getX() + (double)(ax * 2), ((Point2D)dst).getY() + (double)(ay * 2));
                res = (String)res + " L" + ((Point2D)dst).getX() + " " + ((Point2D)dst).getY();
                res = (String)res + " L" + (last.getX() + (double)ax - (double)ay / 1.5) + " " + (last.getY() + (double)ay + (double)ax / 1.5);
                res = (String)res + " L" + xs + " " + ys;
            }
        } else if (style == 20 || style == 19) {
            res = " M" + (((Point2D)dst).getX() + (double)ay) + " " + (((Point2D)dst).getY() - (double)ax);
            res = (String)res + " L" + (((Point2D)dst).getX() + (double)(ax * 2)) + " " + (((Point2D)dst).getY() + (double)(ay * 2));
            res = (String)res + " L" + (((Point2D)dst).getX() - (double)ay) + " " + (((Point2D)dst).getY() + (double)ax);
            float wh = (float)((double)size * 0.9);
            res = (String)res + "--- cx=\"" + (((Point2D)dst).getX() + (double)ax * 3.5) + "\" cy=\"" + (((Point2D)dst).getY() + (double)ay * 3.5) + "\" r=\"" + wh + "\"";
        } else if (style == 5) {
            float wh = (float)((double)size * 0.7);
            res = (String)res + "--- cx=\"" + (((Point2D)dst).getX() + (double)(ax / 2)) + "\" cy=\"" + (((Point2D)dst).getY() + (double)(ay / 2)) + "\" r=\"" + wh + "\"";
        } else if (style == 7 || style == 8 || style == 0 || style == 18) {
            if (style != 0) {
                res = "M" + (((Point2D)dst).getX() + (double)ax + (double)ay) + " " + (((Point2D)dst).getY() + (double)ay - (double)ax);
                res = (String)res + " L" + (((Point2D)dst).getX() + (double)ax - (double)ay) + " " + (((Point2D)dst).getY() + (double)ay + (double)ax);
            }
            float offset = 2.1f;
            if (style == 18) {
                float wh = (float)((double)size * 0.9);
                res = (String)res + "--- cx=\"" + (((Point2D)dst).getX() + (double)((float)ax * offset)) + "\" cy=\"" + (((Point2D)dst).getY() + (double)((float)ay * offset)) + "\" r=\"" + wh + "\"";
            }
            offset = 1.9f;
            if (style == 8) {
                res = (String)res + " M" + (((Point2D)dst).getX() + (double)((float)ax * offset) + (double)ay) + " " + (((Point2D)dst).getY() + (double)((float)ay * offset) - (double)ax);
                res = (String)res + " L" + (((Point2D)dst).getX() + (double)((float)ax * offset) - (double)ay) + " " + (((Point2D)dst).getY() + (double)((float)ay * offset) + (double)ax);
            }
        } else if (style == 15) {
            float offset = 1.9f;
            res = (String)res + " M" + (((Point2D)dst).getX() + (double)((float)ax * offset) + (double)ay / 1.5) + " " + (((Point2D)dst).getY() + (double)((float)ay * offset) - (double)ax / 1.5);
            res = (String)res + " L" + (((Point2D)dst).getX() + (double)((float)ax * offset) - (double)ay / 1.5) + " " + (((Point2D)dst).getY() + (double)((float)ay * offset) + (double)ax / 1.5);
            float wh = (float)((double)size * 0.7);
            res = (String)res + "--- cx=\"" + (((Point2D)dst).getX() + (double)(ax / 2)) + "\" cy=\"" + (((Point2D)dst).getY() + (double)(ay / 2)) + "\" r=\"" + wh + "\"";
        }
        return res;
    }

    private static int getLineEndType(FKIndexAssociation fk) {
        boolean isOneToOneMandatory = fk.isOneToOne();
        int lend = 2;
        lend = isOneToOneMandatory ? ("CASCADE".equalsIgnoreCase(fk.getDeleteRule()) ? 22 : ("RESTRICT".equalsIgnoreCase(fk.getDeleteRule()) ? 8 : ("SET NULL".equalsIgnoreCase(fk.getDeleteRule()) ? 23 : 8))) : ("CASCADE".equalsIgnoreCase(fk.getDeleteRule()) ? 21 : ("RESTRICT".equalsIgnoreCase(fk.getDeleteRule()) ? 17 : ("SET NULL".equalsIgnoreCase(fk.getDeleteRule()) ? 20 : 17)));
        return lend;
    }

    private static void addPath(List points, boolean dashed, Color col, int width, Writer sb) {
        DiagramToSVG.addPath(points, dashed, col, false, width, sb);
    }

    private static void addPath(List points, boolean dashed, Color col, boolean fill, int width, Writer sb) {
        DiagramToSVG.addPath(points, dashed, col, fill, width, sb, null);
    }

    private static void addPath(List points, boolean dashed, Color col, boolean fill, int width, Writer sb, String dashArray) {
        String d = null;
        for (int i = 0; i < points.size(); ++i) {
            Point2D p = (Point2D)points.get(i);
            d = i == 0 ? "M" + (int)p.getX() + " " + (int)p.getY() : d + " L" + (int)p.getX() + " " + (int)p.getY();
        }
        Object dash = ALLOW_NULL;
        if (dashed) {
            dash = dashArray != null && !dashArray.isEmpty() ? " stroke-dasharray=\"" + dashArray + "\"" : " stroke-dasharray=\"8,8\"";
        }
        dash = (String)dash + " stroke-width=\"" + width + "\"";
        String scol = DiagramToSVG.getColor(col);
        float opacity = (float)col.getAlpha() / 255.0f;
        Object path = ALLOW_NULL;
        path = fill ? "\n<path stroke-opacity=\"" + opacity + "\" stroke=" + scol + (String)dash + " d=\"" + d + "\" />" : "\n<path stroke-opacity=\"" + opacity + "\" stroke=" + scol + " fill=\"none\" " + (String)dash + " d=\"" + d + "\" />";
        try {
            sb.write((String)path);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private static String getColor(Color bgcol) {
        String col = "\"rgb(" + bgcol.getRed() + "," + bgcol.getGreen() + "," + bgcol.getBlue() + ")\"";
        return col;
    }

    private static void addSVGstartForLine(Writer sb) {
        try {
            sb.write("\n<g stroke-linecap=\"butt\" >");
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private static void addSVGElementCloseTag(Writer sb) {
        try {
            sb.write("\n</g>");
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private static void addSVGOpenTag(Writer sb, int width, int height, boolean dmwdef) {
        try {
            sb.write("\n<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" version=\"1.1\"  width=\"" + width + "\" height=\"" + height + "\" stroke-opacity=\"" + OPACITY_FK_LINE + "\">");
            if (dmwdef) {
                sb.write("\n" + STYLE);
            }
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private static void addSVGAndSymbolOpenTags(String id, int width, int height, Writer sb, boolean dmwdef) {
        try {
            sb.write("\n<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" version=\"1.1\" width=\"0\" height=\"0\">");
            sb.write("\n<symbol id=\"" + id + "\" viewBox=\"0 0 " + width + " " + height + "\">");
            if (dmwdef) {
                sb.write("\n" + STYLE);
            }
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private static void addSVGOpenTags(String id, int width, int height, Writer sb, boolean dmwdef) {
        try {
            sb.write("\n<svg id=\"" + id + "\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" version=\"1.1\" width=\"" + width + "\" height=\"" + height + "\">");
            if (dmwdef) {
                sb.write("\n" + STYLE);
            }
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private static void addSVGCloseTag(Writer sb) {
        try {
            sb.write("\n</svg>");
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private static void addSymbolCloseTag(Writer sb) {
        try {
            sb.write("\n</symbol>");
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private static void addDefs(Writer sb, DesignPartView dpv) {
        try {
            sb.write("\n<defs id=\"dmw_defs\" >");
            sb.write("\n" + FK_SYM_SVG);
            sb.write("\n" + PK_SYM_SVG);
            sb.write("\n" + UK_SYM_SVG);
            DiagramToSVG.addClipPathDefs(sb, dpv);
            sb.write("\n</defs>");
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private static void addThumbnailDefs(Writer sb, DiagramThumbnailModel dm) {
        try {
            sb.write("\n<defs id=\"dmw_defs\" >");
            DiagramToSVG.addClipPathDefs(sb, dm);
            sb.write("\n</defs>");
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private static void addClipPathDefs(Writer sb, DiagramThumbnailModel dm) {
        try {
            for (Shape tv : dm.shapes) {
                Rectangle r = tv.bounds;
                if (r == null) continue;
                String id = DiagramToSVG.getClipPathID(tv);
                sb.write("\n<clipPath clipPathUnits=\"userSpaceOnUse\" id=\"" + id + "\">");
                sb.write("\n<rect x=\"0\" y=\"0\" width=\"" + r.width + "\" height=\"" + r.height + "\" />");
                sb.write("\n</clipPath>");
            }
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private static void addClipPathDefs(Writer sb, DesignPartView dpv) {
        try {
            for (TopView tv : dpv.getTVShapes()) {
                Rectangle r = tv.getBounds();
                String id = DiagramToSVG.getClipPathID(tv);
                sb.write("\n<clipPath clipPathUnits=\"userSpaceOnUse\" id=\"" + id + "\">");
                sb.write("\n<rect x=\"0\" y=\"0\" width=\"" + r.width + "\" height=\"" + r.height + "\" />");
                sb.write("\n</clipPath>");
            }
            if (dpv instanceof DPVLogical && dpv.showRelAttributes()) {
                for (TVConnector tvc : dpv.getTVConnectors()) {
                    TVLabel tv;
                    Label label = tvc.getCenterLabel();
                    if (label == null || (tv = (TVLabel)label.getFirstViewForDPV(dpv)) == null) continue;
                    Rectangle bounds = tv.getLabelBounds().getBounds();
                    String id = DiagramToSVG.getClipPathID(tvc) + "_C";
                    sb.write("\n<clipPath clipPathUnits=\"userSpaceOnUse\" id=\"" + id + "\">");
                    sb.write("\n<rect x=\"0\" y=\"0\" width=\"" + bounds.width + "\" height=\"" + bounds.height + "\" />");
                    sb.write("\n</clipPath>");
                }
            }
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private static void addUseOfDef(String id, int x, int y, int width, int height, Writer sb) {
        DiagramToSVG.addUseOfDef(id, x, y, width, height, sb, OPACITY_ICON);
    }

    private static void addUseOfDef(String id, int x, int y, int width, int height, Writer sb, float lineOpacity) {
        String use = "\n<use xlink:href=\"#" + id + "\" x=\"" + x + "\" y=\"" + y + "\" width=\"" + width + "\" height=\"" + height + "\" fill-opacity=\"" + lineOpacity + "\"/>";
        try {
            sb.write(use);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    public static void initNumIDs(DesignPart dp) {
        int counter = 1;
        for (Object obj : dp.getAllTopLevelObjects()) {
            if (!(obj instanceof ModelIDObject)) continue;
            ModelIDObject next = (ModelIDObject)obj;
            next.setNumID(counter);
            ++counter;
        }
    }

    static String getClipPathID(TopView tv) {
        String res = "clipPath";
        int num = tv.getModel().getNumID();
        int vnum = tv.getViewNumber();
        return res + num + "_" + vnum;
    }

    static String getClipPathID(Shape tv) {
        String res = "clipPath";
        return res + "_" + tv.clipID;
    }

    public static void setDMWebDefForTV(TopView tv) {
        tv.setUseDefaultColor(false);
        tv.setUseCustomFormat(true);
        DesignObject dob = tv.getModel();
        if (dob instanceof ContainerObject) {
            Color col = DiagramToSVG.getDMWebDefBGCollor((ContainerObject)dob);
            tv.setBackgroundColor(ColorUtil.getColor(col.getRGB(), (int)(255.0f * OPACITY_TABLE_BGR)));
            Color fcol = ColorUtil.getColor(COLOR_BLACK.getRGB(), (int)(255.0f * OPACITY_BORDER));
            tv.setForegroundColor(fcol);
        } else if (dob instanceof FKIndexAssociation) {
            Color col = ColorUtil.getColor(COLOR_BLACK.getRGB(), (int)(255.0f * OPACITY_FK_LINE));
            tv.setBackgroundColor(col);
            tv.setForegroundColor(col);
        }
    }

    public static StringDimension getStringDimension(Font font) {
        return new StringDimension(font);
    }

    public static class Line {
        public boolean dashed = false;
        public String dashArray = "8,8";
        public String name;
        public List<Point2D> points = new ArrayList<Point2D>();
        public Color fgCol;
        public String sourceID;
        public String targetID;
        public String sourceViewID;
        public String targetViewID;
        public int width = 1;

        public Rectangle getBounds() {
            if (this.points.size() > 0) {
                boolean first = true;
                double xmin = 0.0;
                double ymin = 0.0;
                double xmax = 0.0;
                double ymax = 0.0;
                for (Point2D p : this.points) {
                    if (first) {
                        first = false;
                        xmin = xmax = p.getX();
                        ymin = ymax = p.getY();
                        continue;
                    }
                    double x = p.getX();
                    double y = p.getY();
                    if (x < xmin) {
                        xmin = x;
                    } else if (x > xmax) {
                        xmax = x;
                    }
                    if (y < ymin) {
                        ymin = y;
                        continue;
                    }
                    if (!(y > ymax)) continue;
                    ymax = y;
                }
                return new Rectangle((int)xmin, (int)ymin, (int)(xmax - xmin), (int)(ymax - ymin));
            }
            return new Rectangle(1, 1, 1, 1);
        }

        public String getID() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Line)) {
                return false;
            }
            Line l = (Line)obj;
            if (l.width != this.width) {
                return false;
            }
            if (l.fgCol != null && !l.fgCol.equals(this.fgCol)) {
                return false;
            }
            if (l.points.size() != this.points.size()) {
                return false;
            }
            if (!l.sourceID.equalsIgnoreCase(this.sourceID)) {
                return false;
            }
            if (!l.targetID.equalsIgnoreCase(this.targetID)) {
                return false;
            }
            if (!l.sourceViewID.equalsIgnoreCase(this.sourceViewID)) {
                return false;
            }
            if (!l.targetViewID.equalsIgnoreCase(this.targetViewID)) {
                return false;
            }
            if (!l.name.equalsIgnoreCase(this.name)) {
                return false;
            }
            for (int i = 0; i < this.points.size(); ++i) {
                Point2D lp;
                Point2D p = this.points.get(i);
                if (p.equals(lp = l.points.get(i))) continue;
                return false;
            }
            return true;
        }
    }

    public static class DiagramThumbnailModel {
        public List<Shape> shapes = new ArrayList<Shape>();
        public List<Line> lines = new ArrayList<Line>();
        public List<DiagramProcessor.JoinsHolder> joins = new ArrayList<DiagramProcessor.JoinsHolder>();

        public Rectangle2D getBounds() {
            Rectangle tmp;
            Rectangle2D.Double ret = null;
            if (this.shapes.size() > 0) {
                for (Shape shape : this.shapes) {
                    tmp = null;
                    tmp = shape.bounds;
                    if (ret == null) {
                        ret = new Rectangle2D.Double(((RectangularShape)tmp).getX(), ((RectangularShape)tmp).getY(), ((RectangularShape)tmp).getWidth(), ((RectangularShape)tmp).getHeight());
                    }
                    if (tmp == null) continue;
                    Rectangle2D.union(ret, tmp, ret);
                }
            }
            if (this.lines.size() > 0) {
                for (Line line : this.lines) {
                    tmp = null;
                    tmp = line.getBounds();
                    if (ret == null) {
                        ret = new Rectangle2D.Double(((RectangularShape)tmp).getX(), ((RectangularShape)tmp).getY(), ((RectangularShape)tmp).getWidth(), ((RectangularShape)tmp).getHeight());
                    }
                    if (tmp == null) continue;
                    Rectangle2D.union(ret, tmp, ret);
                }
            }
            return ret;
        }

        public void move(int dx, int dy) {
            for (Shape shape : this.shapes) {
                shape.bounds.setLocation(shape.bounds.x + dx, shape.bounds.y + dy);
            }
            for (Line line : this.lines) {
                for (Point2D p : line.points) {
                    p.setLocation(p.getX() + (double)dx, p.getY() + (double)dy);
                }
            }
        }

        public void setClipID() {
            int i = 0;
            for (Shape shape : this.shapes) {
                shape.clipID = ++i;
            }
        }
    }

    public static class Shape {
        public String type = SHAPE_TYPE_TABLE;
        public String name;
        public String schema;
        public Rectangle bounds;
        public int vnum;
        public int clipID;
        public Color fgCol;
        public Color bgCol;
        public String viewID;
        public String text;
        public int textFontSize = 12;
        public Color textColor;

        public String getID() {
            if (SHAPE_TYPE_TABLE.equals(this.type) || SHAPE_TYPE_VIEW.equals(this.type)) {
                if (this.schema != null && !this.schema.isEmpty()) {
                    return this.schema + "." + this.name + "." + String.valueOf(this.viewID);
                }
                return this.name + "." + String.valueOf(this.viewID);
            }
            return this.viewID;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Shape)) {
                return false;
            }
            Shape s = (Shape)obj;
            if (!this.type.equals(s.type)) {
                return false;
            }
            if (!s.getID().equalsIgnoreCase(this.getID())) {
                return false;
            }
            if (!s.bounds.equals(this.bounds)) {
                return false;
            }
            if (SHAPE_TYPE_TABLE.equals(this.type) || SHAPE_TYPE_VIEW.equals(this.type)) {
                if (s.fgCol != null && !s.fgCol.equals(this.fgCol)) {
                    return false;
                }
                if (s.bgCol != null && !s.bgCol.equals(this.bgCol)) {
                    return false;
                }
            } else if (SHAPE_TYPE_NOTE.equals(this.type)) {
                if (s.textColor != null && !s.textColor.equals(this.textColor)) {
                    return false;
                }
                if (s.text != null && !s.text.equals(this.text)) {
                    return false;
                }
            }
            return true;
        }
    }

    public static class ColorUtil {
        public static int getRed(int color) {
            return (color & 0xFF0000) >>> 16;
        }

        public static int getGreen(int color) {
            return (color & 0xFF00) >>> 8;
        }

        public static int getBlue(int color) {
            return color & 0xFF;
        }

        public static int getAlpha(int color) {
            return (color & 0xFF000000) >>> 24;
        }

        public static int getIntColorNoAlpha(int color) {
            return color & 0xFFFFFF;
        }

        public static int getIntColorWithAlpha(int color, int alpha) {
            int t = alpha << 24;
            return color & 0xFFFFFF | t;
        }

        public static Color getColor(int color, int alpha) {
            return new Color(ColorUtil.getRed(color), ColorUtil.getGreen(color), ColorUtil.getBlue(color), alpha);
        }

        public static String getHexcolor(int color) {
            try {
                String res = Integer.toHexString(color);
                if (res.length() > 6) {
                    return "#" + res.substring(2);
                }
                return "#" + res;
            }
            catch (Exception exception) {
                return "#000000";
            }
        }
    }
}

