/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.Measurement;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportTemplate;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class StandardReportTemplatesPersistence {
    public static final String RT_FILE_NAME = "report_templates.xml";
    private static final Logger LOGGER = new Logger(StandardReportTemplatesPersistence.class);

    public static List<StandardReportTemplate> loadReportTemplates() {
        ArrayList<StandardReportTemplate> loadedReportTemplates = new ArrayList<StandardReportTemplate>();
        try {
            File file;
            File dir;
            if (Design.systemTypesDir != null && (dir = new File(Design.systemTypesDir)).exists() && (file = new File(dir, RT_FILE_NAME)).exists()) {
                FileInputStream fis = new FileInputStream(file);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                InputSource inputSource = new InputSource(isr);
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document doc = builder.parse(inputSource);
                StandardReportTemplatesPersistence.loadData(doc, loadedReportTemplates);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to load report templates: ", e);
        }
        return loadedReportTemplates;
    }

    private static void loadData(Document doc, List<StandardReportTemplate> loadedReportTemplates) {
        try {
            NodeList nodes1 = doc.getElementsByTagName("report_template");
            int nodesLength1 = nodes1.getLength();
            for (int i = 0; i < nodesLength1; ++i) {
                NodeList crIO;
                NodeList tDiagrams;
                NodeList tQuantitative;
                NodeList tDescr;
                Element elm = (Element)nodes1.item(i);
                Class<?> clazz = null;
                String rc = elm.getAttribute("type");
                if (!rc.trim().equals("")) {
                    int repCode = Integer.valueOf(rc);
                    if (repCode == 1 || repCode == 2) {
                        clazz = Class.forName("oracle.dbtools.crest.model.design.relational.Table");
                    } else if (repCode == 3 || repCode == 4) {
                        clazz = Class.forName("oracle.dbtools.crest.model.design.logical.Entity");
                    } else if (repCode == 5) {
                        clazz = Class.forName("oracle.dbtools.crest.model.design.Domain");
                    } else if (repCode == 7 || repCode == 8) {
                        clazz = Class.forName("oracle.dbtools.crest.model.design.datatypes.StructuredType");
                    } else if (repCode == 9 || repCode == 10) {
                        clazz = Class.forName("oracle.dbtools.crest.model.design.datatypes.CollectionType");
                    } else if (repCode == 11 || repCode == 12) {
                        clazz = Class.forName("oracle.dbtools.crest.model.design.datatypes.DistinctType");
                    } else if (repCode == 13) {
                        clazz = Class.forName("oracle.dbtools.crest.model.ChangeRequest");
                    } else if (repCode == 14) {
                        clazz = Class.forName("oracle.dbtools.crest.model.design.Measurement");
                    }
                } else {
                    String className = elm.getAttribute("class");
                    clazz = Class.forName(className);
                }
                if (clazz == null) continue;
                StandardReportTemplate rt = new StandardReportTemplate(StringUtilities.decodeAttributeValue(elm.getAttribute("name")), clazz, elm.getAttribute("id"), false);
                if (clazz == Table.class || clazz == Column.class || clazz == FKIndexAssociation.class || clazz == Index.class) {
                    NodeList tIdx;
                    NodeList tFkRT;
                    NodeList tFkRF;
                    NodeList tConstr;
                    NodeList tColsComm;
                    NodeList tCols;
                    tDescr = elm.getElementsByTagName("description_notes");
                    if (tDescr.item(0) != null) {
                        rt.setUseDescriptionInfo(Boolean.valueOf(tDescr.item(0).getTextContent()));
                    }
                    if ((tQuantitative = elm.getElementsByTagName("quantitative_info")).item(0) != null) {
                        rt.setUseQuantitativeInfo(Boolean.valueOf(tQuantitative.item(0).getTextContent()));
                    }
                    if ((tDiagrams = elm.getElementsByTagName("diagrams")).item(0) != null) {
                        rt.setUseDiagrams(Boolean.valueOf(tDiagrams.item(0).getTextContent()));
                    }
                    if ((tCols = elm.getElementsByTagName("table_columns")).item(0) != null) {
                        rt.setUseTableColumns(Boolean.valueOf(tCols.item(0).getTextContent()));
                    }
                    if ((tColsComm = elm.getElementsByTagName("table_columns_comments")).item(0) != null) {
                        rt.setUseTableColumnsComments(Boolean.valueOf(tColsComm.item(0).getTextContent()));
                    }
                    if ((tConstr = elm.getElementsByTagName("table_constraints")).item(0) != null) {
                        rt.setUseTableConstraints(Boolean.valueOf(tConstr.item(0).getTextContent()));
                    }
                    if ((tFkRF = elm.getElementsByTagName("table_fk_rf")).item(0) != null) {
                        rt.setUseTableFKReferredFrom(Boolean.valueOf(tFkRF.item(0).getTextContent()));
                    }
                    if ((tFkRT = elm.getElementsByTagName("table_fk_rt")).item(0) != null) {
                        rt.setUseTableFKReferringTo(Boolean.valueOf(tFkRT.item(0).getTextContent()));
                    }
                    if ((tIdx = elm.getElementsByTagName("table_indexes")).item(0) != null) {
                        rt.setUseTableIndexes(Boolean.valueOf(tIdx.item(0).getTextContent()));
                    }
                } else if (clazz == Entity.class || clazz == Attribute.class || clazz == CandidateKey.class || clazz == Relation.class) {
                    NodeList eOutP;
                    NodeList eIncP;
                    NodeList eRel;
                    NodeList eIdent;
                    NodeList eConstr;
                    NodeList eAttrComm;
                    NodeList eAttr;
                    tDescr = elm.getElementsByTagName("description_notes");
                    if (tDescr.item(0) != null) {
                        rt.setUseDescriptionInfo(Boolean.valueOf(tDescr.item(0).getTextContent()));
                    }
                    if ((tQuantitative = elm.getElementsByTagName("quantitative_info")).item(0) != null) {
                        rt.setUseQuantitativeInfo(Boolean.valueOf(tQuantitative.item(0).getTextContent()));
                    }
                    if ((tDiagrams = elm.getElementsByTagName("diagrams")).item(0) != null) {
                        rt.setUseDiagrams(Boolean.valueOf(tDiagrams.item(0).getTextContent()));
                    }
                    if ((eAttr = elm.getElementsByTagName("entity_attributes")).item(0) != null) {
                        rt.setUseEntityAttributes(Boolean.valueOf(eAttr.item(0).getTextContent()));
                    }
                    if ((eAttrComm = elm.getElementsByTagName("entity_attributes_comments")).item(0) != null) {
                        rt.setUseEntityAttributesComments(Boolean.valueOf(eAttrComm.item(0).getTextContent()));
                    }
                    if ((eConstr = elm.getElementsByTagName("entity_constraints")).item(0) != null) {
                        rt.setUseEntityConstraints(Boolean.valueOf(eConstr.item(0).getTextContent()));
                    }
                    if ((eIdent = elm.getElementsByTagName("entity_identifiers")).item(0) != null) {
                        rt.setUseEntityIdentifiers(Boolean.valueOf(eIdent.item(0).getTextContent()));
                    }
                    if ((eRel = elm.getElementsByTagName("entity_relationships")).item(0) != null) {
                        rt.setUseEntityRelationships(Boolean.valueOf(eRel.item(0).getTextContent()));
                    }
                    if ((eIncP = elm.getElementsByTagName("entity_inc_processes")).item(0) != null) {
                        rt.setUseEntityIncomingProcesses(Boolean.valueOf(eIncP.item(0).getTextContent()));
                    }
                    if ((eOutP = elm.getElementsByTagName("entity_out_processes")).item(0) != null) {
                        rt.setUseEntityOutgoingProcesses(Boolean.valueOf(eOutP.item(0).getTextContent()));
                    }
                } else if (clazz == Domain.class) {
                    NodeList dUie;
                    NodeList dUit;
                    NodeList dDetails = elm.getElementsByTagName("domain_constraints");
                    if (dDetails.item(0) != null) {
                        rt.setUseDomainConstraints(Boolean.valueOf(dDetails.item(0).getTextContent()));
                    }
                    if ((dUit = elm.getElementsByTagName("domain_used_in_tables")).item(0) != null) {
                        rt.setUseDomainUsedInTables(Boolean.valueOf(dUit.item(0).getTextContent()));
                    }
                    if ((dUie = elm.getElementsByTagName("domain_used_in_entities")).item(0) != null) {
                        rt.setUseDomainUsedInEntities(Boolean.valueOf(dUie.item(0).getTextContent()));
                    }
                } else if (clazz == StructuredType.class || clazz == TypeElement.class) {
                    NodeList stUIE;
                    NodeList stUIT;
                    NodeList stMethods;
                    NodeList stAttrC;
                    NodeList stAttr;
                    NodeList tDiagrams2;
                    tDescr = elm.getElementsByTagName("description_notes");
                    if (tDescr.item(0) != null) {
                        rt.setUseDescriptionInfo(Boolean.valueOf(tDescr.item(0).getTextContent()));
                    }
                    if ((tDiagrams2 = elm.getElementsByTagName("diagrams")).item(0) != null) {
                        rt.setUseDiagrams(Boolean.valueOf(tDiagrams2.item(0).getTextContent()));
                    }
                    if ((stAttr = elm.getElementsByTagName("st_attributes")).item(0) != null) {
                        rt.setUseSTAttributes(Boolean.valueOf(stAttr.item(0).getTextContent()));
                    }
                    if ((stAttrC = elm.getElementsByTagName("st_attributes_comments")).item(0) != null) {
                        rt.setUseSTAttributesComments(Boolean.valueOf(stAttrC.item(0).getTextContent()));
                    }
                    if ((stMethods = elm.getElementsByTagName("st_methods")).item(0) != null) {
                        rt.setUseSTMethods(Boolean.valueOf(stMethods.item(0).getTextContent()));
                    }
                    if ((stUIT = elm.getElementsByTagName("st_used_in_tables")).item(0) != null) {
                        rt.setUseSTUsedInTables(Boolean.valueOf(stUIT.item(0).getTextContent()));
                    }
                    if ((stUIE = elm.getElementsByTagName("st_used_in_entities")).item(0) != null) {
                        rt.setUseSTUsedInEntities(Boolean.valueOf(stUIE.item(0).getTextContent()));
                    }
                } else if (clazz == CollectionType.class) {
                    NodeList ctUIE;
                    NodeList ctUIT;
                    tDescr = elm.getElementsByTagName("description_notes");
                    if (tDescr.item(0) != null) {
                        rt.setUseDescriptionInfo(Boolean.valueOf(tDescr.item(0).getTextContent()));
                    }
                    if ((ctUIT = elm.getElementsByTagName("ct_used_in_tables")).item(0) != null) {
                        rt.setUseCTUsedInTables(Boolean.valueOf(ctUIT.item(0).getTextContent()));
                    }
                    if ((ctUIE = elm.getElementsByTagName("ct_used_in_entities")).item(0) != null) {
                        rt.setUseCTUsedInEntities(Boolean.valueOf(ctUIE.item(0).getTextContent()));
                    }
                } else if (clazz == DistinctType.class) {
                    NodeList dtUIE;
                    NodeList dtUIT;
                    tDescr = elm.getElementsByTagName("description_notes");
                    if (tDescr.item(0) != null) {
                        rt.setUseDescriptionInfo(Boolean.valueOf(tDescr.item(0).getTextContent()));
                    }
                    if ((dtUIT = elm.getElementsByTagName("dt_used_in_tables")).item(0) != null) {
                        rt.setUseDTUsedInTables(Boolean.valueOf(dtUIT.item(0).getTextContent()));
                    }
                    if ((dtUIE = elm.getElementsByTagName("dt_used_in_entities")).item(0) != null) {
                        rt.setUseDTUsedInEntities(Boolean.valueOf(dtUIE.item(0).getTextContent()));
                    }
                } else if (clazz == ChangeRequest.class) {
                    crIO = elm.getElementsByTagName("ct_impacted_objects");
                    if (crIO.item(0) != null) {
                        rt.setUseCRImpactedObjects(Boolean.valueOf(crIO.item(0).getTextContent()));
                    }
                } else if (clazz == Measurement.class && (crIO = elm.getElementsByTagName("mt_impacted_objects")).item(0) != null) {
                    rt.setUseMRImpactedObjects(Boolean.valueOf(crIO.item(0).getTextContent()));
                }
                loadedReportTemplates.add(rt);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to load standard report templates: ", e);
        }
    }
}

