/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.OwnedObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;

public class QuotaItemOracle
extends AbstractStorageObjectOracle
implements OwnedObjectOracle {
    private static final String UNLIMITED = "UNLIMITED";
    private UserOracle userOracle = null;
    private TableSpaceOracle tableSpace = null;
    private String size = "UNLIMITED";
    public static final String TYPE_NAME = "QuotaItem";

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public TableSpaceOracle getTableSpace() {
        return this.tableSpace;
    }

    public void setTableSpace(TableSpaceOracle tableSpace) {
        if (this.tableSpace != tableSpace) {
            this.tableSpace = tableSpace;
            this.fireDataFieldChange();
        }
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String value) {
        String numericPart = value = value.trim().toUpperCase();
        if (value.endsWith("K") || value.endsWith("M") || value.endsWith("G") || value.endsWith("T") || value.endsWith("P") || value.endsWith("E")) {
            numericPart = value.substring(0, value.length() - 1).trim();
        }
        try {
            Double.parseDouble(numericPart);
            this.size = value;
        }
        catch (NumberFormatException E) {
            this.size = UNLIMITED;
        }
        this.fireDataFieldChange();
    }

    @Override
    public void setUser(UserOracle user) {
        if (this.userOracle != user) {
            this.userOracle = user;
            this.setPAC_Element(user);
            this.fireDataFieldChange();
        }
    }

    @Override
    public UserOracle getUser() {
        return this.userOracle;
    }

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }
}

