/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.io.IOException;
import java.util.Map;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;

public class ValidTimeDimension
extends DesignObject {
    private Table table;
    private Column startTimeColumn;
    private Column endTimeColumn;
    private String startTimeColumnName;
    private String endTimeColumnName;
    public static final String TYPE_NAME = "ValidTime";

    public ValidTimeDimension(Table table) {
        super(table.getDesignPart());
        this.getDesign().addDesignObject(this);
        this.setTable(table);
        this.setBackup(table.isBackup());
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "Time";
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
        if (table != null) {
            table.addValidTimeDimension(this);
        }
    }

    public Column getStartTimeColumn() {
        return this.startTimeColumn;
    }

    public void setStartTimeColumn(Column startTimeColumn) {
        this.startTimeColumn = startTimeColumn;
    }

    public Column getEndTimeColumn() {
        return this.endTimeColumn;
    }

    public void setEndTimeColumn(Column endTimeColumn) {
        this.endTimeColumn = endTimeColumn;
    }

    public String getStartTimeColumnName() {
        if (this.startTimeColumn != null) {
            return this.startTimeColumn.getName();
        }
        return this.startTimeColumnName;
    }

    public void setStartTimeColumnName(String name) {
        Column column = null;
        if (name == null || name.isEmpty()) {
            this.startTimeColumnName = null;
        } else {
            this.startTimeColumnName = name;
            if (this.table != null) {
                column = (Column)this.table.getElementByName(name);
            }
        }
        this.setEndTimeColumn(column);
    }

    public String getEndTimeColumnName() {
        if (this.endTimeColumn != null) {
            return this.endTimeColumn.getName();
        }
        return this.endTimeColumnName;
    }

    public void setEndTimeColumnName(String name) {
        Column column = null;
        if (name == null || name.isEmpty()) {
            this.endTimeColumnName = null;
        } else {
            this.endTimeColumnName = name;
            if (this.table != null) {
                column = (Column)this.table.getElementByName(name);
            }
        }
        this.setEndTimeColumn(column);
    }

    @Override
    public void remove() {
        if (this.table != null) {
            this.table.removeValidTimeDimension(this);
        }
        super.remove();
    }

    @Override
    public void copy(DesignObject desObject) throws IOException {
        this.copy(desObject, null);
    }

    public void copy(DesignObject targetObject, Map copyMap) throws IOException {
        super.copy(targetObject);
        if (targetObject instanceof ValidTimeDimension) {
            ValidTimeDimension target = (ValidTimeDimension)targetObject;
            this.copyStartTimeColumn(target, copyMap);
            this.copyEndTimeColumn(target, copyMap);
        }
    }

    public void copyStartTimeColumn(ValidTimeDimension target, Map copyMap) {
        target.setStartTimeColumn(this.getTargetColumn(this.getStartTimeColumn(), target, copyMap));
    }

    public void copyEndTimeColumn(ValidTimeDimension target, Map copyMap) {
        target.setEndTimeColumn(this.getTargetColumn(this.getEndTimeColumn(), target, copyMap));
    }

    private Column getTargetColumn(Column sourceCol, ValidTimeDimension target, Map copyMap) {
        Table targetTable;
        Column targetCol = null;
        if (sourceCol != null && (targetTable = target.getTable()) != null) {
            if (copyMap != null) {
                targetCol = (Column)copyMap.get(sourceCol.getObjectID());
            }
            if (targetCol == null && (targetCol = (Column)targetTable.getElementByID(sourceCol.getObjectID())) == null) {
                targetCol = (Column)targetTable.getElementByName(sourceCol.getName());
            }
        }
        return targetCol;
    }
}

