/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.NameSpaceController;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObjectSet;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;

public class IndexSet
extends KeyObjectSet {
    protected static final Object[] PROTOARRAY = new Index[0];
    private ContainerWithKeyObject table;

    public IndexSet(DesignPart designPart, ContainerWithKeyObject table) {
        super(designPart);
        this.table = table;
        this.setNameSpaceController(((RelationalDesign)designPart).getIndexAndConstraintNameController());
    }

    @Override
    protected Object[] getProtoTypeArray() {
        return PROTOARRAY;
    }

    @Override
    protected String getDefaultNamePrefix() {
        return this.getPreference("default index name");
    }

    @Override
    protected String getSeparator() {
        return "_";
    }

    @Override
    public String createName() {
        return super.createName();
    }

    @Override
    protected boolean doAdd(DesignObject object) {
        this.elements.add(object);
        this.addToNameMap(object);
        if (this.getNameSpaceController() != null) {
            this.getNameSpaceController().addObject(object);
        }
        SetEvent event = SetEvent.crateAddEvent();
        event.setAffected(object);
        this.fireChange(event);
        return true;
    }

    public void addAndApplyOrderFromList(List orderedIndexes) {
        ArrayList<Index> fkList = new ArrayList<Index>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Index index = (Index)it.next();
            if (!index.isFK()) continue;
            fkList.add(index);
        }
        this.elements.clear();
        this.elements.addAll(orderedIndexes);
        this.elements.addAll(fkList);
    }

    @Override
    public void sort() {
    }

    public Index getByIdOfRecoveredIntegrityIndex(String id) {
        if (id != null) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                Index index = (Index)it.next();
                if (!id.equals(index.getIdOfRecoveredIntegrityIndex())) continue;
                return index;
            }
        }
        return null;
    }

    @Override
    public boolean changeName(String schema, String oldName, String newName, DesignObject object) {
        NameSpaceController nsc = this.getNameSpaceController();
        if (nsc != null) {
            String validName = nsc.getValidName(object, schema, newName);
            if (validName.equals(newName)) {
                nsc.updateNamesMap(schema, oldName, newName, object);
                this.doRenaming(oldName, newName, object);
                return true;
            }
            return false;
        }
        Object obj2 = this.names.get(newName.toUpperCase());
        if (obj2 == null || obj2 == object || this.checkIndexStates((Index)object, (Index)obj2)) {
            this.doRenaming(oldName, newName, object);
            return true;
        }
        return false;
    }

    private boolean checkIndexStates(Index currentIndex, Index otherIndex) {
        return currentIndex.getIndexState().endsWith("Plain Index") != otherIndex.getIndexState().endsWith("Plain Index");
    }

    @Override
    protected void doRenaming(String oldName, String newName, DesignObject object) {
        String oname;
        DesignObject dobj;
        if (oldName != null && (dobj = (DesignObject)this.names.get(oname = oldName.toUpperCase())) == object) {
            this.names.remove(oname);
        }
        this.names.put(newName.toUpperCase(), object);
        if (!object.getDesign().isLoading()) {
            SetEvent.NAME_CHANGED.setAffected(object);
            this.fireChange(SetEvent.NAME_CHANGED);
        }
    }

    @Override
    public boolean updateNamesMap(SchemaObject oldSchema, String oldName, SchemaObject newSchema, String newName, DesignObject object) {
        NameSpaceController nsc = this.getNameSpaceController();
        boolean res = false;
        if (nsc != null) {
            res = nsc.updateNamesMap(oldSchema, oldName, newSchema, newName, object);
            super.updateNamesMap(null, oldName, null, newName, object);
            return res;
        }
        return super.updateNamesMap(null, oldName, null, newName, object);
    }
}

