/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropIndex;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.ViewIndex;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;

public class CSSBViewIndexOraclev10g
extends AbstractCSSBOracle {
    CSSBDropIndex dropIndex = null;
    Map fkMap;

    public CSSBViewIndexOraclev10g(Map fkMap) {
        this.fkMap = fkMap;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        ViewIndex pkOrUk;
        String columns;
        CompareObjectSelection obj = (CompareObjectSelection)object;
        CompareObjectSelection viewObj = (CompareObjectSelection)((CompareObjectSelection)obj.getParent()).getParent();
        TableView view = (TableView)viewObj.getObject();
        Design design = view.getDesign();
        RDBMSSite site = view.getSelectedRDBMSSite();
        StorageDesignOracle storageDesign = (StorageDesignOracle)design.getStorageDesign(site, view);
        if (!obj.canBeCreate()) {
            boolean dropAndRecreate = false;
            for (EngPropertyHolder ph : obj.getPropertiesComparator().getPropertiesList()) {
                String propertyName;
                if (!ph.isSelected() || !(propertyName = ph.getName()).equals(PropertiesComparator.NAME) && !propertyName.equals(PropertiesComparator.COLUMNS) && !propertyName.equals(PropertiesComparator.INDEX_STATUS)) continue;
                dropAndRecreate = true;
            }
            if (dropAndRecreate) {
                if (this.dropIndex == null) {
                    this.dropIndex = new CSSBDropIndex(this.fkMap);
                }
                this.dropIndex.doAppend(oldbuffer, object, prettyPrint);
            } else {
                return;
            }
        }
        if (!(columns = (pkOrUk = (ViewIndex)obj.getObject()).getColumnsAsString(storageDesign)).isEmpty()) {
            if (!pkOrUk.getComment().isEmpty()) {
                this.appendComment(oldbuffer, pkOrUk);
            }
            StringBuffer buffer = new StringBuffer();
            CSSBViewIndexOraclev10g.appendStringWithSpace(buffer, "ALTER");
            CSSBViewIndexOraclev10g.appendStringWithSpace(buffer, "VIEW");
            CSSBViewIndexOraclev10g.appendStringWithSpace(buffer, CSSBViewIndexOraclev10g.getFormattedTableName(viewObj, storageDesign));
            CSSBViewIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBViewIndexOraclev10g.appendStringWithSpace(buffer, "ADD");
            if (!pkOrUk.getName().startsWith("SYS_")) {
                CSSBViewIndexOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBViewIndexOraclev10g.appendStringWithSpace(buffer, storageDesign.getFormatedName(pkOrUk));
            }
            String advancedComment = buffer.toString();
            if (pkOrUk.isPK()) {
                CSSBViewIndexOraclev10g.appendStringWithSpace(buffer, "PRIMARY KEY");
            } else {
                CSSBViewIndexOraclev10g.appendStringWithSpace(buffer, "UNIQUE");
            }
            CSSBViewIndexOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBViewIndexOraclev10g.appendStringWithSpace(buffer, columns);
            CSSBViewIndexOraclev10g.appendStringWithSpace(buffer, ')');
            CSSBViewIndexOraclev10g.appendStringWithSpace(buffer, "DISABLE");
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBViewIndexOraclev10g.appendLineFinisher(buffer, prettyPrint);
            CSSBViewIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            this.getStatus().incrementAlterView();
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof ViewIndex;
    }
}

