/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import java.util.List;
import oracle.dbtools.crest.model.design.PropertyNames;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropPlSqlObjectOracle;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.compare.storage.oracle.FunctionComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.PackageComparatorOracle;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PlSqlSourceStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.util.string.StringUtilities;

public class CSSBPlSqlObjectOracle
extends AbstractCSSBOracle {
    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        CompareObjectSelection sPlSqlObjSel = (CompareObjectSelection)object;
        PlSqlSourceStorageObjectOracle sourceObject = (PlSqlSourceStorageObjectOracle)sPlSqlObjSel.getObject();
        StoragePropertiesComparator propsComparator = (StoragePropertiesComparator)sPlSqlObjSel.getPropertiesComparator();
        boolean needCreate = false;
        boolean needDrop = false;
        boolean createBody = false;
        if (sPlSqlObjSel.canBeCreate()) {
            needCreate = true;
        } else {
            List propsList = propsComparator.getPropertiesList();
            for (EngPropertyHolder ph : propsList) {
                if (!ph.isModified() || !ph.isSelected() || ph.isFiltered()) continue;
                if (ph.getName().equals(PropertyNames.NAME) || ph.getName().equals(FunctionComparatorOracle.USER)) {
                    needDrop = true;
                    needCreate = true;
                    continue;
                }
                if (ph.getName().equals(FunctionComparatorOracle.DEFINITION) || ph.getName().equals(PackageComparatorOracle.PACKAGE_DEFINITION)) {
                    needCreate = true;
                    continue;
                }
                if (!ph.getName().equals(PackageComparatorOracle.PACKAGE_BODY)) continue;
                createBody = true;
            }
        }
        if (needCreate) {
            String source = sourceObject instanceof PackageOracle ? propsComparator.getChoosedPropertyValue(PackageComparatorOracle.PACKAGE_DEFINITION) : propsComparator.getChoosedPropertyValue(FunctionComparatorOracle.DEFINITION);
            if (source.trim().endsWith(" WRAPPED")) {
                CSSBPlSqlObjectOracle.appendStringWithSpace(oldbuffer, "--");
                CSSBPlSqlObjectOracle.appendStringWithSpace(oldbuffer, sourceObject.getObjectTypeName());
                CSSBPlSqlObjectOracle.appendStringWithSpace(oldbuffer, sourceObject.getLongName());
                CSSBPlSqlObjectOracle.appendStringWithSpace(oldbuffer, "is WRAPPED");
                CSSBPlSqlObjectOracle.appendNewLine(oldbuffer, prettyPrint, 0);
            } else {
                if (needDrop) {
                    CSSBDropPlSqlObjectOracle cssbDropPlSqlObject = new CSSBDropPlSqlObjectOracle();
                    cssbDropPlSqlObject.doAppend(oldbuffer, object, prettyPrint);
                }
                this.appendComment(oldbuffer, sourceObject);
                StringBuffer advancedCommentBuffer = new StringBuffer();
                this.appendCreateOrReplace(advancedCommentBuffer, sourceObject);
                StringBuffer buffer = new StringBuffer(source);
                this.appendToBuffer(oldbuffer, buffer, advancedCommentBuffer.toString());
                if (this.getStatus().getddlAdvancedGenenerator() == null) {
                    CSSBPlSqlObjectOracle.appendNewLine(oldbuffer, prettyPrint, 0);
                    CSSBPlSqlObjectOracle.appendString(oldbuffer, "/");
                }
                CSSBPlSqlObjectOracle.appendNewLine(oldbuffer, prettyPrint, 0);
                if (sourceObject instanceof FunctionOracle) {
                    this.getStatus().incrementCreateFunction();
                } else if (sourceObject instanceof StoredProcedureOracle) {
                    this.getStatus().incrementCreateProc();
                } else {
                    this.getStatus().incrementCreatePackage();
                    this.appendPackageBody(oldbuffer, sourceObject, propsComparator, prettyPrint);
                }
                this.appendPermissions(oldbuffer, sourceObject);
            }
        } else if (createBody) {
            this.appendPackageBody(oldbuffer, sourceObject, propsComparator, prettyPrint);
        }
    }

    private void appendPackageBody(StringBuffer oldbuffer, PlSqlSourceStorageObjectOracle sourceObject, StoragePropertiesComparator propsComparator, boolean prettyPrint) {
        String packageBody = propsComparator.getChoosedPropertyValue(PackageComparatorOracle.PACKAGE_BODY);
        String trimmedPackageBody = packageBody.trim();
        if (trimmedPackageBody.length() > 0) {
            if (trimmedPackageBody.endsWith(" WRAPPED")) {
                CSSBPlSqlObjectOracle.appendStringWithSpace(oldbuffer, "--");
                CSSBPlSqlObjectOracle.appendStringWithSpace(oldbuffer, "Package Body");
                CSSBPlSqlObjectOracle.appendStringWithSpace(oldbuffer, sourceObject.getLongName());
                CSSBPlSqlObjectOracle.appendStringWithSpace(oldbuffer, "is WRAPPED");
                CSSBPlSqlObjectOracle.appendNewLine(oldbuffer, prettyPrint, 0);
            } else {
                StringBuffer advancedCommentBuffer = new StringBuffer();
                this.appendCreateOrReplace(advancedCommentBuffer);
                CSSBPlSqlObjectOracle.appendStringWithSpace(advancedCommentBuffer, "Package Body");
                CSSBPlSqlObjectOracle.appendStringWithSpace(advancedCommentBuffer, sourceObject.getStorageDesign().getFormatedLongNameDDL(sourceObject));
                StringBuffer buffer = new StringBuffer(packageBody);
                this.appendToBuffer(oldbuffer, buffer, advancedCommentBuffer.toString());
                if (this.getStatus().getddlAdvancedGenenerator() == null) {
                    CSSBPlSqlObjectOracle.appendNewLine(oldbuffer, prettyPrint, 0);
                    CSSBPlSqlObjectOracle.appendString(oldbuffer, "/");
                }
                CSSBPlSqlObjectOracle.appendNewLine(oldbuffer, prettyPrint, 0);
                this.getStatus().incrementCreatePackageBody();
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof PlSqlSourceStorageObjectOracle;
    }

    private void appendPermissions(StringBuffer oldbuffer, PlSqlSourceStorageObjectOracle storageObjectOracle) {
        StorageDesignOracle storageDesignOracle = storageObjectOracle.getStorageDesignOracle();
        StringBuffer buffer = new StringBuffer();
        PermissionsSetOracle permissionsSet = storageDesignOracle.getPermissionsSet();
        for (PermissionsOracle permissions : permissionsSet) {
            if (!storageObjectOracle.equals(permissions.getPackage()) && !storageObjectOracle.equals(permissions.getProc()) && !storageObjectOracle.equals(permissions.getFunctionOracle()) || permissions.getUser() == null && permissions.getRole() == null) continue;
            if (StringUtilities.isNotEmpty(permissions.getPrivileges())) {
                this.appendPrivileges(oldbuffer, buffer, permissions, storageObjectOracle, storageDesignOracle, false);
            }
            if (!StringUtilities.isNotEmpty(permissions.getPrivilegesWithGrantOption())) continue;
            this.appendPrivileges(oldbuffer, buffer, permissions, storageObjectOracle, storageDesignOracle, true);
        }
    }

    private void appendPrivileges(StringBuffer oldBuffer, StringBuffer buffer, PermissionsOracle permissions, PlSqlSourceStorageObjectOracle storageObjectOracle, StorageDesignOracle storageDesignOracle, boolean withGrantOption) {
        buffer.append(NEWLINE);
        buffer.append(NEWLINE);
        this.appendComment(buffer, permissions);
        CSSBPlSqlObjectOracle.appendStringWithSpace(buffer, "GRANT");
        if (withGrantOption) {
            buffer.append(permissions.getPrivilegesWithGrantOption());
        } else {
            buffer.append(permissions.getPrivileges());
        }
        this.appendObject(buffer, storageObjectOracle, storageDesignOracle);
        this.appendTo(buffer, permissions, storageDesignOracle);
        if (withGrantOption) {
            this.appendGrantOption(buffer, permissions);
        }
        String advancedComment = buffer.toString();
        this.appendToBuffer(oldBuffer, buffer, advancedComment);
        buffer.append(NEWLINE);
        buffer.append(';');
        buffer.append(NEWLINE);
        this.appendToBuffer(oldBuffer, buffer, advancedComment);
    }

    private void appendObject(StringBuffer buffer, PlSqlSourceStorageObjectOracle storageObjectOracle, StorageDesign storageDesign) {
        buffer.append(NEWLINE);
        CSSBPlSqlObjectOracle.appendStringWithSpace(buffer, "ON");
        CSSBPlSqlObjectOracle.appendStringWithSpace(buffer, storageDesign.getFormatedLongNameDDL(storageObjectOracle));
    }

    private void appendGrantOption(StringBuffer buffer, PermissionsOracle permissions) {
        if (permissions.getRole() == null) {
            CSSBPlSqlObjectOracle.appendStringWithSpace(buffer, "WITH GRANT OPTION");
        }
    }
}

