/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype.oracle.v9i;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDPackedSized;

public class MDTimestampOraclev9i
extends MDPackedSized {
    protected String name = "TIMESTAMP";

    public MDTimestampOraclev9i() {
        this.precision = 6;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected String getNameFirstPart() {
        return "TIMESTAMP";
    }

    protected String getNameSecondPart() {
        return "";
    }

    @Override
    public String getMaxSize() {
        return "31";
    }

    @Override
    public MDDataType deepCopy() {
        MDTimestampOraclev9i copy = new MDTimestampOraclev9i();
        copy.setPrecision(this.getPrecision());
        return copy;
    }

    @Override
    public void setPrecision(int precision) {
        if (precision >= 0 && precision <= 9) {
            this.precision = precision;
            this.precisionStr = String.valueOf(precision);
            this.fireSizeChange();
        }
    }

    @Override
    public boolean hasScale() {
        return false;
    }

    public void setPrecision(String precision) {
        try {
            int pr = Integer.parseInt(precision);
            if (pr >= 0 && pr <= 9) {
                this.precision = pr;
            }
        }
        catch (NumberFormatException e) {
            this.precision = 6;
        }
    }

    @Override
    public void appendTo(StringBuffer buffer) {
        buffer.append(this.getNameFirstPart());
        if (this.getPrecision() != 6) {
            buffer.append(" (");
            buffer.append(this.getPrecision());
            buffer.append(")");
        }
        buffer.append(this.getNameSecondPart());
    }

    @Override
    public String getPrecisionText() {
        return Messages.getString("MDTimestampOracle.FractionalSecondsPrecision");
    }

    @Override
    public int getMaxPrecision() {
        return 9;
    }
}

