/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle.v10g;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.UndoTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.util.Closeables;

public class MOHUndoTableSpaceOraclev10g
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "UNDO TABLESPACE";
    private static final Logger LOGGER = new Logger(MOHUndoTableSpaceOraclev10g.class);
    protected boolean dbaUser;

    public MOHUndoTableSpaceOraclev10g(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List extract(Connection sqlConnection, List schemas) throws SQLException {
        ResultSet rs;
        Statement statement;
        ArrayList<DBObject> list;
        block6: {
            list = new ArrayList<DBObject>();
            statement = sqlConnection.createStatement();
            rs = null;
            try {
                String filterCondition = this.getFilterConditionOracle("TABLESPACE_NAME");
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("TABLESPACE_NAME").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(this.dbaUser ? "dba_tablespaces" : "user_tablespaces").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("TABLESPACE_NAME").append(' ');
                buffer.append("NOT").append(' ').append("IN").append(' ');
                buffer.append('(').append('\'');
                buffer.append("SYSTEM").append('\'').append(')').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("CONTENTS").append('=').append('\'');
                buffer.append("UNDO").append('\'').append(' ');
                if (filterCondition != null) {
                    buffer.append("AND").append(' ').append(filterCondition).append(' ');
                }
                buffer.append("ORDER BY").append(' ');
                buffer.append("TABLESPACE_NAME");
                rs = statement.executeQuery(buffer.toString());
                if (rs == null) break block6;
                while (rs.next()) {
                    String tablespaceName = rs.getString(1);
                    DBObject dboTablespace = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), tablespaceName, OBJECT_TYPE);
                    list.add(dboTablespace);
                }
                rs.close();
            }
            catch (Exception e) {
                try {
                    LOGGER.error("MOHUndoTableSpaceOraclev10g.extract():", e);
                }
                catch (Throwable throwable) {
                    Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                    throw throwable;
                }
                Closeables.close((Object[])new AutoCloseable[]{rs, statement});
            }
        }
        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws SQLException {
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            for (int i = 0; i < selectedObjects.size(); ++i) {
                DBObject dbo = (DBObject)selectedObjects.get(i);
                if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
                try {
                    if (statement == null) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("SELECT").append(' ');
                        buffer.append("BIGFILE").append(',');
                        buffer.append("RETENTION").append(' ');
                        buffer.append("FROM").append(' ');
                        buffer.append(this.dbaUser ? "dba_tablespaces" : "user_tablespaces").append(' ');
                        buffer.append("WHERE").append(' ');
                        buffer.append("TABLESPACE_NAME").append('=').append('?').append(' ');
                        buffer.append("AND").append(' ');
                        buffer.append("CONTENTS").append('=').append('\'');
                        buffer.append("UNDO").append('\'');
                        statement = sqlConnection.prepareStatement(buffer.toString());
                    }
                    statement.setString(1, dbo.getName());
                    rs = statement.executeQuery();
                }
                catch (Exception e) {
                    LOGGER.error("MOHUndoTableSpaceOraclev10g.generate():", e);
                }
                if (rs != null) {
                    if (rs.next()) {
                        StorageDesign storageDesign = this.getStorageDesign();
                        if (storageDesign instanceof StorageDesignOraclev10g) {
                            UndoTablespaceOracle tableSpace = ((StorageDesignOraclev10g)storageDesign).getUndoTablespaceSet().createTablespace();
                            tableSpace.setName(dbo.getName());
                            this.setProperties(tableSpace, rs);
                            this.stampModelObject(tableSpace, dbo);
                        } else {
                            LOGGER.error("Unable to find Storage Design!");
                        }
                    }
                    rs.close();
                }
                importLog.incrementImportedStatements();
                this.addToHandledObjects(dbo);
            }
        }
        catch (Throwable throwable) {
            Closeables.close((Object[])new AutoCloseable[]{rs, statement});
            throw throwable;
        }
        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
    }

    private void setProperties(UndoTablespaceOracle tableSpace, ResultSet resultSet) throws SQLException {
        String bigfile = resultSet.getString("BIGFILE");
        if ("YES".equals(bigfile)) {
            tableSpace.setFileType("BIGFILE");
        } else if ("NO".equals(bigfile)) {
            tableSpace.setFileType("SMALLFILE");
        }
        String retention = resultSet.getString("RETENTION");
        if ("GUARANTEE".equals(retention) || "NOGUARANTEE".equals(retention)) {
            tableSpace.setRetention(retention);
        }
    }
}

