/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.mle_js;

import java.io.IOException;
import java.io.Writer;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.RequestManager;
import oracle.dbtools.crest.imports.metadata.mle_js.DBMExtractionHandlerMLE_JS;
import oracle.dbtools.crest.imports.metadata.mle_js.MOHMlejsHandler;
import oracle.dbtools.crest.model.PropertiesObject;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.mle_js.AntlrAstParser;
import oracle.dbtools.mle_js.MLEConstants;
import oracle.dbtools.mle_js.MLEJS_Util;
import oracle.dbtools.mle_js.MLEModule;
import oracle.dbtools.mle_js.ModuleMetadata;
import oracle.dbtools.mle_js.RequestProcessing;

public class MOHModule
extends MOHMlejsHandler
implements MLEConstants {
    public static final String OBJECT_TYPE = "MODULE";
    public static final String DBA_TABLE = "SYS.DBA_MLE_MODULES";
    public static final String ALL_TABLE = "SYS.ALL_MLE_MODULES";
    public static final String DBA_ARGS_TABLE = "SYS.DBA_SCHEDULER_PROGRAM_ARGS";
    public static final String ALL_ARGS_TABLE = "SYS.ALL_SCHEDULER_PROGRAM_ARGS";

    public MOHModule(DBMExtractionHandlerMLE_JS dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public List<PropertiesObject> generate(Connection conn, List<DBObject> selectedObjects) throws Exception {
        boolean dba = this.isDBA(conn);
        String sql = this.getSQL(dba);
        ArrayList<PropertiesObject> res = new ArrayList<PropertiesObject>();
        try {
            for (DBObject dbo : selectedObjects) {
                if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
                try {
                    PreparedStatement ps = conn.prepareStatement(sql);
                    try {
                        String schema = dbo.getSchema();
                        String name = dbo.getName();
                        ps.setString(1, schema);
                        ps.setString(2, name);
                        ResultSet rs = ps.executeQuery();
                        try {
                            if (!rs.next()) continue;
                            String version = rs.getString(3);
                            Blob blob = rs.getBlob(4);
                            String module = MLEJS_Util.blobToString(blob);
                            Clob clob = rs.getClob(5);
                            String metadata = null;
                            if (clob != null) {
                                metadata = clob.getSubString(1L, (int)clob.length());
                                clob.free();
                            }
                            MLEModule mod = new MLEModule();
                            mod.setProperty("MODULE_OWNER", schema);
                            mod.setProperty("MODULE_NAME", name);
                            mod.setProperty("VERSION", version);
                            mod.setProperty(OBJECT_TYPE, module);
                            mod.setProperty("METADATA", metadata);
                            res.add(mod);
                        }
                        finally {
                            if (rs == null) continue;
                            rs.close();
                        }
                    }
                    finally {
                        if (ps == null) continue;
                        ps.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
        return res;
    }

    String getSQL(boolean dba) {
        String sql = "select module_owner, module_name,version, module, metadata from " + (dba ? DBA_TABLE : ALL_TABLE) + " \n where module_owner = ? and module_name = ?";
        return sql;
    }

    public ModuleMetadata.AllMetadata getAllMetadata(Connection conn, RequestManager.ContentWrapper cw, String schema, String name, Logger log) {
        boolean dba = this.isDBA(conn);
        return this.getAllMetadata(conn, cw, schema, name, log, dba);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModuleMetadata.AllMetadata getAllMetadata(Connection conn, RequestManager.ContentWrapper cw, String schema, String name, Logger log, boolean dba) {
        String sql = this.getMetadataSQL(dba);
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, schema);
            ps.setString(2, name);
            try (ResultSet rs = ps.executeQuery();){
                ModuleMetadata.AllMetadata allmeta;
                if (!rs.next()) return null;
                Clob clob = rs.getClob(1);
                String metadata = "{}";
                if (clob != null) {
                    metadata = clob.getSubString(1L, (int)clob.length());
                }
                if (metadata == null) return null;
                ModuleMetadata.AllMetadata allMetadata = allmeta = AntlrAstParser.getAllMetaDataFromJSON(metadata);
                return allMetadata;
            }
        }
        catch (Exception e) {
            cw.logError(" Error getting module metadata", e);
        }
        return null;
    }

    String getMetadataSQL(boolean dba) {
        String sql = "select metadata from " + (dba ? DBA_TABLE : ALL_TABLE) + " \n where module_owner = ? and module_name = ?";
        return sql;
    }

    public void updateUserMetadata(Connection conn, RequestManager.ContentWrapper cw, String schema, String name, String userMetaData, String oldGuid, Logger log) {
        boolean dba = this.isDBA(conn);
        String mschema = MLEJS_Util.getName(schema);
        String mname = MLEJS_Util.getName(name);
        ModuleMetadata.AllMetadata allmeta = this.getAllMetadata(conn, cw, mschema, mname, log, dba);
        String guid = null;
        String oldUsermeta = null;
        if (allmeta == null) {
            int status = 404;
            cw.setContentType(MLEJS_Util.CT_JSON_UTF8);
            cw.setStatus(status);
            String res = "{\"schema\":\"" + RequestProcessing.encode(schema) + "\",\"name\":\"" + RequestProcessing.encode(name) + "\",\"error\":\"Module is not found\"}";
            cw.writeBytes(res);
            return;
        }
        guid = allmeta.getUserMetaGUID();
        oldUsermeta = allmeta.getUserMetadata();
        if (guid == null || guid.isEmpty() || guid.equals(oldGuid)) {
            String newguid = new GUID().toString();
            allmeta.setUserMetaGUID(newguid);
            allmeta.setUserMetadata(userMetaData);
            String meta = allmeta.toJSONString(true);
            String sql = "{call ords_sdw_mle_js.update_module_metadata(?,?,?)}";
            try (CallableStatement cs = conn.prepareCall(sql);){
                cs.setString(1, schema);
                cs.setString(2, name);
                Clob clob = conn.createClob();
                clob.setString(1L, meta);
                cs.setClob(3, clob);
                try {
                    cs.execute();
                    cw.setContentType(MLEJS_Util.CT_JSON_UTF8);
                    String res = "{\"schema\":\"" + RequestProcessing.encode(schema) + "\",\"name\":\"" + RequestProcessing.encode(name) + "\",\"" + ModuleMetadata.USER_METADATA_GUID + "\":\"" + newguid + "\"}";
                    cw.writeBytes(res);
                }
                catch (Exception e) {
                    String err = e.getMessage();
                    int status = 500;
                    if (err.toLowerCase(Locale.ENGLISH).indexOf("no data found") > -1) {
                        status = 404;
                    }
                    cw.setContentType(MLEJS_Util.CT_JSON_UTF8);
                    cw.setStatus(status);
                    String res = "{\"schema\":\"" + RequestProcessing.encode(schema) + "\",\"name\":\"" + RequestProcessing.encode(name) + "\",\"error\":\"" + RequestProcessing.encode(err) + "\"}";
                    cw.writeBytes(res);
                }
            }
            catch (Exception e) {
                cw.logError(" MOHModule - update MLE JS module user defined metadata", e);
            }
        } else {
            try {
                cw.setStatus(409);
                MOHModule.addChangedCode(cw, schema, name, "user metadata already updated", 409, guid, oldUsermeta, log);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static void addChangedCode(RequestManager.ContentWrapper cw, String schema, String name, String error, int statusCode, String guid, String userMetadata, Logger log) throws IOException {
        Writer wr = cw.getWriter();
        MLEJS_Util.addOpenObjectChar(wr, true);
        RequestProcessing.addElement("schema", RequestProcessing.encode(String.valueOf(schema)), wr, true);
        RequestProcessing.addElement("name", RequestProcessing.encode(String.valueOf(name)), wr, false);
        RequestProcessing.addElement("statusCode", String.valueOf(statusCode), wr, false, true);
        if (error != null) {
            RequestProcessing.addElement("error", RequestProcessing.encode(String.valueOf(error)), wr, false);
        }
        if (guid != null) {
            RequestProcessing.addElement(ModuleMetadata.USER_METADATA_GUID, RequestProcessing.encode(String.valueOf(guid)), wr, false);
        }
        if (userMetadata != null) {
            wr.write(",\n\"" + ModuleMetadata.USER_META + "\":" + userMetadata);
        }
        wr.write("\n}");
    }
}

