/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.util.Closeables;

public class MOHView
extends AbstractMOHandler {
    PreparedStatement viewDefSt;
    PreparedStatement nullSchemaSt;
    public static final String OBJECT_TYPE = "VIEW";

    public MOHView(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    protected ResultSet getTables(DatabaseMetaData dbmd, DBObject dbo, boolean all) throws SQLException {
        if (all) {
            return dbmd.getTables(null, dbo.getName(), "%", new String[]{OBJECT_TYPE, "VIRTUAL_VIEW"});
        }
        return dbmd.getTables(null, dbo.getSchema(), dbo.getName(), new String[]{OBJECT_TYPE, "VIRTUAL_VIEW"});
    }

    protected ResultSet getColumns(DatabaseMetaData dbmd, DBObject dboTableView) throws SQLException {
        return dbmd.getColumns(null, dboTableView.getSchema(), dboTableView.getName(), "%");
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        DatabaseMetaData dbmd = sqlConnection.getMetaData();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            ResultSet rs = this.getTables(dbmd, dboNext, true);
            try {
                while (rs.next()) {
                    String objName = rs.getString("TABLE_NAME");
                    String schema = rs.getString(2);
                    if (schema == null) {
                        schema = dboNext.getName();
                    }
                    DBObject dbo = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), objName, OBJECT_TYPE, schema);
                    list.add(dbo);
                }
                rs.close();
            }
            finally {
                if (rs == null) continue;
                rs.close();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws SQLException {
        this.viewDefSt = null;
        this.nullSchemaSt = null;
        try {
            first = true;
            dbmd = sqlConnection.getMetaData();
            dbProductName = dbmd.getDatabaseProductName().toUpperCase();
            syntaxProvider = null;
            for (i = 0; i < AbstractView.DB_SYNTAX_PROVIDERS.length; ++i) {
                if (!dbProductName.startsWith(AbstractView.DB_SYNTAX_PROVIDERS[i].toUpperCase())) continue;
                syntaxProvider = AbstractView.DB_SYNTAX_PROVIDERS[i];
                break;
            }
            for (i = 0; i < selectedObjects.size(); ++i) {
                dboTableView = (DBObject)selectedObjects.get(i);
                if (!"VIEW".equalsIgnoreCase(dboTableView.getType())) continue;
                if ("Hive".equalsIgnoreCase(dbProductName)) {
                    stmt = sqlConnection.createStatement();
                    sql = "describe formatted " + dboTableView.getName();
                    col = false;
                    empty = false;
                    rs = stmt.executeQuery(sql);
                    try {
                        if (rs == null) ** GOTO lbl113
                        defStarted = false;
                        tableView = this.getDesign().getRelationalDesign().getTableViewSet().createTableView(null);
                        tableView.setSchema(dboTableView.getSchema());
                        tableView.setName(dboTableView.getName());
                        while (rs.next()) {
                            val = rs.getString(1);
                            if ("# col_name".equals(val.trim())) {
                                col = true;
                                continue;
                            }
                            if (col && (val == null || "".equals(val.trim()))) {
                                if (empty = empty == false) continue;
                                col = false;
                                continue;
                            }
                            if (col && empty) {
                                col_name = val.trim();
                                dataType = rs.getString(2);
                                cvExp = tableView.createViewElement(tableView.getDesignPart());
                                cvExp.setName(col_name);
                                cvExp.setHeaderAlias(col_name);
                                this.stampModelObject((ModelObject)cvExp, tableView.getName(), col_name);
                                cvExp.setDesign(tableView.getDesign());
                                cvExp.setAlias(col_name);
                                cvExp.setDataType(dataType);
                                cvExp.setContainer(tableView);
                                tableView.add(cvExp);
                                continue;
                            }
                            if ("View Original Text:".equals(val.trim())) {
                                usql = rs.getString(2);
                                tableView.setUserDefined(true);
                                tableView.setUserDefinedSQL(this.parseAsSelect(usql));
                                defStarted = true;
                                continue;
                            }
                            if ("View Expanded Text:".equals(val.trim())) {
                                defStarted = false;
                                continue;
                            }
                            if (!defStarted) continue;
                            usql = tableView.getUserDefinedSQL();
                            tableView.setUserDefined(true);
                            tableView.setUserDefinedSQL(this.parseAsSelect(usql) + "\n" + val);
                        }
                        rs.close();
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                } else {
                    rs = this.getTables(dbmd, dboTableView, false);
                    try {
                        if (rs != null && rs.next()) {
                            tableView = this.getDesign().getRelationalDesign().getTableViewSet().createTableView(null);
                            tableView.setSchema(dboTableView.getSchema());
                            tableView.setName(dboTableView.getName());
                            this.stampModelObject(tableView, dboTableView);
                            if (first || this.isSupportInformation_Schema()) {
                                first = false;
                                this.getViewDefinition(sqlConnection, tableView, dboTableView);
                                if (syntaxProvider != null && !"".equals(tableView.getUserDefinedSQL())) {
                                    tableView.setSyntaxProvider(syntaxProvider);
                                }
                            }
                            rsc = this.getColumns(dbmd, dboTableView);
                            try {
                                if (rsc != null) {
                                    while (rsc.next()) {
                                        col_name = rsc.getString(4);
                                        cvExp = tableView.createViewElement(tableView.getDesignPart());
                                        cvExp.setName(col_name);
                                        cvExp.setHeaderAlias(col_name);
                                        this.stampModelObject((ModelObject)cvExp, tableView.getName(), col_name);
                                        cvExp.setDesign(tableView.getDesign());
                                        cvExp.setAlias(col_name);
                                        cvExp.setContainer(tableView);
                                        tableView.add(cvExp);
                                    }
                                    rsc.close();
                                }
                            }
                            finally {
                                if (rsc != null) {
                                    rsc.close();
                                }
                            }
                        }
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                importLog.incrementImportedStatements();
            }
        }
        catch (Throwable var21_29) {
            Closeables.close((Object[])new PreparedStatement[]{this.viewDefSt, this.nullSchemaSt});
            throw var21_29;
        }
        Closeables.close((Object[])new PreparedStatement[]{this.viewDefSt, this.nullSchemaSt});
    }

    private String parseAsSelect(String userDef) {
        String beforeAs = Token.getStringBefore2(userDef, "AS");
        String afterAs = Token.getStringAfter(userDef, "AS");
        if (!"".equals(beforeAs) && !"".equals(afterAs) && afterAs.startsWith("(")) {
            afterAs = Token.getValBetweenBrackets(afterAs);
            return beforeAs + " AS " + afterAs;
        }
        return userDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getViewDefinition(Connection sqlConnection, TableView tableView, DBObject dbo) {
        ResultSet rs = null;
        try {
            String query;
            if (dbo.getSchema() != null && !"".equals(dbo.getSchema())) {
                if (this.viewDefSt == null) {
                    query = "select view_definition from information_schema.views where table_name = ? and table_schema = ?";
                    this.viewDefSt = sqlConnection.prepareStatement(query);
                }
                this.viewDefSt.setString(1, dbo.getName());
                this.viewDefSt.setString(2, dbo.getSchema());
                rs = this.viewDefSt.executeQuery();
            } else {
                if (this.nullSchemaSt == null) {
                    query = "select view_definition from information_schema.views where table_name = ?";
                    this.nullSchemaSt = sqlConnection.prepareStatement(query);
                }
                this.nullSchemaSt.setString(1, dbo.getName());
                rs = this.nullSchemaSt.executeQuery();
            }
            if (rs != null) {
                if (rs.next()) {
                    String view_def = rs.getString(1);
                    String definition = "CREATE VIEW " + tableView.getName();
                    tableView.setUserDefinedSQL(definition + " \nAS \n" + this.parseAsSelect(view_def));
                    tableView.setUserDefined(true);
                }
                rs.close();
            }
            this.setSupportInformation_Schema(true);
            Closeables.close((Object)rs);
        }
        catch (SQLException e) {
            this.setSupportInformation_Schema(false);
            Logger.error(e);
        }
        finally {
            Closeables.close(rs);
        }
    }
}

