/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.MethodParamProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.MethodProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.MethodProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StructuredTypeProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TypeElementProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.util.string.StringUtilities;

public class SSBStructuredTypeOraclev10g
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    public void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        if (object instanceof StructuredType) {
            StructuredType type = (StructuredType)object;
            SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendComment(buffer, type);
        } else if (object instanceof StructuredTypeProxyOraclev10g) {
            StructuredTypeProxyOraclev10g typeProxy = (StructuredTypeProxyOraclev10g)object;
            this.storageDesign = typeProxy.getStorageDesign();
            if (!typeProxy.getStructuredType().isPredefined()) {
                SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendComment(buffer, typeProxy);
                this.appendFullDefinition(buffer, typeProxy, prettyPrint);
                this.appendPermissions(buffer, typeProxy);
                this.incrementCreateStructuredType();
            }
        }
    }

    private void appendFullDefinition(StringBuffer oldbuffer, StructuredTypeProxyOraclev10g typeProxy, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        this.appendPrompt(buffer, typeProxy, "TYPE");
        SSBStructuredTypeOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
        SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "CREATE");
        SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "OR");
        SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "REPLACE");
        SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "TYPE");
        if (typeProxy.getOwner() != null && this.storageDesign.getDesign().getSettings().isIncludeSchemaInDDL()) {
            SSBStructuredTypeOraclev10g.appendString(buffer, this.storageDesign.getFormatedName(typeProxy.getOwner()));
            SSBStructuredTypeOraclev10g.appendString(buffer, '.');
        }
        SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(typeProxy));
        advancedComment = buffer.toString();
        if (typeProxy.getForceReplace().equalsIgnoreCase("YES") && this.storageDesign instanceof StorageDesignOraclev11g) {
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "FORCE");
        }
        if (!"".equalsIgnoreCase(typeProxy.getGlobalOid())) {
            SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "OID");
            SSBStructuredTypeOraclev10g.appendString(buffer, '\'');
            SSBStructuredTypeOraclev10g.appendString(buffer, typeProxy.getGlobalOid());
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, '\'');
        }
        if (!"".equalsIgnoreCase(typeProxy.getInvokerRights())) {
            SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "AUTHID");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, typeProxy.getInvokerRights());
        }
        StructuredTypeProxyOracle parentProxy = null;
        StructuredType parentType = ((StructuredType)typeProxy.getObject()).getParentType();
        if (parentType != null) {
            parentProxy = (StructuredTypeProxyOracle)this.storageDesign.getStructuredTypeProxySet().getProxy(parentType.getObjectID());
        }
        if (parentProxy == null) {
            SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "AS");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "OBJECT");
            SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        } else {
            SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "UNDER");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(parentProxy));
        }
        this.appendSqljObjectType(buffer, typeProxy, prettyPrint);
        SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, '(');
        this.appendElements(buffer, typeProxy, prettyPrint);
        this.appendMethods(buffer, typeProxy, prettyPrint);
        SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, ')');
        if ("NO".equalsIgnoreCase(typeProxy.getFinal())) {
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "NOT");
        }
        SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "FINAL");
        if ("NO".equalsIgnoreCase(typeProxy.getInstantiable())) {
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "NOT");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "INSTANTIABLE");
        }
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisherWithSlash(buffer, prettyPrint);
        SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
    }

    private void appendSqljObjectType(StringBuffer buffer, StructuredTypeProxyOraclev10g typeProxy, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(typeProxy.getMapToJavaClass())) {
            SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "EXTERNAL");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "NAME");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, typeProxy.getJavaClass());
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "LANGUAGE");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "JAVA");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "USING");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, typeProxy.getJavaInstanceUsing());
        }
    }

    private void appendElements(StringBuffer buffer, StructuredTypeProxyOraclev10g typeProxy, boolean prettyPrint) {
        boolean first = true;
        StructuredType st = typeProxy.getStructuredType();
        TypeElement[] elems = st.getElements();
        for (int i = 0; i < elems.length; ++i) {
            TypeElementProxyOraclev10g typeElement = (TypeElementProxyOraclev10g)typeProxy.getElementByDesignObject(elems[i]);
            if (!first) {
                this.appendComma(buffer);
            } else {
                first = false;
            }
            SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(typeElement));
            Object datatype = null;
            TypeElement attribute = (TypeElement)typeElement.getObject();
            DesignObject attDataType = attribute.getType();
            if (attDataType instanceof StructuredType || attDataType instanceof CollectionType) {
                RelationalObjectProxy proxy = this.storageDesign.getProxy(attDataType);
                datatype = proxy != null ? this.storageDesign.getFormatedLongNameDDL(proxy) : this.storageDesign.getFormatedName(attDataType);
                if (attribute.isReference() && attDataType instanceof StructuredType) {
                    datatype = "REF " + (String)datatype;
                }
            } else {
                datatype = attribute.getDataType(this.storageDesign.getRDBMSType().getName());
            }
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, (String)datatype);
            if ("".equalsIgnoreCase(typeElement.getSqlJAttr())) continue;
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "EXTERNAL");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "NAME");
            SSBStructuredTypeOraclev10g.appendString(buffer, '\'');
            SSBStructuredTypeOraclev10g.appendString(buffer, typeElement.getSqlJAttr());
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, '\'');
        }
    }

    private void appendMethods(StringBuffer buffer, StructuredTypeProxyOracle typeProxy, boolean prettyPrint) {
        boolean first;
        Iterator it = typeProxy.getMethods().iterator();
        boolean bl = first = typeProxy.getElements().size() == 0;
        while (it.hasNext()) {
            MethodProxyOraclev10g method = (MethodProxyOraclev10g)it.next();
            if (!first) {
                this.appendComma(buffer);
            } else {
                first = false;
            }
            SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            this.appendInheritanceClauses(buffer, method, prettyPrint);
            boolean isConstructor = "YES".equalsIgnoreCase(method.getConstructor());
            if (!isConstructor) {
                if (typeProxy.getMapOrderFunction() == method) {
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, typeProxy.getMapOrderType());
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "MEMBER");
                } else if ("YES".equalsIgnoreCase(method.getIsStatic())) {
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "STATIC");
                } else {
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "MEMBER");
                }
            }
            this.appendProcSpec(buffer, typeProxy, method, isConstructor, prettyPrint);
            this.appendPragmaClause(buffer, method, prettyPrint);
        }
    }

    private void appendInheritanceClauses(StringBuffer buffer, MethodProxyOraclev10g method, boolean prettyPrint) {
        if (!"NO".equalsIgnoreCase(method.getOverriding())) {
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "OVERRIDING");
        }
        if ("NO".equalsIgnoreCase(method.getInstantiable())) {
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "NOT");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "INSTANTIABLE");
        } else if ("YES".equalsIgnoreCase(method.getIsFinal())) {
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "FINAL");
        }
    }

    private void appendProcSpec(StringBuffer buffer, StructuredTypeProxyOracle typeProxy, MethodProxyOraclev10g method, boolean isConstructor, boolean prettyPrint) {
        if (isConstructor) {
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "CONSTRUCTOR");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "FUNCTION");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(typeProxy));
        } else {
            if ("PROCEDURE".equalsIgnoreCase(method.getMethodType())) {
                SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "PROCEDURE");
            } else {
                SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "FUNCTION");
            }
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(method));
        }
        if (method.getParams().size() > 0 || "NO".equalsIgnoreCase(method.getCopySelf())) {
            SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, '(');
            SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            boolean first = true;
            if ("NO".equalsIgnoreCase(method.getCopySelf()) && "NO".equalsIgnoreCase(method.getIsStatic())) {
                SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "SELF");
                SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "IN");
                SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "OUT");
                SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "NOCOPY");
                SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(typeProxy));
                first = false;
            }
            for (MethodParamProxyOracle param : method.getParams()) {
                if (first) {
                    first = false;
                } else {
                    this.appendComma(buffer);
                    SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                }
                SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(param));
                if (!"".equalsIgnoreCase(param.getDirectionType())) {
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, param.getDirectionType());
                }
                if ("NO".equalsIgnoreCase(param.getCopyArgument())) {
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "NOCOPY");
                }
                String datatype = this.getMethodParamDatatype((MethodParam)param.getObject());
                SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, datatype);
                String defaultValue = param.getDefaultValue().trim();
                if (defaultValue.length() <= 0) continue;
                SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "DEFAULT");
                String df = this.addQuotesToDefault(datatype, defaultValue);
                SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, df);
            }
            SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, ')');
        }
        if (isConstructor) {
            SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "RETURN");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "SELF");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "AS");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "RESULT");
        } else {
            MethodParam returnValue = ((Method)method.getObject()).getReturnValue();
            if (returnValue != null) {
                SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "RETURN");
                SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, this.getMethodParamDatatype(returnValue));
            }
        }
        if (method.getDeterministic().equalsIgnoreCase("YES")) {
            SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "DETERMINISTIC");
        }
        if (method.getParallel().equalsIgnoreCase("YES")) {
            SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "PARALLEL_ENABLE");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, method.getPartitioningAndStreaming());
        }
        if (method.getPipeliningAndAggregation().equalsIgnoreCase("Pipelined")) {
            SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "PIPELINED");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, method.getPipeliningAndAggregationImpl());
        } else if (method.getPipeliningAndAggregation().equalsIgnoreCase("Pipelined Using")) {
            SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "PIPELINED USING");
        } else if (method.getPipeliningAndAggregation().equalsIgnoreCase("Aggregate Using")) {
            SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "AGGREGATE USING");
        }
        if (!"PL/SQL".equalsIgnoreCase(method.getImplLanguage())) {
            SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "AS");
            SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "LANGUAGE");
            if ("Java".equalsIgnoreCase(method.getImplLanguage())) {
                SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "JAVA");
                SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "NAME");
                SSBStructuredTypeOraclev10g.appendString(buffer, '\'');
                SSBStructuredTypeOraclev10g.appendString(buffer, method.getJavaName());
                SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, '\'');
            } else if ("C".equalsIgnoreCase(method.getImplLanguage())) {
                SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "C");
                if (!"".equalsIgnoreCase(method.getCName())) {
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "NAME");
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, method.getCName());
                }
                SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "LIBRARY");
                SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, method.getCLibrary());
                if ("YES".equalsIgnoreCase(method.getWithContext())) {
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "WITH");
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "CONTEXT");
                }
                if (!"".equalsIgnoreCase(method.getCPartemeters())) {
                    SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "PARAMETERS");
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, '(');
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, method.getCPartemeters());
                    SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, ')');
                }
            }
        }
    }

    private String getMethodParamDatatype(MethodParam methodParam) {
        Object datatype = null;
        DesignObject paramDataType = methodParam.getType();
        if (paramDataType instanceof StructuredType || paramDataType instanceof CollectionType) {
            RelationalObjectProxy proxy = this.storageDesign.getProxy(paramDataType);
            datatype = proxy != null ? this.storageDesign.getFormatedLongNameDDL(proxy) : this.storageDesign.getFormatedName(paramDataType);
            if (methodParam.isReference() && paramDataType instanceof StructuredType) {
                datatype = "REF " + (String)datatype;
            }
        } else {
            datatype = methodParam.getDataType(this.storageDesign.getRDBMSType().getName());
        }
        return datatype;
    }

    private void appendPragmaClause(StringBuffer buffer, MethodProxyOracle method, boolean prettyPrint) {
        if (!"".equalsIgnoreCase(method.getPragmaClause())) {
            SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "PRAGMA");
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "RESTRICT_REFERENCES");
            SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, '(');
            SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, method.getPragmaClause());
            SSBStructuredTypeOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof StructuredTypeProxyOraclev10g && ((StructuredTypeProxyOraclev10g)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof StructuredType && ((StructuredType)object).isMarkedGenerate();
    }

    protected void appendPermissions(StringBuffer oldBuffer, StructuredTypeProxyOracle structuredTypeProxyOracle) {
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)structuredTypeProxyOracle.getStorageDesign();
        StringBuffer buffer = new StringBuffer();
        PermissionsSetOracle permissionsSet = storageDesignOracle.getPermissionsSet();
        for (PermissionsOracle permissions : permissionsSet) {
            if (!structuredTypeProxyOracle.equals(permissions.getStructuredTypeOracle()) || permissions.getUser() == null && permissions.getRole() == null) continue;
            if (StringUtilities.isNotEmpty(permissions.getPrivileges())) {
                this.appendPrivileges(oldBuffer, buffer, permissions, structuredTypeProxyOracle, storageDesignOracle, false);
            }
            if (!StringUtilities.isNotEmpty(permissions.getPrivilegesWithGrantOption())) continue;
            this.appendPrivileges(oldBuffer, buffer, permissions, structuredTypeProxyOracle, storageDesignOracle, true);
        }
    }

    private void appendPrivileges(StringBuffer oldBuffer, StringBuffer buffer, PermissionsOracle permissions, StructuredTypeProxyOracle structuredTypeProxyOracle, StorageDesignOracle storageDesignOracle, boolean withGrantOption) {
        buffer.append(NEWLINE);
        this.appendComment(buffer, permissions);
        SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "GRANT");
        if (withGrantOption) {
            buffer.append(permissions.getPrivilegesWithGrantOption());
        } else {
            buffer.append(permissions.getPrivileges());
        }
        this.appendObject(buffer, structuredTypeProxyOracle, storageDesignOracle);
        this.appendTo(buffer, permissions, storageDesignOracle);
        if (withGrantOption) {
            this.appendGrantOption(buffer, permissions);
        }
        String advancedComment = buffer.toString();
        buffer.append(NEWLINE);
        buffer.append(';');
        buffer.append(NEWLINE);
        this.appendToBuffer(oldBuffer, buffer, advancedComment);
    }

    private void appendObject(StringBuffer buffer, StructuredTypeProxyOracle structuredTypeProxyOracle, StorageDesign storageDesign) {
        buffer.append(NEWLINE);
        SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "ON");
        SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, storageDesign.getFormatedLongNameDDL(structuredTypeProxyOracle));
    }

    private void appendGrantOption(StringBuffer buffer, PermissionsOracle permissions) {
        if (permissions.getRole() == null) {
            SSBStructuredTypeOraclev10g.appendStringWithSpace(buffer, "WITH GRANT OPTION");
        }
    }
}

