/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.util.string.StringUtilities;

public class SSBDirectoryOraclev10g
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    public void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        DirectoryOracle dir = (DirectoryOracle)object;
        this.storageDesign = dir.getStorageDesign();
        this.appendPrompt(buffer, dir, "DIRECTORY");
        this.appendComment(oldbuffer, dir);
        this.appendCreateDir(buffer, dir);
        advancedComment = buffer.toString();
        this.appendDirPath(buffer, dir, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBDirectoryOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        SSBDirectoryOraclev10g.appendLineFinisher(buffer, prettyPrint);
        SSBDirectoryOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        this.appendPermissions(oldbuffer, dir);
        this.incrementCreateDirectory();
    }

    private void appendCreateDir(StringBuffer buffer, DirectoryOracle dir) {
        this.appendCreateOrReplace(buffer);
        SSBDirectoryOraclev10g.appendStringWithSpace(buffer, "DIRECTORY");
        SSBDirectoryOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(dir));
    }

    private void appendDirPath(StringBuffer buffer, DirectoryOracle dir, boolean prettyPrint) {
        String dirPath = dir.getDirPath();
        SSBDirectoryOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBDirectoryOraclev10g.appendStringWithSpace(buffer, "AS");
        SSBDirectoryOraclev10g.appendString(buffer, '\'');
        SSBDirectoryOraclev10g.appendString(buffer, dirPath);
        SSBDirectoryOraclev10g.appendStringWithSpace(buffer, '\'');
        if (dirPath == null || dirPath.equals("")) {
            SSBDirectoryOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBDirectoryOraclev10g.appendString(buffer, "--  ERROR: No Path name specified");
            this.incrementErrors();
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof DirectoryOracle && ((DirectoryOracle)object).isMarkedGenerate();
    }

    protected void appendPermissions(StringBuffer oldBuffer, DirectoryOracle directoryOracle) {
        StorageDesignOracle storageDesignOracle = directoryOracle.getStorageDesignOracle();
        StringBuffer buffer = new StringBuffer();
        PermissionsSetOracle permissionsSet = storageDesignOracle.getPermissionsSet();
        for (PermissionsOracle permissions : permissionsSet) {
            if (!directoryOracle.equals(permissions.getDirectoryOracle()) || permissions.getUser() == null && permissions.getRole() == null) continue;
            if (StringUtilities.isNotEmpty(permissions.getPrivileges())) {
                this.appendPrivileges(oldBuffer, buffer, permissions, directoryOracle, storageDesignOracle, false);
            }
            if (!StringUtilities.isNotEmpty(permissions.getPrivilegesWithGrantOption())) continue;
            this.appendPrivileges(oldBuffer, buffer, permissions, directoryOracle, storageDesignOracle, true);
        }
    }

    private void appendPrivileges(StringBuffer oldBuffer, StringBuffer buffer, PermissionsOracle permissions, DirectoryOracle directoryOracle, StorageDesignOracle storageDesignOracle, boolean withGrantOption) {
        buffer.append(NEWLINE);
        this.appendComment(buffer, permissions);
        SSBDirectoryOraclev10g.appendStringWithSpace(buffer, "GRANT");
        if (withGrantOption) {
            buffer.append(permissions.getPrivilegesWithGrantOption());
        } else {
            buffer.append(permissions.getPrivileges());
        }
        this.appendObject(buffer, directoryOracle, storageDesignOracle);
        this.appendTo(buffer, permissions, storageDesignOracle);
        if (withGrantOption) {
            this.appendGrantOption(buffer, permissions);
        }
        String advancedComment = buffer.toString();
        buffer.append(NEWLINE);
        buffer.append(';');
        buffer.append(NEWLINE);
        this.appendToBuffer(oldBuffer, buffer, advancedComment);
    }

    private void appendObject(StringBuffer buffer, DirectoryOracle directoryOracle, StorageDesign storageDesign) {
        buffer.append(NEWLINE);
        SSBDirectoryOraclev10g.appendStringWithSpace(buffer, "ON");
        SSBDirectoryOraclev10g.appendStringWithSpace(buffer, "DIRECTORY");
        SSBDirectoryOraclev10g.appendStringWithSpace(buffer, storageDesign.getFormatedLongNameDDL(directoryOracle));
    }

    private void appendGrantOption(StringBuffer buffer, PermissionsOracle permissions) {
        if (permissions.getRole() == null) {
            SSBDirectoryOraclev10g.appendStringWithSpace(buffer, "WITH GRANT OPTION");
        }
    }
}

